#include <errno.h>
#include <unistd.h>
#include <sys/select.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <time.h>

#include "myheader.h"
#include "wlanfunc.h"

int wlan_sitesurvey(void)
{
	unsigned int offset = 0, shift;
	FILE *fp, *tfp;
	unsigned char buffer[MAX_BUFFER_LEN];
	unsigned char *tokenp, *token = ":";
	unsigned char channel;
	char *stop_at;
	
	struct _wlanstruct wlanstruct;
	
	if ((fp = fopen (SITESURVEY_PATH, "r")) == NULL )
	{
		printf ("Can't find the file(wlan_sitesurvey.inc)\n");
		exit(0);
	}

	if ((tfp = fopen (SITESURVEY_RESULT, "w+b")) == NULL)
	{
		printf ("Can't write the file(sitesurvey_result.inc)\n");
		exit(0);
	}

	while (!feof(fp))
	{
        	fgets (buffer, MAX_BUFFER_LEN, fp);
		
                offset = 0;
		if((strstr(buffer, SITESURVEY_STRING)))			//NULL: find the string
		{
			memset (wlanstruct.mode, 0, sizeof (wlanstruct.mode));
			memset (wlanstruct.ssid, 0, sizeof (wlanstruct.ssid));
			memset (wlanstruct.channel, 0, sizeof (wlanstruct.channel));
			memset (wlanstruct.encryption, 0, sizeof (wlanstruct.encryption));
			memset (wlanstruct.state, 0, sizeof (wlanstruct.state));
			memset (wlanstruct.bssid, 0, sizeof (wlanstruct.bssid));
                        memcpy (wlanstruct.bssid, (buffer + strlen(buffer) - MAC_LEN + 2), (MAC_LEN - 3));	//BSSID
			
			fgets (buffer, MAX_BUFFER_LEN, fp);

			if (strstr(buffer, "Extra"))
				fgets (buffer, MAX_BUFFER_LEN, fp);
				
			tokenp = strtok (buffer, token);
			tokenp = strtok (NULL, token);
                        memcpy (wlanstruct.ssid, (tokenp + 1), (strlen(tokenp) - 3));

			fgets (buffer, MAX_BUFFER_LEN, fp);
			tokenp = strtok (buffer, token);
			tokenp = strtok (NULL, token);
			*(tokenp + (strlen(tokenp) - 4)) = '\x0a';
			*(tokenp + (strlen(tokenp) - 3)) = '\x0';
			for (shift = 0; shift < strlen(tokenp); shift++)
			{
				if (tokenp[shift] == '.')
				{
					tokenp[shift] = tokenp[shift + 1];
					tokenp[shift + 1] = '.';
				}
			}
			channel = (unsigned char)((strtoul (tokenp, &stop_at, 10) - 2407) / 5);
			if (channel > 13)
				memcpy (wlanstruct.channel, "14", 2);//CHANNEL
			else
			{
				if (channel >= 10)
				{
					channel -= 10;
					tokenp[0] = 0x31;
					tokenp[1] = 0x30 + channel;
					tokenp[2] = '\x0a';
					tokenp[3] = '\x0';
					memcpy (wlanstruct.channel, tokenp, strlen(tokenp) - 1);
				}
				else
				{
					tokenp[0] = 0x30 + channel;
					tokenp[1] = '\x0a';
					tokenp[2] = '\x0';
				}
					memcpy (wlanstruct.channel, tokenp, strlen(tokenp) - 1);
			}

			
			fgets (buffer, MAX_BUFFER_LEN, fp);
			tokenp = strtok (buffer, token);
			tokenp = strtok (NULL, token);
			if (strstr (tokenp, "Managed"))					//MODE
				memcpy (wlanstruct.mode, "Infrastructure", 14);
			else
				memcpy (wlanstruct.mode, "Ad-hoc", 6);						
			fgets (buffer, MAX_BUFFER_LEN, fp);
			fgets (buffer, MAX_BUFFER_LEN, fp);

			tokenp = strtok (buffer, token);
			tokenp = strtok (NULL, token);
			if (tokenp[3] == '/')
			{
				tokenp[3] = '\x0a';
				tokenp[4] = '\x0';
			}
			else if (tokenp[2] == '/')
			{
				tokenp[2] = '\x0a';
				tokenp[3] = '\x0';
			}
			else
			{
				tokenp[1] = '\x0a';
				tokenp[2] = '\x0';
			}
			if (tokenp[0] == '0')
				wlanstruct.state[0] = (unsigned char)(((int)time(0)%10) + 0x30);
			else
				memcpy (wlanstruct.state, tokenp, (strlen(tokenp) - 1));	//SIGNAL
                        fgets (buffer, MAX_BUFFER_LEN, fp);
			tokenp = strtok (buffer, token);
			tokenp = strtok (NULL, token);
			if (!memcmp (tokenp, "off", 3))
//				memcpy (wlanstruct.encryption, tokenp, (strlen(tokenp) - 1));//WEP
				memcpy (wlanstruct.encryption, "off", 3);
			else
				memcpy (wlanstruct.encryption, "on", 2);

			fwrite (&wlanstruct, sizeof(wlanstruct), 1, tfp);
		}
	}
	fclose (tfp);
	fclose (fp);
	return 0;
}

int wlan_config(void)
{
	FILE *fp, *tfp;
	unsigned char buffer[MAX_BUFFER_LEN], offset = 0;
	unsigned char *tokenp, *token = ":", i;
	
	struct _wlanstruct wlanstruct;
	
	if ((fp = fopen (CONFIG_PATH, "r")) == NULL )
	{
		printf ("Can't find the file(wlan_config.inc)\n");
		exit(0);
	}
	if ((tfp = fopen (CONFIG_RESULT, "w")) == NULL)
	{
		printf ("Can't write the file(wlanresult.inc)\n");
		exit(0);
	}
	
	memset (&wlanstruct, 0, sizeof(wlanstruct));
	while (!feof(fp))
	{
		fgets (buffer, MAX_BUFFER_LEN, fp);
		if ( (strstr (buffer, CONFIG_STRING)))
		{
			memset (&wlanstruct, 0, sizeof(wlanstruct));

			tokenp = strtok (buffer, token);
			if (strstr (tokenp, "802.11-g"))
			{
				strcpy (wlanstruct.state, "Connect");
				wlanstruct.state[strlen(wlanstruct.state) + 1] = '\x0';
				printf("%s", wlanstruct.state);
			}
			else
				break;
			
			tokenp = strtok (NULL, token);
                       	while ( *(tokenp + 1 + offset) != '"')
				offset++;
			*(tokenp + offset + 1 ) = '\x0';
			strcpy (wlanstruct.ssid, tokenp + 1);
			printf ("%s", wlanstruct.ssid);

			fgets (buffer, MAX_BUFFER_LEN, fp);
			if ((strstr(buffer, "Rate"))){
			}
			else{
				strcpy (wlanstruct.bssid, buffer + strlen(buffer) - MAC_LEN);
				wlanstruct.bssid[strlen(wlanstruct.bssid) + 1] = '\x0';
			}
			printf ("%s", wlanstruct.bssid);

			tokenp = strtok (buffer, token);
			tokenp = strtok (NULL, token);
			if (strstr (tokenp, "Managed")){
				tokenp = strtok (NULL, token);
				strcpy (wlanstruct.mode, "Infrastructure");
			}
			else
				strcpy (wlanstruct.mode, "Ad-hoc");
			
			wlanstruct.mode[strlen(wlanstruct.mode) + 1] = '\x0';
//			wlanstruct.mode[strlen(wlanstruct.mode) ] = '\x0a';
							       
			if (*(tokenp + 1) == '\x20')
			{
//			       	*(tokenp + 1) = '\x0a';
        	                *(tokenp + 2) = '\x0';
			}
			else
			{
//				*(tokenp + 2) = '\x0a';
				*(tokenp + 3) = '\x0';
			}
			strcpy (wlanstruct.channel, tokenp);
			printf ("%s", wlanstruct.channel);

			if (strlen(wlanstruct.bssid) == 0){
				for (i=0; i < 6; i++){
					tokenp = strtok(NULL, token);
					if (i == 0)
						memcpy (&wlanstruct.bssid[i*3], tokenp+1, 2);
					else
						memcpy (&wlanstruct.bssid[i*3], tokenp, 2);
					if (i != 5)	
						wlanstruct.bssid[(i*3) + 2] = ':';
				}
			}

			fgets (buffer, MAX_BUFFER_LEN, fp);
			fgets (buffer, MAX_BUFFER_LEN, fp);
			fgets (buffer, MAX_BUFFER_LEN, fp);
			tokenp = strtok (buffer, token);
			tokenp = strtok (NULL, token);
			if (!memcmp (tokenp, "off", 3))
				strcpy (wlanstruct.encryption, "off");
			else
				strcpy (wlanstruct.encryption, "on");
			printf ("%s", wlanstruct.encryption);
		}
	}
    
	 if ( !strlen (wlanstruct.mode) )
        {
                fputs ("MODE=Unknown\n", tfp);
                fputs ("ESSID=Unknown\n", tfp);
                fputs ("CHANNEL=Unknown\n", tfp);
                fputs ("WEP=Unknown\n", tfp);
                fputs ("STATE=Disconnected\n", tfp);
                fputs ("BSSID=Unknown\n", tfp);
        }

	else
	{
		sprintf (buffer, "MODE=%s\n", wlanstruct.mode);
		fputs (buffer, tfp);
		sprintf (buffer, "ESSID=%s\n", wlanstruct.ssid);
		fputs (buffer, tfp);
		sprintf (buffer, "CHANNEL=%s\n", wlanstruct.channel);
		fputs (buffer, tfp);
		sprintf (buffer, "WEP=%s\n", wlanstruct.encryption);
		fputs (buffer, tfp);
		sprintf (buffer, "STATE=%s\n", wlanstruct.state);
		fputs (buffer, tfp);
		sprintf (buffer, "BSSID=%s\n", wlanstruct.bssid);
		fputs (buffer, tfp);
	}
	
	fclose (tfp);
        fclose (fp);	
	return 0;
}
