/*
 *	Wireless Tools
 *
 *		Jean II - HPLB '99 - HPL 99->01
 *
 * This tool can access various piece of information on the card
 * not part of iwconfig...
 * You need to link this code against "iwlist.c" and "-lm".
 *
 * This file is released under the GPL license.
 *     Copyright (c) 1997-2002 Jean Tourrilhes <jt@hpl.hp.com>
 */

#include "iwlib.h"		/* Header */
#include <sys/time.h>

#define CONFIG_RESULT           "/tmp/config_result.inc"
#define SITESURVEY_RESULT       "/tmp/sitesurvey_result.inc"

/***************************** SCANNING *****************************/
/*
 * This one behave quite differently from the others
 */
#if WIRELESS_EXT > 13
static int print_wireless_info(int skfd, char* ifname, char args[], int count)
{
	unsigned char	buffer[IW_SCAN_MAX_DATA];
	struct wireless_info info;
	struct _wlanstruct wlaninfo;
	struct iwreq	wrq;
      	struct ifreq ifr;
	FILE *fp;

	args = args;
	count = count;

        if ((fp = fopen (CONFIG_RESULT, "wb")) == NULL){
		printf ("Can't write the file(sitesurvey_result.inc)\n");
		exit(0);
	}

	memset(&info, 0x00, sizeof(wireless_info));

	/* Get wireless name */
	
	if(iw_get_ext(skfd, ifname, SIOCGIWNAME, &wrq) < 0){
		/* If no wireless name : no wireless extensions */
		/* But let's check if the interface exists at all */
		strcpy(ifr.ifr_name, ifname);
		if(ioctl(skfd, SIOCGIFFLAGS, &ifr) < 0)
			return(-ENODEV);
		else
			return(-ENOTSUP);
	}
	else{
		strncpy(info.name, wrq.u.name, IFNAMSIZ);
		info.name[IFNAMSIZ] = '\0';
	}

	/* Get operation mode */
	if(iw_get_ext(skfd, ifname, SIOCGIWMODE, &wrq) >= 0){
		info.mode = wrq.u.mode;

		if((info.mode < IW_NUM_OPER_MODE) && (info.mode >= 0))
			info.has_mode = 1;
		if((info.has_mode) && (info.mode == IW_MODE_ADHOC)){
			memcpy(wlaninfo.mode, "Ad-hoc", 6);
			printf("MODE=Ad-hoc\r\n");
		}
		else{
			memcpy(wlaninfo.mode, "Infrastructure", 14);
			printf("MODE=Infrastructure\r\n");
		}
	}
	else{
                fputs ("MODE=Unknown\n", fp);
                fputs ("ESSID=Unknown\n", fp);
                fputs ("CHANNEL=Unknown\n", fp);
                fputs ("SECURITY=Unknown\n", fp);
                fputs ("STATE=Disconnected\n", fp);
                fputs ("BSSID=Unknown\n", fp);
		fclose(fp);
		return(0);
	}

	/* Get ESSID */
	wrq.u.essid.pointer = (caddr_t) info.essid;
	wrq.u.essid.length = IW_ESSID_MAX_SIZE + 1;
	wrq.u.essid.flags = 0;
	if(iw_get_ext(skfd, ifname, SIOCGIWESSID, &wrq) >= 0){
		info.has_essid = 1;
		info.essid_on = wrq.u.data.flags;
		if((info.essid_on) && (strlen(info.essid)))
			sprintf(wlaninfo.state, "%s", "Connect");
		else
			sprintf(wlaninfo.state, "%s", "Disconnected");
		sprintf(wlaninfo.ssid, "%s", info.essid);
	}
	printf("SSID=%s\r\n Length=%d", info.essid, strlen(info.essid));

        /* Get frequency / channel */
        if(iw_get_ext(skfd, ifname, SIOCGIWFREQ, &wrq) >= 0){
                info.has_freq = 1;
        //      info->freq = iw_freq2float(&(wrq.u.freq));
        //      frequency = (((unsigned int) wrq.u.freq.m / 100000) - 2407);
        //      printf ("Frequency=%d\n",frequency);
        //      info->freq = (double)(frequency / 5);
                info.freq = (double) wrq.u.freq.m;
                printf("CHANNEL=%d\r\n", (int)info.freq);
		sprintf(wlaninfo.channel, "%d", (int)info.freq);
        }

        /* Get encryption information */
	
        wrq.u.data.pointer = (caddr_t) info.key;
        wrq.u.data.length = IW_ENCODING_TOKEN_MAX;
        wrq.u.data.flags = 0;
        if(iw_get_ext(skfd, ifname, SIOCGIWENCODE, &wrq) >= 0){
		printf("wrq.u.data1.flags=%d\n", wrq.u.data.flags);
		switch(wrq.u.data.flags){
			case Ndis802_11WEPDisabled:
				sprintf(wlaninfo.encryption, "off");
                                break;
			case Ndis802_11WEPEnabled:
				sprintf(wlaninfo.encryption, "WEP");
                                break;
                        case Ndis802_11Encryption2Enabled:
                        case Ndis802_11Encryption3Enabled:
                        	sprintf(wlaninfo.encryption, "WPA-PSK");
                                break;
		}

		info.has_key = 1;
                info.key_size = wrq.u.data.length;
                info.key_flags = wrq.u.data.flags;
        }
	else{
		sprintf(wlaninfo.encryption, "SECURITY=off");
	}
	
	/* Get AP address */
	
	if(iw_get_ext(skfd, ifname, SIOCGIWAP, &wrq) >= 0){
		info.has_ap_addr = 1;
		memcpy(&(info.ap_addr), &(wrq.u.ap_addr), sizeof (sockaddr));
		sprintf(wlaninfo.bssid, "%s", iw_pr_ether(buffer, info.ap_addr.sa_data));
		if(!memcmp(wlaninfo.bssid, "FF:FF:FF:FF:FF:FF", 17)){
	                fputs ("MODE=Unknown\n", fp);
        	        fputs ("ESSID=Unknown\n", fp);
                	fputs ("CHANNEL=Unknown\n", fp);
	                fputs ("SECURITY=Unknown\n", fp);
        	        fputs ("STATE=Disconnected\n", fp);
                	fputs ("BSSID=Unknown\n", fp);
	                fclose(fp);
        	        return(0);					
		}

		printf("BSSID=%s\n", wlaninfo.bssid);
	}
	else{
		fputs ("MODE=Not Active\n", fp);
                fputs ("ESSID=Not Active\n", fp);
                fputs ("CHANNEL=Not Active\n", fp);
                fputs ("SECURITY=Not Active\n", fp);
                fputs ("STATE=Disconnected\n", fp);
                fputs ("BSSID=Not Active\n", fp);
                fclose(fp);
                return(0);
/*
		memcpy(wlaninfo.bssid, "FF:FF:FF:FF:FF:FF", 17);
		sprintf(wlaninfo.state, "%s", "Disconnected");
*/
		printf("BSSID=%s\n", wlaninfo.bssid);

	}

	sprintf (buffer, "MODE=%s\n", wlaninfo.mode);
        fputs (buffer, fp);
        sprintf (buffer, "ESSID=%s\n", wlaninfo.ssid);
        fputs (buffer, fp);
        sprintf (buffer, "CHANNEL=%s\n", wlaninfo.channel);
        fputs (buffer, fp);
        sprintf (buffer, "SECURITY=%s\n", wlaninfo.encryption);
        fputs (buffer, fp);
        sprintf (buffer, "STATE=%s\n", wlaninfo.state);
        fputs (buffer, fp);
        sprintf (buffer, "BSSID=%s\n", wlaninfo.bssid);
        fputs (buffer, fp);
	

	fclose(fp);
	return (0);	
}
			

/*------------------------------------------------------------------*/
/*
 * Perform a scanning on one device
 */
static int print_scanning_info(int skfd, char *ifname, char *args[], int count)
{
	struct iwreq wrq;
	unsigned char buffer[IW_SCAN_MAX_DATA];	/* Results */
	struct timeval	tv;			/* Select timeout */
	int timeout = 5000000;			/* 5s */
	struct	_wlanstruct info;
	FILE	*fp;
			  
	/* Avoid "Unused parameter" warning */
	args = args; count = count;

	/* Init timeout value -> 250ms*/
	tv.tv_sec = 0;
	tv.tv_usec = 250000;

        if ((fp = fopen (SITESURVEY_RESULT, "wb")) == NULL)
        {
                printf ("Can't write the file(sitesurvey_result.inc)\n");
                exit(0);
        }
	

  	/*
	   * Here we should look at the command line args and set the IW_SCAN_ flags
	   * properly
	   */
	wrq.u.param.flags = IW_SCAN_DEFAULT;
	wrq.u.param.value = 0;		/* Later */

	/* Initiate Scanning */
	if(iw_set_ext(skfd, ifname, SIOCSIWSCAN, &wrq) < 0){
		if(errno != EPERM){
			fprintf(stderr, "%-8.8s Interface doesn't support scanning : %s\n\n", 
					ifname, strerror(errno));
			return(-1);
		}
      /* If we don't have the permission to initiate the scan, we may
       * still have permission to read left-over results.
       * But, don't wait !!! */
		tv.tv_usec = 0;
	}
	
	timeout -= tv.tv_usec;
  /* Forever */
	
	while(1){
		fd_set rfds;		/* File descriptors for select */
		int last_fd;	/* Last fd */
		int ret;
		
		/* Guess what ? We must re-generate rfds each time */
		FD_ZERO(&rfds);
		last_fd = -1;
		
		/* In here, add the rtnetlink fd in the list */
		/* Wait until something happens */
		ret = select(last_fd + 1, &rfds, NULL, NULL, &tv);
		
		/* Check if there was an error */
		if(ret < 0){
			if(errno == EAGAIN || errno == EINTR)
				continue;
			fprintf(stderr, "Unhandled signal - exiting...\n");
			return(-1);
		}
		
		/* Check if there was a timeout */
		if(ret == 0){
			/* Try to read the results */
			wrq.u.data.pointer = buffer;
			wrq.u.data.flags = 0;
			wrq.u.data.length = sizeof(buffer);
			if(iw_get_ext(skfd, ifname, SIOCGIWSCAN, &wrq) < 0){
				/* Check if results not available yet */
				if(errno == EAGAIN){
					/* Restart timer for only 100ms*/
					tv.tv_sec = 0;
					tv.tv_usec = 100000;
					timeout -= tv.tv_usec;
					if(timeout > 0)
						continue;	/* Try again later */
				}
				/* Bad error */
				fprintf(stderr, "%-8.8s  Failed to read scan data : %s\n\n",
						ifname, strerror(errno));
				return(-2);
			}
			else
				/* We have the results, go to process them */
				break;
		}
		
		/* In here, check if event and event type
		 * if scan event, read results. All errors bad & no reset timeout */
	}
	if(wrq.u.data.length){
		struct iw_event	iwe;
		struct stream_descr stream;
		int ret;
		struct iw_range range;
		int has_range;
		unsigned char   key[IW_ENCODING_TOKEN_MAX];
		
		has_range = (iw_get_range_info(skfd, ifname, &range) >= 0);
		printf("Scan completed !!\r\n");
		iw_init_event_stream(&stream, buffer, wrq.u.data.length);
		do{
			/* Extract an event and print it */
			ret = iw_extract_event_stream(&stream, &iwe);
			if(ret > 0){
				switch(iwe.cmd){
                                        case SIOCGIWMODE:
//memcpy(info.mode, iw_operation_mode[iwe.u.mode], sizeof(iw_operation_mode[iwe.u.mode]));
                                        sprintf(info.mode, "%s", iw_operation_mode[iwe.u.mode]);
                                                printf("MODE=%s\n", info.mode);
                                                fwrite (&info, sizeof(wlanstruct), 1, fp);
						memset(&info, 0x00, sizeof(wlanstruct));
                                                break;                          //Mode

					case SIOCGIWAP:				//BSSID	
						iw_pr_ether(buffer, iwe.u.ap_addr.sa_data);
						sprintf(info.bssid, "%s", buffer);
						printf("BSSID=%s\n", info.bssid);
						break;

					case SIOCGIWFREQ:			//Channel
//						info.channel = (int) wrq.u.freq.m;
//						frequency = (unsigned int) iwe.u.freq.m / 100000;
//						frequency = (frequency - 2407) / 5;
						if ((int)wrq.u.freq.m > 13)
							sprintf(info.channel, "14");
						else
							sprintf(info.channel, "%d", (int) iwe.u.freq.m);
						printf("CHANNEL=%s\n", info.channel);
						break;
						
					case IWEVQUAL:				//SIGNAL
						iwe.u.qual.updated = 0x0;
//						iw_print_stats(buffer,&iwe.u.qual,&range,has_range);
						sprintf(info.state, "%d", iwe.u.qual.qual);
						printf("SIGNAL=%s\n", info.state);
						break;
					
					case SIOCGIWESSID:			//SSID
						if((iwe.u.essid.pointer) && (iwe.u.essid.length))
							memcpy(info.ssid, iwe.u.essid.pointer, iwe.u.essid.length);
						info.ssid[iwe.u.essid.length] = '\0';
						if(iwe.u.essid.flags){
							/* Does it have an ESSID index ? */
						}
						printf("SSID=%s\n", info.ssid);
						break;

					case SIOCGIWENCODE:			//WEP
/*
						if(iwe.u.data.pointer)
							memcpy(key,iwe.u.essid.pointer,iwe.u.data.length);
						else
							iwe.u.data.flags |= IW_ENCODE_NOKEY;
*/
						switch(iwe.u.data.flags){
							case Ndis802_11WEPDisabled:
								sprintf(info.encryption, "off");
								printf("encryption=%s\n", info.encryption);
								break;
								
							case Ndis802_11WEPEnabled:
								sprintf(info.encryption, "WEP");
								printf("encryption=%s\n", info.encryption);
								break;
								
							case Ndis802_11Encryption2Enabled:
								sprintf(info.encryption, "TKIP");
								printf("encryption=%s\n", info.encryption);
								break;

							case Ndis802_11Encryption3Enabled:
								sprintf(info.encryption, "AES");
								printf("encryption=%s\n", info.encryption);
								break;
						}
						/*
						if(iwe.u.data.flags & Ndis802_11WEPDisabled){
							sprintf(info.encryption, "off");
//							memcpy(info.encryption, "off", 3);
						}
						else{
							sprintf(info.encryption, "on");
//							memcpy(info.encryption, "on", 2);
						}
						printf("encryption=%s\n", info.encryption);
						break;
						*/
	
					default:
						break;
				}
			}
		}
		while(ret > 0);
	}
	else
	       	printf("%-8.8s  No scan results\n", ifname);
	fclose(fp);
	return(0);
}

static int print_readmac_info(int skfd, char *ifname, char*args[])
{
        struct wireless_info info;
        struct iwreq    wrq;
        struct ifreq ifr;
        char buf[32];
        int mac[6], i;
                                                                                                   
                                                                                                   
        if(iw_get_ext(skfd, ifname, SIOCGIWNAME, &wrq) < 0){
                /* If no wireless name : no wireless extensions */
                /* But let's check if the interface exists at all */
                strcpy(ifr.ifr_name, ifname);
                if(ioctl(skfd, SIOCGIFFLAGS, &ifr) < 0)
                        return(-ENODEV);
                else
                        return(-ENOTSUP);
        }
        else{
                strncpy(info.name, wrq.u.name, IFNAMSIZ);
                info.name[IFNAMSIZ] = '\0';
        }

        memset(&wrq, 0, sizeof(wrq));
        memset(&buf, 0, sizeof(buf));
                                                                                                   
        sprintf(buf, "04");
        wrq.u.data.pointer = (caddr_t)buf;
        wrq.u.data.length = strlen(buf) + 1;
        if(iw_get_ext(skfd, ifname, RTPRIV_IOCTL_E2P, &wrq) < 0){
        	printf("RTPRIV_IOCTL_MAC addr:04");
	}

	for ( i = 0; i < sizeof(buf); i++)
		buf[i] = toupper(buf[i]);
	
	printf("WLAN=%s\n", buf);
	sscanf(wrq.u.data.pointer, "%02x:%02x:%02x:%02x:%02x:%02x\n", &mac[0], &mac[1], &mac[2], &mac[3], &mac[4], &mac[5]);
	
	printf("HW_WLAN_ADDR=%02x%02x%02x%02x%02x%02x\n", mac[0], mac[1], mac[2], mac[3], mac[4], mac[5]);
        return 0;
}

static int print_writemac_info(int skfd, char *ifname, char *args[])
{
        struct wireless_info info;
        struct iwreq    wrq;
        struct ifreq ifr;
	char buf[32];
    	int mac[6];


        if(iw_get_ext(skfd, ifname, SIOCGIWNAME, &wrq) < 0){
                /* If no wireless name : no wireless extensions */
                /* But let's check if the interface exists at all */
                strcpy(ifr.ifr_name, ifname);
                if(ioctl(skfd, SIOCGIFFLAGS, &ifr) < 0)
                        return(-ENODEV);
                else
                        return(-ENOTSUP);
        }
        else{
                strncpy(info.name, wrq.u.name, IFNAMSIZ);
                info.name[IFNAMSIZ] = '\0';
        }

	sscanf(args[0], "%02x:%02x:%02x:%02x:%02x:%02x", &mac[0], &mac[1], &mac[2], &mac[3], &mac[4], &mac[5]);
	
	memset(&wrq , 0, sizeof(wrq));
	memset(&buf , 0, sizeof(buf));
	
	sprintf(buf, "04");
	wrq.u.data.pointer = (caddr_t)buf;
	wrq.u.data.length = strlen(buf) + 1;
        if(iw_get_ext(skfd, ifname, RTPRIV_IOCTL_E2P, &wrq) < 0){
                printf("RTPRIV_IOCTL_MAC addr:04");
        }

	if(!strncasecmp(buf, args[0], strlen(args[0]))){
		printf("bus=%s args=%s args_len=%d\n", buf, args[0], strlen(args[0]));
		printf("Wireless Mac is same with config !!\n");
		printf("MAC=%s\n", buf);
		return(0);
	}

        memset(&wrq , 0, sizeof(wrq));
        memset(&buf , 0, sizeof(buf));

	sprintf(buf, "04=%02x%02x", mac[1], mac[0]);
	wrq.u.data.pointer = (caddr_t) buf;
	wrq.u.data.length = strlen(buf) + 1;

        if(iw_set_ext(skfd, ifname, RTPRIV_IOCTL_E2P, &wrq) < 0){
		printf("RTPRIV_IOCTL_MAC addr:04");
	}

        sprintf(buf, "06=%02x%02x", mac[3], mac[2]);
        wrq.u.data.pointer = (caddr_t) buf;
        wrq.u.data.length = strlen(buf) + 1;
                                                                                                   
        if(iw_set_ext(skfd, ifname, RTPRIV_IOCTL_E2P, &wrq) < 0){
                printf("RTPRIV_IOCTL_MAC addr:04");
        }

        sprintf(buf, "08=%02x%02x", mac[5], mac[4]);
        wrq.u.data.pointer = (caddr_t) buf;
        wrq.u.data.length = strlen(buf) + 1;
                                                                                                   
        if(iw_set_ext(skfd, ifname, RTPRIV_IOCTL_E2P, &wrq) < 0){
                printf("RTPRIV_IOCTL_MAC addr:04");
        }
	
	return(0);
}
#endif	/* WIRELESS_EXT > 13 */

/************************* COMMON UTILITIES *************************/
/*
 * This section was written by Michael Tokarev <mjt@tls.msk.ru>
 * But modified by me ;-)
 */

/* command list */
typedef struct iwlist_entry {
	const char *cmd;
	iw_enum_handler fn;
	int min_count;
	int max_count;
}iwlist_cmd;

static const struct iwlist_entry iwlist_cmds[] = {
#if WIRELESS_EXT > 13
	{ "config",		print_wireless_info,	0, 5 },
	{ "sitesurvey",		print_scanning_info,	0, 5 },
	{ "writemac", 		print_writemac_info,	0, 5 },
	{ "readmac", 		print_readmac_info,	0, 5 },
#endif
	{ NULL, NULL, 0, 0 },
};

/*------------------------------------------------------------------*/
/*
 * Find the most appropriate command matching the command line
 */
static inline const iwlist_cmd * find_command(const char *cmd)
{
	const iwlist_cmd *found = NULL;
	int ambig = 0;
	unsigned int len = strlen(cmd);
	int i;
	
	/* Go through all commands */
	
	for(i = 0; iwlist_cmds[i].cmd != NULL; ++i){
		/* No match -> next one */
		if(strncasecmp(iwlist_cmds[i].cmd, cmd, len) != 0)
			continue;
		
		/* Exact match -> perfect */
		if(len == strlen(iwlist_cmds[i].cmd))
			return &iwlist_cmds[i];
		
		/* Partial match */
		if(found == NULL)
			/* First time */
			found = &iwlist_cmds[i];
		else
			/* Another time */
			if (iwlist_cmds[i].fn != found->fn)
				ambig = 1;
	}
	
	if(found == NULL){
		fprintf(stderr, "iwlist: unknown command `%s'\n", cmd);
		return NULL;
	}
	
	if(ambig){
		fprintf(stderr, "iwlist: command `%s' is ambiguous\n", cmd);
		return NULL;
	}
	
	return found;
}

/*------------------------------------------------------------------*/
/*
 * Display help
 */
static void iw_usage(int status)
{
	FILE* f = status ? stderr : stdout;
	int i;
	
	fprintf(f,   "Usage:  wlan [interface] %s\n", iwlist_cmds[0].cmd);
	
	for(i = 1; iwlist_cmds[i].cmd != NULL; ++i)
		fprintf(f, "              [interface] %s\n", iwlist_cmds[i].cmd);
	
	exit(status);
}

/******************************* MAIN ********************************/

/*------------------------------------------------------------------*/
/*
 * The main !
 */
int main(int	argc, char **	argv)
{
	int skfd;			/* generic raw socket desc.	*/
	char *dev;			/* device name			*/
	char *cmd;			/* command			*/
	char **args;			/* Command arguments */
	int count;			/* Number of arguments */
	const iwlist_cmd *iwcmd;

	if(argc == 1 || argc > 4)
		iw_usage(1);

	if (!strcmp(argv[1], "-h") || !strcmp(argv[1], "--help"))
		iw_usage(0);
	
	/* This is also handled slightly differently */
	if (!strcmp(argv[1], "-v") || !strcmp(argv[1], "--version"))
		return(iw_print_version_info("iwlist"));
	
	if (argc == 2){
		cmd = argv[1];
		dev = NULL;
		args = NULL;
		count = 0;
	}
	else{
		cmd = argv[2];
		dev = argv[1];
		args = argv + 3;
		count = argc - 3;
	}
	
	/* find a command */
	iwcmd = find_command(cmd);
	
	if(iwcmd == NULL)
		return 1;
	
	/* Check arg numbers */
	if(count < iwcmd->min_count){
		fprintf(stderr, "iwlist: command `%s' needs more arguments\n", cmd);
		return 1;
	}
	
	if(count > iwcmd->max_count){
		fprintf(stderr, "iwlist: command `%s' needs fewer arguments\n", cmd);
		return 1;
	}
	
	/* Create a channel to the NET kernel. */
	if((skfd = iw_sockets_open()) < 0){
		perror("socket");
		return -1;
	}
	
	/* do the actual work */
	if (dev){
		(*iwcmd->fn)(skfd, dev, args, count);
	}
	else{
		iw_enum_devices(skfd, iwcmd->fn, args, count);
	}
	
	/* Close the socket. */
	close(skfd);
	
	return 0;
}
