#!/bin/sh

SCRIPT_FILE="DoIT.sh"
. /home/EdiPrint/target.def

if [ $# = 1 ]; then
	case "$1" in
		"clean")
			export MAKECLEAR=1
			export MAKING=0
			MAKING_IMG=0
			;;
		"noimg")
			export MAKECLEAR=0
			export MAKING=1
			MAKING_IMG=0
			;;
		"config")
			export MAKECLEAR=1
			export MAKCONFIG=1
			export MAKING=0
			MAKING_IMG=0
			;;
		"clean_model")
			cd /home/EdiPrint/AP/goahead-2.1.1/LINUX/
			make clean
			cd /home/EdiPrint/AP/getmodel/
                        make clean
			cd /home/EdiPrint/AP/agent/
			make clean
			cd /home/EdiPrint/AP/Diagd/
			make clean
			cd /home/EdiPrint/AP/upnpd/
			make clean
			;;
	esac
else
	export MAKECLEAR=0
	export MAKING=1
	MAKING_IMG=1
fi

for DIR in $(ls); do
    if [ -d $DIR ]; then
		cd $DIR
		if [ -f $SCRIPT_FILE ]; then
		    echo ""
			echo "******************** Compiling $DIR ********************"
			echo ""
			./$SCRIPT_FILE ap
			if [ $? = 0 ]; then
				echo ""
				echo "******************** End compile $DIR ********************"
				echo ""
			else
                echo ""
                echo "******************** compile ERROR in $DIR !! ********************"
                echo ""
				exit 1
			fi
		fi
		cd ..
	fi
done

if [ "$MAKING_IMG" = "1" ]; then
	echo ""
	echo "******************** Making appimg ********************"
	echo ""
	cd mkimg
	./mkps
#	if [ $? = 0 ]; then
#		echo ""
#		echo "******************** Make appimg OK !! ********************"
#		echo ""
#	else
#	echo ""
#	    echo "******************** Make appimg FAIL !! ********************"
#		echo ""
#		exit 1
#	fi
fi

echo ""
echo "******************** Script finished !! ********************"
echo ""


