#!/bin/sh

CMD=echo
ETHDEV=`cat /sbin/interface`

start_raw() {
	$CMD launch raw
}

start_lpd() {
	$CMD lpd
}

start_ipp() {
	$CMD ipp
}

start_ipx() {
	$CMD launch ipx
}

start_atalk() {
	$CMD papd
}

start_smb() {
	$CMD ns br0 #$ETHDEV
	$CMD smbd
}

start_nb() {
	$CMD nb br0 #$ETHDEV
}

stop_raw() {
	$CMD raw
}

stop_lpd() {
	$CMD lpd
}

stop_ipp() {
	$CMD ipp
}

stop_ipx() {
	$CMD pserver
}

stop_atalk() {
	$CMD papd
}

stop_smb() {
	$CMD ns
	$CMD smbd
}

stop_nb() {
	$CMD nb
}

doaction() {
	case $2 in
		raw)
			$1_raw
			;;
		lpd)
			$1_lpd
			;;
		ipp)
			$1_ipp
			;;
		ipx)
			$1_ipx
			;;
		atalk)
			$1_atalk
			;;
		smb)
			$1_smb
			;;
		nb)
			$1_nb
			;;
		all)
			$1_raw
			$1_lpd
			$1_ipp
			$1_ipx
			$1_atalk
			$1_smb
			$1_nb
			;;
		*)
			echo "Invalid protocol"
			exit 1
	esac
}

ACT=$1
                                                                                
case $ACT in
	start)
		CMD=
		;;
	stop)
		CMD="killall"
		;;
	restart)
#		$PROG stop $2 $3 $4 $5 $6 $7 $8 $9
#		$PROG start $2 $3 $4 $5 $6 $7 $8 $9
		$PROG stop $@
		$PROG start $@
		exit 0
		;;
	reload)
		killall -1 lpsched
		exit 0
		;;
	*)
		echo "Usage: $PROG {start|stop|restart} [protocol(s)]"
		echo "       $PROG {reload}"
		exit 1
esac

shift 1
ARG=$1
                                                                                
while [ "$ARGXX" != "XX" ]; do
	doaction "$ACT" "$ARG"
	if [ "$2XX" != "XX" ]; then
		shift 1
		ARG=$1
	else
		break
	fi
done
exit 0
