/* Reimplementation of Daniel J. Bernsteins taia library.
 * (C) 2001 Uwe Ohse, <uwe@ohse.de>.
 *   Report any bugs to <uwe@ohse.de>.
 * Placed in the public domain.
 */
/* @(#) $Id: taia_now.c,v 1.1.1.1 2005/08/17 06:37:29 johnsoncheng Exp $ */
#include <sys/types.h>
#include <sys/time.h>
#include "taia.h"

void
taia_now (struct taia *t)
{
	struct timeval tv;
	gettimeofday (&tv, (void *)0);
	tai_unix (&t->sec, tv.tv_sec);
	t->atto = 0;
	t->nano = 1000 * tv.tv_usec + 500;
}
