#include <time.h>
#include <stdlib.h>
#include "ftpparse.h"
#include "sort_it.h"
#include "byte.h"

unsigned long sortmode=SM_NEW;


static int cmp_them(const void *a, const void *b)
{
	const struct ftpparse *fa=a;
	const struct ftpparse *fb=b;
	if (sortmode==SM_NEW) return fb->mtime-fa->mtime;
	if (sortmode==SM_OLD) return fa->mtime-fb->mtime;
	if (sortmode==SM_LONG) return fb->size-fa->size;
	if (sortmode==SM_SHORT) return fa->size-fb->size;
	if (fa->namelen==fb->namelen)	
		return byte_diff(fa->name,fa->namelen,fb->name)
			* (sortmode==SM_ALPHA? 1 : -1);
	else {
		int x;
		x = byte_diff (fa->name, fa->namelen < fb->namelen ?
				fa->namelen : fb->namelen, fb->name);
		if (x) return x * (sortmode==SM_ALPHA? 1 : -1);
		if (fa->namelen<fb->namelen) return 1 * (sortmode==SM_ALPHA? 1 :-1);
		if (fa->namelen==fb->namelen) return 0;
		return -1 * (sortmode==SM_ALPHA? 1 :-1);
	}
}

void
sort_it(struct ftpparse *fp, int count)
{
    qsort(fp,count,sizeof(*fp),cmp_them);
}

