#include <time.h>
#include <stdlib.h>
#include "ftpparse.h"
#include "buffer.h"
#include "stralloc.h"
#include "ftplib.h"
#include "ftpcopy.h"
#include "mdtm.h"
#include "bailout.h"
#include "error.h"

int
modtime_request(const char *s, time_t *t)
{
	char *p;
	unsigned int i;
	struct tm tm;
	static int init_done;
	if (!init_done) {
		init_done++;
		/* why do i have to do this? Why isn't there a "set time zone to ..."
		 * function? tzset is just plain broken, it doesn't even provide
		 * a return value ...
		 */
		if (setenv("TZ","UTC",1))
			oom();
		tzset();
	}

	cmdwrite2("MDTM ",s);
	p=ccread();
	if (!p) 
		xbailout(111,errno,"failed to read MDTM answer",0,0,0);
	if (*p!='2') {
		warning(0,"got unwanted answer to `MDTM ",s,"': ",p);
		if (*p=='5' && p[1]=='0' && p[2]=='2') 
			return -1;
		return 0;
	}
	tm.tm_year=tm.tm_mon=tm.tm_mday=tm.tm_hour=tm.tm_min=tm.tm_sec=0;
	tm.tm_gmtoff=0;
	tm.tm_zone=0;
	tm.tm_isdst=0;
	for (i=4;p[i];i++) {
		int *q;
		switch (i) {
		case 4: case 5: case 6: case 7: q=&tm.tm_year; goto doit;
		case 8: case 9: q=&tm.tm_mon; goto doit;
		case 10: case 11: q=&tm.tm_mday; goto doit;
		case 12: case 13: q=&tm.tm_hour; goto doit;
		case 14: case 15: q=&tm.tm_min; goto doit;
		case 16: case 17: 
			q=&tm.tm_sec;
		doit:
			(*q)*=10;
			(*q)+=p[i]-'0';
			break;
		case 18: 
			goto parseerror;
		}
	}
	if (i!=18) {
		parseerror:
		warning(0,"failed to parse ",p,0,0);
		return 0;
	}
	tm.tm_year-=1900;
	tm.tm_mon-=1;
	*t=mktime(&tm);
	if (*t == (time_t) -1) {
		warning(0,"failed to parse ",p,0,0);
		return 0;
	}
	return 1;
}
