#! /bin/sh
#
# check for function $1.
# $4 is how to call the function.
fn="$1" ; shift
extraheader="$1" ; shift
call="$1" ; shift
extralink="$1" ; shift
libs="$1" ; shift
FN=`echo "$fn" | tr 'a-z' 'A-Z'`
#
cat >conftest.c <<EOF
#include <sys/types.h>
$extra
int main(void)
{
	$call
	;
	_exit(0);
}
EOF
./auto-compile.sh -c conftest.c  #2>/dev/null >/dev/null
if test $? -ne 0 ; then
	rm -f conftest.c
	cat <<EOF
#ifndef have_${fn}_h
#define have_${fn}_h
#undef HAVE_$FN /* systype-info */
#endif
EOF
exit 0
fi
for i in "" $libs ; do
	if test "x$i" = x ; then
		l=""
	else
		l="-l$i"
	fi
	# >&2 because we use the stdout of this script, and the MAC OS X linker
	# thinks the error messages belong on stdout.
	./auto-link.sh conftest conftest.o $extralink $l >&2
	if test "x$?" = "x0" ; then
		if ./conftest ; then
			cat <<EOF
#ifndef have_${fn}_h
#define have_${fn}_h
#define HAVE_$FN 1 /* systype-info */
#endif
EOF
			rm -f conftest.c conftest.o conftest
			exit 0
		fi
	fi
done
rm -f conftest.c conftest.o conftest
cat <<EOF
#ifndef have_${fn}_h
#define have_${fn}_h
#undef HAVE_$FN /* systype-info */
#endif
EOF
