#include <time.h> /* ftpparse needs it */
#include "attributes.h"
#include "stralloc.h"
#include "ftpparse.h"
#include "buffer.h"
#include "ftplib.h"
#include "alloc.h"
#include "uogetopt.h"
#include "uotime.h"
#include "urlparse.h"
#include "iopause.h"
#include "getln.h"
#include "fmt.h"
#include "str.h"
#include "error.h"
#include "ftpcopy.h"
#include "bailout.h"
#include "close.h"
#include "str.h"
#include "readwrite.h"
#include "sort_it.h"
#include "mlsx.h"
#include "strhash.h"

static strhash hash;


buffer io_i;
buffer io_o;
int data_sock=-1;
static const char *o_user;
static const char *o_pass;
static const char *o_acct;
static const char *o_title;
static const char *o_urlprefix;
static int may_mlsx=1;
static int o_interactive;
static int o_recursive;
unsigned long o_loglevel=1;
static int o_html=0;
unsigned long o_timeout=30;
unsigned long o_login_sleep=5;
static int o_machine=0;
extern unsigned long sortmode;
static const char *o_list_options=0;
static stralloc urlprefix;
static unsigned long o_tries=1;
static unsigned int dirprintoffset=0;
static int o_raw=0;
static int o_print_dir=0;
stralloc remoteip;

static void usage(void) attribute_noreturn;


#define KB (1024)
#define MB (1024*1024)
static void ulong_pad(stralloc *out, unsigned long l, unsigned int ml)
{
	char buf[FMT_ULONG];
	l=fmt_ulong(buf,l);
	if (l<ml) 
		if (!stralloc_catb(out,"    ",ml-l)) oom();
	if (!stralloc_catb(out,buf,l)) oom();
}

static void mksize(stralloc *out,size_t l)
{
	if (l<10000) {
		ulong_pad(out,l,4);
		if (!stralloc_cats(out,"    B")) oom();
	}
	else if (l<9*MB) {
		ulong_pad(out,l/KB,4);
		if (!stralloc_cats(out,".")) oom();

		ulong_pad(out, (l-(l/KB)*KB)/102,1);
		if (!stralloc_cats(out," KB")) oom();
	} else {
		ulong_pad(out,l/MB,4);
		if (!stralloc_cats(out,".")) oom();
		ulong_pad(out, (l-(l/MB)*MB)/(102*KB),1);
		if (!stralloc_cats(out," MB")) oom();
	}
}

static void
entity(stralloc *d, struct ftpparse *x)
{
	char nb[FMT_ULONG];
	char db[20];
	static stralloc sizebuf=STRALLOC_INIT;
	uo_sec70_t s70;
	uo_datetime_t dt;
	s70=x->mtime;
	uo_sec702dt(&dt,&s70);
	yyyy_mm_dd_hh_mm_ss(db,&dt,'-');
	if (o_machine) {
		log1("N");
		if (d->s[dirprintoffset])
			log2(d->s+dirprintoffset,"/");
		logmem(x->name,x->namelen);
		log1("\nK");
		if (x->flagtrycwd && x->flagtryretr) log1("link"); /* guess */
		else if (x->flagtrycwd) log1("dir");
		else log1("file");
		log1("\nS");
		nb[fmt_ulong(nb,x->size)]=0;
		log4(nb,"\nT",db,"\n");
	} else if (o_html) {
		log1("<dt><a href=\"");
		logmem(urlprefix.s,urlprefix.len);
		if (d->s[dirprintoffset]) 
			log2(d->s+dirprintoffset,"/");
		logmem(x->name,x->namelen);
		log1("\">");
		if (d->s[dirprintoffset])
			log2(d->s+dirprintoffset,"/");
		logmem(x->name,x->namelen);
		log1("</a><br>\n");
		log3("<dd> last modified ",db,", ");
		sizebuf.len=0;
		mksize(&sizebuf,x->size);
		logmem(sizebuf.s,sizebuf.len);
		log1("\n");
	} else{
		if (x->flagtrycwd && x->flagtryretr) log1("link "); /* guess */
		else if (x->flagtrycwd) log1("dir  ");
		else log1("file ");
		log2(db,"  ");
		sizebuf.len=0;
		mksize(&sizebuf,x->size);
		logmem(sizebuf.s,sizebuf.len);
		log1(" ");
		if (d->s[dirprintoffset])
			log2(d->s+dirprintoffset,"/");
		logmem(x->name,x->namelen);
		log1("\n");
	}
}


static int 
get_listing(stralloc *r_dir, stralloc *dirdata, int *dirlines)
{
	char *p;
	int got_it;
	int listno;

	if (data_sock==-1)
		data_sock=do_pasv();

	cmdwrite2(r_dir->s[0]=='/' ? "CWD " : "CWD /",r_dir->s);

	p=ccread();
	if (!p) xbailout(111,errno,"failed to read CWD answer",0,0,0);
	if (*p!='2') {
		warning(0,"unwanted answer to CWD ",r_dir->s,": ",p);
		return 0;
	}
	got_it=0;
	if (may_mlsx) 
		listno=0;
	else
		listno=1;
  retry_listing:
	if (listno==0)
		cmdwrite1("MLSD");
	else if (o_list_options)
		cmdwrite2("LIST ", o_list_options);
	else
		cmdwrite1("LIST");
	
	p=ccread();
	if (!p) 
		xbailout(111,errno,"failed to read LIST/MLSD answer",0,0,0);
	if (listno==0 && *p=='5') {
		listno=1;
		if (!str_start(p,"501")) 
			may_mlsx=0;
		goto retry_listing;
	}

	if (*p!='1') {
		warning(0,"unwanted answer to LIST/MLSD ",r_dir->s,": ",p);
		return 0;
	}
	*dirlines=ftp_read_list(data_sock,dirdata);
	if (-1==*dirlines)
		xbailout(111,errno,"failed to read directory listing",0,0,0);
	close(data_sock);
	data_sock=-1;
	x2("LIST/MLSD");

	return 1;
}

static int
parseit(stralloc *r_dir, stralloc *dirdata, int dirlines)
{
	char *p,*e;
	int ind;
	struct ftpparse *parsed;
	int i;
	p=dirdata->s;
	e=dirdata->s+dirdata->len;
	parsed=(struct ftpparse *)alloc(sizeof(*parsed) * dirlines);
	if (!parsed) oom();
	ind=0;

	while (p!=e) {
		unsigned int l=str_len(p);
		int ok;
		if (o_raw) {
			logmem(p,l);
			logmem("\n",1);
		}
		if (may_mlsx) {
			ok=mlsx_parse(&parsed[ind],p,l);
		} else {
			ok=ftpparse(&parsed[ind],p,l);
		}
		if (!ok) {
			if (!str_start(p,"total") && !str_start(p,"Total")) 
				log3("cannot parse LIST line: ",p,"\r\n");
		} else if (parsed[ind].name[0]=='.'
			&& (parsed[ind].namelen==1 || (parsed[ind].namelen==2 && parsed[ind].name[1]=='.'))) {
			if (o_loglevel > 1) {
				log2(r_dir->s,"/");
				logmem(parsed[ind].name,parsed[ind].namelen);
				log1(": ignored\n");
			}
		} else {
			ind++;
		}
		p+=l+1;
	}
	if (!o_raw)
		sort_it(parsed,ind);
	/* output */
	if (!o_raw)
		for (i=0;i<ind;i++) 
			entity(r_dir,&parsed[i]);
	if (o_recursive) 
		for (i=0;i<ind;i++)  {
			struct ftpparse *x;
			stralloc t=STRALLOC_INIT;
			char *id;
			unsigned int idlen;
			x=&parsed[i];
			if (x->flagtryretr || !x->flagtrycwd)
				continue;
			if (x->idlen) {
				idlen=x->idlen;
				id=x->id;
			} else {
				if (!stralloc_copy(&t,r_dir)) oom();
				if (!stralloc_append(&t,"/")) oom();
				if (!stralloc_catb(&t,x->name,x->namelen)) oom();
				id=t.s;
				idlen=t.len;
			}
			if (!strhash_lookup(&hash,id,idlen,0,0)) {
				unsigned int pos;
				stralloc dd=STRALLOC_INIT;
				int dl=0;
				r_dir->len--;
				pos=r_dir->len;

				if (1!=strhash_enter(&hash, 1,id,idlen, 0,"",0)) oom();

				if (r_dir->s[r_dir->len-1]!='/')
					if (!stralloc_append(r_dir,"/")) 
						oom();
				if (!stralloc_catb(r_dir,x->name,x->namelen))
					oom();
				if (!stralloc_0(r_dir)) oom();
				if (get_listing(r_dir,&dd,&dl)) {
					if (o_html) {
						log2("<dt>Listing of:<dd>",r_dir->s);
						log1("<dl>\n");
					}
					if (!o_html && o_print_dir) {
						logmem(r_dir->s,r_dir->len-1);
						logmem(":\n",2);
					}
					parseit(r_dir,&dd,dl);
					if (o_html)
						log1("</dl>\n");
				}
				stralloc_free(&dd);
				r_dir->len=pos;
				if (!stralloc_0(r_dir)) oom();
			}
			stralloc_free(&t);
		}
	return 1;
}

static uogetopt_t myopts[] =
{
{ 0, "", UOGO_TEXT, 0,0, "Login / username / password options:",0},
{  0, "account", UOGO_STRING, &o_acct,0,
"Send ACCOUNT as account name during login phase.\n"
"Note: this is _not_ the user name (-u), but the\n"
"name of what could be called a subaccount\n"
"implemented by a few servers.","ACCOUNT"},
{'p', "pass", UOGO_STRING, &o_pass,0,
"Use PASS as password to login on the ftp server.\n"
"The default is `anonymous@invalid.example'.","PASSWORD"},
{'u', "user", UOGO_STRING, &o_user,0,
"Use NAME to login on the ftp server.\n"
"The default is `anonymous'. Use an empty name\n"
"to force to not log in.","NAME"},
{'\0', "tries", UOGO_ULONG, &o_tries,0,
"Number of tries to connect and log in.\n"
"The default is 1.",0},
{'\0', "login-sleep", UOGO_ULONG, &o_login_sleep,0,
"Seconds to sleep after a failed login.\n"
/*2345678901234567890123456789012345678901234567890 */
"More precisely: ftpls will fall to sleep for this\n"
"many seconds after a try to connect or login has\n"
"failed. The default is 5.",0},

{ 0, "", UOGO_TEXT, 0,0, "Operational options:",0},
{0, "interactive", UOGO_FLAG, &o_interactive,1,
"Read directories to list from stdin.\n"
"The directory in the URL is ignored.\n"
"Each listing is terminated by a END-OF-LISTING\n"
"line. Do not use this together with --html.",""},
{'T', "timeout", UOGO_ULONG, &o_timeout,0,
"Timeout to use for read/write (sec.).\n"
"The default is 30 seconds.",0},
{'R', "recursive", UOGO_FLAG, &o_recursive, 1, "Do recursive listing.\n",0}, 
{  0, "raw", UOGO_FLAG, &o_raw, 1, "Raw output in original format.\n",0},

{ 0, "", UOGO_TEXT, 0,0, "Sorting options:",0},
{'a', "alpha", UOGO_FLAG, &sortmode, SM_ALPHA, "sort alphabetical.",0},
{'z', "omega", UOGO_FLAG, &sortmode, SM_OMEGA, "sort reverse alphabetical.",0},
{'n', "newest", UOGO_FLAG, &sortmode, SM_NEW, "sort youngest first.",0},
{'o', "oldest", UOGO_FLAG, &sortmode, SM_OLD, "sort oldest first.",0},
{'s', "shortest", UOGO_FLAG, &sortmode, SM_SHORT, "sort shortest first.",0},
{'l', "longest", UOGO_FLAG, &sortmode, SM_LONG, "sort longest first.",0},

{ 0, "", UOGO_TEXT, 0,0, "Output options:",0},
{'h', "html", UOGO_FLAG, &o_html, 1, "Create HTML index.\n",0},
{'m', "machine", UOGO_FLAG, &o_machine, 1, "Create machine parsable output.",0},
{'t', "title", UOGO_STRING, &o_title,0,
"Title text to use on the HTML output.","TEXT"},
{'U', "urlprefix", UOGO_STRING, &o_urlprefix,0,
"URL-Prefix to use in listings.\n"
"The default is taken from the arguments.","URL"},
{  0, "print-dir", UOGO_FLAG, &o_print_dir, 1, "Print sub directory names.\n"
"This option makes ftpls print the name of a\n"
"directory before it lists it's content. Note\n"
"that the name of the top level directory of each\n"
"listing will not be printed.",0},

{ 0, "", UOGO_TEXT, 0,0, "Workaround options:",0},
{'L', "list-options", UOGO_STRING, &o_list_options,1,
"Add OPTS to LIST command.\n"
"This allows to pass arbitrary options to the\n"
"FTP servers LIST command. Note that ftpcopy does\n"
"not cope well with recursive directory listings.","OPTS"},
{0, "force-select", UOGO_FLAG, &iopause_force_select,1,
"Use select, not poll.\n"
"This works around a limitation of the socks5\n"
"reference implementation. Use this only if you\n"
"are using SOCKS. Note: Direct access to a DNS\n"
"resolver is needed if you use host names.",0},
{0, 0, 0, 0, 0, 0, 0}           /* --help and --version */
};

static void 
usage(void) 
{
	bailout(0,
	  "usage: ftpls [options] host[:port] [remotedir-if-not-interactive]\n"
	  "   or: ftpls [options] URL\n"
	  "  use the --help option to get a description of the options",
	  0,0,0);
}

static int
onelisting(stralloc *d)
{
	static stralloc dirdata=STRALLOC_INIT;
	static int dirlines=0;
	dirprintoffset=d->len-1; /* \0 */
	strhash_destroy(&hash);
	if (-1==strhash_create(&hash,16,32,strhash_hash)) oom();

	if (!get_listing(d,&dirdata,&dirlines))
		return 1;
	if (o_html) {
		log1("<html><head>\n");
		if (o_title) log3("<title>",o_title,"</title>\n");
		log1("</head><body>\n");
		if (o_title) {
			log3("<h1>",o_title,"</h1>\n");
		}
		log1("<dl>\n");
	}
	parseit(d,&dirdata,dirlines);
	if (o_html) {
		log1("</dl></body></html>\n");
	}
	if (o_interactive)
		if (!o_html)
			log1("END-OF-LISTING\n");
	return 0;
}

int 
main(int argc, char **argv)
{
	const char *host,*remotedir;
	stralloc d1=STRALLOC_INIT;
	stralloc proto=STRALLOC_INIT;
	stralloc user=STRALLOC_INIT;
	stralloc pass=STRALLOC_INIT;
	stralloc hostport=STRALLOC_INIT;
	stralloc rest=STRALLOC_INIT;
	int retcode;

	bailout_progname(argv[0]);

	uogetopt (flag_bailout_log_name, PACKAGE, VERSION, 
		&argc, argv, uogetopt_out, 
	  "usage: ftpls [options] host[:port] [remotedir-if-not-interactive]\n"
	  "   or: ftpls [options] URL\n",
	  myopts,
	  "\nReport bugs to <ftpcopy@bulkmail.ohse.de>");
	if (argc <2 || argc >3)
		usage();

	if (urlparse(argv[1],&proto,&user,&pass,&hostport,&rest)) {
		if (!stralloc_0(&proto)) oom();
		if (!str_equal(proto.s,"ftp")) 
			xbailout(100,0,"URL type `",proto.s,"' is not supported",0);
		if (!hostport.len) xbailout(100,0,"empty host in url",0,0,0);
		if (!stralloc_0(&hostport)) oom();
		host=hostport.s;
		if (!rest.len) if (!stralloc_append(&rest,"/")) oom();
		if (!stralloc_0(&rest)) oom();
		remotedir=rest.s;
		if (!o_user && user.len) {
			if (!stralloc_0(&user)) oom();
			o_user=user.s;
		}
		if (!o_pass && pass.len) {
			if (!stralloc_0(&pass)) oom();
			o_user=pass.s;
		}
		if (argv[2]) 
			usage();

		if (!stralloc_copys(&urlprefix,argv[1])) oom();
		if (urlprefix.s[urlprefix.len-1]!='/')
			if (!stralloc_append(&urlprefix,"/")) oom();
	} else {
		host=argv[1];
		if (!argv[2] && !o_interactive) 
			usage();
		remotedir=argv[2];
		if (o_html && !o_interactive) {
			if (!stralloc_copys(&urlprefix,"ftp://")) oom();
			if (!stralloc_cats(&urlprefix,host)) oom();
			if (!stralloc_cats(&urlprefix,remotedir)) oom();
			if (urlprefix.s[urlprefix.len-1]!='/')
				if (!stralloc_append(&urlprefix,"/")) oom();
		} else
			if (!stralloc_0(&urlprefix)) oom();
	}
	if (!o_user) o_user="anonymous";
	if (!o_pass) o_pass="anonymous@example.invalid";
	if (o_urlprefix) if (!stralloc_copys(&urlprefix,o_urlprefix)) oom();

	connect_auth(host,o_user,o_pass,o_acct,o_tries);

	sx2("TYPE I");
	retcode=0;
	if (o_interactive) {
		buffer io_stdin;
		char spc[BUFFER_INSIZE];
		buffer_init(&io_stdin,(buffer_op_t)read,0,spc,sizeof(spc));
		while (1) {
			int gotlf;
			if (-1==getln(&io_stdin,&d1,&gotlf,'\n'))
				xbailout(111,errno,"failed to read from stdin",0,0,0);
			if (d1.len==0)
				break;
			d1.len--;
			if (!stralloc_copys(&urlprefix,"ftp://")) oom();
			if (!stralloc_cats(&urlprefix,host)) oom();
			if (!stralloc_cat(&urlprefix,&d1)) oom();
			if (urlprefix.s[urlprefix.len-1]!='/')
				if (!stralloc_append(&urlprefix,"/")) oom();
			if (!stralloc_0(&d1)) oom();
			retcode=onelisting(&d1);
		}
	} else {
		if (!stralloc_copys(&d1,remotedir) || !stralloc_0(&d1)) oom();
		retcode=onelisting(&d1);
	}
	return (0);
}
