#include "stralloc.h"
#include "buffer.h"
#include "getln.h"
#include "timeoutio.h"
#include "ftplib.h"
#include "readwrite.h"
#include "str.h"
#include "error.h"

MKTIMEOUTREAD(30)

int 
ftp_read_list(int fd,stralloc *dir)
{
	buffer io;
	int lines=0;
	char buf[BUFFER_INSIZE];
	stralloc direntry=STRALLOC_INIT;
	buffer_init(&io,(buffer_op_t)TIMEOUTREADFN(30),fd,buf,BUFFER_INSIZE);
	dir->len=0;
	while (1) {
		int gotlf;
		if (-1==getln(&io,&direntry,&gotlf,'\n'))
			return -1;
		if (direntry.len==0) break; /* XXX temporary errors? */
		if (!gotlf) 
			return -1;
		direntry.len--;
		if (direntry.s[direntry.len-1]=='\r') direntry.len--;
		direntry.s[direntry.len]=0;
		if (str_start(direntry.s,"total") 
			|| str_start(direntry.s,"Total"))
			continue;
		if (!stralloc_catb(dir,direntry.s,direntry.len+1)) 
			return -1;
		lines++;
	}
	stralloc_free(&direntry);
	return lines;
}

