#include "buffer.h"
#include "attributes.h"
#include "stralloc.h"
#include "str.h"
#include "ftplib.h"
#include "bailout.h"
#include "ftpcopy.h"
#include "error.h"
#include "timeoutio.h"
#include "host_connect.h"
#include "readwrite.h"
#include "iopause.h"
#include "close.h"
#include "mysleep.h"

static stralloc io_i_mem;
static stralloc io_o_mem;

MKTIMEOUTREAD(o_timeout)
MKTIMEOUTWRITE(o_timeout)
static void die_remoteread(void) attribute_noreturn;
static void die_commandwrite(void) attribute_noreturn;
static void die_remoteeof(void) attribute_noreturn;
static void die_logwrite(void) attribute_noreturn;

static void die_remoteread(void)
{ xbailout(111,errno,"failed to read from remote",0,0,0);}
static void die_commandwrite(void)
{ xbailout(111,errno,"failed to send command",0,0,0);}
static void die_remoteeof(void)
{ xbailout(111,errno,"connection closed by remote host",0,0,0);}
static void die_logwrite(void) 
{xbailout(111,errno,"failed to write log",0,0,0);}


char *
ccread(void)
{
	static stralloc sa=STRALLOC_INIT;
	switch(ftp_cc_read(&io_i,&sa)) {
	case  0: errno=0; /* FALL THROUGH */
	case -1: return 0;
	}
	return sa.s;
}
char *
ccread_oneline(void)
{
	static stralloc sa=STRALLOC_INIT;
	switch(ftp_cc_read_oneline(&io_i,&sa)) {
	case  0: errno=0; /* FALL THROUGH */
	case -1: return 0;
	}
	return sa.s;
}
void
cmdwrite2(const char *s1, const unsigned char *s2)
{
	if (-1==ftp_cc_write_cmd_ss(&io_o,s1,s2))
		die_commandwrite();
}
void x2(const char *where)
{
	char *p;
	p=ccread();
	if (!p && !errno)  die_remoteeof();
	if (!p) die_remoteread();
	if (*p != '2') xbailout(111,0,"received unwanted answer to ",where,": ",p);
}
void sx2(const char *what)
{
	cmdwrite1(what);
	x2(what);
}
void
cmdwrite1(const char *s1)
{
	if (-1==ftp_cc_write_cmd_s(&io_o,s1)) 
		die_commandwrite();
}
#define LOGSTR(x) if (-1==buffer_puts(buffer_1,(x))) die_logwrite();
#define LOGMEM(x,y) if (-1==buffer_put(buffer_1,(x),(y))) die_logwrite();
#define LOGFLUSH() if (-1==buffer_flush(buffer_1)) die_logwrite();

void log1(const char *s1) { LOGSTR(s1); LOGFLUSH(); }
void log2(const char *s1, const char *s2)
	{ LOGSTR(s1); LOGSTR(s2); LOGFLUSH(); }
void log3(const char *s1, const char *s2, const char *s3)
	{ LOGSTR(s1); LOGSTR(s2); LOGSTR(s3); LOGFLUSH(); }
void log4(const char *s1, const char *s2, const char *s3, const char *s4)
	{ LOGSTR(s1); LOGSTR(s2); LOGSTR(s3); LOGSTR(s4); LOGFLUSH(); }
void logmem(const char *s1,unsigned int l) { LOGMEM(s1,l); LOGFLUSH(); }

int
do_pasv(void)
{
	int x;
	x=ftp_cc_pasv(&io_i,&io_o,o_timeout,&remoteip);
	switch(x) {
	case 0: die_remoteeof();
	case -1: die_remoteread();
	case -2: xbailout(111,0,"cannot parse PASV answer",0,0,0);
	case -3: xbailout(111,0,"illegal redirect by FTP server",0,0,0);
	}
	return x;
}
int
connect_auth (const char *host, const char *o_user, 
	const char *o_pass, const char *o_acct, int tries)
{
	if (!stralloc_ready(&io_i_mem,BUFFER_INSIZE)) oom();
	if (!stralloc_ready(&io_o_mem,BUFFER_OUTSIZE)) oom();
	if (!o_login_sleep)
		o_login_sleep=1;

	while (1) {
		int need_auth = 1;
		int need_acct = 0;
		char *p;
		int sock;
		if (!tries) 
			xbailout(111,0,"failed to connect or log in",0,0,0);
		tries--;
		if (!tries)
			sock=xhost_connect4(host,21,o_timeout,&remoteip);
		else
			sock=host_connect4(host,21,o_timeout,&remoteip);
		if (sock==-1)
			goto dosleep1;

		buffer_init(&io_i,(buffer_op_t)TIMEOUTREADFN(o_timeout),sock,
		io_i_mem.s,BUFFER_INSIZE);
		buffer_init(&io_o,(buffer_op_t)TIMEOUTWRITEFN(o_timeout),sock,
		io_o_mem.s,BUFFER_OUTSIZE);
											
		p = ccread ();
		if (!p) {
			if (tries) goto dosleep;
			if (!errno) 
				die_remoteeof();
			die_remoteread();
		}
		if (o_loglevel > 2)
			log2 (p, "\n");
		if (!str_start (p, "220 ")) {
			if (!tries) 
				xbailout (111,0, "received unexpected greeting message: ", 
					p, 0, 0);
			goto dosleep;
		}
		if (!o_user || !*o_user) 
			need_auth=0;
		if (str_start(p,"220 Features:")) {
			char *q;
			for (q = p; *q; q++) {
				if (*q == ' ' && q[1] == 'a')
					break;
			}
			if (*q)
				if (str_equal (o_user, "anonymous")
					|| str_equal (o_user, "ftp"))
					need_auth = 0;
		}

		if (need_auth) {
			cmdwrite2 ("USER ", o_user);
			p = ccread ();
			if (!p) {
				if (tries) goto dosleep;
				if (!errno) 
					die_remoteeof();
				die_remoteread();
			}
			if (o_loglevel > 2)
				log2 (p, "\n");
			if (*p == '5') {
				if (tries) goto dosleep;
				xbailout (111,0, "received unwanted USER response: ", p, 0, 0);
			}
			if (*p == '2')
				return sock;
			if (o_pass && *o_pass) {
				cmdwrite2 ("PASS ", o_pass);
				p = ccread ();
				if (!p) {
					if (tries) goto dosleep;
					if (!errno)
						die_remoteeof();
					die_remoteread();
				}
				if (o_loglevel > 2)
					log2 (p, "\n");
				if (str_start(p,"332"))
					need_acct=1;
				else if (*p != '2') {
					if (!tries) 
						xbailout (111,0, "remote host rejected password: ", 
							p, 0, 0);
					goto dosleep;
				}
			} else
				xbailout(111,0,"remote host asked for password.",0,0,0);
			if (need_acct) {
				if (!o_acct)
					xbailout(111,0,"remote host asked for ACCT.",0,0,0);
				cmdwrite2 ("ACCT ", o_acct);
				p = ccread ();
				if (!p) {
					if (tries) goto dosleep;
					if (!errno)
						die_remoteeof();
					die_remoteread();
				}
				if (o_loglevel > 2)
					log2 (p, "\n");
				if (*p != '2') {
					if (!tries) 
						xbailout(111,0,"remote host rejected account: ",p,0,0);
					goto dosleep;
				}
			}
		}
		return sock;
	  dosleep:
		close(sock);
	  dosleep1:
	  	mysleep(o_login_sleep);
	}
}
