MDADM(8)                                                              MDADM(8)



NNAAMMEE
       mdadm - manage MD devices _a_k_a Linux Software Raid.


SSYYNNOOPPSSIISS
       mmddaaddmm _[_m_o_d_e_] _<_r_a_i_d_d_e_v_i_c_e_> _[_o_p_t_i_o_n_s_] _<_c_o_m_p_o_n_e_n_t_-_d_e_v_i_c_e_s_>


DDEESSCCRRIIPPTTIIOONN
       RAID  devices  are  virtual devices created from two or more real block
       devices. This allows multiple devices (typically disk drives or  parti-
       tions  there-of) to be combined into a single device to hold (for exam-
       ple) a single filesystem.  Some RAID levels include redundancy  and  so
       can survive some degree of device failure.

       Linux  Software  RAID  devices are implemented through the md (Multiple
       Devices) device driver.

       Currently, Linux supports LLIINNEEAARR md devices,  RRAAIIDD00  (striping),  RRAAIIDD11
       (mirroring), RRAAIIDD44, RRAAIIDD55, RRAAIIDD66, RRAAIIDD1100, MMUULLTTIIPPAATTHH, and FFAAUULLTTYY.

       MMUULLTTIIPPAATTHH  is  not a Software RAID mechanism, but does involve multiple
       devices.  For MMUULLTTIIPPAATTHH each device is a path to  one  common  physical
       storage device.

       FFAAUULLTTYY is also not true RAID, and it only involves one device.  It pro-
       vides a layer over a true device that can be used to inject faults.



MMOODDEESS
       mdadm has 7 major modes of operation:

       AAsssseemmbbllee
              Assemble the parts of a previously created array into an  active
              array.  Components  can  be  explicitly given or can be searched
              for.  mmddaaddmm checks that the  components  do  form  a  bona  fide
              array,  and can, on request, fiddle superblock information so as
              to assemble a faulty array.


       BBuuiilldd  Build an array that doesn't have  per-device  superblocks.   For
              these  sorts  of arrays, _m_d_a_d_m cannot differentiate between ini-
              tial creation and subsequent assembly of an array.  It also can-
              not  perform  any  checks  that  appropriate  devices  have been
              requested.  Because of this, the BBuuiilldd mode should only be  used
              together with a complete understanding of what you are doing.


       CCrreeaattee Create a new array with per-device superblocks.


       MMaannaaggee This is for doing things to specific components of an array such
              as adding new spares and removing faulty devices.


       MMiisscc   This mode allows operations on independent devices such as exam-
              ine  MD superblocks, erasing old superblocks and stopping active
              arrays.


       FFoollllooww oorr MMoonniittoorr
              Monitor one or more md devices and act  on  any  state  changes.
              This  is  only  meaningful  for  raid1, 4, 5, 6, 10 or multipath
              arrays as only these have interesting state.   raid0  or  linear
              never have missing, spare, or failed drives, so there is nothing
              to monitor.


       GGrrooww   Grow (or shrink) an array, or otherwise reshape it in some  way.
              Currently supported growth options including changing the active
              size of componenet devices in RAID level  1/4/5/6  and  changing
              the number of active devices in RAID1.


OOPPTTIIOONNSS
       Available options are:


       --AA, ----aasssseemmbbllee
              Assemble a pre-existing array.


       --BB, ----bbuuiilldd
              Build a legacy array without superblocks.


       --CC, ----ccrreeaattee
              Create a new array.


       --QQ, ----qquueerryy
              Examine  a device to see (1) if it is an md device and (2) if it
              is a component of an md array.  Information about what  is  dis-
              covered is presented.


       --DD, ----ddeettaaiill
              Print detail of one or more md devices.


       --EE, ----eexxaammiinnee
              Print content of md superblock on device(s).


       --FF, ----ffoollllooww, ----mmoonniittoorr
              Select MMoonniittoorr mode.


       --GG, ----ggrrooww
              Change the size or shape of an active array.


       --XX, ----eexxaammiinnee--bbiittmmaapp
              Report information about a bitmap file.


       --hh, ----hheellpp
              Display general help message or, after one of the above options,
              a mode specific help message.


       ----hheellpp--ooppttiioonnss
              Display more detailed help about command line parsing  and  some
              commonly used options.


       --VV, ----vveerrssiioonn
              Print version information for mdadm.


       --vv, ----vveerrbboossee
              Be more verbose about what is happening.  This can be used twice
              to be extra-verbose.  The extra verbosity currently only affects
              ----ddeettaaiill ----ssccaann and ----eexxaammiinnee ----ssccaann.


       --qq, ----qquuiieett
              Avoid  printing  purely  informative messages.  With this, mmddaaddmm
              will be silent unless there is  something  really  important  to
              report.


       --bb, ----bbrriieeff
              Be  less  verbose.   This  is  used with ----ddeettaaiill and ----eexxaammiinnee.
              Using ----bbrriieeff with ----vveerrbboossee gives an intermediate level of ver-
              bosity.


       --WW, ----wwrriittee--mmoossttllyy
              subsequent  devices  lists in a ----bbuuiilldd, ----ccrreeaattee, or ----aadddd com-
              mand will be flagged as 'write-mostly'.  This is valid for RAID1
              only  and  means  that  the  'md' driver will avoid reading from
              these devices if at all possible.  This can be useful if mirror-
              ing over a slow link.


       --bb, ----bbiittmmaapp==
              Give  the  name of a bitmap file to use with this array.  Can be
              used with --create (file should  not  exist),  --assemble  (file
              should exist), of --grow (file should not exist).

              The file iinntteerrnnaall can be used to indicate that the bitmap should
              be stored in the array, near the superblock.  There is a limited
              amount of space for such bitmaps, but it is often sufficient.

              The  file  nnoonnee  can  be given when used with --grow to remove a
              bitmap.


       ----bbiittmmaapp--cchhuunnkk==
              Set the Chunksize of the bitmap. Each bit  corresponds  to  that
              many Kilobytes of storage. Default is 4.


       ----wwrriittee--bbeehhiinndd==
              Specify  that  write-behind  mode  should  be enabled (valid for
              RAID1 only). If an argument is specified, it will set the  maxi-
              mum  number  of outstanding writes allowed. The default value is
              256.  A write-intent bitmap is required in order to  use  write-
              behind mode, and write-behind is only attempted on drives marked
              as _w_r_i_t_e_-_m_o_s_t_l_y.



       --ff, ----ffoorrccee
              Be more forceful about  certain  operations.   See  the  various
              modes of the exact meaning of this option in different contexts.


       --cc, ----ccoonnffiigg==
              Specify the config file.  Default is  //eettcc//mmddaaddmm..ccoonnff.   If  the
              config  file  given is ppaarrttiittiioonnss then nothing will be read, but
              _m_d_a_d_m will act as  though  the  config  file  contained  exactly
              DDEEVVIICCEE  ppaarrttiittiioonnss and will read //pprroocc//ppaarrttiittiioonnss to find a list
              of devices to scan.  If the word nnoonnee is given  for  the  config
              file,  then _m_d_a_d_m will act as though the config file were empty.


       --ss, ----ssccaann
              scan config file or //pprroocc//mmddssttaatt for  missing  information.   In
              general,  this  option gives mmddaaddmm permission to get any missing
              information, like component devices, array devices, array  iden-
              tities,  and  alert  destination  from  the  configuration file:
              //eettcc//mmddaaddmm..ccoonnff.  One exception is MISC mode when using ----ddeettaaiill
              or  ----ssttoopp  in  which  case  ----ssccaann  says to get a list of array
              devices from //pprroocc//mmddssttaatt.


       --ee ,,  ----mmeettaaddaattaa==
              Declare the style of superblock (raid metadata) to be used.  The
              default is 0.90 for --create, and to guess for other operations.

              Options are:

              0, 0.90, default
                     Use the original 0.90  format  superblock.   This  format
                     limits  arrays to 28 componenet devices and limits compo-
                     nent devices of levels 1 and greater to 2 terabytes.

              1, 1.0, 1.1, 1.2
                     Use the new version-1 format superblock.   This  has  few
                     restrictions.    The   different   subversion  store  the
                     superblock at different locations on the  device,  either
                     at  the  end (for 1.0), at the start (for 1.1) or 4K from
                     the start (for 1.2).


FFoorr ccrreeaattee oorr bbuuiilldd::
       --cc, ----cchhuunnkk==
              Specify chunk size of kibibytes.  The default is 64.


       ----rroouunnddiinngg==
              Specify rounding factor for linear array (==chunk size)


       --ll, ----lleevveell==
              Set raid level.  When used with _-_-_c_r_e_a_t_e, options  are:  linear,
              raid0,  0,  stripe, raid1, 1, mirror, raid4, 4, raid5, 5, raid6,
              6, raid10, 10, multipath, mp, fautly.  Obviously some  of  these
              are synonymous.

              When  used  with  _-_-_b_u_i_l_d, only linear, stripe, raid0, 0, raid1,
              multipath, mp, and faulty are valid.


       --pp, ----llaayyoouutt==
              This option configures the  fine  details  of  data  layout  for
              raid5,  and  raid10  arrays,  and controls the failure modes for
              _f_a_u_l_t_y.

              The layout of the raid5 parity block can be one of left-asymmet-
              ric,  left-symmetric, right-asymmetric, right-symmetric, la, ra,
              ls, rs.  The default is left-symmetric.

              When setting the failure mode for _f_a_u_l_t_y the options are: write-
              transient,  wt,  read-transient, rt, write-presistent, wp, read-
              persistent, rp, write-all, read-fixable, rf, clear, flush, none.

              Each  mode can be followed by a number which is used as a period
              between fault generation.  Without a number, the fault is gener-
              ated  once  on  the  first relevant request.  With a number, the
              fault will be generated after that many request, and  will  con-
              tinue to be generated every time the period elapses.

              Multiple  failure  modes  can be current simultaneously by using
              the "--grow" option to set subsequent failure modes.

              "clear" or "none" will remove any pending  or  periodic  failure
              modes, and "flush" will clear any persistant faults.

              To  set  the  parity  with  "--grow",  the  level  of  the array
              ("faulty") must be specified before the fault mode is specified.

              Finally,  the  layout  options  for RAID10 are either 'n' or 'p'
              followed by a small number.  The default is 'n2'.

              _n signals 'near' copies (multiple copies of one data  block  are
              at  similar  offsets in different devices) while _f signals 'far'
              copies (multiple copies have very different offsets).  See md(4)
              for more detail about 'near' and 'far'.

              The number is the number of copies of each datablock.  2 is nor-
              mal, 3 can be useful.  This number can be at most equal  to  the
              number  of  devices  in  the  array.  It does not need to divide
              evenly into that number (e.g. it is perfectly legal to  have  an
              'n2' layout for an array with an odd number of devices).


       ----ppaarriittyy==
              same as --layout (thus explaining the p of _-_p).


       --bb, ----bbiittmmaapp==
              Specify  a  file  to  store  a write-intent bitmap in.  The file
              should not exist unless --force is also given.   The  same  file
              should be provided when assembling the array.


       ----bbiittmmaapp--cchhuunnkk==
              Specifty the chunksize for the bitmap.


       --nn, ----rraaiidd--ddeevviicceess==
              Specify  the  number of active devices in the array.  This, plus
              the number of spare devices (see below) must equal the number of
              _c_o_m_p_o_n_e_n_t_-_d_e_v_i_c_e_s  (including "mmiissssiinngg" devices) that are listed
              on the command line for ----ccrreeaattee.  Setting a value of 1 is prob-
              ably  a mistake and so requires that ----ffoorrccee be specified first.
              A value of 1 will then be allowed for linear,  multipath,  raid0
              and raid1.  It is never allowed for raid4 or raid5.
              This  number  can only be changed using ----ggrrooww for RAID1 arrays,
              and only on kernels which provide necessary support.


       --xx, ----ssppaarree--ddeevviicceess==
              Specify the number of  spare  (eXtra)  devices  in  the  initial
              array.   Spares can also be added and removed later.  The number
              of component devices listed on the command line must  equal  the
              number of raid devices plus the number of spare devices.



       --zz, ----ssiizzee==
              Amount  (in  Kibibytes)  of  space  to  use  from  each drive in
              RAID1/4/5/6.  This must be a multiple of  the  chunk  size,  and
              must  leave about 128Kb of space at the end of the drive for the
              RAID superblock.  If this is not specified (as  it  normally  is
              not)  the smallest drive (or partition) sets the size, though if
              there is a variance among the drives of greater than 1%, a warn-
              ing is issued.

              This value can be set with ----ggrrooww for RAID level 1/4/5/6. If the
              array was created with a size smaller than the currently  active
              drives,  the extra space can be accessed using ----ggrrooww.  The size
              can be given as mmaaxx which means to choose the largest size  that
              fits on all current drives.


       ----aassssuummee--cclleeaann
              Tell  _m_d_a_d_m that the array pre-existed and is known to be clean.
              It can be useful when trying to recover from a major failure  as
              you  can  be  sure  that  no  data  will  be affected unless you
              actually write to the array.  It can also be used when  creating
              a  RAID1 or RAID10 if you want to avoid the initial resync, how-
              ever this practice - while normally safe - is  not  recommended.
              Use this ony if you really know what you are doing.


       --NN, ----nnaammee==
              Set a nnaammee for the array.  This is currently only effective when
              creating an array with a version-1 superblock.  The  name  is  a
              simple  textual string that can be used to identify array compo-
              nents when assembling.


       --RR, ----rruunn
              Insist that _m_d_a_d_m run the array, even if some of the  components
              appear  to  be  active in another array or filesystem.  Normally
              _m_d_a_d_m will ask for confirmation before including such components
              in an array.  This option causes that question to be suppressed.


       --ff, ----ffoorrccee
              Insist that _m_d_a_d_m accept the geometry and layout specified with-
              out  question.   Normally  _m_d_a_d_m  will  not allow creation of an
              array with only one device, and will try to create a raid5 array
              with  one  missing  drive (as this makes the initial resync work
              faster).  With ----ffoorrccee, _m_d_a_d_m will not try to be so clever.


       --aa, ----aauuttoo{{==nnoo,,yyeess,,mmdd,,mmddpp,,ppaarrtt,,pp}}{{NNNN}}
              Instruct mdadm to create the device  file  if  needed,  possibly
              allocating an unused minor number.  "md" causes a non-partition-
              able array to be used.  "mdp", "part" or "p" causes a partition-
              able array (2.6 and later) to be used.  "yes" requires the named
              md device to haveo a 'standard' format, and the type  and  minor
              number will be determined from this.  See DEVICE NAMES below.

              The  argument can also come immediately after "-a".  e.g. "-ap".

              If _-_-_s_c_a_n is also given, then any _a_u_t_o_= entries  in  the  config
              file  will over-ride the _-_-_a_u_t_o instruction given on the command
              line.

              For partitionable arrays, _m_d_a_d_m will create the device file  for
              the  whole  array  and  for the first 4 partitions.  A different
              number of partitions can be specified at the end of this  option
              (e.g.   ----aauuttoo==pp77).   If  the device name ends with a digit, the
              partition names add a'p', and a number, e.g. "/dev/home1p3".  If
              there is no trailing digit, then the partition names just have a
              number added, e.g. "/dev/scratch3".

              If the md device name is in a 'standard' format as described  in
              DEVICE  NAMES,  then  it will be created, if necessary, with the
              appropriate number based on that name.  If the  device  name  is
              not  in one of these formats, then a unused minor number will be
              allocated.  The minor number will be considered unused if  there
              is  no  active  array  for that number, and there is no entry in
              /dev for that number and with a non-standard name.


FFoorr aasssseemmbbllee::
       --uu, ----uuuuiidd==
              uuid of array to assemble. Devices which don't  have  this  uuid
              are excluded


       --mm, ----ssuuppeerr--mmiinnoorr==
              Minor  number  of  device  that  array was created for.  Devices
              which don't have this minor number are excluded.  If you  create
              an  array  as  /dev/md1,  then  all superblocks will contain the
              minor number  1,  even  if  the  array  is  later  assembled  as
              /dev/md2.

              Giving the literal word "dev" for ----ssuuppeerr--mmiinnoorr will cause _m_d_a_d_m
              to use the minor number of the md device that  is  being  assem-
              bled.  e.g. when assembling //ddeevv//mmdd00, will look for super blocks
              with a minor number of 0.


       --NN, ----nnaammee==
              Specify the name of the array to assemble.   This  must  be  the
              name that was specified when creating the array.


       --ff, ----ffoorrccee
              Assemble the array even if some superblocks appear out-of-date


       --RR, ----rruunn
              Attempt  to start the array even if fewer drives were given than
              are needed for a full array. Normally  if  not  all  drives  are
              found  and  ----ssccaann is not used, then the array will be assembled
              but not started.  With ----rruunn an attempt will be made to start it
              anyway.


       --aa, ----aauuttoo{{==nnoo,,yyeess,,mmdd,,mmddpp,,ppaarrtt}}
              See this option under Create and Build options.


       --bb, ----bbiittmmaapp==
              Specify  the  bitmap file that was given when the array was cre-
              ated.


       --UU, ----uuppddaattee==
              Update the superblock on each device while assembling the array.
              The  argument  given  to  this flag can be one of ssppaarrcc22..22, ssuumm--
              mmaarriieess, uuuuiidd, rreessyynncc, bbyytteeoorrddeerr, or ssuuppeerr--mmiinnoorr.

              The ssppaarrcc22..22 option will adjust the superblock of an array  what
              was  created on a Sparc machine running a patched 2.2 Linux ker-
              nel.  This kernel got the alignment of part  of  the  superblock
              wrong.   You can use the ----eexxaammiinnee ----ssppaarrcc22..22 option to _m_d_a_d_m to
              see what effect this would have.

              The ssuuppeerr--mmiinnoorr option will update the pprreeffeerreedd mmiinnoorr  field  on
              each  superblock  to  match  the minor number of the array being
              assembled.  This is not needed on 2.6 and later kernels as  they
              make this adjustment automatically.

              The uuuuiidd option will change the uuid of the array.  If a UUID is
              given with the "--uuid" option that UUID will be used as  a  new
              UUID  and  with  NNOOTT be used to help identify the devices in the
              array.  If no "--uuid" is given, a random uuid is chosen.

              The rreessyynncc option will cause the array to be marked _d_i_r_t_y  mean-
              ing  that  any  redundancy  in the array (e.g. parity for raid5,
              copies for raid1) may be incorrect.  This will  cause  the  raid
              system  to  perform a "resync" pass to make sure that all redun-
              dant information is correct.

              The bbyytteeoorrddeerr option allows arrays to be moved between  machines
              with  different  byte-order.   When assembling such an array for
              the first time after  a  move,  giving  ----uuppddaattee==bbyytteeoorrddeerr  will
              cause  _m_d_a_d_m  to  expect  superblocks  to  have  their byteorder
              reversed, and will correct  that  order  before  assembling  the
              array.    This   is  only  valid  with  original  (Verion  0.90)
              superblocks.

              The  ssuummmmaarriieess  option  will  correct  the  summaries   in   the
              superblock.  That  is  the  counts  of  total,  working, active,
              failed, and spare devices.


FFoorr MMaannaaggee mmooddee::
       --aa, ----aadddd
              hotadd listed devices.


       ----rree--aadddd
              Listed devices are assumed to have recently  been  part  of  the
              array, and they are re-added.  This is only different from --add
              when a write-intent bitmap is present.   It  causes  only  those
              parts  of  the  device  that  have  changed since the device was
              removed from the array to be reconstructed.

              This flag is only needed with arrays that are  built  without  a
              superblock  (i.e.  --build,  not  --create).   For  array with a
              superblock, _m_d_a_d_m checks if a superblock is present and automat-
              ically determines if a re-add is appropriate.


       --rr, ----rreemmoovvee
              remove  listed  devices.   They  must  not be active.  i.e. they
              should be failed or spare devices.


       --ff, ----ffaaiill
              mark listed devices as faulty.


       ----sseett--ffaauullttyy
              same as --fail.


FFoorr EExxaammiinnee mmooddee::
       ----ssppaarrcc22..22
              If an array was created on a 2.2 Linux kernel patched with  RAID
              support,  the  superblock will have been created incorrectly, or
              at least incompatibly with 2.4 and  later  kernels.   Using  the
              ----ssppaarrcc22..22  flag  with  ----eexxaammiinnee will fix the superblock before
              displaying it.  If this appears to do the right thing, then  the
              array   can   be   successfully   assembled   using   ----aasssseemmbbllee
              ----uuppddaattee==ssppaarrcc22..22.


FFoorr MMiisscc mmooddee::
       --RR, ----rruunn
              start a partially built array.


       --SS, ----ssttoopp
              deactivate array, releasing all resources.


       --oo, ----rreeaaddoonnllyy
              mark array as readonly.


       --ww, ----rreeaaddwwrriittee
              mark array as readwrite.


       ----zzeerroo--ssuuppeerrbblloocckk
              If the device contains a valid md superblock, the block is over-
              written with zeros.  With --force the block where the superblock
              would be is over-written even if it doesn't appear to be  valid.


       --tt, ----tteesstt
              When  used  with  ----ddeettaaiill,  the  exit status of _m_d_a_d_m is set to
              reflect the status of the device.


FFoorr MMoonniittoorr mmooddee::
       --mm, ----mmaaiill
              Give a mail address to send alerts to.


       --pp, ----pprrooggrraamm, ----aalleerrtt
              Give a program to be run whenever an event is detected.


       --yy, ----ssyysslloogg
              Cause all events to be reported through 'syslog'.  The  messages
              have facility of 'daemon' and varying priorities.


       --dd, ----ddeellaayy
              Give  a  delay  in  seconds.  mmddaaddmm polls the md arrays and then
              waits this many seconds before polling again.  The default is 60
              seconds.


       --ff, ----ddaaeemmoonniissee
              Tell  mmddaaddmm to run as a background daemon if it decides to moni-
              tor anything.  This causes it to fork and run in the child,  and
              to disconnect form the terminal.  The process id of the child is
              written to stdout.  This is useful with ----ssccaann which  will  only
              continue  monitoring if a mail address or alert program is found
              in the config file.


       --ii, ----ppiidd--ffiillee
              When mmddaaddmm is running in daemon mode, write the pid of the  dae-
              mon  process  to  the  specified file, instead of printing it on
              standard output.


       --11, ----oonneesshhoott
              Check arrays only once.  This will generate NNeewwAArrrraayy events  and
              more significantly DDeeggrraaddeeddAArrrraayy and SSppaarreessMMiissssiinngg events.  Run-
              ning
                      mmddaaddmm ----mmoonniittoorr ----ssccaann --11
              from a cron script  will  ensure  regular  notification  of  any
              degraded arrays.


       --tt, ----tteesstt
              Generate  a  TTeessttMMeessssaaggee alert for every array found at startup.
              This alert gets mailed and passed to the  alert  program.   This
              can  be  used for testing that alert message do get through suc-
              cessfully.


AASSSSEEMMBBLLEE MMOODDEE
       Usage: mmddaaddmm ----aasssseemmbbllee _m_d_-_d_e_v_i_c_e _o_p_t_i_o_n_s_-_a_n_d_-_c_o_m_p_o_n_e_n_t_-_d_e_v_i_c_e_s_._._.

       Usage: mmddaaddmm ----aasssseemmbbllee ----ssccaann _m_d_-_d_e_v_i_c_e_s_-_a_n_d_-_o_p_t_i_o_n_s_._._.

       Usage: mmddaaddmm ----aasssseemmbbllee ----ssccaann _o_p_t_i_o_n_s_._._.


       This usage assembles one or more raid arrays from  pre-existing  compo-
       nents.  For each array, mdadm needs to know the md device, the identity
       of the array, and a number of component-devices. These can be found  in
       a number of ways.

       In  the first usage example (without the ----ssccaann) the first device given
       is the md device.  In the second usage example, all devices listed  are
       treated  as  md devices and assembly is attempted.  In the third (where
       no devices are listed) all md devices that are listed in the configura-
       tion file are assembled.

       If  precisely one device is listed, but ----ssccaann is not given, then _m_d_a_d_m
       acts as though ----ssccaann was given and identify information  is  extracted
       from the configuration file.

       The  identity  can  be  given with the ----uuuuiidd option, with the ----ssuuppeerr--
       mmiinnoorr option, can be found  in the config file, or will be  taken  from
       the  super  block  on  the first component-device listed on the command
       line.

       Devices can be given on the ----aasssseemmbbllee command line or  in  the  config
       file. Only devices which have an md superblock which contains the right
       identity will be considered for any array.

       The config file is only used  if  explicitly  named  with  ----ccoonnffiigg  or
       requested  with  (a  possibly  implicit)  ----ssccaann..   In  the later case,
       //eettcc//mmddaaddmm..ccoonnff is used.

       If ----ssccaann is not given, then the config file will only be used to  find
       the identity of md arrays.

       Normally  the  array will be started after it is assembled.  However if
       ----ssccaann is not given and insufficient drives were listed to start a com-
       plete  (non-degraded)  array,  then  the array is not started (to guard
       against usage errors).  To insist that the array  be  started  in  this
       case (as may work for RAID1, 4, 5, 6, or 10), give the ----rruunn flag.

       If  an  aauuttoo option is given, either on the command line (--auto) or in
       the configuration file (e.g. auto=part), then _m_d_a_d_m will create the  md
       device  if  necessary or will re-create it if it doesn't look usable as
       it is.

       This can be useful for handling partitioned devices (which don't have a
       stable  device  number  -  it can change after a reboot) and when using
       "udev" to manage your //ddeevv tree (udev cannot handle md devices  because
       of the unusual device initialisation conventions).

       If  the  option  to  "auto"  is "mdp" or "part" or (on the command line
       only) "p", then mdadm will create  a  partitionable  array,  using  the
       first free one that is not inuse, and does not already have an entry in
       /dev (apart from numeric /dev/md* entries).

       If the option to "auto" is "yes" or "md" or (on the command line) noth-
       ing,  then mdadm will create a traditional, non-partitionable md array.

       It is expected that the "auto" functionality will  be  used  to  create
       device   entries  with  meaningful  names  such  as  "/dev/md/home"  or
       "/dev/md/root", rather than names based on the numerical array  number.

       When  using  this  option  to  create a partitionable array, the device
       files for the first 4 partitions are also created. If a different  num-
       ber  is  required  it  can be simply appended to the auto option.  e.g.
       "auto=part8".  Partition names are created by appending a digit  string
       to  the  device  name,  with an intervening "p" if the device name ends
       with a digit.

       The ----aauuttoo option is also available in  Build  and  Create  modes.   As
       those  modes  do  not use a config file, the "auto=" config option does
       not apply to these modes.


BBUUIILLDD MMOODDEE
       Usage:  mmddaaddmm  ----bbuuiilldd  _d_e_v_i_c_e  ----cchhuunnkk==_X  ----lleevveell==_Y   ----rraaiidd--ddeevviicceess==_Z
                   _d_e_v_i_c_e_s


       This  usage  is similar to ----ccrreeaattee.  The difference is that it creates
       an array without a superblock. With these arrays there is no difference
       between  initially  creating  the array and subsequently assembling the
       array, except that hopefully there is useful data there in  the  second
       case.

       The  level  may  raid0,  linear,  multipath, or faulty, or one of their
       synonyms. All devices must be listed and the array will be started once
       complete.


CCRREEAATTEE MMOODDEE
       Usage: mmddaaddmm ----ccrreeaattee _d_e_v_i_c_e ----cchhuunnkk==_X ----lleevveell==_Y
                   ----rraaiidd--ddeevviicceess==_Z _d_e_v_i_c_e_s


       This  usage will initialise a new md array, associate some devices with
       it, and activate the array.

       If the ----aauuttoo option is given (as described in more detail in the  sec-
       tion on Assemble mode), then the md device will be created with a suit-
       able device number if necessary.

       As devices are added, they are checked to  see  if  they  contain  raid
       superblocks  or  filesystems. They are also checked to see if the vari-
       ance in device size exceeds 1%.

       If any discrepancy is found, the array will not automatically  be  run,
       though the presence of a ----rruunn can override this caution.

       To  create a "degraded" array in which some devices are missing, simply
       give the word "mmiissssiinngg" in place of a device  name.   This  will  cause
       mmddaaddmm  to leave the corresponding slot in the array empty.  For a RAID4
       or RAID5 array at most one slot can be "mmiissssiinngg"; for a RAID6 array  at
       most  two  slots.   For a RAID1 array, only one real device needs to be
       given.  All of the others can be "mmiissssiinngg".

       When creating a RAID5 array, mmddaaddmm will automatically create a degraded
       array  with  an  extra spare drive.  This is because building the spare
       into a degraded array is in general faster than resyncing the parity on
       a  non-degraded, but not clean, array.  This feature can be over-ridden
       with the _-_-_f_o_r_c_e option.


       The General Management options that are valid with --create are:

       ----rruunn  insist on running the array even if some devices look like  they
              might be in use.


       ----rreeaaddoonnllyy
              start the array readonly - not supported yet.


MMAANNAAGGEE MMOODDEE
       Usage: mmddaaddmm _d_e_v_i_c_e _o_p_t_i_o_n_s_._._. _d_e_v_i_c_e_s_._._.


       This  usage  will  allow  individual  devices in an array to be failed,
       removed or added.  It is possible to perform multiple  operations  with
       on command. For example:
         mmddaaddmm //ddeevv//mmdd00 --ff //ddeevv//hhddaa11 --rr //ddeevv//hhddaa11 --aa //ddeevv//hhddaa11
       will  firstly mark //ddeevv//hhddaa11 as faulty in //ddeevv//mmdd00 and will then remove
       it from the array and finally add it back in as a spare.  However  only
       one md array can be affected by a single command.


MMIISSCC MMOODDEE
       Usage: mmddaaddmm _o_p_t_i_o_n_s _._._.  _d_e_v_i_c_e_s _._._.


       MISC mode includes a number of distinct operations that operate on dis-
       tinct devices.  The operations are:

       --query
              The device is examined to see if it is (1) an active  md  array,
              or  (2)  a component of an md array.  The information discovered
              is reported.


       --detail
              The device should be an active md device.  mmddaaddmm will display  a
              detailed description of the array.  ----bbrriieeff or ----ssccaann will cause
              the output to be less detailed and the format to be suitable for
              inclusion  in  //eettcc//mmddaaddmm..ccoonnff.   The  exit status of _m_d_a_d_m will
              normally be 0 unless _m_d_a_d_m  failed  to  get  useful  information
              about  the  device(s).   However  if the ----tteesstt option is given,
              then the exit status will be:

              0      The array is functioning normally.

              1      The array has at least one failed device.

              2      The array has multiple failed devices and hence is  unus-
                     able (raid4 or raid5).

              4      There  was an error while trying to get information about
                     the device.


       --examine
              The device should be a component of an  md  array.   mmddaaddmm  will
              read  the  md superblock of the device and display the contents.
              If ----bbrriieeff is given, or ----ssccaann then multiple  devices  that  are
              components of the one array are grouped together and reported in
              a single entry suitable for inclusion in //eettcc//mmddaaddmm..ccoonnff.

              Having ----ssccaann without listing any devices will cause all devices
              listed in the config file to be examined.


       --stop The  devices  should  be  active md arrays which will be deacti-
              vated, as long as they are not currently in use.


       --run  This will fully activate a partially assembled md array.


       --readonly
              This will mark an active array as read-only, providing  that  it
              is not currently being used.


       --readwrite
              This will change a rreeaaddoonnllyy array back to being read/write.


       --scan For all operations except ----eexxaammiinnee, ----ssccaann will cause the oper-
              ation to be applied to all arrays listed in  //pprroocc//mmddssttaatt.   For
              ----eexxaammiinnee,,  ----ssccaann  causes all devices listed in the config file
              to be examined.



MMOONNIITTOORR MMOODDEE
       Usage: mmddaaddmm ----mmoonniittoorr _o_p_t_i_o_n_s_._._. _d_e_v_i_c_e_s_._._.


       This usage causes mmddaaddmm to periodically poll a number of md arrays  and
       to report on any events noticed.  mmddaaddmm will never exit once it decides
       that there are arrays to be checked, so it should normally  be  run  in
       the background.

       As  well  as  reporting  events,  mmddaaddmm may move a spare drive from one
       array to another if they are in the same ssppaarree--ggrroouupp and if the  desti-
       nation array has a failed drive but no spares.

       If  any devices are listed on the command line, mmddaaddmm will only monitor
       those devices. Otherwise all arrays listed in  the  configuration  file
       will  be  monitored.   Further,  if  ----ssccaann is given, then any other md
       devices that appear in //pprroocc//mmddssttaatt will also be monitored.

       The result of monitoring the arrays is the generation of events.  These
       events  are  passed  to  a  separate  program (if specified) and may be
       mailed to a given E-mail address.

       When passing event to program, the program is run once for  each  event
       and  is given 2 or 3 command-line arguements.  The first is the name of
       the event (see below).  The second is the name of the md  device  which
       is affected, and the third is the name of a related device if relevant,
       such as a component device that has failed.

       If ----ssccaann is given, then a program or an E-mail address must be  speci-
       fied  on the command line or in the config file.  If neither are avail-
       able, then mmddaaddmm will not monitor anything.  Without ----ssccaann mmddaaddmm  will
       continue  monitoring  as long as something was found to monitor.  If no
       program or email is given, then each event is reported to ssttddoouutt.

       The different events are:


           DDeevviicceeDDiissaappppeeaarreedd
                  An md array which previously was configured  appears  to  no
                  longer be configured. (syslog priority: Critical)

                  If _m_d_a_d_m was told to monitor an array which is RAID0 or Lin-
                  ear, then it will report DDeevviicceeDDiissaappppeeaarreedd  with  the  extra
                  information  WWrroonngg--LLeevveell.   This is because RAID0 and Linear
                  do not support the device-failed, hot-spare and resync oper-
                  ations which are monitored.


           RReebbuuiillddSSttaarrtteedd
                  An  md array started reconstruction. (syslog priority: Warn-
                  ing)


           RReebbuuiilldd_N_N
                  Where _N_N is 20, 40, 60, or 80, this indicates  that  rebuild
                  has passed that many percentage of the total. (syslog prior-
                  ity: Warning)


           RReebbuuiillddFFiinniisshheedd
                  An md array that was  rebuilding,  isn't  any  more,  either
                  because  it finished normally or was aborted. (syslog prior-
                  ity: Warning)


           FFaaiill   An active component device of an array has  been  marked  as
                  faulty. (syslog priority: Critical)


           FFaaiillSSppaarree
                  A  spare component device which was being rebuilt to replace
                  a faulty device has failed. (syslog priority: Critial)


           SSppaarreeAAccttiivvee
                  A spare component device which was being rebuilt to  replace
                  a  faulty  device  as been successfully rebuild and has been
                  made active.  (syslog priority: Info)


           NNeewwAArrrraayy
                  A new md array has been detected in the  //pprroocc//mmddssttaatt  file.
                  (syslog priority: Info)


           DDeeggrraaddeeddAArrrraayy
                  A  newly noticed array appears to be degraded.  This message
                  is not generated when _m_d_a_d_m notices a  drive  failure  which
                  causes  degradation,  but  only  when  _m_d_a_d_m notices that an
                  array is degraded when it first  sees  the  array.   (syslog
                  priority: Critial)


           MMoovveeSSppaarree
                  A spare drive has been moved from one array in a ssppaarree--ggrroouupp
                  to another to allow a failed drive to be replaced.   (syslog
                  priority: Info)


           SSppaarreessMMiissssiinngg
                  If  _m_d_a_d_m  has been told, via the config file, that an array
                  should have a certain number of  spare  devices,  and  _m_d_a_d_m
                  detects  that  it  has  fewer that this number when it first
                  sees the array, it  will  report  a  SSppaarreessMMiissssiinngg  message.
                  (syslog priority: Info)


           TTeessttMMeessssaaggee
                  An  array  was  found  at  startup,  and the ----tteesstt flag was
                  given.  (syslog priority: Info)

       Only FFaaiill ,, FFaaiillSSppaarree ,, DDeeggrraaddeeddAArrrraayy ,, and TTeessttMMeessssaaggee cause Email  to
       be  sent.   All events cause the program to be run.  The program is run
       with two or three arguments, they  being  the  event  name,  the  array
       device and possibly a second device.

       Each event has an associated array device (e.g.  //ddeevv//mmdd11) and possibly
       a second device.  For  FFaaiill,  FFaaiillSSppaarree,  and  SSppaarreeAAccttiivvee  the  second
       device  is  the  relevant  component  device.  For MMoovveeSSppaarree the second
       device is the array that the spare was moved from.

       For mmddaaddmm to move spares from  one  array  to  another,  the  different
       arrays  need to be labelled with the same ssppaarree--ggrroouupp in the configura-
       tion file.  The ssppaarree--ggrroouupp name can be any string. It is  only  neces-
       sary that different spare groups use different names.

       When  mmddaaddmm  detects  that an array which is in a spare group has fewer
       active devices than necessary for the complete array, and has no  spare
       devices,  it  will  look for another array in the same spare group that
       has a full complement of working drive  and  a  spare.   It  will  then
       attempt  to  remove  the  spare from the second drive and add it to the
       first.  If the removal succeeds but the adding fails, then it is  added
       back to the original array.


GGRROOWW MMOODDEE
       The  GROW  mode  is  used  for  changing the size or shape of an active
       array.  For this to work, the kernel must support the necessary change.
       Various  types  of growth may be added during 2.6 development, possibly
       including restructuring a raid5 array to have more active devices.

       Currently the only support available is to

       ?   change the "size" attribute for RAID1, RAID5 and RAID6.

       ?   change the "raid-disks" attribute of RAID1.

       ?   add a write-intent bitmap to a RAID1 array.


       Normally when an array is built the "size" it taken from  the  smallest
       of  the  drives.   If  all  the small drives in an arrays are, one at a
       time, removed and replaced with larger drives, then you could  have  an
       array  of  large  drives with only a small amount used.  In this situa-
       tion, changing the "size" with "GROW" mode will allow the  extra  space
       to  start being used.  If the size is increased in this way, a "resync"
       process will start to make sure the new parts of the array are synchro-
       nised.

       Note that when an array changes size, any filesystem that may be stored
       in the array will  not  automatically  grow  to  use  the  space.   The
       filesystem will need to be explicitly told to use the extra space.

       A  RAID1  array  can  work  with  any  number of devices from 1 upwards
       (though 1 is not very useful).  There may be times which  you  want  to
       increase  or  decrease the number of active devices.  Note that this is
       different to hot-add or hot-remove which changes the number of inactive
       devices.

       When  reducing  the number of devices in a RAID1 array, the slots which
       are to be removed from the array must already be vacant.  That is,  the
       devices that which were in those slots must be failed and removed.

       When  the  number  of  devices  is  increased,  any hot spares that are
       present will be activated immediately.

       A write-intent bitmap can be added to, or remove from, an active  RAID1
       array.   Either  internal  bitmap, of bitmaps stored in a separate file
       can be added.  Note that if you add a bitmap stored in a file which  is
       in  a  filesystem  that is on the raid array being affected, the system
       will deadlock.  The bitmap must be on a separate filesystem.


EEXXAAMMPPLLEESS
         mmddaaddmm ----qquueerryy //ddeevv//nnaammee--ooff--ddeevviiccee
       This will find out if a given device is a raid array,  or  is  part  of
       one, and will provide brief information about the device.

         mmddaaddmm ----aasssseemmbbllee ----ssccaann
       This  will assemble and start all arrays listed in the standard confile
       file.  This command will typically go in a system startup file.

         mmddaaddmm ----ssttoopp ----ssccaann
       This will shut down all array that can be shut down (i.e. are not  cur-
       rently in use).  This will typically go in a system shutdown script.

         mmddaaddmm ----ffoollllooww ----ssccaann ----ddeellaayy==112200
       If  (and  only  if)  there  is an Email address or program given in the
       standard config file, then monitor the status of all arrays  listed  in
       that file by polling them ever 2 minutes.

         mmddaaddmm ----ccrreeaattee //ddeevv//mmdd00 ----lleevveell==11 ----rraaiidd--ddeevviicceess==22 //ddeevv//hhdd[[aacc]]11
       Create /dev/md0 as a RAID1 array consisting of /dev/hda1 and /dev/hdc1.

         eecchhoo ''DDEEVVIICCEE //ddeevv//hhdd**[[00--99]] //ddeevv//ssdd**[[00--99]]'' >> mmddaaddmm..ccoonnff
         mmddaaddmm ----ddeettaaiill ----ssccaann >>>> mmddaaddmm..ccoonnff
       This will create a  prototype  config  file  that  describes  currently
       active  arrays that are known to be made from partitions of IDE or SCSI
       drives.  This file should be reviewed before being used as it may  con-
       tain unwanted detail.

         eecchhoo ''DDEEVVIICCEE //ddeevv//hhdd[[aa--zz]] //ddeevv//ssdd**[[aa--zz]]'' >> mmddaaddmm..ccoonnff
          mmddaaddmm  ----eexxaammiinnee  ----ssccaann ----ccoonnffiigg==mmddaaddmm..ccoonnff >>>> mmddaaddmm..ccoonnff This will
       find what arrays could be assembled from existign IDE  and  SCSI  whole
       drives  (not  partitions)  and store the information is the format of a
       config file.  This file is very likely to contain unwanted detail, par-
       ticularly  the  ddeevviicceess==  entries.   It  should  be reviewed and edited
       before being used as an actual config file.

         mmddaaddmm ----eexxaammiinnee ----bbrriieeff ----ssccaann ----ccoonnffiigg==ppaarrttiittiioonnss
         mmddaaddmm --EEbbsscc ppaarrttiittiioonnss
       Create a list of devices by reading //pprroocc//ppaarrttiittiioonnss,  scan  these  for
       RAID superblocks, and printout a brief listing of all that was found.

         mmddaaddmm --AAcc ppaarrttiittiioonnss --mm 00 //ddeevv//mmdd00
       Scan all partitions and devices listed in //pprroocc//ppaarrttiittiioonnss and assemble
       //ddeevv//mmdd00 out of all such devices with a RAID superblock  with  a  minor
       number of 0.

         mmddaaddmm ----mmoonniittoorr ----ssccaann ----ddaaeemmoonniissee >> //vvaarr//rruunn//mmddaaddmm
       If  config  file contains a mail address or alert program, run mdadm in
       the background in monitor mode monitoring all md devices.   Also  write
       pid of mdadm daemon to //vvaarr//rruunn//mmddaaddmm.

         mmddaaddmm ----ccrreeaattee ----hheellpp
       Providew help about the Create mode.

         mmddaaddmm ----ccoonnffiigg ----hheellpp
       Provide help about the format of the config file.

         mmddaaddmm ----hheellpp
       Provide general help.



FFIILLEESS
   //pprroocc//mmddssttaatt
       If  you're using the //pprroocc filesystem, //pprroocc//mmddssttaatt lists all active md
       devices with information about them.  mmddaaddmm uses this  to  find  arrays
       when  ----ssccaann is given in Misc mode, and to monitor array reconstruction
       on Monitor mode.



   //eettcc//mmddaaddmm..ccoonnff
       The config file lists which devices may be scanned to see if they  con-
       tain  MD  super  block,  and  gives identifying information (e.g. UUID)
       about known MD arrays.  See mmddaaddmm..ccoonnff(5) for more details.


DDEEVVIICCEE NNAAMMEESS
       While entries in the /dev directory can have any format you like, _m_d_a_d_m
       has  an  understanding of 'standard' formats which it uses to guide its
       behaviour when creating device files via the _-_-_a_u_t_o option.

       The standard names for non-partitioned arrays  (the  only  sort  of  md
       array available in 2.4 and earlier) either of

              /dev/mdNN
              /dev/md/NN

       where  NN is a number.  The standard names for partitionable arrays (as
       available from 2.6 onwards) is one of

              /dev/md/dNN
              /dev/md_dNN

       Partition numbers should be indicated by added  "pMM"  to  these,  thus
       "/dev/md/d1p2".


NNOOTTEE
       mmddaaddmm was previously known as mmddccttll.

       mmddaaddmm  is  completely separate from the rraaiiddttoooollss package, and does not
       use the _/_e_t_c_/_r_a_i_d_t_a_b configuration file at all.


SSEEEE AALLSSOO
       For information on the various levels of RAID, check out:


              http://ostenfeld.dk/~jakob/Software-RAID.HOWTO/

       The lastest version of _m_d_a_d_m should always be available from

              http://www.kernel.org/pub/linux/utils/raid/mdadm/

       _m_d_a_d_m_._c_o_n_f(5), _m_d(4).

       _r_a_i_d_t_a_b(5), _r_a_i_d_0_r_u_n(8), _r_a_i_d_s_t_o_p(8), _m_k_r_a_i_d(8).



v2.3                                                                  MDADM(8)
