MDADM.CONF(5)                                                    MDADM.CONF(5)



NNAAMMEE
       mdadm.conf - configuration for management of Software Raid with mdadm

SSYYNNOOPPSSIISS
       /etc/mdadm.conf

DDEESSCCRRIIPPTTIIOONN
       mmddaaddmm  is  a  tool  for creating, managing, and monitoring RAID devices
       using the mmdd driver in Linux.

       Some common tasks, such as assembling all arrays, can be simplified  by
       describing the devices and arrays in this configuration file.


   SSYYNNTTAAXX
       The  file  should  be  seen as a collection of words separated by white
       space (space, tab, or newline).  Any word that beings with a hash  sign
       (#)  starts  a comment and that word together with the remainder of the
       line is ignored.

       Any line that starts with white space (space  or  tab)  is  treated  as
       though it were a continuation of the previous line.

       Empty  lines  are  ignored,  but otherwise each (non continuation) line
       must start with a keyword as  listed  below.   The  keywords  are  case
       insensitive and can be abbreviated to 3 characters.

       The keywords are:

       DDEEVVIICCEE A  ddeevviiccee  line  lists the devices (whole devices or partitions)
              that might contain a component of an MD array.  When looking for
              the  components  of  an array, mmddaaddmm will scan these devices (or
              any devices listed on the command line).

              The ddeevviiccee line may contain a number of different devices (sepa-
              rated  by spaces) and each device name can contain wild cards as
              defined by gglloobb(7).

              Also, there may be several device lines present in the file.

              Alternatively, a ddeevviiccee line can contain  the  word  ppaarrttiittiioonnss.
              This  will  cause _m_d_a_d_m to read _/_p_r_o_c_/_p_a_r_t_i_t_i_o_n_s and include all
              devices and partitions found there-in.  _m_d_a_d_m does not  use  the
              names  from _/_p_r_o_c_/_p_a_r_t_i_t_i_o_n_s but only the major and minor device
              numbers.  It scans _/_d_e_v to find the name that matches  the  num-
              bers.

              For example:

              DEVICE /dev/hda* /dev/hdc*
              DEV    /dev/sd*
              DEVICE /dev/discs/disc*/disc
              DEVICE partitions


       AARRRRAAYY  The  ARRAY lines identify actual arrays.  The second word on the
              line should be the name of the device where the  array  is  nor-
              mally  assembled,  such  as //ddeevv//mmdd11.  Subsequent words identify
              the array, or identify the array as a member of a group. If mul-
              tiple  identities  are given, then a component device must match
              ALL identities to be considered a match.  Each identity word has
              a tag, and equals sign, and some value.  The tags are:


           uuuuiidd==  The  value  should  be  a  128 bit uuid in hexadecimal, with
                  punctuation interspersed if desired.  This  must  match  the
                  uuid stored in the superblock.

           nnaammee==  The  value  should  be a simple textual name as was given to
                  _m_d_a_d_m when the array was created.  This must match the  name
                  stored  in  the superblock on a device for that device to be
                  included in the array.  Not all  superblock-formats  support
                  names.

           ssuuppeerr--mmiinnoorr==
                  The  value  is  an  integer which indicates the minor number
                  that was stored in the superblock when the  array  was  cre-
                  ated.  When  an array is created as /dev/mdX, then the minor
                  number X is stored.

           ddeevviicceess==
                  The value is a comma  separated  list  of  device  names  or
                  device  name  patterns.  Only devices with names which match
                  one entry in the list will be used to  assemble  the  array.
                  Note  that the devices listed there must also be listed on a
                  DEVICE line.

           lleevveell== The value is a raid level.  This is  not  normally  used  to
                  identify an array, but is supported so that the output of

                  mmddaaddmm ----eexxaammiinnee ----ssccaann

                  can be use directly in the configuration file.

           nnuumm--ddeevviicceess==
                  The  value  is  the  number  of devices in a complete active
                  array.  As with lleevveell== this is mainly for compatibility with
                  the output of

                  mmddaaddmm ----eexxaammiinnee ----ssccaann.


           ssppaarree--ggrroouupp==
                  The  value  is  a  textual  name for a group of arrays.  All
                  arrays with the same ssppaarree--ggrroouupp name are considered  to  be
                  part  of  the  same  group.   The significance of a group of
                  arrays is that mmddaaddmm will, when monitoring the arrays,  move
                  a  spare drive from one array in a group to another array in
                  that group if the first array had a failed or missing  drive
                  but no spare.


           aauuttoo==  This  option  declares to mmddaaddmm that it should try to create
                  the device file of the array if it doesn't already exist, or
                  exists but with the wrong device number.

                  The  value  of  this option can be "yes" or "md" to indicate
                  that a traditional, non-partitionable  md  array  should  be
                  created,  or "mdp", "part" or "partition" to indicate that a
                  partitionable md array (only  available  in  linux  2.6  and
                  later)  should be used.  This later set can also have a num-
                  ber appended to  indicate  how  many  partitions  to  create
                  device files for, e.g.  aauuttoo==mmddpp55.  The default is 4.


       MMAAIILLAADDDDRR
              The  mmaaiillaaddddrr line gives an E-mail address that alerts should be
              sent to when is running in ----mmoonniittoorr mode  (and  was  given  the
              ----ssccaann  option).   There should only be one MMAAIILLAADDDDRR line and it
              should have only one address.



       PPRROOGGRRAAMM
              The pprrooggrraamm line gives the name of a  program  to  be  run  when
              mmddaaddmm ----mmoonniittoorr detects potentially interesting events on any of
              the arrays that it is monitoring.  This program  gets  run  with
              two or three arguments, they being the Event, the md device, and
              possibly the related component device.

              There should only be one pprrooggrraamm line and it should be give only
              one program.


EEXXAAMMPPLLEE
       DEVICE /dev/sd[bcdjkl]1
       DEVICE /dev/hda1 /dev/hdb1

       # /dev/md0 is known by it's UID.
       ARRAY /dev/md0 UUID=3aaa0122:29827cfa:5331ad66:ca767371
       # /dev/md1 contains all devices with a minor number of
       #   1 in the superblock.
       ARRAY /dev/md1 superminor=1
       # /dev/md2 is made from precisey these two devices
       ARRAY /dev/md2 devices=/dev/hda1,/dev/hdb1

       # /dev/md4 and /dev/md5 are a spare-group and spares
       #  can be moved between them
       ARRAY /dev/md4 uuid=b23f3c6d:aec43a9f:fd65db85:369432df
                  spare-group=group1
       ARRAY /dev/md5 uuid=19464854:03f71b1b:e0df2edd:246cc977
                  spare-group=group1
       # /dev/md/home is created if need to be a partitionable md array
       # any spare device number is allocated.
       ARRAY /dev/md/home UUID=9187a482:5dde19d9:eea3cc4a:d646ab8b
                  auto=part

       MAILADDR root@mydomain.tld
       PROGRAM /usr/sbin/handle-mdadm-events



SSEEEE AALLSSOO
       mmddaaddmm(8), mmdd(4).




                                                                 MDADM.CONF(5)
