#include 	<dhcpd.h>
#include 	"filter.h"

//#define		_NOT_READY

#ifdef		_NOT_READY
  #define	BLANK_CHAR1		'A'
  #define	BLANK_CHAR2		'B'
#else
  #define	BLANK_CHAR1		'\0'
  #define	BLANK_CHAR2		'\0'
#endif

#define		REPLACE_OLD		' '
#define		REPLACE_NEW		'#'		
int find_position (char * src, char * pattern, int * len)
{
	char * ptr = src; 
	char * left_brackets = NULL;
	char * right_brackets = NULL;
	char * pattern_pos = NULL;
	int result = 0;

	if (!strcmp (pattern, ""))
		return -1;

	pattern_pos = strstr (src, pattern);
//printf ("pattern = %s, pattern's position = %d\n", pattern, pattern_pos);
	//  if can not find any match string then return failure
	if (pattern_pos == 0)
		return -2;

	//  find the pattern's location
	while (ptr)
	{
		ptr = strstr (ptr, "lease");
		left_brackets = strstr (ptr, "{");
		right_brackets = strstr (ptr, "}");
		if (left_brackets >= right_brackets)
			return -3;

		//  if pattern's location in the range (the range is between "{" and "}")
		//  then return offset value, base on source handle
		if ((int)pattern_pos > (int)left_brackets && (int)pattern_pos < (int)right_brackets)
		{
			result = (int)ptr - (int)src; //  pattern's location - srouce handle
			break;
		}
		ptr = right_brackets;
	}

	//  the length = lease...{......} exclude \n
	*len = ((int)right_brackets - (int)ptr) + 1;  //  ex:5 - 9, len=5-9+1=5

	return result;
}

void remove_lease (int pos, int find_len, int total_len, char * buf, char blank_char)
{
	int idx = 0;
	//  if the pattern was found, then do...
	if (pos >= 0 && find_len > 0)
	{
		//  remove the section that we don't want
		while((pos + find_len + idx + 1) < total_len)
		{
			*(buf + pos + idx) = \
			*(buf + pos + find_len + idx + 1);
			//  because every scope has one line feed
			idx++;
		}
		//  blank
		while ((idx + pos) < total_len)
		{
			*(buf + pos + idx) = blank_char;
			idx++;
		}
	}
}

void replace_buffer_char (char * buf, int len, char replace_old, char replace_new)
{
	while (len--)
	{
		if (buf[len] == replace_old)
			buf[len] = replace_new;
	}
}

void write_to_file (char * buf, int write_len, char * tmp_file, char * lease_file)
{
	FILE * fpw = NULL;
	fpw = fopen (DHCP_LEASE_TMP, "w+");

	if (fpw)
	{
		char command[512];
		memset (command, '\0', sizeof (command));
		sprintf (command, "rm %s", lease_file);
		fwrite (buf, write_len, 1, fpw);
		fclose (fpw);
		system (command);
		memset (command, '\0', sizeof (command));
		sprintf (command,"cp %s %s", tmp_file, lease_file);
		system (command);
	}
}

int remove_exist_lease (struct lease * c_lease)
{
	FILE * fp = NULL;
	FILE * fpw = NULL;
	char * buf = NULL;
	char dhcp_lease_file[] = _PATH_DHCPD_DB;
	int result = 0;
	unsigned long len = 0;

	//  open lease database file
	fp = fopen (dhcp_lease_file , "r");

	if (fp != NULL)
	{
		//  get file length
		fseek (fp, 0, SEEK_END);
		len = ftell (fp);
		//  move cursor to start of the file
		fseek (fp, 0, SEEK_SET);
		if (len > 0)
		{
			//  allocat memory for buffer
			buf = (char *)calloc (1, sizeof (char) * len + 1);
			if (buf)
			{
				int pos = 0, find_len = 0, idx = 0, write_len = len;
				char binding_string[] = "  binding state free";
				//  read from lease database file
				fread (buf, len, 1, fp);
				//  close dhcpd.leases
				fclose (fp);

				//  find abandoned state and remove it
				do
				{
					pos = 0;
					find_len = 0;

					//  find pattern's location in the buffer
					pos = find_position (buf, "abandoned", &find_len);
					remove_lease (pos, find_len, len, buf, BLANK_CHAR1);
					if (find_len > 0)
						write_len -= (find_len + 1);
				}
				while (pos >= 0 && find_len > 0);

				//  find existing lease and remove it
				do
				{
					pos = 0;
					find_len = 0;

					//  find pattern's location in the buffer
					pos = find_position (buf, print_hw_addr ( \
						c_lease->hardware_addr.htype, \
						c_lease->hardware_addr.hlen, \
						c_lease->hardware_addr.haddr), &find_len);
					remove_lease (pos, find_len, len, buf, BLANK_CHAR1);
					if (find_len > 0)
						write_len -= (find_len + 1);
				}
				while (pos >= 0 && find_len > 0);

				write_to_file (buf, write_len, DHCP_LEASE_TMP, dhcp_lease_file);
				free (buf);
			}
			else
				result = -4; //  alloc memory error
		}
		else 
		{
			result = -3; //  file size less than 0
			fclose (fp);
		}
	}
	else
		result = -2; //  open file failure
	return result;
}

int add_lease_to_log (struct lease * c_lease, char * starts_time, char * end_time)
{
	FILE * fp = NULL, * tmpfp = NULL, * tmpfp_bak = NULL;
	int result = 0;    //  success
	char s[256];
	
	fp = fopen (DHCP_LOG, "r");
	if (fp)
	{
		tmpfp_bak = tmpfile ();
		if (tmpfp_bak)
		{
			while (fgets (s, sizeof (s), fp))
				fputs (s, tmpfp_bak);
			fclose (fp);

			tmpfp = tmpfile ();
			if (tmpfp)
			{
				//  remove exist lease
				rewind (tmpfp_bak);
				while (fgets (s, sizeof (s), tmpfp_bak))
				{
					if (!strstr(s, print_hw_addr (c_lease->hardware_addr.htype, 
						c_lease->hardware_addr.hlen,
						c_lease->hardware_addr.haddr)))
						fputs (s, tmpfp);
			
				}
				replace_char (starts_time, ';', ' ');
				replace_char (end_time, ';', ' ');
				fprintf (tmpfp, "%s#%s#%s#%s\n", piaddr (c_lease->ip_addr), 
								print_hw_addr ( \
	  							c_lease->hardware_addr.htype, \
								c_lease->hardware_addr.hlen, \
								c_lease->hardware_addr.haddr), 
								remove_week_day (starts_time),
								remove_week_day (end_time));
				//  copy tmpfp to fp
				rewind (tmpfp);
				fp = fopen (DHCP_LOG, "w");
				if (fp)
				{
					while (fgets (s, sizeof (s), tmpfp))
					fputs (s, fp); 
					result = 0;
				}
				else
					result = -3;  //  can't open log file for write
				fclose (fp);
				fclose (tmpfp);
			}
			else
				result = -2;  //  can't open tmp file
			fclose (tmpfp_bak);
		}
		else 
			result = -2;
	}
	else
	{
		fp = fopen (DHCP_LOG, "w");
		if (fp)
		{
			sprintf (s, "%s#%s#%s#%s\n", piaddr (c_lease->ip_addr), 
							print_hw_addr ( \
	  						c_lease->hardware_addr.htype, \
							c_lease->hardware_addr.hlen, \
							c_lease->hardware_addr.haddr), 
							remove_week_day (starts_time),
							remove_week_day (end_time));
			fputs (s, fp); 
			result = 0;
		}
		else
			result = -1;  //  can't open log file
		fclose (fp);
		
	}
	return result;
}

char * replace_char (char * src, char target, char replace)
{
	int index = 0, len = strlen (src);
	while (index < len)
	{
		if (src[index] == target)
			src[index] = replace;
		index++;
	}
	return src;
}

char * remove_week_day (char * src)
{
	int index = 0, len = strlen (src);
	while (index < len)
	{
		if (src[index++] == ' ')
			return &src[index];
	}
	return src;
}

int record_status (char * status)
{
	FILE * fp = fopen (DHCP_LOG, "a+");
	if (!fp)
		return -1;
	fprintf (fp, "%s\n", status);
	fclose (fp);
	return 0;
}
