#include <stdio.h>
#include <stdlib.h>

#include <cgi.h>
#include <NAS.h>
#include <storage.h>
#include "config.h"

int main()
{
	INPUT	*input, *p=NULL;

	CGI_Init();
	input=CGI_Get_Input();
	if ((p=CGI_Find_Parameter(input, "reset"))!=NULL)
	{
		if (!strcmp(p->val, "yes"))
		{	/* start reset all settings	*/
			system("/sbin/reset_all");
			printf("Reset successful...<br>");
			printf("Please restart system now...<br>");
		}
		else
		if (!strcmp(p->val, "no"))
		{	/* do nothing		*/
			printf("nothing to do...<br>");
		}
		else
			goto fail;
	}
	else
	if ((p=CGI_Find_Parameter(input, "hdnum"))!=NULL)
	{
		int	num, drive_no;
		char	buf[256];

		GetProfileString("Storage", "Change No", "FALSE", buf, sizeof(buf));
		if (!strcasecmp(buf, "TRUE"))
		{
			drive_no=Get_Profile_Integer(NASCONF_STORAGE_SECTION, NASCONF_DRIVE_NO_FIELD, 0);
			if (drive_no<3 || drive_no>4)
				goto fail;
			num=atoi(p->val);
			if (num<3 || num>4)
				goto fail;
			WriteProfileString(NASCONF_STORAGE_SECTION, NASCONF_DRIVE_NO_FIELD, p->val);
			printf("set hd number = %d successful...<br>", num);
			printf("Please restart system now...<br>");
		}
		else
			goto fail;
	}
	else
	if ((p=CGI_Find_Parameter(input, "backup"))!=NULL)
	{
		if (!strcmp(p->val, "yes"))
		{	/* backup system settings */
			Backup_System_Config();
			printf("Backup system settings successful...<br>");
			printf("Please restart system now...<br>");
		}
		else
		if (!strcmp(p->val, "no"))
		{	/* do nothing		*/
			printf("nothing to do...<br>");
		}
		else
			goto fail;
	}
	else
	if ((p=CGI_Find_Parameter(input, "recover"))!=NULL)
	{
		if (!strcmp(p->val, "yes"))
		{	/* recover system settings */
			Recover_System_Config();
			printf("Recover system settings successful...<br>");
			printf("Please restart system now...<br>");
		}
		else
		if (!strcmp(p->val, "no"))
		{	/* do nothing		*/
			printf("nothing to do...<br>");
		}
		else
			goto fail;
	}
	CGI_Free_Input(input);
	return 1;
fail:
	printf("Failed to run tools.cgi !!<br>");
	return 0;
}

