#include <v2_menu.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <stdarg.h>
#include "cgi.h"
#include "uLinux.h"
#include "config.h"
#include "server.h"
//#include "server01.h"
#include "server02.h"
//#include "server03.h"
#include "timezone.h"
#include "cfg_ntp.h"

// ------------------------------------
// The status of testing NTP server:
// -1: Failure
//  0: Not tested yet
//  1: Success
// ------------------------------------
int test1_status = 0;
int test2_status = 0;
int test3_status = 0;
int test4_status = 0;


char Parameter[MAX_PARAMETER_NUMBER][BUF_SIZE];
extern char *timezone_Windows[];

char Selected_Timezone[BUF_SIZE] = "";


int server02_replace(FILE *fptr, char *name, void *arg)
{
	int ret = ERROR_FAIL;
	INPUT *input = (INPUT *)arg;
	
        if (strncasecmp(name, "PARAMETER_", strlen("PARAMETER_")) == 0) {
                int i = atoi(&(name[strlen("PARAMETER_")]));

                if (i > 0 && i < MAX_PARAMETER_NUMBER) {
                        fprintf(fptr, "%s", Parameter[i - 1]);
                }
        }
        else if (strcasecmp(name, "TIMEZONE_LIST") == 0) {
		int i;
                for (i = 0; i < (WINDOWS_TIMEZONE_MAX-1); i++) {
                        if (!strcmp(timezone_Windows[i], Selected_Timezone))
                                fprintf(fptr, "<OPTION VALUE=\"%d\" SELECTED>%s</OPTION>\n", i, timezone_Windows[i]);
                        else
                                fprintf(fptr, "<OPTION VALUE=\"%d\">%s</OPTION>\n", i, timezone_Windows[i]);
                }
        }
        else if (strcasecmp(name, "USE_NTP") == 0) {
		if((CGI_Find_Parameter(input, "TEST_BTN1") != NULL) ||
		   (CGI_Find_Parameter(input, "TEST_BTN2") != NULL) ||
		   (CGI_Find_Parameter(input, "TEST_BTN3") != NULL) || 
		   (CGI_Find_Parameter(input, "TEST_BTN4") != NULL)) 
		{
//			if((CGI_Find_Parameter(input, "SPECIFY_NTP_SERVER") != NULL) || (CGI_Find_Parameter(input, "ENABLE_NTP_SERVER") != NULL)) 
		if(CGI_Find_Parameter(input, "CONFIGURE_NTP") != NULL)
			{
				fprintf(fptr, "%s", "var use_ntp = 1;");
			}
			else {
				fprintf(fptr, "%s", "var use_ntp = 0;");
			}
		}
		else {
			if(NTP_Is_Server_Used() || NTP_Is_Server_Enabled()) {
				fprintf(fptr, "%s", "var use_ntp = 1;");
			}
			else {
				fprintf(fptr, "%s", "var use_ntp = 0;");
			}
		}
	}
        else if (strcasecmp(name, "NTP_ENABLED") == 0) {
		if((CGI_Find_Parameter(input, "TEST_BTN1") != NULL) ||
		   (CGI_Find_Parameter(input, "TEST_BTN2") != NULL) ||
		   (CGI_Find_Parameter(input, "TEST_BTN3") != NULL) || 
		   (CGI_Find_Parameter(input, "TEST_BTN4") != NULL)) 
		{
			if(CGI_Find_Parameter(input, "ENABLE_NTP_SERVER") != NULL) {
				fprintf(fptr, "%s", "var ntp_enabled = 1;");
			}
			else {
				fprintf(fptr, "%s", "var ntp_enabled = 0;");
			}
		}
		else {
			if(NTP_Is_Server_Enabled() == TRUE) {
				fprintf(fptr, "%s", "var ntp_enabled = 1;");
			}
			else {
				fprintf(fptr, "%s", "var ntp_enabled = 0;");
			}
		}
	}
	else if(!strcmp(name, "CHECK_CONFIGURE_NTP")) {
		if((CGI_Find_Parameter(input, "TEST_BTN1") != NULL) ||
		   (CGI_Find_Parameter(input, "TEST_BTN2") != NULL) ||
		   (CGI_Find_Parameter(input, "TEST_BTN3") != NULL) || 
		   (CGI_Find_Parameter(input, "TEST_BTN4") != NULL)) 
		{
			fprintf(fptr, "%s", "checked");
		}
		else {
			if(NTP_Is_Server_Used() || NTP_Is_Server_Enabled()) {
				fprintf(fptr, "%s", "checked");
			}
		}
	}
/*
	else if(!strcmp(name, "RADIO_SPECIFY_NTP")) {
		if(CGI_Find_Parameter(input, "TEST_BTN4") != NULL) {
			fprintf(fptr, "%s", "checked");
		}
		else {
			if(!NTP_Is_Server_Enabled()) {
				fprintf(fptr, "%s", "checked");
			}
		}
	}
*/
	else if(!strcmp(name, "SERVER4_IP")) {
		char ip_address[IP_ADDRESS_LENGTH];
		INPUT *tmp = NULL;

		if(CGI_Find_Parameter(input, "TEST_BTN4") != NULL) {
			if((tmp=CGI_Find_Parameter(input, "SPECIFIC_SERVER")) != NULL) {
				fprintf(fptr, "%s", tmp->val);
			}
		}
		else {
			ret = NTP_Get_Server_IP(ip_address, sizeof(ip_address));
			if(ret == SUCCESS) {
				fprintf(fptr, "%s", ip_address);
			}
		}
	}
	else if(!strcmp(name, "TIME_INTERVAL")) {
		int interval = 0;
		INPUT *tmp = NULL;
		char str_interval[3] = "\"\"";
			 
		if(CGI_Find_Parameter(input, "TEST_BTN4") != NULL) {
			if((tmp=CGI_Find_Parameter(input, "INTERVAL")) != NULL) {
				if(!strcmp(tmp->val, "")) {
					fprintf(fptr, "%s", str_interval);
				}
				else {
					fprintf(fptr, "%s", tmp->val);
				}
			}
		}
		else {
			if(NTP_Get_Interval(&interval)) {
				sprintf(str_interval, "%d", interval);
			}
			fprintf(fptr, "%s", str_interval);
		}
	}
	else if(!strcmp(name, "MIN_SELECT")) {
		char time_unit[10] = "";
		INPUT *tmp = NULL;
			 
		if(CGI_Find_Parameter(input, "TEST_BTN4") != NULL) {
			if((tmp=CGI_Find_Parameter(input, "INTERVAL_TYPE")) != NULL) {
				if(0 == atoi(tmp->val)) {
					fprintf(fptr, "%s", "Selected");
				}
				else {
					fprintf(fptr, "%s", "");
				}
			}
			else {
				fprintf(fptr, "%s", "");
			}
		}
		else {
			if(NTP_Get_Interval_Unit(time_unit, sizeof(time_unit))) {
				if(!strcasecmp(time_unit, "MINUTE")) {
					fprintf(fptr, "%s", "Selected");
				}
			}
			else {
				fprintf(fptr, "%s", "");
			}
		}
	}
	else if(!strcmp(name, "HOUR_SELECT")) {
		char time_unit[10] = "";
		INPUT *tmp = NULL;
		 
		if(CGI_Find_Parameter(input, "TEST_BTN4") != NULL) {
			if((tmp=CGI_Find_Parameter(input, "INTERVAL_TYPE")) != NULL) {
				if(1 == atoi(tmp->val)) {
					fprintf(fptr, "%s", "Selected");
				}
				else {
					fprintf(fptr, "%s", "");
				}
			}
			else {
				fprintf(fptr, "%s", "");
			}
		}
		else {
			if(NTP_Get_Interval_Unit(time_unit, sizeof(time_unit))) {
				if(!strcasecmp(time_unit, "HOUR")) {
					fprintf(fptr, "%s", "Selected");
				}
			}
			else {
				fprintf(fptr, "%s", "");
			}
		}
	}
	else if(!strcmp(name, "DAY_SELECT")) {
		char time_unit[10] = "";
		INPUT *tmp = NULL;
		 
		if(CGI_Find_Parameter(input, "TEST_BTN4") != NULL) {
			if((tmp=CGI_Find_Parameter(input, "INTERVAL_TYPE")) != NULL) {
				if(2 == atoi(tmp->val)) {
					fprintf(fptr, "%s", "Selected");
				}
				else {
					fprintf(fptr, "%s", "");
				}
			}
			else {
				fprintf(fptr, "%s", "");
			}
		}
		else {
			if(NTP_Get_Interval_Unit(time_unit, sizeof(time_unit))) {
				if(!strcasecmp(time_unit, "DAY")) {
					fprintf(fptr, "%s", "Selected");
				}
			}
			else {
				fprintf(fptr, "%s", "");
			}
		}
	}
	else if(!strcmp(name, "TEST1_STATUS")) {
		switch(test1_status) {
			case -1:
				fprintf(fptr, "%s", "IEI_NAS_SERVER_NTP_STR15");
				break;
			case 0:
				fprintf(fptr, "%s", "IEI_NAS_SERVER_NTP_STR13");
				break;
			case 1:
				fprintf(fptr, "%s", "IEI_NAS_SERVER_NTP_STR14");
				break;
			default:
				fprintf(fptr, "%s", "IEI_NAS_SERVER_NTP_STR13");
		}
	}
	else if(!strcmp(name, "TEST2_STATUS")) {
		switch(test2_status) {
			case -1:
				fprintf(fptr, "%s", "IEI_NAS_SERVER_NTP_STR15");
				break;
			case 0:
				fprintf(fptr, "%s", "IEI_NAS_SERVER_NTP_STR13");
				break;
			case 1:
				fprintf(fptr, "%s", "IEI_NAS_SERVER_NTP_STR14");
				break;
			default:
				fprintf(fptr, "%s", "IEI_NAS_SERVER_NTP_STR13");
		}
	}
	else if(!strcmp(name, "TEST3_STATUS")) {
		switch(test3_status) {
			case -1:
				fprintf(fptr, "%s", "IEI_NAS_SERVER_NTP_STR15");
				break;
			case 0:
				fprintf(fptr, "%s", "IEI_NAS_SERVER_NTP_STR13");
				break;
			case 1:
				fprintf(fptr, "%s", "IEI_NAS_SERVER_NTP_STR14");
				break;
			default:
				fprintf(fptr, "%s", "IEI_NAS_SERVER_NTP_STR13");
		}
	}
	else if(!strcmp(name, "TEST4_STATUS")) {
		switch(test4_status) {
			case -1:
				fprintf(fptr, "%s", "IEI_NAS_SERVER_NTP_STR15");
				break;
			case 0:
				fprintf(fptr, "%s", "IEI_NAS_SERVER_NTP_STR13");
				break;
			case 1:
				fprintf(fptr, "%s", "IEI_NAS_SERVER_NTP_STR14");
				break;
			default:
				fprintf(fptr, "%s", "IEI_NAS_SERVER_NTP_STR13");
		}
	}
/*
	else if(!strcmp(name, "RADIO_ENABLE_NTP")) {
		if((CGI_Find_Parameter(input, "TEST_BTN1") != NULL) ||
		   (CGI_Find_Parameter(input, "TEST_BTN2") != NULL) ||
		   (CGI_Find_Parameter(input, "TEST_BTN3") != NULL)) 
		{
			fprintf(fptr, "%s", "checked");
		}
		else {	
			if(NTP_Is_Server_Enabled() == TRUE) {
				fprintf(fptr, "%s", "checked");
			}
		}
	}
	else if(!strcmp(name, "SERVER1_IP")) {
		char ip_address[IP_ADDRESS_LENGTH];
		INPUT *tmp = NULL;

		if((CGI_Find_Parameter(input, "TEST_BTN1") != NULL) ||
		   (CGI_Find_Parameter(input, "TEST_BTN2") != NULL) ||
		   (CGI_Find_Parameter(input, "TEST_BTN3") != NULL)) 
		{
			if((tmp=CGI_Find_Parameter(input, "SERVER1")) != NULL) {
				fprintf(fptr, "%s", tmp->val);
			}
		}
		else {
			ret = NTP_Get_ServerN_IP(ip_address, 1, sizeof(ip_address));
			if(ret != 0) {
				fprintf(fptr, "%s", ip_address);
			}
		}
	}
	else if(!strcmp(name, "SERVER2_IP")) {
		char ip_address[IP_ADDRESS_LENGTH];
		INPUT *tmp = NULL;

		if((CGI_Find_Parameter(input, "TEST_BTN1") != NULL) ||
		   (CGI_Find_Parameter(input, "TEST_BTN2") != NULL) ||
		   (CGI_Find_Parameter(input, "TEST_BTN3") != NULL)) 
		{
			if((tmp=CGI_Find_Parameter(input, "SERVER2")) != NULL) {
				fprintf(fptr, "%s", tmp->val);
			}
		}
		else {
			ret = NTP_Get_ServerN_IP(ip_address, 2, sizeof(ip_address));
			if(ret != 0) {
				fprintf(fptr, "%s", ip_address);
			}
		}
	}
	else if(!strcmp(name, "SERVER3_IP")) {
		char ip_address[IP_ADDRESS_LENGTH];
		INPUT *tmp = NULL;

		if((CGI_Find_Parameter(input, "TEST_BTN1") != NULL) ||
		   (CGI_Find_Parameter(input, "TEST_BTN2") != NULL) ||
		   (CGI_Find_Parameter(input, "TEST_BTN3") != NULL)) 
		{
			if((tmp=CGI_Find_Parameter(input, "SERVER3")) != NULL) {
				fprintf(fptr, "%s", tmp->val);
			}
		}
		else {
			ret = NTP_Get_ServerN_IP(ip_address, 3, sizeof(ip_address));
			if(ret != 0) {
				fprintf(fptr, "%s", ip_address);
			}
		}
	}
*/
	else
		return CGI_REPLACE_FAIL;
        return CGI_REPLACE_OK;
}




int show_server02_header(int server_select, INPUT *input)
{
        HEADER_ITEM     header;
	//static char*    server_defs[]={SERVER_DEFS};

        CGI_Output_Html1(SERVER02_MAIN_HEADER, "$", server02_replace, input);
        header.back[0]=0x0;
        header.home[0]=0x0;
        header.logout[0]=0x0;
        CGI_Get_Help(header.help, "help_server.html#help_servertime");
        CGI_Show_Menu_V3_1(FUNC_SYSTEM, &header);
        CGI_Output_Html1(MENU_V3_HEADER_HTML, "$", server02_replace, NULL);
        CGI_Show_Menu_V3_2(SERVER_DEF, server_select);
        CGI_Output_Html1(MENU_V3_MIDDLE_HTML, "$", server02_replace, NULL);
        
        return 1;
}



int show_server02_tail()
{
        CGI_Output_Html1(MENU_V3_TAIL_HTML, "$", server02_replace, NULL);
        CGI_Output_Html1(SERVER_TAIL_HTML, "$", server02_replace, NULL);
        return 1;
}



void show_server_time()
{
	char date_time[BUF_SIZE];
	int year, day;
	int hour, minute, second;
	int Selected_AMPM = 0;
	int Selected_Month = 0;


	Get_Current_Date_Time(date_time);
	memcpy(Parameter[0], &(date_time[2]), 2);
	Parameter[0][2] = '\0';
	day = atoi(Parameter[0]);
	sprintf(Parameter[0], "%d", day);
	memcpy(Parameter[1], &(date_time[4]), 4);
	Parameter[1][4] = '\0';
	year = atoi(Parameter[1]);
	sprintf(Parameter[1], "%d", year);
	memcpy(Parameter[2], &(date_time[8]), 2);
	Parameter[2][2] = '\0';
	hour = atoi(Parameter[2]);
	if (hour >= 12) {
		Selected_AMPM = 1;
		if (hour > 12) hour -= 12;
	}
	else {
		Selected_AMPM = 0;
		if (hour == 0) hour = 12;
	}
	sprintf(Parameter[2], "%d", hour);
	memcpy(Parameter[3], &(date_time[10]), 2);
	Parameter[3][2] = '\0';
	minute = atoi(Parameter[3]);
	sprintf(Parameter[3], "%d", minute);
	memcpy(Parameter[4], &(date_time[12]), 2);
	Parameter[4][2] = '\0';
	second = atoi(Parameter[4]);
	sprintf(Parameter[4], "%d", second);
	sprintf(Parameter[5], "%d", Selected_AMPM);
	date_time[2] = '\0';
	Selected_Month = atoi(date_time);
	sprintf(Parameter[6], "%d", Selected_Month);
	Get_System_Time_Zone(Selected_Timezone, sizeof(Selected_Timezone));
}

int do_server02_main(INPUT *input, int server_select)
{
	
	show_server02_header(server_select, input);
	show_server_time();
	/* put your code here */
	CGI_Output_Html1(SERVER02_MAIN_HTML, "$", server02_replace, input);
	show_server02_tail();
	return SERVER_SUCCESS;
}


int do_server02_apply(INPUT *input)
{
	char date_time[BUF_SIZE] = "";
	INPUT *p = NULL;
	int i;
	int year, month, day, hour, minute, second;
	char ip_address[IP_ADDRESS_LENGTH];

	Get_Current_Date_Time(date_time);
	
	p = CGI_Find_Parameter(input, "TIMEZONE");
	i = atoi(p->val);
	Set_System_Time_Zone(timezone_Windows[i]);
	if((p = CGI_Find_Parameter(input, "CHANGE_DATE")) != NULL) {
		
//		NTP_Set_Enable_Server(FALSE);
//		NTP_Disable_Server();
//		NTP_Set_Use_Server(FALSE);
//		NTP_Use_Server();

		p = (INPUT *) CGI_Find_Parameter(input, "YEAR");
		year = atoi(p->val);
		p = (INPUT *) CGI_Find_Parameter(input, "MONTH");
		month = atoi(p->val);
		p = (INPUT *) CGI_Find_Parameter(input, "DAY");
		day = atoi(p->val);
		p = (INPUT *) CGI_Find_Parameter(input, "AMPM");
		i = atoi(p->val);
		p = (INPUT *) CGI_Find_Parameter(input, "HOUR");
		hour = atoi(p->val);
		if (i == 1) {
			if (hour < 12) hour += 12;
		}
		else {
			if (hour == 12) hour = 0;
		}
		p = CGI_Find_Parameter(input, "MINUTE");
		minute = atoi(p->val);
		p = CGI_Find_Parameter(input, "SECOND");
		second = atoi(p->val);
		sprintf(date_time, "%02d%02d%04d%02d%02d%02d", month, day, year, hour, minute, second);
		Set_Current_Date_Time(date_time);
	}

	if((p=CGI_Find_Parameter(input, "CONFIGURE_NTP")) == NULL) { // Configure to NOT use NTP
		if(NTP_Is_Server_Enabled()) {
			NTP_Set_Enable_Server(FALSE);	// uLinux.conf: Enable NTP Server = FALSE
			NTP_Disable_Server();		// /etc/init.d/ntpd.sh stop 
		}
		NTP_Set_Use_Server(FALSE);
		NTP_Use_Server();
	}
	else {

//		if((p=CGI_Find_Parameter(input, "ENABLE_NTP_SERVER")) == NULL) { // NOT enable NTP server
			if(NTP_Is_Server_Enabled()) {
				NTP_Set_Enable_Server(FALSE);	// uLinux.conf: Enable NTP Server = FALSE
				NTP_Disable_Server();		// /etc/init.d/ntpd.sh stop 
			}
			if((p=CGI_Find_Parameter(input, "SPECIFIC_SERVER")) != NULL) {
				strcpy(ip_address, p->val);
				NTP_Set_Server_IP(ip_address);
			}
			if((p=CGI_Find_Parameter(input, "INTERVAL")) != NULL) {
				NTP_Set_Interval(atoi(p->val));
				if((p=CGI_Find_Parameter(input, "INTERVAL_TYPE")) != NULL) {
					char time_unit[10] = "";
					
					switch(atoi(p->val)) {
						case 0:
							strcpy(time_unit, "MINUTE");
							break;
						case 1:
							strcpy(time_unit, "HOUR");
							break;
						case 2:
							strcpy(time_unit, "DAY");
							break;
					}
					NTP_Set_Interval_Unit(time_unit);
				}
			}
			NTP_Set_Use_Server(TRUE);	// uLinux.conf: Use NTP Server = TRUE 
			NTP_Use_Server();		
/*		}
		else {
			NTP_Set_Use_Server(TRUE);	// uLinux.conf: Use NTP Server = TRUE
			NTP_Set_Enable_Server(TRUE);	// uLinux.conf: Enable NTP Server = TRUE
//			sleep(2);			
			if((p=CGI_Find_Parameter(input, "SERVER1")) != NULL) {
				strcpy(ip_address, p->val);
				NTP_Set_ServerN_IP(ip_address, 1, IP_ADDRESS_LENGTH);
			}
			if((p=CGI_Find_Parameter(input, "SERVER2")) != NULL) {
				strcpy(ip_address, p->val);
				NTP_Set_ServerN_IP(ip_address, 2, IP_ADDRESS_LENGTH);
			}
			if((p=CGI_Find_Parameter(input, "SERVER3")) != NULL) {
				strcpy(ip_address, p->val);
				NTP_Set_ServerN_IP(ip_address, 3, IP_ADDRESS_LENGTH);
			}
			NTP_Use_Server();		
			NTP_Enable_Server();		// /etc/init.d/ntpd.sh start 
		}
*/
		Set_Current_Date_Time(date_time);
	}
	return SERVER_SUCCESS;
}


int do_server02_main_submit(INPUT *input, int server_select)
{
	int	btn;
	int	ret=SERVER_SUCCESS;
	INPUT *p = NULL;
	char ip_address[IP_ADDRESS_LENGTH];

	btn=get_btn(input);
	switch (btn)
	{
		case SERVER_BTN_APPLY:
			/* put your "apply button" code here */
			if((ret=do_server02_apply(input))==SERVER_SUCCESS)
				do_server02_main(input, server_select);
			break;	
/*	
		case SERVER_BTN_TEST1:
			if((p = (INPUT *) CGI_Find_Parameter(input, "SERVER1")) != NULL) {
				strncpy(ip_address, p->val, sizeof(ip_address));
				if(SUCCESS == NTP_Test_Server(ip_address)) {
					test1_status = 1;
				}
				else {
					test1_status = -1;
				}
			}
			do_server02_main(input, server_select);
			break;
		case SERVER_BTN_TEST2:
			if((p = (INPUT *) CGI_Find_Parameter(input, "SERVER2")) != NULL) {
				strncpy(ip_address, p->val, sizeof(ip_address));
				if(SUCCESS == NTP_Test_Server(ip_address)) {
					test2_status = 1;
				}
				else {
					test2_status = -1;
				}
			}
			do_server02_main(input, server_select);
			break;
		case SERVER_BTN_TEST3:
			if((p = (INPUT *) CGI_Find_Parameter(input, "SERVER3")) != NULL) {
				strncpy(ip_address, p->val, sizeof(ip_address));
				if(SUCCESS == NTP_Test_Server(ip_address)) {
					test3_status = 1;
				}
				else {
					test3_status = -1;
				}
			}
			do_server02_main(input, server_select);
			break;
*/
		case SERVER_BTN_TEST4:
			if((p = (INPUT *) CGI_Find_Parameter(input, "SPECIFIC_SERVER")) != NULL) {
				strncpy(ip_address, p->val, sizeof(ip_address));
				//if(SUCCESS == NTP_Test_Server(ip_address)) {
				if(SUCCESS == NTP_Update_Now(ip_address)) {
					test4_status = 1;
				}
				else {
					test4_status = -1;
				}
			}
			if((ret=do_server02_apply(input))==SERVER_SUCCESS)//Shone modified 2005,12,02
				do_server02_main(input, server_select);
			break;
	}
	return ret;
}
