#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <stdarg.h>
#include <v2_menu.h>
#include <unistd.h>
#include "uLinux.h"
#include "config.h"
#include "cgi.h"
#include "server.h"
#include "server01.h"
#include "../CGI2.1/icp.h"

#define HOSTNAME_SCRIPT_PATH    "/etc/init.d/hostname.sh"
#define SMB_SCRIPT_PATH         "/etc/init.d/smb.sh"

extern void LOG_TABLE_COL(FILE *fp, int, char *, char *, char *);
extern ACTIVE_USER_INFO *count_active_user(int *real);
extern void show_active_user(FILE *fp, ACTIVE_USER_INFO *active, int);

char Parameter[MAX_PARAMETER_NUMBER][BUF_SIZE];

void DebugOutput(char *msg, ...)
{
	FILE *dout;
	char buf[2048];
	va_list args;

	va_start(args, msg);
	vsnprintf(buf, sizeof(buf)-1, msg, args);
	va_end(args);

	dout = fopen("/home/httpd/cgi-bin/cgi.debug", "a");
	fputs(buf, dout);
	fclose(dout);
}

/*
int is_DBCS_lead_byte(char byte)
{
	int ret = 0;

	unsigned int ch = ((unsigned int) byte & 0x010101ff);

	if ((ch >= 0xA1) && (ch <= 0xFE)) {
		ret = 1;
		if (strcasecmp(Lang, "JPN") == 0) {
			if ((ch <= 0xDF) && (ch >= 0xA0))
				ret = 0;
		}
	}
	return ret;
}
*/

int is_DBCS_string(char *str)
{
//	int i, len = strlen(str);
//	for (i = 0; i < len; i++)
//		if (is_DBCS_lead_byte(str[i]) == 1)
//				return 1;
	return 0;
}



int server01_replace(FILE *fptr, char *name, void *arg)
{
        if (strncasecmp(name, "PARAMETER_", strlen("PARAMETER_")) == 0) {
		int i = atoi(&(name[strlen("PARAMETER_")]));
                if (i > 0 && i < MAX_PARAMETER_NUMBER) {
                        fprintf(fptr, "%s", Parameter[i - 1]);
                }
	}
	else if(!strcmp(name, "START_HERE")){
		int real_count = 0;
		//marked by jeffrey 2005/09/15
		//ACTIVE_USER_INFO *active = count_active_user(&real_count);
		//Shone marked 2006,01,10
		//fprintf(fptr, "<p>&nbsp;</p>\n");
		//fprintf(fptr, "<SCRIPT Language=\"JavaScript\">document.write(IEI_IDS_STRING160)</SCRIPT><br>\n<p>&nbsp;</p>\n");
		//show_active_user(fptr, active, real_count);
		//if (active != NULL)
		//	free(active);
	}
	else
		return CGI_REPLACE_FAIL;
        return CGI_REPLACE_OK;
}

int show_server01_header(int server_select)
{
        HEADER_ITEM     header;
	//static char*    server_defs[]={SERVER_DEFS};

        CGI_Output_Html1(SERVER_HEADER_HTML, "$", server01_replace, NULL);
        header.back[0]=0x0;
        header.home[0]=0x0;
        header.logout[0]=0x0;
        CGI_Get_Help(header.help, "help_server.html#help_servername");
        CGI_Show_Menu_V3_1(FUNC_SYSTEM, &header);
        CGI_Output_Html1(MENU_V3_HEADER_HTML, "$", server01_replace, NULL);
        CGI_Show_Menu_V3_2(SERVER_DEF, server_select);
        CGI_Output_Html1(MENU_V3_MIDDLE_HTML, "$", server01_replace, NULL);
        return 1;
}

int show_server01_tail()
{
        CGI_Output_Html1(MENU_V3_TAIL_HTML, "$", server01_replace, NULL);
        CGI_Output_Html1(SERVER_TAIL_HTML, "$", server01_replace, NULL);
        return 1;
}


void show_server_name()
{
	Get_Server_Name(Parameter[0], sizeof(Parameter[0]));
	Get_Workgroup_Name(Parameter[1], sizeof(Parameter[1]));
	Get_Server_Comment(Parameter[2], sizeof(Parameter[2]));
	
}



int do_server01_main(INPUT *input, int server_select)
{
	show_server01_header(server_select);
	show_server_name();
	/* put your code here */
	CGI_Output_Html1(SERVER01_MAIN_HTML, "$", server01_replace, NULL);
	show_server01_tail();
	return SERVER_SUCCESS;
}




int do_server01_apply(INPUT *input)
{

	int ret = VALUE_NO_CHANGE;
	char buf[BUF_SIZE];
	INPUT *p, *p1;

	if((p = CGI_Find_Parameter(input, "SERVER_NAME")) != NULL) {
		if (is_DBCS_string(p->val) == 1)
			return ERROR_ILLEGAL_NAME;
	}
	if((p1 = CGI_Find_Parameter(input, "WORKGROUP")) != NULL) {
		if (is_DBCS_string(p1->val) == 1) 
			return ERROR_ILLEGAL_NAME;
	}
	if (NULL != p) {
		Get_Server_Name(buf, sizeof(buf)) ;
		if (strcmp(buf, p->val) != 0) {
			ret = VALUE_CHANGED;
			Set_Server_Name(p->val, 0);
			sprintf(buf,"%s restart 1>/dev/null 2 >&1",HOSTNAME_SCRIPT_PATH);//Shone added
			system(buf);
			sprintf(buf,"%s restart 1>/dev/null 2 >&1",SMB_SCRIPT_PATH);
                        system(buf);
			//set_restart_flag(1);//Shone marked 2005,12,19
		}
	}
	if (NULL != p1) {
		Get_Workgroup_Name(buf, sizeof(buf)) ;
		if (strcmp(buf, p1->val) != 0) {
			//ret = VALUE_CHANGED;
			Set_Workgroup_Name(p1->val);
		}
	}
	if((p = CGI_Find_Parameter(input, "SERVER_DESC")) != NULL) {
		Get_Server_Comment(buf, sizeof(buf)) ;
		if (strcmp(buf, p->val) != 0) {
			//ret = VALUE_CHANGED;
			Set_Server_Comment(p->val);
		}
	}

	return ret;


}

int show_server01_restart_header(int server_select)
{
        HEADER_ITEM     header;

        CGI_Output_Html1(SERVER_HEADER_HTML, "$", server01_replace, NULL);
        header.back[0]=0x0;
        header.home[0]=0x0;
        header.logout[0]=0x0;
	if(Is_Version_22())
	        CGI_Get_Help(header.help, "help_server.html#help_qconfig_reboot");
	else
		CGI_Get_Help(header.help, "help_qconfig_reboot.html");
        CGI_Show_Menu_V3_1(FUNC_SYSTEM, &header);
        CGI_Output_Html1(MENU_V3_HEADER_HTML, "$", server01_replace, NULL);
        CGI_Show_Menu_V3_2(SERVER_DEF, server_select);
        CGI_Output_Html1(MENU_V3_MIDDLE_HTML, "$", server01_replace, NULL);
        return 1;
}

int do_server01_restart(INPUT *input, int server_select)
{
        show_server01_restart_header(server_select);

        /* put your code here */
        CGI_Output_Html1(SERVER01_RESTART_HTML, "$", server01_replace, NULL);

        show_server01_tail();
        return SERVER_SUCCESS;
}

int do_restart_ending(INPUT *input, int server_select)
{
        HEADER_ITEM     header;

        CGI_Output_Html1(SERVER01_RESTART_ING_HEADER_HTML, "$", server01_replace, NULL);
        header.back[0]=0x0;
        header.home[0]=0x0;
        header.logout[0]=0x0;
	if(Is_Version_22())
	        CGI_Get_Help(header.help, "help_server.html#help_qconfig_reboot");
	else
		CGI_Get_Help(header.help, "help_qconfig_reboot.html");
	CGI_Show_Menu_V3_1(FUNC_WEBFS_1, &header);

        /* put your code here */
        CGI_Output_Html1(SERVER01_RESTART_ENDING_HTML, "$", server01_replace, NULL);

        //show_quick11_tail();
        CGI_Output_Html1(MENU_V3_TAIL_HTML, "$", server01_replace, NULL);
        CGI_Output_Html1(SERVER_TAIL_HTML, "$", server01_replace, NULL);
        return SERVER_SUCCESS;
}

int do_server01_restart_submit(INPUT *input, int server_select)
{
	int 	btn;
        pid_t   mypid;
        pid_t   parent;
        char    dir[128], buf[128];

	btn=get_btn(input);
	//CGI_Debug_Input(input);
	switch (btn)
	{
		case SERVER_BTN_YES:
                        parent=getpid();
                        sprintf(dir, "/proc/%d/exe", parent);
                        mypid=fork();
                        if (mypid==0)
                        {       //child
                                close(0);
                                close(1);
                                close(2);
                                while (1)
                                {
                                        if (readlink(dir, buf, 256)==-1)
                                                break;
                                        sleep(1);
                                }
				Restart_System();
                                exit(1);
                        }
                        else
                                do_restart_ending(input, server_select);
			break;
		case SERVER_BTN_NO:
			do_server01_main(input, server_select);
			break;
	}
	return SERVER_SUCCESS;
}


int do_server01_main_submit(INPUT *input, int server_select)
{
	int	btn;
	int	ret=SERVER_SUCCESS;

	btn=get_btn(input);
	switch (btn)
	{
		case SERVER_BTN_APPLY:
			/* put your "next button" code here */
			if((ret=do_server01_apply(input))==VALUE_CHANGED) {
				//do_server01_restart(input, server_select);
				do_server01_main(input, server_select);//Shone modified 2005,12,19
			}
			else if(ret==VALUE_NO_CHANGE) {
				do_server01_main(input, server_select);
			}
			break;
		ret=SERVER_SUCCESS;
	}
	return ret;
}
