#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <stdarg.h>
#include <unistd.h>


/* NAS include file */
#include <cgi.h>
#include <v2_menu.h>
#include <NAS.h>
#include <cfg_nic.h>
#include <sys/stat.h>
#include "uLinux.h"
#include "config.h"
#include "cfg_ntp.h"

/* local include */
#include "quick.h"
#include "quick11.h"
#include "quick05.h"
#include "../CGI2.1/icp.h"
#include "NAS.h"
#include "codepage.h"
#include "storage.h"

#define JS(ID) "<SCRIPT Language=\"JavaScript\">document.write(" #ID ")</SCRIPT>"

extern void LOG_TABLE_COL(FILE *fp, int, char *, char *, char *);
//extern ACTIVE_USER_INFO *count_active_user(int *real);
//extern void show_active_user(FILE *fp, ACTIVE_USER_INFO *active, int);
int Net_Link_Flag=0;

void DebugOutput(char *msg, ...)
{
	FILE *dout;
	char buf[2048];
	va_list args;

	va_start(args, msg);
	vsnprintf(buf, sizeof(buf)-1, msg, args);
	va_end(args);

	dout = fopen("/home/httpd/cgi-bin/cgi.debug", "a");
	fputs(buf, dout);
	fclose(dout);
}

/*-----------------------------------------------------------------------*/
/*before removing one volume, system should kill the samba service on it */
/*-----------------------------------------------------------------------*/

static void killusers_delshare_on_volume(int vol_no,int del_share)
{
	SMB_SHARE_INFO *smb_info,*smb_start;
	char mp_str[BUF_SIZE];//,buf[BUF_SIZE];

	Get_MP_String(vol_no,DATA_PART,mp_str);

	smb_info = SMB_Get_Share_Info();
	smb_start = smb_info;
	while(smb_info != NULL) 
	{
		if(strstr(smb_info->path,mp_str) !=NULL) 
		{
			//sprintf(buf, "/sbin/smbtools -k \"%s\"",smb_info->sharename);
			//system(buf);

			if(del_share) Remove_NAS_Share(smb_info->sharename);
			//sprintf(buf,"/bin/kill -HUP `/sbin/pidof smbd` 2>/dev/null 1>/dev/null");
			//system(buf);
		}
		smb_info = smb_info->next;
	}
	SMB_Free_Share_Info(smb_start);
}

static int my_report_log(char *message)
{
        char cmd_line[256];
        sprintf(cmd_line,"/sbin/report_log \"%s\"",message);
        system(cmd_line);
        return 0;
}

int quick11_replace(FILE *fptr, char *name, void *arg)
{
	char buf[BUF_SIZE];
	int ret;
	INPUT *input = (INPUT *)arg;

	if(!strcmp(name, "system_status"))
	{
		Get_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_DISK_FLAG, QUICK_SETUP_DEFAULT_STRING, buf, sizeof(buf), QUICK_CONF_FILE);//Shone
		if (strcmp(buf,"1"))//Not initializing
		{
			if(Get_Admin_Configured_Status()&&!read_initial_flag())
				fprintf(fptr, "QUICK11_STR14");//system is ok
			else if(read_initial_flag())
				fprintf(fptr, "QUICK11_STR12");//your setting is as below...
			else if(!Get_Admin_Configured_Status())
				fprintf(fptr, "QUICK11_STR15");//system is not initialized
		}
		else fprintf(fptr, "QUICK11_STR13");//initializing
	}
	else if(!strcmp(name, "init_mark_strat")||!strcmp(name, "init_mark_end"))
	{
		Get_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_DISK_FLAG, QUICK_SETUP_DEFAULT_STRING, buf, sizeof(buf), QUICK_CONF_FILE);
		if (!strcmp(buf,"1"))//initializing
		{
			if(!strcmp(name, "init_mark_strat"))
				fprintf(fptr, "<!--");
			else if(!strcmp(name, "init_mark_end"))
				fprintf(fptr, "-->");
		}
	}
	else if(!strcmp(name, "system_ok_mark_start")||!strcmp(name, "system_ok_mark_end"))
	{
		Get_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_DISK_FLAG, QUICK_SETUP_DEFAULT_STRING, buf, sizeof(buf), QUICK_CONF_FILE);
		if (strcmp(buf,"1"))//Not initializing
		{
			if(Get_Admin_Configured_Status()&&!read_initial_flag())//system is ok
			{
				if(!strcmp(name, "system_ok_mark_start"))
					fprintf(fptr, "<!--");
				else if(!strcmp(name, "system_ok_mark_end"))
					fprintf(fptr, "-->");
			}
		}
	}
	else if(!strcmp(name, "server_name"))
	{
		Get_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_SERVER_NAME, QUICK_SETUP_DEFAULT_STRING, buf, sizeof(buf), QUICK_CONF_FILE);	
		if(!strcmp(buf,QUICK_SETUP_DEFAULT_STRING))
			Get_Server_Name(buf, sizeof(buf));
			
		fprintf(fptr, "\"%s\"",buf);
	} 
	else if(!strcmp(name, "time_zone"))
	{
		Get_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_TIME_ZONE, QUICK_SETUP_DEFAULT_STRING, buf, sizeof(buf), QUICK_CONF_FILE);	
		if(!strcmp(buf,QUICK_SETUP_DEFAULT_STRING))
			Get_System_Time_Zone(buf, sizeof(buf));			

		fprintf(fptr, "\"%s\"",buf);
	} 
	else if(!strcmp(name, "time_setting"))
	{
		Get_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_TIME, QUICK_SETUP_DEFAULT_STRING, buf, sizeof(buf), QUICK_CONF_FILE);	
		if(!strcmp(buf,QUICK_SETUP_DEFAULT_STRING))
		{
			Get_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_TIME_NTP, QUICK_SETUP_DEFAULT_STRING, buf, sizeof(buf), QUICK_CONF_FILE);	
			if(!strcmp(buf,QUICK_SETUP_DEFAULT_STRING))
			{
				if(NTP_Is_Server_Used())
				{
					char buf2[BUF_SIZE];
					//char time_unit[10]="";	
					int ret;
					strcpy(buf2,"QUICK03_STR08");
					ret = NTP_Get_Server_IP(buf, sizeof(buf));
		                        if(ret == SUCCESS)
					{
						//int interval;
						sprintf(buf2,"%s+\"&nbsp;:&nbsp; %s\"",buf2,buf);
/*						sprintf(buf2,"%s+\"&nbsp;:&nbsp; %s",buf2,buf);
						if(NTP_Get_Interval(&interval))				
							sprintf(buf2,"%s&nbsp;/&nbsp;%d \"",buf2,interval);
						if(NTP_Get_Interval_Unit(time_unit, sizeof(time_unit)))
						{
							if(!strcasecmp(time_unit, "MINUTE"))
								strcat(buf2,"+ QUICK03_STR11");
							else if(!strcasecmp(time_unit, "HOUR"))
								strcat(buf2,"+ QUICK03_STR12");
							else if(!strcasecmp(time_unit, "DAY"))
								strcat(buf2,"+ QUICK03_STR13");
						}*/
		
					}	
					fprintf(fptr, "%s",buf2);	
				}
				else//Using current time 
				{
					char buf2[BUF_SIZE];
					Get_Current_Date_Time(buf);
					time_transform(buf2,buf);
					fprintf(fptr, "\"%s\"",buf2);		
				}
			}
			else//Using NTP
			{
				char buf2[BUF_SIZE];
				strcpy(buf2,"QUICK03_STR08");
				//sprintf(buf2,"%s+\"&nbsp;:&nbsp; %s",buf2,buf);
				sprintf(buf2,"%s+\"&nbsp;:&nbsp; %s\"",buf2,buf);
				Get_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_TIME_GAP, QUICK_SETUP_DEFAULT_STRING, buf, sizeof(buf), QUICK_CONF_FILE);
				//if(!strcmp(buf,QUICK_SETUP_DEFAULT_STRING))
/*				sprintf(buf2,"%s&nbsp;/&nbsp;%s \"",buf2,buf);	
				Get_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_TIME_UNIT, QUICK_SETUP_DEFAULT_STRING, buf, sizeof(buf), QUICK_CONF_FILE);	
				//if(!strcmp(buf,QUICK_SETUP_DEFAULT_STRING))
				{
					if(!strcmp(buf,"MINUTE"))
						strcat(buf2,"+ QUICK03_STR11");
					else if (!strcmp(buf,"HOUR"))
                                                strcat(buf2,"+ QUICK03_STR12");
					else if (!strcmp(buf,"DAY"))
                                                strcat(buf2,"+ QUICK03_STR13");
				}*/
				fprintf(fptr, "%s",buf2);
			}
		}
		else//Setting specific time
		{
			char buf2[BUF_SIZE];
			//mon day year hour minute sec --> year / mon /day AM/PM hour : min : sec
			time_transform(buf2,buf);
			fprintf(fptr, "\"%s\"",buf2);
		}
	} 
	else if(!strcmp(name, "lang_setting"))
	{
		char buf2[BUF_SIZE];
		Get_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_CODEPAGE, QUICK_SETUP_DEFAULT_STRING, buf2, sizeof(buf2), QUICK_CONF_FILE);	
		if(!strcmp(buf2,QUICK_SETUP_DEFAULT_STRING))
		{
			ret=Get_System_Codepage();
			sprintf(buf,"%s%d","IEI_IDS_STRING",ret);
		}
		else
			sprintf(buf,"%s%s","IEI_IDS_STRING",buf2);
			
		fprintf(fptr, "%s",buf);
	} 
	else if(!strcmp(name, "network_type"))
	{
		Get_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_NETWORK, QUICK_SETUP_DEFAULT_STRING, buf, sizeof(buf), QUICK_CONF_FILE);	
		if(!strcmp(buf,QUICK_SETUP_DEFAULT_STRING))
		{
			NIC_NAS_INFO    nic_nas_info;
			NIC_Get_Info_From_uLinux(&nic_nas_info, NIC_LAN01);
			if(nic_nas_info.usage==NIC_USE_DHCP)
				strcpy(buf,"DHCP");
			else if(nic_nas_info.usage==NIC_USE_STATIC)
				sprintf(buf,"%s (STATIC)",nic_nas_info.ifconfig.ipaddr);
		}
		else
		{
			if(strcmp(buf,"DHCP"))
			{
				char buf2[BUF_SIZE];
				
				Get_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_STATIC_IP, QUICK_SETUP_DEFAULT_STRING, buf2, sizeof(buf2), QUICK_CONF_FILE);
				sprintf(buf,"%s : %s",buf,buf2);
			}
		}		

		fprintf(fptr, "\"%s\"",buf);
	} 
	else if(!strcmp(name, "initial_disk"))
	{
		ret=Get_Disk_Status(1);
		if(ret!=S_INITIALIZING && ret!=S_FORMATTING)
		{
			char buf2[BUF_SIZE];
			Get_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_DISK_FLAG, QUICK_SETUP_DEFAULT_STRING, buf2, sizeof(buf2), QUICK_CONF_FILE);
			Get_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_DISK_INIT, QUICK_SETUP_DEFAULT_STRING, buf, sizeof(buf), QUICK_CONF_FILE);
			if(!strcasecmp(buf,"no"))
			{
				if(Get_Disk_Status(1)==S_NOT_EXIST)
					fprintf(fptr, "<font class=\"st_red\">%s</font>",JS(IEI_DEVICE_MSG30));
				else
					fprintf(fptr, "<font class=\"st\">%s</font>",JS(QUICK11_STR06));//Do not initialize
			}
			else if(!strcasecmp(buf,"yes") && strcmp(buf2,"1"))
				fprintf(fptr, "<font class=\"st\">%s</font>",JS(QUICK11_STR05));//Initial Disk
			else 
			{
				if (!strcmp(buf2,"1"))
					fprintf(fptr, "<font class=\"st\">%s</font>", JS(IEI_DEVICE_MSG18));//The starting moment, the status of disk  hasn't been changed yet
				else if(ret==S_READY)
					fprintf(fptr, "<font class=\"st\">%s</font>",JS(IEI_DEVICE_MSG31));//Ready
				else if(ret==S_NOT_EXIST)
					fprintf(fptr, "<font class=\"st_red\">%s</font>",JS(IEI_DEVICE_MSG30));
				else fprintf(fptr, "<font class=\"st\">%s</font>",JS(QUICK11_STR06));
			}
		}
		else
		{
			Get_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_DISK_INIT, QUICK_SETUP_DEFAULT_STRING, buf, sizeof(buf), QUICK_CONF_FILE);
			if(!strcasecmp(buf,"yes"))
			{
				int progress;
				
				progress=HD_Get_Format_Progress("/dev/sda3");
				if(progress==0)
					fprintf(fptr, "<font class=\"st\">%s</font>", JS(IEI_DEVICE_MSG18));
				else 
					fprintf(fptr, "<font class=\"st\">%s (%d%%)</font>", JS(IEI_DEVICE_MSG26),progress);
			}
			else 
			{
				if(ret==S_READY)
					fprintf(fptr, "<font class=\"st\">%s</font>",JS(IEI_DEVICE_MSG31));//Ready
				else fprintf(fptr, "<font class=\"st\">%s</font>",JS(QUICK11_STR06));
			}
		}	
	}
        else if (!strcmp(name, "net_restart_link"))//Shone added 2005,09,27
	{
		INPUT *tmp;
		if ((tmp=CGI_Find_Parameter(input,"Net_Link"))!=NULL)
		{
			NIC_NAS_INFO    nic_nas_info;
			NIC_Get_Info_From_uLinux(&nic_nas_info, NIC_LAN01);
			if (nic_nas_info.usage==NIC_USE_STATIC)
				strcpy(buf,nic_nas_info.ifconfig.ipaddr);
			else
				Get_Server_Name(buf, BUF_SIZE);
			
			fprintf(fptr, "<tr style=\"position:relative;left=22;\" class=\"12-blue\">");
			fprintf(fptr, "<td width=\"60%%\" colspan=\"1\"><font color=\"#0033FF\">%s</font></td>",JS(QUICK11_STR08_1));
			fprintf(fptr, "<td width=\"20%%\"></td>");
			fprintf(fptr, "<td width=\"20%%\"></td>");
			fprintf(fptr, "</tr>");
			fprintf(fptr, "<tr style=\"position:relative;left=22;\">");
			fprintf(fptr, "<td width=\"60%%\"><b><a href=\"http://%s:6000/cgi-bin/index.cgi\">%s</a></b></td>",buf,JS(QUICK11_STR10));
			fprintf(fptr, "<td width=\"20%%\"></td>");
			fprintf(fptr, "<td width=\"20%%\"></td>");
			fprintf(fptr, "</tr>");
		}
	}
        else if (!strcmp(name, "START_HERE"))//Shone added 2005,10,13
	{
		if(Net_Link_Flag)
		{
			NIC_NAS_INFO    nic_nas_info;
			NIC_Get_Info_From_uLinux(&nic_nas_info, NIC_LAN01);
			if (nic_nas_info.usage==NIC_USE_STATIC)
				strcpy(buf,nic_nas_info.ifconfig.ipaddr);
			else
				Get_Server_Name(buf, BUF_SIZE);
			
			fprintf(fptr, "<font color=\"#0033FF\">%s</font><p></p>",JS(QUICK11_STR08_1));
			//fprintf(fptr, "<a href=\"http://%s:6000/cgi-bin/misc/misc.cgi?func=restart_main&counter=%ld\">%s</a>",buf,time(NULL),JS(QUICK11_STR10));
			fprintf(fptr, "<a href=\"http://%s:6000/cgi-bin/quick/quick.cgi?func=quick11_restart&counter=%ld\">%s</a>",buf,time(NULL),JS(QUICK11_STR10));
		}
		else
			fprintf(fptr, "%s",JS(IEI_NAS_MISC_ASKREBOOT_YES_NO));
	}
	else if(!strcmp(name, "quick_net_restart_mark_start")||!strcmp(name, "quick_net_restart_mark_end"))
	{
		if (Net_Link_Flag)
		{
			if(!strcmp(name, "quick_net_restart_mark_start"))
				fprintf(fptr, "<!--");
			else if(!strcmp(name, "quick_net_restart_mark_end"))
				fprintf(fptr, "-->");
		}
	}
        else if (!strcmp(name, "Refresh"))//Shone added 2005,0917
	{
		char tmp[20]="";
		Get_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_DISK_FLAG, QUICK_SETUP_DEFAULT_STRING, buf, sizeof(buf), QUICK_CONF_FILE);
		if (!strcmp(buf,"1"))//I use a flag to determine the refreshment to prevent refreshing when the formatting is set from Device Management
		{
			Get_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_NETWORK, QUICK_SETUP_DEFAULT_STRING, buf, sizeof(buf), QUICK_CONF_FILE);
			if(strcmp(buf,QUICK_SETUP_DEFAULT_STRING))//Network setting has been modified, using theis way temporarily.
				strcpy(tmp,"&Net_Link="); 
			fprintf(fptr, "setTimeout(\"window.location.replace('/cgi-bin/quick/quick.cgi?func=quick11_main&counter=%ld%s')\", 5000);"
					,time(NULL),tmp);
		}
	}
	else
		return CGI_REPLACE_FAIL;
        return CGI_REPLACE_OK;
}

int show_quick11_header(int quick_select)
{
        HEADER_ITEM     header;
	static char*    quick_defs[]={QUICK_DEFS};

        CGI_Output_Html1(QUICK_HEADER_HTML, "$", quick11_replace, NULL);
        header.back[0]=0x0;
        header.home[0]=0x0;
        header.logout[0]=0x0;
	if(Is_Version_22())
	        CGI_Get_Help(header.help, "help_quick.html#help_qconfig_finish");
	else
		CGI_Get_Help(header.help, "help_qconfig_finish.html");
        CGI_Show_Menu_V3_1(FUNC_QUICK, &header);
        CGI_Output_Html1(MENU_V3_HEADER_HTML, "$", quick11_replace, NULL);
        CGI_Show_Menu_V3_2(quick_defs[get_quick_def()], quick_select);
        CGI_Output_Html1(MENU_V3_MIDDLE_HTML, "$", quick11_replace, NULL);
        return 1;
}

int show_quick11_restart_header(int quick_select)
{
        HEADER_ITEM     header;
	static char*    quick_defs[]={QUICK_DEFS};

        CGI_Output_Html1(QUICK_HEADER_HTML, "$", quick11_replace, NULL);
        header.back[0]=0x0;
        header.home[0]=0x0;
        header.logout[0]=0x0;
	if(Is_Version_22())
	        CGI_Get_Help(header.help, "help_quick.html#help_qconfig_reboot");
	else
		CGI_Get_Help(header.help, "help_qconfig_reboot.html");
        CGI_Show_Menu_V3_1(FUNC_QUICK, &header);
        CGI_Output_Html1(MENU_V3_HEADER_HTML, "$", quick11_replace, NULL);
        CGI_Show_Menu_V3_2(quick_defs[get_quick_def()], quick_select);
        CGI_Output_Html1(MENU_V3_MIDDLE_HTML, "$", quick11_replace, NULL);
        return 1;
}

int show_quick11_tail()
{
        CGI_Output_Html1(MENU_V3_TAIL_HTML, "$", quick11_replace, NULL);
        CGI_Output_Html1(QUICK_TAIL_HTML, "$", quick11_replace, NULL);
        return 1;
}

int do_quick11_main(INPUT *input, int quick_select)
{
	if(read_restart_flag()&&!read_initial_flag())
	{
		INPUT *tmp;
		if ((tmp=CGI_Find_Parameter(input,"Net_Link"))!=NULL)
			Net_Link_Flag = 1;
		do_quick11_restart(input, quick_select);
		//set_restart_flag(0);//The flag will be cleared only when No is pressed, Shone
		return QUICK_SUCCESS;
	}
	show_quick11_header(quick_select);

	/* put your code here */
	//CGI_Output_Html1(QUICK11_MAIN_HTML, "$", quick11_replace, NULL);
	CGI_Output_Html1(QUICK11_MAIN_HTML, "$", quick11_replace, input);//Shone modified 2005,09,27 

	show_quick11_tail();
	return QUICK_SUCCESS;
}

int do_quick11_restart(INPUT *input, int quick_select)
{
        show_quick11_restart_header(quick_select);

        /* put your code here */
        CGI_Output_Html1(QUICK11_RESTART_HTML, "$", quick11_replace, NULL);

        show_quick11_tail();
        return QUICK_SUCCESS;
}

int do_restart_ending(INPUT *input, int quick_select)
{
        HEADER_ITEM     header;

        CGI_Output_Html1(QUICK_RESTART_ING_HEADER_HTML, "$", quick11_replace, NULL);
        header.back[0]=0x0;
        header.home[0]=0x0;
        header.logout[0]=0x0;
	if(Is_Version_22())
	        CGI_Get_Help(header.help, "help_quick.html#help_qconfig_reboot");
	else
		CGI_Get_Help(header.help, "help_qconfig_reboot.html");
	CGI_Show_Menu_V3_1(FUNC_WEBFS_1, &header);


        /* put your code here */
        CGI_Output_Html1(QUICK11_RESTART_ENDING_HTML, "$", quick11_replace, NULL);

        //show_quick11_tail();
        CGI_Output_Html1(MENU_V3_TAIL_HTML, "$", quick11_replace, NULL);
        CGI_Output_Html1(QUICK_TAIL_HTML, "$", quick11_replace, NULL);
        return QUICK_SUCCESS;
}

int do_quick11_main_submit(INPUT *input, int quick_select)
{
	int	btn;
	int	ret=QUICK_SUCCESS;
	char 	buf[BUF_SIZE];

	btn=get_btn(input);
	switch (btn)
	{
		case QUICK_BTN_FINISH:
			/* put your "next button" code here */
			Get_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_DISK_INIT, QUICK_SETUP_DEFAULT_STRING, buf, sizeof(buf), QUICK_CONF_FILE);
			if(!strcasecmp(buf,"yes"))
			{
				int ret2=QUICK_SUCCESS;
				ret=Get_Disk_Status(1);
				ret2=Get_Badblocks_Status(1);
				//if(disk_status!=S_READY && disk_status!=S_NOT_MOUNTED && disk_status!=S_UNINITIALIZE)
				if(ret==S_INITIALIZING || ret==S_FORMATTING || ret==S_SCANNING || ret2 == BADBLOCKS_SCANNING)
					return ERROR_DISK_NOT_INITIALIZABLE;
				else if(ret==S_NOT_EXIST)
					return ERROR_DISK_NOT_EXIST;
				/*else if(ret!=S_READY) //Shone marked to allow formatting in other status 2005,11,04
					return ERROR_DISK_ABNORMAL;*/
			}

			Set_Admin_Configured_Status(TRUE);
			if (read_initial_flag()==0)
			{
				if(read_restart_flag())
				{
					do_quick11_restart(input, quick_select);
				//	set_restart_flag(0);//The flag will be cleared only when No is pressed, Shone
				}
				else
					CGI_Load_Html("/cgi-bin/index.cgi");
			}
			else
			{
				//set_restart_flag(1);//Shone test
				do_initial_job();
				sprintf(buf,"/cgi-bin/quick/quick.cgi?func=quick11_main&counter=%ld",time(NULL));
				CGI_Load_Html(buf);
			}
			break;
		case QUICK_BTN_BACK:
			/* put your "back button" code here */
			do_quick05_main(input, quick_select-1);
			break;
	}
	return ret;
}

int do_quick11_restart_submit(INPUT *input, int quick_select)
{
        int     btn;
        pid_t   mypid;
        pid_t   parent;
        char    dir[128], buf[128];

        btn=get_btn(input);

        switch (btn)
        {
                case QUICK_BTN_YES:
                        parent=getpid();
                        sprintf(dir, "/proc/%d/exe", parent);
                        mypid=fork();
                        if (mypid==0)
                        {       //child
                                close(0);
                                close(1);
                                close(2);
                                while (1)
                                {
                                        if (readlink(dir, buf, 256)==-1)
                                                break;
                                        sleep(1);
                                }
                                Restart_System();
                                exit(1);
                        }
                        else {
                                do_restart_ending(input, quick_select);
                        }
                        break;
                case QUICK_BTN_NO:
			set_restart_flag(0);//Shone added 2005,12,15
                        CGI_Load_Html("/cgi-bin/index.cgi");
                        break;
        }
        return QUICK_SUCCESS;
}

void Make_Disk_Init_Flag(int flag)
{
	char buf[BUF_SIZE];
	Get_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_DISK_INIT, QUICK_SETUP_DEFAULT_STRING, buf, sizeof(buf), QUICK_CONF_FILE);
        if(!strcasecmp(buf,"yes")&&flag)
		Set_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_DISK_FLAG, "1", QUICK_CONF_FILE);
	else
	{
		Set_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_DISK_FLAG, "0", QUICK_CONF_FILE);
		Set_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_DISK_INIT, QUICK_SETUP_DEFAULT_STRING, QUICK_CONF_FILE);//Shone 2005,10,11
	}
}

void do_initial_job()
{
	Make_Disk_Init_Flag(1);//Make a disk initialization flag for quick to let it show correct message
	Quick_Set_Server_Name();
	Quick_Set_Language();//Shone added 2005,11,04
	//Quick_Set_Admin_Passwd();//Shone moved this function to the last step 'cause the refreshment will ask user to enter new password
	Quick_Set_Time_Setting();
	Quick_Set_IP_Setting();
	Quick_Do_Disk_Init();
}

void Quick_Set_Server_Name()
{
	char buf[BUF_SIZE];
	//pid_t child_pid;

	Get_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_SERVER_NAME, QUICK_SETUP_DEFAULT_STRING, buf, sizeof(buf), QUICK_CONF_FILE);
	if(strcmp(buf,QUICK_SETUP_DEFAULT_STRING))
	{
		Set_Server_Name(buf, 0); 	
		Get_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_NETWORK, QUICK_SETUP_DEFAULT_STRING, buf, sizeof(buf), QUICK_CONF_FILE);
		if(!strcmp(buf,QUICK_SETUP_DEFAULT_STRING))//Network setting has not been modified
		{
			sprintf(buf,"%s restart 1>/dev/null 2 >&1",HOSTNAME_SCRIPT_PATH);
			system(buf);
			sprintf(buf,"%s restart 1>/dev/null 2 >&1",SMB_SCRIPT_PATH);//Better not to use fork() here, 'cause initial disk need to stop samba
			system(buf);
		}
	}
}
 
void Quick_Set_Admin_Passwd()
{
	char buf[BUF_SIZE];

	Get_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_ADMIN_PASSWD, QUICK_SETUP_DEFAULT_STRING, buf, sizeof(buf), QUICK_CONF_FILE);
	if(strcmp(buf,QUICK_SETUP_DEFAULT_STRING))
	{
		char user[] = "administrator";
		Get_Exact_NAS_User_Name(user);
		Change_NAS_User_Password(user, buf);	
	}
}

void My_Set_Time(char *time_string)
{//MMDDYYYYhhmmss to MMDDhhmmYYYY.ss
	char exec[256],tmp[20],tmp2[2],*p;
	int i;
	
	tmp2[0]=*(time_string+12);
	tmp2[1]=*(time_string+13);
	strcpy(tmp,time_string);
	p=tmp;
	*(p+12)='.';
	*(p+13)=tmp2[0];
	*(p+14)=tmp2[1];//Tmp to MMDDYYYYhhmm.ss
	*(p+15)=0x0;
	for(i=0;i<4;i++)//Tmp to MMDDhhmmYYYY.ss
	{
		tmp2[0]=*(p+4+i);
		*(p+4+i)=*(p+8+i);
		*(p+8+i)=tmp2[0];
	}
		
	sprintf(exec,"/bin/date -s %s 1>/dev/null 2>&1",tmp);
	system(exec);
}

void Quick_Set_Time_Setting()
{
	char buf[BUF_SIZE];

	Get_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_TIME_ZONE, QUICK_SETUP_DEFAULT_STRING, buf, sizeof(buf), QUICK_CONF_FILE);
	if(strcmp(buf,QUICK_SETUP_DEFAULT_STRING))
	   Set_System_Time_Zone(buf);

	Get_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_TIME, QUICK_SETUP_DEFAULT_STRING, buf, sizeof(buf), QUICK_CONF_FILE);
	if(strcmp(buf,QUICK_SETUP_DEFAULT_STRING))
		My_Set_Time(buf);
	   //Set_Current_Date_Time(buf);

	Get_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_TIME_NTP, QUICK_SETUP_DEFAULT_STRING, buf, sizeof(buf), QUICK_CONF_FILE);
	if(strcmp(buf,QUICK_SETUP_DEFAULT_STRING))
	{
		NTP_Set_Server_IP(buf);
	/*	Get_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_TIME_GAP, QUICK_SETUP_DEFAULT_STRING, buf, sizeof(buf), QUICK_CONF_FILE);
		if(strcmp(buf,QUICK_SETUP_DEFAULT_STRING)||strcmp(buf,""))
		   NTP_Set_Interval(atoi(buf));
		else */
		NTP_Set_Interval(7);//default to 7 days
		
	/*	Get_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_TIME_UNIT, QUICK_SETUP_DEFAULT_STRING, buf, sizeof(buf), QUICK_CONF_FILE);
		if(strcmp(buf,QUICK_SETUP_DEFAULT_STRING)||strcmp(buf,""))
		   NTP_Set_Interval_Unit(buf);
		else */
		NTP_Set_Interval_Unit("DAY");
			
		NTP_Set_Use_Server(TRUE);       // uLinux.conf: Use NTP Server = TRUE
		NTP_Use_Server();
	}
}

void Quick_Set_Language()
{
	int ret;//Used in case it is needed
	char buf[BUF_SIZE];

	Get_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_CODEPAGE, QUICK_SETUP_DEFAULT_STRING, buf, sizeof(buf), QUICK_CONF_FILE);
	if(strcmp(buf,QUICK_SETUP_DEFAULT_STRING))
		ret = Set_System_Codepage(atoi(buf));
}

void Quick_Set_IP_Setting()
{
	char buf[BUF_SIZE];
	NIC_NAS_INFO nic_nas_info;
	
	Get_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_NETWORK, QUICK_SETUP_DEFAULT_STRING, buf, sizeof(buf), QUICK_CONF_FILE);
	if(strcmp(buf,QUICK_SETUP_DEFAULT_STRING))
	{
		NIC_Get_Info_From_uLinux(&nic_nas_info, NIC_LAN01);
		if(!strcmp(buf,"DHCP"))
		  nic_nas_info.usage=NIC_USE_DHCP;
		else 
		{
			nic_nas_info.usage=NIC_USE_STATIC;
			Get_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_STATIC_IP, QUICK_SETUP_DEFAULT_STRING, buf, sizeof(buf), QUICK_CONF_FILE);
			if(strcmp(buf,QUICK_SETUP_DEFAULT_STRING))
			   strcpy(nic_nas_info.ifconfig.ipaddr,buf);
			Get_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_NET_MASK, QUICK_SETUP_DEFAULT_STRING, buf, sizeof(buf), QUICK_CONF_FILE);
			if(strcmp(buf,QUICK_SETUP_DEFAULT_STRING))
			   strcpy(nic_nas_info.ifconfig.netmask,buf);
			Get_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_NET_GATE, QUICK_SETUP_DEFAULT_STRING, buf, sizeof(buf), QUICK_CONF_FILE);
			if(strcmp(buf,QUICK_SETUP_DEFAULT_STRING))
			   strcpy(nic_nas_info.ifconfig.gateway,buf);
		}
		NIC_Set_Info_To_uLinux(&nic_nas_info);
	}	
	Get_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_NET_DNS1, QUICK_SETUP_DEFAULT_STRING, buf, sizeof(buf), QUICK_CONF_FILE);
	if(strcmp(buf,QUICK_SETUP_DEFAULT_STRING))
	{	
		FILE *fp;
		if((fp=fopen("/etc/resolv.conf","w"))==NULL)
			return;
		Set_Profile_String (NETWORK_SECTION, FIELD_DNS1, buf);
		if(strcmp(buf,"0.0.0.0"))
		{
			strcat(buf,"\n");
			fputs(buf,fp);
		}
		Get_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_NET_DNS2, QUICK_SETUP_DEFAULT_STRING, buf, sizeof(buf), QUICK_CONF_FILE);
		Set_Profile_String (NETWORK_SECTION, FIELD_DNS2, buf);
		if(strcmp(buf,"0.0.0.0"))
		{
			strcat(buf,"\n");
			fputs(buf,fp);
		}
		fputs("search qnap.org\n",fp);
		
		fclose(fp);		
	}
}

void Quick_Do_Disk_Init()
{
	char msg_log[256];
	char dev_name[32];
	char buf[BUF_SIZE];
	char tmp[20]="";
	pid_t child_pid;


	Get_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_DISK_INIT, QUICK_SETUP_DEFAULT_STRING, buf, sizeof(buf), QUICK_CONF_FILE);
	if(!strcasecmp(buf,"yes"))
	{
		int net_flag=0,ret=0;
		Set_Profile_Integer("QRAID1", "SATA Format", 1);//Shone moved here from NasLib
		strcpy(msg_log,"[SATA Disk] Start initialization.");
		my_report_log(msg_log);

		child_pid = fork();
		if(child_pid == 0)
		{ // child process
			int restart_flag=0;
			FILE *fp;
			close(0);
			close(1);
			close(2);

			if(Is_QRAID1_running()&&Get_QRAID1_Disk_Status()!=S_QRAID1_UNMATCH)
			{
				Get_Profile_String("QRAID1", "device name", "", dev_name, sizeof(dev_name));
				Stop_QRAID1();
			}

			killusers_delshare_on_volume(1,1);
			fp=popen("/bin/df | grep /dev/sda4","r");
			if(fp!=NULL)
			{
				fgets(buf,sizeof(buf),fp);
				Trim(buf);
				pclose(fp);
			}
			if(strstr(buf,"sda4")==NULL)//Shone modified to match the new system setting 2005,12,05
				restart_flag=1;
			ret=Init_NAS_Single_Disk(1);
			Get_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_NETWORK, QUICK_SETUP_DEFAULT_STRING, buf, sizeof(buf), QUICK_CONF_FILE);
			if(strcmp(buf,QUICK_SETUP_DEFAULT_STRING))//Network setting has been modified
				net_flag=1;

			Make_Disk_Init_Flag(0);
			set_initial_flag(0);	
			if(ret==SUCCESS)
			{
				if(restart_flag==1)//Shone modified to match the new system setting 2005,12,05
					set_restart_flag(1);
				//Add_Default_Shares();//This action is moved to Init_NAS_Single_Disk function 2005,12,15 Shone
				strcpy(msg_log,"[SATA Disk] Initialization completed.");
				write_log(msg_log,4);
			}
			else 
			{
				strcpy(msg_log,"[SATA Disk] Initialization failed.");
				write_log(msg_log,1);
			}
			sleep(6);//Wait for the Refreshment
			Quick_Set_Admin_Passwd();
			if(net_flag)
			{
				Quick_Restart_Network();
				sprintf(buf,"%s restart 1>/dev/null 2 >&1 &",HOSTNAME_SCRIPT_PATH);
				system(buf);
				sprintf(buf,"%s restart 1>/dev/null 2 >&1 &",SMB_SCRIPT_PATH);
				system(buf);
			}
			Conf_Remove_Section(QUICK_CONF_FILE,QUICK_SETUP_SECTION);
		}
	}
	else
	{
		int net_flag=0;
		NIC_NAS_INFO    nic_nas_info;
		NIC_Get_Info_From_uLinux(&nic_nas_info, NIC_LAN01);

		Get_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_NETWORK, QUICK_SETUP_DEFAULT_STRING, buf, sizeof(buf), QUICK_CONF_FILE);
		if(strcmp(buf,QUICK_SETUP_DEFAULT_STRING))//Network setting has been modified
			net_flag=1;
		Make_Disk_Init_Flag(0);
		set_initial_flag(0);
	
		if (net_flag) 
			strcpy(tmp,"&Net_Link="); 
		sprintf(buf,"/cgi-bin/quick/quick.cgi?func=quick11_main&counter=%ld%s",time(NULL),tmp);//Shone added 2005,09,26
		CGI_Load_Html(buf);
		child_pid = fork();
		if(child_pid == 0)
		{
			close(0);
			close(1);
			close(2);

			sleep(3);
			if(net_flag)
			{
				Quick_Restart_Network();
				sprintf(buf,"%s restart 1>/dev/null 2 >&1 &",HOSTNAME_SCRIPT_PATH);
				system(buf);
				sprintf(buf,"%s restart 1>/dev/null 2 >&1 &",SMB_SCRIPT_PATH);
				system(buf);
			}
			sleep(5);
			Quick_Set_Admin_Passwd();
			Conf_Remove_Section(QUICK_CONF_FILE,QUICK_SETUP_SECTION);
		}
		if (nic_nas_info.usage==NIC_USE_DHCP && net_flag)
			sleep(5);//Wait for samba restart,needed by DHCP mode
		else if (net_flag)
			sleep(1);//Wait for network restarting
	}
}

void Quick_Restart_Network()
{
	char buf[BUF_SIZE];
	
	sprintf(buf,"%s restart 1>/dev/null 2 >&1",NET_SCRIPT_PATH);
	system(buf);
}

void Add_Default_Shares()
{
        Create_Default_Share("Qmultimedia",SHARE_ADMINISTRATOR);//Shone modified 2005,12,05
	Create_Default_Share("Qdownload",SHARE_ADMINISTRATOR);
	Create_Default_Share("Qweb",SHARE_ADMINISTRATOR);
	Create_Default_Share("Qusb", SHARE_EVERYONE);
	Create_Default_Share("Public",SHARE_EVERYONE_GUEST);
}

void time_transform(char *dest,char *src)
{
	//mon day year hour minute sec --> year / mon /day AM/PM hour : min : sec
	char tmp[5],*p;
	int i;
	p=tmp;
	for(i=0;i<4;i++)
		tmp[i]=src[i+4];	
	*(p+i)=0x0;
	strcpy(dest,tmp);
	for(i=0;i<2;i++)
		tmp[i]=src[i];	
	*(p+i)=0x0;
	sprintf(dest,"%s / %s",dest,tmp);

	for(i=0;i<2;i++)
		tmp[i]=src[i+2];	
	*(p+i)=0x0;
	sprintf(dest,"%s / %s",dest,tmp);

	for(i=0;i<2;i++)
		tmp[i]=src[i+8];	
	*(p+i)=0x0;
	if(atoi(tmp)<12)
	{
		if(atoi(tmp)==0)
			sprintf(dest,"%s AM 12",dest);
		else
			sprintf(dest,"%s AM %s",dest,tmp);
	}
	else 
	{
		if(atoi(tmp)==12)
			sprintf(dest,"%s PM %02d",dest,atoi(tmp));
		else
			sprintf(dest,"%s PM %02d",dest,atoi(tmp)-12);
	}
	
	for(i=0;i<2;i++)
		tmp[i]=src[i+10];	
	*(p+i)=0x0;
	sprintf(dest,"%s : %s",dest,tmp);
			
	for(i=0;i<2;i++)
		tmp[i]=src[i+12];	
	*(p+i)=0x0;
	sprintf(dest,"%s : %s",dest,tmp);
}
