#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* NAS include file */
#include <cgi.h>
#include <v2_menu.h>
#include <sys/shm.h>
#include <stdarg.h>
/* local include */
#include "quick.h"
#include "quick04.h"
#include "quick05.h"
#include "quick11.h"
#include "nas_quota.h"

/*---- SHARE MEMORY DEFINE------*/
#define SHM_STORAGE_KEY 6262
#define SHM_SIZE	8
#define SHM_PROCESS_STATUS_OFFSET	0
#define SHM_CHILD_PID_OFFSET		4

#define JS(ID) "<SCRIPT Language=\"JavaScript\">document.write(" #ID ")</SCRIPT>"

typedef struct QUICK_VOLUME_NO_DATA {
	int vol_type;
	int vol_num;
	int a_vol_num;
}QUICK_VOLUME_NO_DATA;

int quick05_replace(FILE *fptr, char *name, void *arg)
{
	if (!strcmp(name, "Model_Name")) 
	{
		char buf[BUF_SIZE];
		Get_TS_SATA_Model(buf,sizeof(buf));
                if(!strcmp(buf,"") || Get_Disk_Status(1)==S_NOT_EXIST)
                        fprintf(fptr, "--");
                else fprintf(fptr, "%s", buf);
	}
	else if (!strcmp(name, "Total_Size")) 
	{
		char total_size[64]="";
		DISK_INFO disk_info;

		disk_info.capacity=0;//Shone added to prevent incorrect capacity value
		Get_NAS_Disks_Info(&disk_info,1);
		sprintf(total_size,"%.0f MB",disk_info.capacity/1024);
		if(disk_info.capacity>0 && Get_Disk_Status(1)!=S_NOT_EXIST)
			fprintf(fptr,"%s",total_size);
		else
			fprintf(fptr, "--");
	}
	else if (!strcmp(name, "yes_check") || !strcmp(name, "no_check")) 
	{
		int ret=Get_Disk_Status(1);
		
		if(!strcmp(name, "yes_check"))
		{
			if(ret==S_NOT_EXIST||ret==S_INITIALIZING||ret==S_FORMATTING||ret==S_SCANNING)
 	                       fprintf(fptr, "disabled");
			else if(ret==S_NOT_MOUNTED||ret==S_UNINITIALIZE||ret==S_NOT_MOUNTED)
 	                       fprintf(fptr, "checked");
		}
		else if(!strcmp(name, "no_check"))
		{
			if(ret==S_NOT_EXIST)
 	                       fprintf(fptr, "checked");
			else if(ret==S_READY)
 	                       fprintf(fptr, "checked");
			else if(ret!=S_UNINITIALIZE&&ret!=S_NOT_MOUNTED&&ret!=S_NOT_MOUNTED)
 	                       fprintf(fptr, "checked");
		}	
	}
	else
		return CGI_REPLACE_FAIL;
	return CGI_REPLACE_OK;
}

int show_quick05_header(int quick_select)
{
        HEADER_ITEM     header;
	static char*    quick_defs[]={QUICK_DEFS};

        CGI_Output_Html1(QUICK_HEADER_HTML, "$", quick05_replace, NULL);
        header.back[0]=0x0;
        header.home[0]=0x0;
        header.logout[0]=0x0;
        if(Is_Version_22())
	        CGI_Get_Help(header.help, "help_quick.html#help_qconfig_step7");
	else
		CGI_Get_Help(header.help, "help_qconfig_step7.html");
        CGI_Show_Menu_V3_1(FUNC_QUICK, &header);
        CGI_Output_Html1(MENU_V3_HEADER_HTML, "$", quick05_replace, NULL);
        CGI_Show_Menu_V3_2(quick_defs[get_quick_def()], quick_select);
        CGI_Output_Html1(MENU_V3_MIDDLE_HTML, "$", quick05_replace, NULL);
        return 1;
}

int show_quick05_tail()
{
        CGI_Output_Html1(MENU_V3_TAIL_HTML, "$", quick05_replace, NULL);
        CGI_Output_Html1(QUICK_TAIL_HTML, "$", quick05_replace, NULL);
        return 1;
}

int do_quick05_main(INPUT *input, int quick_select)
{
	int ret;
	//LVM_VOLUME_INFO *vol_info = NULL;
	show_quick05_header(quick_select);
	
	CGI_Output_Html1(QUICK05_MAIN_HTML, "$", quick05_replace, NULL);
	ret=Get_Disk_Status(1);
	//if (ret==S_INITIALIZING || ret==S_FORMATTING || ret==S_SCANNING)
	if (ret==S_NOT_EXIST)
	{

	}
	show_quick05_tail();
	return QUICK_SUCCESS;
}

int do_quick05_main_submit(INPUT *input, int quick_select)
{
	int	btn;
	int	ret=QUICK_SUCCESS;
	INPUT	*tmp;

	btn=get_btn(input);
	switch (btn)
	{
		case QUICK_BTN_NEXT:
			/* put your "next button" code here */
			if((tmp=CGI_Find_Parameter(input,"yes_no_btn"))!=NULL)
			{
				if(atoi(tmp->val)==1)
				{
					/*int disk_status;
					disk_status=Get_Disk_Status(1);
					if(disk_status!=S_READY && disk_status!=S_NOT_MOUNTED && disk_status!=S_UNINITIALIZE)
						return ERROR_DISK_NOT_INITIALIZABLE;*/
					Set_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_DISK_INIT, "yes", QUICK_CONF_FILE);//Shone 2005,09,29
					set_initial_flag(1);
				}	
				else
					clear_tmp_field(QUICK_SETUP_SECTION,FIELD_QS_DISK_INIT);
				
			}	
			do_quick11_main(input, quick_select+1);
			break;
		case QUICK_BTN_BACK:
			/* put your "back button" code here */
			do_quick04_main(input, quick_select-1);
			break;
	}
	return ret;
}

