#include <stdio.h>

/* NAS include file */
#include <cgi.h>
#include <v2_menu.h>
#include <cfg_nic.h>

/* local file */
#include "quick.h"
#include "quick00.h"
#include "quick01.h"
#include "quick02.h"
#include "quick03.h"
#include "quick03_1.h"
#include "quick04.h"
//#include "quick05.h"
//#include "quick06.h"
#include "quick05.h"
//#include "quick08.h"
//#include "quick09.h"
//  Tiger
//#include "quick09_1.h"

//#include "quick10.h"
#include "quick11.h"

#define	QUICK_FLAG_FILE		"/tmp/quick.flag"
#define	QUICK_INIT_FLAG_FILE		"/tmp/quick_init.flag"

void set_restart_flag(int bEnable)
{
	FILE	*fptr;

	fptr=fopen(QUICK_FLAG_FILE, "w");
	fwrite(&bEnable, 1, sizeof(int), fptr);
	fclose(fptr);
}

void set_initial_flag(int bEnable)
{
	FILE	*fptr;

	fptr=fopen(QUICK_INIT_FLAG_FILE, "w");
	fwrite(&bEnable, 1, sizeof(int), fptr);
	fclose(fptr);
}

void clear_tmp_field(char *section,char *field)
{
	char tmp[128];
	Get_Private_Profile_String(section,field,"@",tmp,128,QUICK_CONF_FILE);//Shone modified 2005,09,29
	if(strcmp(tmp,"@"))
		Conf_Remove_Field( QUICK_CONF_FILE, section, field);
}

int read_restart_flag()
{
	FILE	*fptr;
	int	ret;

	if ((fptr=fopen(QUICK_FLAG_FILE, "r"))==NULL)
		return 0;
	fread(&ret, 1, sizeof(int), fptr);
	fclose(fptr);
	return ret;
}

int read_initial_flag()
{
	FILE	*fptr;
	int	ret;

	if ((fptr=fopen(QUICK_INIT_FLAG_FILE, "r"))==NULL)
		return 0;
	fread(&ret, 1, sizeof(int), fptr);
	fclose(fptr);
	return ret;
}

int get_btn(INPUT *input)
{
	INPUT	*tmp;
	int	ret=QUICK_BTN_UNKNOWN;

	if ((tmp=CGI_Find_Parameter(input, "TEST_BTN"))!=NULL)
                return QUICK_BTN_TEST;

	tmp = CGI_Find_Parameter(input, "subfunc");
	if (tmp) {
		if (!strcmp (tmp->val, "next"))
			ret=QUICK_BTN_NEXT;
		else if (!strcmp (tmp->val, "back"))
			ret=QUICK_BTN_BACK;
		else if (!strcmp (tmp->val, "continue"))
			ret=QUICK_BTN_CONTINUE;
		else if (!strcmp (tmp->val, "finish"))
			ret=QUICK_BTN_FINISH;
		else if (!strcmp (tmp->val, "add"))
			ret=QUICK_BTN_ADD;
		else if (!strcmp (tmp->val, "remove"))
			ret=QUICK_BTN_REMOVE;
		else if (!strcmp (tmp->val, "yes"))
			ret=QUICK_BTN_YES;
		else if (!strcmp (tmp->val, "no"))
			ret=QUICK_BTN_NO;
		else if (!strcmp (tmp->val, "refresh"))
			ret=QUICK_BTN_REFRESH;
	} else
		ret=QUICK_BTN_NEXT;

	 return	ret;
}

int get_quick_def()
{
	int num;

	num=NIC_Count_Interface();
	if (num==2)
		return 1;
	else
	if (num==1)
		return 0;
	return 0;
}

int get_func(INPUT *input, int *quick_select)
{
	INPUT	*tmp;
	int	ret=QUICK_NONE;

	tmp=CGI_Find_Parameter(input, "func");
	if (tmp==NULL)
		ret=QUICK_NONE;
	else
	{
		if (!strcmp(tmp->val, "main"))
		{
			ret=QUICK00_MAIN;
			*quick_select=SELECT_QUICK00;
		}
		else
		if (!strcmp(tmp->val, "quick00_main"))
		{
			ret=QUICK00_MAIN;
			*quick_select=SELECT_QUICK00;
		}
		else
		if (!strcmp(tmp->val, "quick00_main_submit"))
		{
			ret=QUICK00_MAIN_SUBMIT;
			*quick_select=SELECT_QUICK00;
		}
		else
		if (!strcmp(tmp->val, "quick01_main"))
		{
			ret=QUICK01_MAIN;
			*quick_select=SELECT_QUICK01;
		}
		else
		if (!strcmp(tmp->val, "quick01_main_submit"))
		{
			ret=QUICK01_MAIN_SUBMIT;
			*quick_select=SELECT_QUICK01;
		}
		else
		if (!strcmp(tmp->val, "quick02_main"))
		{
			ret=QUICK02_MAIN;
			*quick_select=SELECT_QUICK02;
		}
		else
		if (!strcmp(tmp->val, "quick02_main_submit"))
		{
			ret=QUICK02_MAIN_SUBMIT;
			*quick_select=SELECT_QUICK02;
		}
		else
		if (!strcmp(tmp->val, "quick03_main"))
		{
			ret=QUICK03_MAIN;
			*quick_select=SELECT_QUICK03;
		}
		else
		if (!strcmp(tmp->val, "quick03_main_submit"))
		{
			ret=QUICK03_MAIN_SUBMIT;
			*quick_select=SELECT_QUICK03;
		}
		else
		if (!strcmp(tmp->val, "quick03_1_main"))
		{
			ret=QUICK03_1_MAIN;
			*quick_select=SELECT_QUICK03_1;
		}
		else
		if (!strcmp(tmp->val, "quick03_1_main_submit"))
		{
			ret=QUICK03_1_MAIN_SUBMIT;
			*quick_select=SELECT_QUICK03_1;
		}
		else
		if (!strcmp(tmp->val, "quick04_main"))
		{
			ret=QUICK04_MAIN;
			*quick_select=SELECT_QUICK04;
		}
		else
		if (!strcmp(tmp->val, "quick04_main_submit"))
		{
			ret=QUICK04_MAIN_SUBMIT;
			*quick_select=SELECT_QUICK04;
		}
		else
		if (!strcmp(tmp->val, "quick05_main"))
		{
			ret=QUICK05_MAIN;
			*quick_select=SELECT_QUICK05;
		}
		else
		if (!strcmp(tmp->val, "quick05_main_submit"))
		{
			ret=QUICK05_MAIN_SUBMIT;
			*quick_select=SELECT_QUICK05;
		}
		else
		if (!strcmp(tmp->val, "quick11_main"))
		{
			ret=QUICK11_MAIN;
			*quick_select=SELECT_QUICK11;
		}
		else
		if (!strcmp(tmp->val, "quick11_main_submit"))
		{
			ret=QUICK11_MAIN_SUBMIT;
			*quick_select=SELECT_QUICK11;
		}
		else
		if (!strcmp(tmp->val, "quick11_restart"))
		{
			ret=QUICK11_RESTART;
			*quick_select=SELECT_QUICK11;
		}
		else
		if (!strcmp(tmp->val, "quick11_restart_submit"))
		{
			ret=QUICK11_RESTART_SUBMIT;
			*quick_select=SELECT_QUICK11;
		}
	}
	return ret;
}

int quick_replace(FILE *fptr, char *name, void *arg)
{
	if (!strcmp(name, "test"))
	{
	}
	else
		return CGI_REPLACE_FAIL;
	return CGI_REPLACE_OK;
}

void do_quick_error(int	code, int quick_select)
{
	HEADER_ITEM	header;
	ERRMSG errormsg;  //  add by Tiger
	if (code==QUICK_SUCCESS)
		return;

	/* header */
	CGI_Output_Html1(QUICK_HEADER_HTML, "$", quick_replace,	NULL);
	header.back[0]=0x0;
	header.home[0]=0x0;
	header.logout[0]=0x0;
	if(Is_Version_22())
		CGI_Get_Help(header.help, "help_warning.html");
	else
		CGI_Get_Help(header.help, "help_warning.html");
	CGI_Show_Menu_V3_1(FUNC_QUICK, &header);
	CGI_Output_Html1(MENU_V3_HEADER_HTML, "$",	quick_replace, NULL);
	CGI_Show_Menu_V3_2(QUICK2_DEF, quick_select);
	CGI_Output_Html1(MENU_V3_MIDDLE_HTML, "$",	quick_replace, NULL);

//  Tiger
	errormsg.type =	CGI_ERROR;
	if(code >= -100)
	{
		sprintf (errormsg.title, "QUICK_DEF_NAME%02d", ((code*(-1)) / 10));
		sprintf (errormsg.msg, "QUICK_ERROR_MSG%d", code*(-1));
	}
	else
	{
		switch(code)
		{
			case ERROR_DISK_NOT_INITIALIZABLE:
				strcpy(errormsg.title, "QUICK11_TITLE");
				//strcpy(errormsg.msg, "\"The disk is busy, please wait until it is done.\"");//Shone Trans
				strcpy(errormsg.msg, "IEI_DEVICE_MSG16");
				break;
			case ERROR_DISK_NOT_EXIST:
				strcpy(errormsg.title, "QUICK11_TITLE");
				strcpy(errormsg.msg, "IEI_DEVICE_MSG17");
				break;
			case ERROR_DISK_ABNORMAL:
				strcpy(errormsg.title, "QUICK11_TITLE");
				strcpy(errormsg.msg, "\"The disk is abnormal, please check the status.\"");
				break;
		}		
	}
	strcpy (errormsg.note, "");

	//CGI_Show_Error_V2(errormsg.msg);
	CGI_Show_Error_V3 (&errormsg);
//  here

#ifdef _DEBUG
	printf("error code = [%d]<br>\n", code);
#endif

	/* tail	*/
	CGI_Output_Html1(MENU_V3_TAIL_HTML, "$", quick_replace, NULL);
	CGI_Output_Html1(QUICK_TAIL_HTML, "$", quick_replace, NULL);
}

int main()
{
	INPUT	*input = NULL;
	int	func, ret=0;
	int	quick_select=0;

	CGI_Init();
	CGI_Check_User();
	input=CGI_Get_Input();
	func=get_func(input, &quick_select);

	switch (func)
	{
		case QUICK_NONE:
			break;
		case QUICK00_MAIN:
			ret=do_quick00_main(input, quick_select);
			break;
		case QUICK00_MAIN_SUBMIT:
			ret=do_quick00_main_submit(input, quick_select);
			break;
		case QUICK01_MAIN:
			ret=do_quick01_main(input, quick_select);
			break;
		case QUICK01_MAIN_SUBMIT:
			ret=do_quick01_main_submit(input, quick_select);
			break;
		case QUICK02_MAIN:
			ret=do_quick02_main(input, quick_select);
			break;
		case QUICK02_MAIN_SUBMIT:
			ret=do_quick02_main_submit(input, quick_select);
			break;
		case QUICK03_MAIN:
			ret=do_quick03_main(input, quick_select);
			break;
		case QUICK03_MAIN_SUBMIT:
			ret=do_quick03_main_submit(input, quick_select);
			break;
		case QUICK03_1_MAIN:
			ret=do_quick03_1_main(input, quick_select);
			break;
		case QUICK03_1_MAIN_SUBMIT:
			ret=do_quick03_1_main_submit(input, quick_select);
			break;
		case QUICK04_MAIN:
			ret=do_quick04_main(input, quick_select);
			break;
		case QUICK04_MAIN_SUBMIT:
			ret=do_quick04_main_submit(input, quick_select);
			break;
		case QUICK05_MAIN:
			ret=do_quick05_main(input, quick_select);
			break;
		case QUICK05_MAIN_SUBMIT:
			ret=do_quick05_main_submit(input, quick_select);
			break;
		case QUICK11_MAIN:
			ret=do_quick11_main(input, quick_select);
			break;
		case QUICK11_MAIN_SUBMIT:
			ret=do_quick11_main_submit(input, quick_select);
			break;
		case QUICK11_RESTART:
			ret=do_quick11_restart(input, quick_select);
			break;
		case QUICK11_RESTART_SUBMIT:
			ret=do_quick11_restart_submit(input, quick_select);
			break;
	}
	do_quick_error(ret, quick_select);
	CGI_Free_Input(input);
	return QUICK_SUCCESS;
}

