//**************************************************************************
//
//	Copyright (c) 2002  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		wlan_main.c
//
//	Abstract:
//		WLAN main cgi
//
//	FUNCTIONS:
//
//	COMMENTS:
//
//	HISTORY:
//		V1.0 2002/02/19		Tiger Fu created
//
//**************************************************************************
#include 	<stdio.h>
#include 	<string.h>
#include 	<stdlib.h>

/* NAS lib */
#include	<Util.h>
#include	<cgi.h>
#include	<cfg_nic.h>
#include 	<v2_menu.h>

#include	"wlan_main.h"

#define		ERROR_PAGE				"/home/httpd/cgi-bin/dns/html/errormsg.html"

#define		LAST_PAGE				"/cgi-bin/network/wlan_setting/wlan_setting.cgi?func=main&counter=%d"

#define		TITLE_PAGE				"/home/httpd/cgi-bin/network/wlan_setting/html/wlan_main_title.html"
#define		MAIN_PAGE				"/home/httpd/cgi-bin/network/wlan_setting/html/wlan_main.html"
#define		TAIL_PAGE				"/home/httpd/cgi-bin/network/wlan_setting/html/wlan_main_tail.html"

#define		RESTART_PAGE				"/home/httpd/cgi-bin/network/wlan_setting/html/restart_main.html"
#define		RESTART_TITLE_PAGE			"/home/httpd/cgi-bin/network/wlan_setting/html/restart_main_title.html"
#define		RESTARTING_PAGE				"/home/httpd/cgi-bin/network/wlan_setting/html/restarting_main.html"
#define		RESTARTING_TITLE_PAGE			"/home/httpd/cgi-bin/network/wlan_setting/html/restarting_main_title.html"

char *szDefineFilePath[] = {"/home/httpd/cgi-bin/network/network-1.def",
			    "/home/httpd/cgi-bin/network/network-1.nodns.def",
			    "/home/httpd/cgi-bin/network/network-1.noprn.def",
			    "/home/httpd/cgi-bin/network/network-1.noprndns.def",
			    "/home/httpd/cgi-bin/network/network-2.def",
			    "/home/httpd/cgi-bin/network/network-2.nodns.def",
			    "/home/httpd/cgi-bin/network/network-2.noprn.def",
			    "/home/httpd/cgi-bin/network/network-2.noprndns.def"};

int main ()
{
	INPUT	*arg=NULL, *form=NULL;
	int	func, ret;
	char	buf[256];

	sprintf (buf, LAST_PAGE, time (NULL));

	CGI_Init();
	CGI_Check_User ();

	arg=(INPUT *)CGI_Get_Input_URL();
	form=(INPUT *)CGI_Get_Input_FORM();
#ifdef _DEBUG
	CGI_Debug_Input(arg);
	CGI_Debug_Input(form);
#endif
	func = get_wlan_func(arg);

#ifdef _DEBUG
	printf ("func = %d<br>\n", func);
#endif
	switch (func)
	{
		case WLANMAIN:
			show_wlan_main ();
			break;

		case WLANOK:
			if ((ret = wlan_submit (form)) > 0 || ret == WLAN_NOT_ACTION)
				show_wlan_main ();
			else
			{
				if (ret == WLAN_SYSTEM_RESTART)
					show_wlan_reboot ();
				else
					show_wlan_error (ret);
			}
			break;

		case WLAN_QUERY_REBOOT:
			if (wlan_restart_confirm (arg))
			{
				show_wlan_restarting ();
#ifndef	_DEBUG
				wlan_begin_restart ();
#endif
			}
			else
				CGI_Load_Html (buf);
			break;

		case WLANNOFUNC:
			break;
	}

	CGI_Free_Input(arg);
	CGI_Free_Input(form);

	return WLANSUCCESS;
}

int get_wlan_func (INPUT *arg)
{
	int	ret = WLANNOFUNC;
	INPUT	*parg;
	parg=arg;
	while (parg!=NULL)
	{
		if (!strcmp (parg->name, "func"))
		{
			if (!strcmp (parg->val, "main"))
				ret = WLANMAIN;
			else if (!strcmp (parg->val, "ok"))
				ret = WLANOK;
			else if (!strcmp (parg->val, "query-restart"))
				ret = WLAN_QUERY_REBOOT;
			break;
		}
		parg=(INPUT *)parg->next;
	}
	return ret;
}

int wlan_replace(FILE * fp, char * oldstr)
{
	char buf[80];
	WLAN wlan_info;

	bzero (&wlan_info, sizeof (wlan_info));

	if (fp == NULL)
		return -1;

	if (!strcmp (oldstr, "is_checked"))
	{
		if (Is_WLAN_Enabled ())
			fprintf (fp, "checked");
	}
	else if (!strcmp (oldstr, "Wireless"))
	{
		if (Get_WLAN_Data (&wlan_info))
			fprintf (fp, "%s", wlan_info.szSSID);
	}
	else if (strstr (oldstr, "is_ch_selected"))
	{
		if (Get_WLAN_Data (&wlan_info))
		{
			if (wlan_info.nChannelID < 1 || wlan_info.nChannelID > 14)
			{
				if (atoi (oldstr) == 1)
					fprintf (fp, "selected");
			}
			else
			{
				if (wlan_info.nChannelID == atoi (oldstr))
					fprintf (fp, "selected");
			}
		}
	}
	/*else if (!strcmp (oldstr, "rts_threshold"))
	{
		if (Get_WLAN_Data (&wlan_info))
			fprintf (fp, "%d", wlan_info.nRTSThreshold);
	}
	else if (!strcmp (oldstr, "fragment_threshold"))
	{
		if (Get_WLAN_Data (&wlan_info))
			fprintf (fp, "%d", wlan_info.nFragmentThreshold);
	}*/
	else if (strstr (oldstr, "is_encryp_selected"))
	{
		if (Get_WLAN_Data (&wlan_info))
		{
			if (wlan_info.nWEPEncyption < 0 || wlan_info.nWEPEncyption > 2)
			{
				if (atoi (oldstr) == 0)
					fprintf (fp, "selected");
			}
			else
			{
				if (wlan_info.nWEPEncyption == atoi (oldstr))
					fprintf (fp, "selected");
			}
		}
	}
	else if (strstr (oldstr, "key_setting"))
	{
		if (Get_WLAN_Data (&wlan_info))
		{
			fprintf (fp, "%s", wlan_info.szKeyValue[atoi (oldstr)]);
		}
	}
	else if (strstr (oldstr, "is_key_selected"))
	{
		if (Get_WLAN_Data (&wlan_info))
		{
			if (wlan_info.nWEPDefaultKeyID < 0 || wlan_info.nWEPDefaultKeyID > 3)
			{
				if (atoi (oldstr) == 0)
					fprintf (fp, "checked");
			}
			else
			{
				if (wlan_info.nWEPDefaultKeyID == atoi (oldstr))
					fprintf (fp, "checked");
			}
		}
	}
	else
		return CGI_REPLACE_FAIL;
	return CGI_REPLACE_OK;
}


int wlan_submit (INPUT * form)
{
	INPUT * pform = NULL;
	int ret = 0, do_compare = 0, i;
	WLAN wlan_info, current_wlan_info;

	bzero (&wlan_info, sizeof (wlan_info));
	bzero (&current_wlan_info, sizeof (current_wlan_info));

	if (Get_WLAN_Data (&current_wlan_info))
		do_compare = 1;

	pform = form;
	while (pform!=NULL)
	{
		if (!strcmp (pform->name, "Wlan_oprate"))
		{
			wlan_info.nEnabled = 1;
		}
		else if (!strcmp (pform->name, "Wlan_ESSID"))
		{
			strcpy (wlan_info.szSSID, pform->val);
		}
		else if (!strcmp (pform->name, "Channel_ID"))
		{
			wlan_info.nChannelID = atoi (pform->val);
		}
		/*else if (!strcmp (pform->name, "RTS"))
		{
			wlan_info.nRTSThreshold = atoi (pform->val);
		}
		else if (!strcmp (pform->name, "Fragment"))
		{
			wlan_info.nFragmentThreshold = atoi (pform->val);
		}*/
		else if (!strcmp (pform->name, "WEP_Encryption"))
		{
			wlan_info.nWEPEncyption = atoi (pform->val);
		}
		else if (!strcmp (pform->name, "Key_select"))
		{
			wlan_info.nWEPDefaultKeyID = atoi (pform->val);
		}
		else if (!strcmp (pform->name, "KEY_1"))
		{
			strcpy (wlan_info.szKeyValue[0], pform->val);
		}
		else if (!strcmp (pform->name, "KEY_2"))
		{
			strcpy (wlan_info.szKeyValue[1], pform->val);
		}
		else if (!strcmp (pform->name, "KEY_3"))
		{
			strcpy (wlan_info.szKeyValue[2], pform->val);
		}
		else if (!strcmp (pform->name, "KEY_4"))
		{
			strcpy (wlan_info.szKeyValue[3], pform->val);
		}
		pform=(INPUT *)pform->next;
	}

	if (do_compare) //  if get original data successful
	{
		//  only update selected key value
		/*for (i = 0; i < NUMBER_OF_KEY; i++)
		{
			if (i != wlan_info.nWEPDefaultKeyID || wlan_info.nWEPEncyption == WLAN_WEP_DISABLE)
				strcpy (wlan_info.szKeyValue[i], current_wlan_info.szKeyValue[i]);
		}*/

		if (wlan_info.nWEPEncyption == WLAN_WEP_DISABLE)
			wlan_info.nWEPDefaultKeyID = current_wlan_info.nWEPDefaultKeyID;

		if ((ret = check_input (&wlan_info)) == 0) // check input, maybe error or wlan was diabled
		{
			//  check the value whether modified
			if (is_data_change (&wlan_info, &current_wlan_info))
			{
				Set_WLAN_Data (&wlan_info);
				ret = WLAN_SYSTEM_RESTART;
			}
			else
				ret = 1; //  data no change
		}
		else if (ret == WLAN_NOT_ACTION)
		{
			//  if disabled then restore all data but without enble field
			if (current_wlan_info.nEnabled != WLAN_DISABLED)
			{
				restore_data (&wlan_info, &current_wlan_info);
				Set_WLAN_Data (&wlan_info);
				ret = WLAN_SYSTEM_RESTART;
			}
		}
	}
	return ret;

}

int wlan_restart_confirm (INPUT * form)
{
	INPUT		*pform;

	pform=form;
	while (pform!=NULL)
	{
		if (!strcmp (pform->name, "OK"))
			return 1;  //  restart
		else if (!strcmp (pform->name, "CANCEL"))
			return 0;  //  do not restart
		pform=(INPUT *)pform->next;
	}
	return 0;  //  do not restart
}

int wlan_begin_restart (void)
{
	pid_t	mypid;
	pid_t	parent;
	char	dir[128], buf[128];
	int result = 1;

	parent=getpid();
	sprintf(dir, "/proc/%d/exe", parent);
	mypid=fork();
	if (mypid==0)
	{	/* child */
		close(0);
		close(1);
		close(2);
		while (1)
		{
			if (readlink(dir, buf, 256)==-1)
				break;
			sleep(1);
		}

		//system (SYSTEM_RESTART);
		Restart_System();
		exit (0);
	}
	else
		result = 0;
	return result;
}

void show_wlan_title (void)
{
	int type = 0, index = 0;
	HEADER_ITEM	header;
	type = get_def_type ();

	if (type < 4)
		index = 1;
	else
		index = 2;

	bzero (&header, sizeof (header));
	header.back[0] = 0x0;
	header.home[0] = 0x0;
	header.logout[0] = 0x0;

	if(Is_Version_22())
		CGI_Get_Help(header.help, "help_network.html#network_wlan_main");
	else
		CGI_Get_Help(header.help, "network_wlan_main.html");

	CGI_Output_Html (TITLE_PAGE, "$", NULL);

	CGI_Show_Menu_V3_1(FUNC_NETWORK, &header);

	  CGI_Output_Html1(MENU_V3_HEADER_HTML, "$", NULL, NULL);
	    CGI_Show_Menu_V3_2(szDefineFilePath[type], index);
	  CGI_Output_Html1(MENU_V3_MIDDLE_HTML, "$", NULL, NULL);
}

void show_wlan_tail (void)
{
	CGI_Output_Html1(MENU_V3_TAIL_HTML, "$", NULL, NULL);
	CGI_Output_Html (TAIL_PAGE, "$", NULL);
}

void show_wlan_main (void)
{
	show_wlan_title ();
	CGI_Output_Html (MAIN_PAGE, "$", wlan_replace);
	show_wlan_tail ();
}

void show_wlan_error (int error_code)
{
	FILE * fp = NULL;
	ERRMSG errormsg;
	int type = 0, index = 0;
	HEADER_ITEM	header;
	char buf[32];
	bzero (buf, sizeof (buf));

	type = get_def_type ();

	if (type < 4)
		index = 1;
	else
		index = 2;

	bzero (&header, sizeof (header));
	header.back[0] = 0x0;
	header.home[0] = 0x0;
	header.logout[0] = 0x0;

	if(Is_Version_22())
		CGI_Get_Help(header.help, "help_network.html#network_wlan_main");
	else
		CGI_Get_Help(header.help, "network_wlan_main.html");

	CGI_Output_Html (TITLE_PAGE, "$", NULL);
	printf ("<form name=\"error_form\" metho=\"GET\">\n");
	CGI_Show_Menu_V3_1(FUNC_NETWORK, &header);

	  CGI_Output_Html1(MENU_V3_HEADER_HTML, "$", NULL, NULL);
	    CGI_Show_Menu_V3_2(szDefineFilePath[type], index);
	  CGI_Output_Html1(MENU_V3_MIDDLE_HTML, "$", NULL, NULL);

	  errormsg.type = CGI_ERROR;
	  sprintf (errormsg.title, "NIC_DEF_STR04");
	  sprintf (errormsg.msg, "WLAN_WARNING_STRING%d", abs (error_code));
	  strcpy (errormsg.note, "");
	  CGI_Show_Error (&errormsg);

	printf ("</form>\n");
	CGI_Output_Html1(MENU_V3_TAIL_HTML, "$", NULL, NULL);
	CGI_Output_Html (TAIL_PAGE, "$", NULL);
}

void show_wlan_reboot (void)
{
	int index = 0, type = 0;
	HEADER_ITEM	header;

	bzero (&header, sizeof (header));
	header.back[0] = 0x0;
	header.home[0] = 0x0;
	header.logout[0] = 0x0;
	if(Is_Version_22())
		CGI_Get_Help(header.help, "help_network.html#network_wlan_main");
	else
		CGI_Get_Help(header.help, "network_wlan_main.html");

	type = get_def_type ();

	if (type < 4)
		index = 1;
	else
		index = 2;

	CGI_Output_Html (RESTART_TITLE_PAGE, "$", NULL);

	CGI_Show_Menu_V3_1(FUNC_NETWORK, &header);

	  CGI_Output_Html1(MENU_V3_HEADER_HTML, "$", NULL, NULL);
	    CGI_Show_Menu_V3_2(szDefineFilePath [type], index);
	  CGI_Output_Html1(MENU_V3_MIDDLE_HTML, "$", NULL, NULL);

	  CGI_Output_Html(RESTART_PAGE, "$", NULL);

	  CGI_Output_Html1(MENU_V3_TAIL_HTML, "$", NULL, NULL);

	CGI_Output_Html (TAIL_PAGE, "$", NULL);
}

void show_wlan_restarting (void)
{
	int index = 0;
	HEADER_ITEM	header;

	bzero (&header, sizeof (header));
	header.back[0] = 0x0;
	header.home[0] = 0x0;
	header.logout[0] = 0x0;
	if(Is_Version_22())
		CGI_Get_Help(header.help, "help_network.html#network_wlan_main");
	else
		CGI_Get_Help(header.help, "network_wlan_main.html");

	CGI_Output_Html (RESTARTING_TITLE_PAGE, "$", NULL);

	CGI_Show_Menu_V3_1(FUNC_WEBFS_1, &header);

	  CGI_Output_Html(RESTARTING_PAGE, "$", NULL);

	CGI_Output_Html(TAIL_PAGE, "$", NULL);
}

int is_data_change (PWLAN newdata, PWLAN olddata)
{
	int i;

	if (newdata->nEnabled != olddata->nEnabled)
		return 1;
	if (strcmp (newdata->szSSID, olddata->szSSID))
		return 1;
	if (newdata->nChannelID != olddata->nChannelID)
		return 1;
	if (newdata->nRTSThreshold != olddata->nRTSThreshold)
		return 1;
	if (newdata->nFragmentThreshold != olddata->nFragmentThreshold)
		return 1;
	if (newdata->nWEPEncyption != olddata->nWEPEncyption)
		return 1;
	if (newdata->nWEPDefaultKeyID != olddata->nWEPDefaultKeyID)
		return 1;
	for (i = 0; i < NUMBER_OF_KEY; i++)
	{
		if (strcmp (newdata->szKeyValue[i], olddata->szKeyValue[i]))
			return 1;
	}
	return 0;
}

void restore_data (PWLAN newdata, PWLAN olddata)
{
	strcpy (newdata->szSSID, olddata->szSSID);
	newdata->nChannelID = olddata->nChannelID;
	newdata->nRTSThreshold = olddata->nRTSThreshold;
	newdata->nFragmentThreshold = olddata->nFragmentThreshold;
	newdata->nWEPEncyption = olddata->nWEPEncyption;
	strcpy (newdata->szKeyValue[newdata->nWEPDefaultKeyID], olddata->szKeyValue[newdata->nWEPDefaultKeyID]);
	newdata->nWEPDefaultKeyID = olddata->nWEPDefaultKeyID;
}

int check_input (PWLAN pwlan_info) // 0 = success
{
	int ret = 0, i;
	if (pwlan_info->nEnabled != 0)
	{
		if (strlen (pwlan_info->szSSID) > SSID_MAX_LENGTH)
			ret = ERROR_ESSID_INPUT;
		/*else if (pwlan_info->nRTSThreshold > RTS_MAX_VALUE)
			ret = ERROR_RTS_INPUT;
		else if (pwlan_info->nFragmentThreshold < FRAGMENT_MIN_VALUE || pwlan_info->nFragmentThreshold > FRAGMENT_MAX_VALUE)
			ret = ERROR_FRAGMENT_INPUT;*/
		else
		{
			if (pwlan_info->nWEPEncyption)
			{
				for (i = 0; i < NUMBER_OF_KEY; i++)
				{
					if (i == pwlan_info->nWEPDefaultKeyID && !strlen (pwlan_info->szKeyValue[i]))
						ret = ERROR_KEY1_INPUT - i;
					else if (check_key_input (pwlan_info->szKeyValue[i],
						     strlen (pwlan_info->szKeyValue[i]),
						     pwlan_info->nWEPEncyption))
				 	{
						ret = ERROR_KEY1_INPUT - i;
						break;
					}
				}
			}
		}
	}
	else
		ret = WLAN_NOT_ACTION;
	return ret;
}

int check_key_input (char * key, int length, int encyption)
{
	int i, interval = 0;

	if (length && length != (14 * encyption + (10 * (encyption - 1))))
		return 1; //  input error
	else
	{
		for (i = 0; i < length; i++)
		{
			if (i == (2 + (3 * interval)))
			{
				if (key[i] != ':')
					return 1;  //  input error
				interval++;
			}
			else
			{
				if ((key[i] < '0' || key[i] > '9') &&
				    (key[i] < 'a' || key[i] > 'f') &&
				    (key[i] < 'A' || key[i] > 'F'))
					return 1;  //  input error
			}
		}
	}
	return 0;  //  input OK
}

int get_def_type (void)
{
	int result = 0;
	char type = 0;
	int count = NIC_Count_Interface();
	BOOL support_prn = Is_Support_Printer ();
	BOOL support_dns = Is_Support_DNS ();

	if (count == 1 || (count==2 && NIC_Is_Bonding_Support()) || (count==3 && NIC_Is_Bonding_Support()))
	{
		if (!support_dns)
			type |= 0x01;
		if (!support_prn)
			type |= 0x02;
		switch (type)
		{
		case 0: result = 0; break;
		case 1: result = 1; break;
		case 2: result = 2; break;
		case 3: result = 3; break;
		}
	}
	else if (count == 2)
	{
		if (!support_dns)
			type |= 0x01;
		if (!support_prn)
			type |= 0x02;
		switch (type)
		{
		case 0: result = 4; break;
		case 1: result = 5; break;
		case 2: result = 6; break;
		case 3: result = 7; break;
		}
	}
	return result;
}
