##!/bin/sh

[ -f /usr/sbin/papd ] || exit 0

RETVAL=0

case "$1" in
  start)
        # Start daemons.
        echo -n "Starting papd: "
	if [ `/sbin/getcfg printers Support -u -d FALSE` = FALSE ]
	then
		echo " not support printer function."
		exit 0
	fi

	if [ `/sbin/getcfg printers Enable -u -d FALSE` = FALSE ]
	then
		echo " disable."
		exit 0
	fi

	if [ `/sbin/getcfg Appletalk Enable -u -d FALSE` = FALSE ]
	then
		echo " disable."
		exit 0
	fi
                       
    cp /usr/sbin/filter /mnt/HDB_ROOT 
    cp /usr/sbin/general.cfg /mnt/HDB_ROOT
    cp /usr/sbin/postscript.cfg /mnt/HDB_ROOT
    cp /usr/sbin/textonly.cfg /mnt/HDB_ROOT
    
        #/usr/sbin/papd
	/sbin/daemon_mgr papd start "/usr/sbin/papd"
	RETVAL=$?
        echo
        [ $RETVAL -eq 0 ]
        ;;
  stop)
        # Stop daemons.
        echo -n "Shutting down papd: "
	# /bin/kill -9 `/sbin/pidof papd`
	/sbin/daemon_mgr papd stop "/usr/sbin/papd"
	RETVAL=$?
        echo
        [ $RETVAL -eq 0 ]
        ;;
  status)
	status papd
	RETVAL=$?
	;;
  restart|reload)
	$0 stop
	$0 start
	RETVAL=$?
	;;
  *)
        echo "Usage: papd.sh {start|stop|restart|reload|status}"
        exit 1
esac

exit $RETVAL
