#!/bin/bash

SETSID=/usr/bin/setsid
write_hosts()
{
        $SETSID /bin/echo "127.0.0.1		localhost		localhost" > /etc/hosts
        $SETSID /bin/echo "`/sbin/nic_getinfo ppp0 ip`		`/bin/hostname`		`/bin/hostname`" >> /etc/hosts
        landev=`/sbin/getcfg "Network" Interface1 -d eth0`
        $SETSID /bin/echo "`/sbin/nic_getinfo $landev ip`		`/bin/hostname`		`/bin/hostname`" >> /etc/hosts
}

add_dns()
{
        NAS_DNS=`/sbin/getcfg "Network" DNS -d 0.0.0.0`
        if [ "$NAS_DNS" != "0.0.0.0" ]; then
                /bin/echo "nameserver $NAS_DNS" >> /etc/resolv.conf
        fi
        /bin/cat /etc/config/ppp/resolv.conf >> /etc/resolv.conf
}

refresh_lcd()
{
	$SETSID /bin/kill -HUP `/sbin/pidof sysmond` 2>/dev/null 1>/dev/null
}

restart_dhcp()
{
	if [ `/sbin/getcfg "DHCP Server" Enable -u -d FALSE` = TRUE ]; then
		$SETSID /etc/init.d/dhcpd.sh restart
	fi
}

restart_nat()
{
	if [ `/sbin/getcfg NAT Support -u -d FALSE` = TRUE ]; then
		$SETSID /sbin/init_fw
	fi
}

pptp_connect()
{
#        if [ -e /var/pptp.status ]; then
                /bin/rm -f /var/pptp.status
#        fi
	refresh_lcd
	write_hosts
	add_dns
	restart_dhcp
	restart_nat
	/etc/init.d/smb restart
}

use_dhcp()
{
#	/sbin/write_log "PPTP connect fail, use dhcp to connect." 4
	if [ `/sbin/getcfg "Network" "Interface Number" -u -d 1` = 2 ]; then
		DEV=`/sbin/getcfg "Network" "Wan"`
	fi
	if [ `/sbin/getcfg "Network" "Interface Number" -u -d 1` = 1 ]; then
		DEV=`/sbin/getcfg "Network" "Interface1"`
	fi
	/sbin/ifconfig $DEV 0.0.0.0
	TIMES=0
	while [ `/sbin/nic_getinfo $DEV ip` = "127.0.0.1" ]; do
		if [ $TIMES = 1 ]; then
			break
		fi
		/sbin/setcfg "Network" "Wan DHCP" "TRUE"
		/sbin/dhcpcd $DEV -t 5 2>/dev/null 1>/dev/null
		TIMES=1
	done
	if [ `/sbin/nic_getinfo $DEV ip` != "127.0.0.1" ]; then
#		refresh_lcd
#		write_hosts
#		restart_dhcp
#		restart_nat
		pptp_connect
		/sbin/setcfg "Network" "Wan DHCP" "FALSE"
	fi
}

stop_dhcp()
{
	if [ `/sbin/getcfg "Network" "Interface Number" -u -d 1` = 2 ]; then
		DEV=`/sbin/getcfg "Network" "Wan"`
	fi
	if [ `/sbin/getcfg "Network" "Interface Number" -u -d 1` = 1 ]; then
		DEV=`/sbin/getcfg "Network" "Interface1"`
	fi
	/sbin/ifconfig $DEV down
#	if [ -e /var/run/dhcpcd*.pid ]; then
		/bin/rm /var/run/dhcpcd*.pid -f 2>/dev/null 1>/dev/null
#	fi
	/bin/kill -9 `/sbin/pidof /sbin/dhcpcd` 2>/dev/null 1>/dev/null
}

case "$1" in
	start)
		/sbin/setcfg "Network" "Wan DHCP" "FALSE"
		DEV=`/sbin/getcfg "Network" "Wan"`
		while [ true ]; do
			/bin/rm /var/run/pptp/* 2>/dev/null 1>/dev/null
			SERVER_IP=`/sbin/getcfg PPTP "Server IP" -u -d 0.0.0.0`
			/sbin/ifconfig eth0 `/sbin/getcfg PPTP "Local IP" -u -d 0.0.0.0` 2>/dev/null 1>/dev/null
			/usr/bin/setsid /usr/sbin/pptp `/sbin/getcfg PPTP "Server IP" -u -d 0.0.0.0` 2>/dev/null 1>/dev/null
			/bin/sleep 10
			if [ `/sbin/nic_getinfo ppp0 ip` != "127.0.0.1" ]; then
				pptp_connect
				break
			fi
			/bin/kill -9 `/sbin/pidof pppd` 2>/dev/null 1>/dev/null
			if [ `/sbin/getcfg PPTP "Fail Use DHCP" -u -d FALSE` = TRUE ]; then
				/sbin/setcfg "Network" "Wan DHCP" "TRUE"
				use_dhcp
				if [ `/sbin/nic_getinfo $DEV ip` != "127.0.0.1" ]; then
					pptp_connect
					break;
				fi
			fi
#			/sbin/write_log "PPTP connect fail, retry again." 4
		done
        ;;
	stop)
		/sbin/setcfg "Network" "Wan DHCP" "FALSE"
		if [ `/sbin/getcfg PPTP "Fail Use DHCP" -u -d FALSE` = TRUE ]; then
			stop_dhcp
		else
			/bin/kill `/sbin/pidof -9 pppd` 2>/dev/null 1>/dev/null
		fi
		
        ;;
	restart)
		$0 stop
		$0 start
        ;;
	*)
		echo "Usage: /etc/init.d/pptp.sh {start|stop|restart}"
		exit 1
esac

exit 0

