#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>

/* include NAS lib */
#include <cgi.h>
#include <Util.h>
#include <config.h>
#include <v2_menu.h>
#include <cfg_nic.h>
#include <cfg_printer.h>
#include <cfg_dns.h>
#include <cfg_samba.h>

/* include local file */
#include "network.h"
#include "nic_ms.h"

int Domain_Master_Enabled() //Shone added to test if Domain Master enabled 2005,3,19
{
     char result[80];
     int ret=0;
            
     Conf_Get_Field("/etc/config/smb.conf", "global", "domain master",result,80);
     if (!strcmp(result,"yes"))
        ret=1;
           
     return ret;
}   

int ms_replace(FILE *fptr, char *name, void *arg)
{
	char	buf[256], *ptr;
	int		ret;

	if (!strcmp(name, "ONLOAD"))
	{
	}
	else
	if (!strcmp(name, "Workgroup"))
	{
		char	buf[256];
		
		if ( Get_Samba3_Workgroup_Name(buf) >= 0 )
			fprintf(fptr, "%s", buf);
	}
	else
	if (!strcmp(name, "Description"))
	{
		char	buf[256];
		
		if ( Get_Samba3_Description(buf) >= 0 ) {
			fprintf(fptr, "%s", buf);
		}
	}
	else
	if (!strcmp(name, "DescriptionStatus"))
 	{
		if ( !Is_Samba_Enabled() ) {
			fprintf(fptr, "disabled");
		}
	}
	else
	if (!strcmp(name, "MS_SMB_Check"))
	{
		ret=Is_Samba_Enabled();
		if (ret!=0)
			fprintf(fptr, "checked");
	}
	else
	if (!strcmp(name, "WorkgroupStatus"))
	{
		MS_Net_Type	type = STANDALONE;

		if (Is_Samba_Enabled() && Get_MS_Server_Type(&type) >= 0 )
		{
			switch(type) {
				case	STANDALONE:
					break;
				case	NTDC:
				case	NTDM:
				case	ADDM:
					fprintf(fptr, "disabled");
					break;
			}
		}
		else
			fprintf(fptr, "disabled");
	}
	else
	if (!strcmp(name, "StandaloneSrv_status"))
	{
		if (!Is_Samba_Enabled() )
			fprintf(fptr, " disabled");
	}
	else
	if (!strcmp(name, "WINS_IP_disabled"))
	{
		BOOL	checked = FALSE;
		char	IP[16];
			
		//if ( !Is_Samba_Enabled() || Get_Samba3_WINS(&checked, IP) >= 0 )
		Get_Samba3_WINS(&checked, IP);
		if ( !Is_Samba_Enabled() || !checked)//Shone 2005/3/22
			fprintf(fptr, "disabled");
        }
        else
        if (    !strcmp(name, "WINS_IP1") || !strcmp(name, "WINS_IP2") || !strcmp(name, "WINS_IP3") ||
                !strcmp(name, "WINS_IP4"))
        {
                char    ipaddr[20];
		char	*pip;
		BOOL	checked = FALSE;
			
		if (  Get_Samba3_WINS(&checked, ipaddr) >= 0 ) {
			ptr=name+(strlen(name)-1);
			pip=parser_ipaddr(buf, ipaddr, (int)(*ptr-'1'));
			if (pip==NULL)
				fprintf(fptr, "0");
			else
				fprintf(fptr, "%d", atoi(pip));
		}
        }
        else
        if (!strcmp(name, "Ext_WinsSrv_checked"))
        {
		BOOL	checked = FALSE;
		char	ip[16];
		int	ret = 0;
		
		ret = Get_Samba3_WINS(&checked, ip);
		if ( (ret >= 0) && checked )
			fprintf(fptr, "checked");
		if (!Is_Samba_Enabled() )
			fprintf(fptr, " disabled");
        }
        else
        if (!strcmp(name, "Int_WinsSrv_checked"))
        {
		BOOL checked = FALSE;

		if ( Get_Samba3_WINS_Srv(&checked) >= 0 )
			if ( checked )
				fprintf(fptr, "checked");
		if (!Is_Samba_Enabled() )
			fprintf(fptr, " disabled");
        }
       else
       if (!strcmp(name, "DM"))
          {
			if (Domain_Master_Enabled())
				fprintf(fptr, "checked");
			if (!Is_Samba_Enabled() )
				fprintf(fptr, " disabled");
           }	
       else
                return CGI_REPLACE_FAIL;
        return CGI_REPLACE_OK;
}

//  Add by Tiger
int show_ms_header ()
{
        HEADER_ITEM     header;
	int	nic_count;

        header.back[0]=0x0;
        header.home[0]=0x0;
        header.logout[0]=0x0;
        if(Is_Version_22())
                CGI_Get_Help(header.help, "help_network.html#network_ms_main");
        else
                CGI_Get_Help(header.help, "network_ms_main.html");
        CGI_Show_Menu_V3_1(FUNC_NETWORK, &header);
        CGI_Output_Html1(MENU_V3_HEADER_HTML, "$", ms_replace, NULL);
        nic_count=NIC_Count_Interface();

        CGI_Show_Menu_V3_2("/home/httpd/cgi-bin/network/network.def", 2);
        CGI_Output_Html1(MENU_V3_MIDDLE_HTML, "$", ms_replace, NULL);
        return NIC_SUCCESS;
}

int show_ms_tail ()
{
	return CGI_Output_Html1(MENU_V3_TAIL_HTML, "$", ms_replace, NULL);
}
//  add until here

int do_ms_main()
{
        CGI_Output_Html1(NIC_HEADER_HTML, "$", ms_replace, NULL);
        show_ms_header ();
        CGI_Output_Html1(NIC_MS_MAIN_HTML, "$", ms_replace, NULL);
        show_ms_tail ();
        CGI_Output_Html1(NIC_TAIL_HTML, "$", ms_replace, NULL);

        return NIC_SUCCESS;
}

int do_ms_main_submit(INPUT *input)
{
	INPUT   *tmp;
	char    ipaddr[NIC_IPADDR_LEN];

	if ((tmp=CGI_Find_Parameter(input, "MS_SMB_Check"))!=NULL)
	{ // enable or modify now
		MS_Net_Type	type = STANDALONE;
		char 		DWname[64]="";
		//char		NTusername[256]="";
		//char		NTpassword[256]="";

		if ((tmp=CGI_Find_Parameter(input, "NetworkType"))!=NULL) 
		{
			Set_MS_Server_Type(type);
        	if ((tmp=CGI_Find_Parameter(input, "WorkgroupName"))!=NULL) {
				strcpy(DWname, tmp->val);
				WritePrivateProfileString("global", "Workgroup", DWname, "/etc/config/smb.conf");
				WriteProfileString("System", "Workgroup", DWname);
			}
		}
		Enable_Samba(1);
		//WriteProfileString("Samba", "Enable", "TRUE");
		//We dont need fork now
		//child_pid = fork();
		//if(child_pid == 0) { // child process
		/*{
			int	smb_ret = 0, err_no;
			char	logmsg[1024];

			smb_ret = Run_Samba3(type, DWname, NTusername, NTpassword);
			switch (smb_ret){
				case	SMB3_SUCCESS:
					sprintf(logmsg, "/sbin/write_log \"Microsoft Networking configured successfully.\" 4 1>/dev/null 2>/dev/null");
					err_no = 0;
					break;
				case	SMB3_USAGE_ERROR:
					sprintf(logmsg, "/sbin/write_log \"Microsoft Networking configured failed, internal error.\" 1 1>/dev/null 2>/dev/null");
					err_no = -200;
					break;
				case	SMB3_UNKNOWN_ERROR:
					sprintf(logmsg, "/sbin/write_log \"Microsoft Networking configured failed, unknown error.\" 1 1>/dev/null 2>/dev/null");
					err_no = -201;
					break;
				case	SMB3_KDC_SRV_ERROR:
					sprintf(logmsg, "/sbin/write_log \"Microsoft Networking configured failed. Please check the DNS server settings.\" 1 1>/dev/null 2>/dev/null");
					err_no = -202;
					break;
				case	SMB3_KDC_REALM_ERROR:
				case	SMB3_AD_JOIN_ERROR:
					if ( type == STANDALONE ) {
						sprintf(logmsg, "/sbin/write_log \"Microsoft Networking configured failed. Please check the workgroup setting.\" 1 1>/dev/null 2>/dev/null");
						err_no = -203;
					}
					else {
						sprintf(logmsg, "/sbin/write_log 'Microsoft Networking configured failed. Please check the domain / username / password settings.' 1 1>/dev/null 2>/dev/null");
						err_no = -204;
					}
					break;
				case	SMB3_KDC_TIME_DIFF_ERROR:
					sprintf(logmsg, "/sbin/write_log \"Microsoft Networking configured failed. Please synchronize time with Windows server.\" 1 1>/dev/null 2>/dev/null");
					err_no = -205;
					break;
				case	SMB3_NTD_JOIN_ERROR:
					sprintf(logmsg, "/sbin/write_log \"Microsoft Networking configured failed. Please check the domain / username / password settings.\" 1 1>/dev/null 2>/dev/null");
					err_no = -204;
					break;
				default:
					;
			}
			system(logmsg);	
			if (err_no!=0)
				return err_no;
		}*/
	}
	else
		Enable_Samba(0);

	if ((tmp=CGI_Find_Parameter(input, "Description"))!=NULL) {
		Set_Samba3_Description(tmp->val);
	}

	if ((tmp=CGI_Find_Parameter(input, "Ext_WinsSrv"))!=NULL) {
		if (!strcmp (tmp->val, "ON")) {
                	CGI_Get_Text_IP(ipaddr, NIC_IPADDR_LEN, input, "WINS_IP1", "WINS_IP2", "WINS_IP3", "WINS_IP4");
			Set_Samba3_WINS(TRUE, ipaddr);
		} else
			Set_Samba3_WINS(FALSE, ipaddr);
	} else Set_Samba3_WINS(FALSE, "0.0.0.0");

	if ((tmp=CGI_Find_Parameter(input, "Int_WinsSrv"))!=NULL) {
		if (!strcmp (tmp->val, "ON"))
			Set_Samba3_WINS_Srv(TRUE);
		else
			Set_Samba3_WINS_Srv(FALSE);
	} else Set_Samba3_WINS_Srv(FALSE);

        if(Is_Samba_Enabled())  //Shone added to enable Domain Master 2005,03,19
          {
             if ((tmp=CGI_Find_Parameter(input, "DM"))!=NULL)
                {
                   if (!strcmp (tmp->val, "ON"))
                      {
                          if(!Domain_Master_Enabled())
                            {
                               Conf_Set_Field("/etc/config/smb.conf", "global", "domain master", "yes");
                               Conf_Set_Field("/etc/config/smb.conf", "global", "local master", "yes");
                               Conf_Set_Field("/etc/config/smb.conf", "global", "preferred master", "yes");
                               Conf_Set_Field("/etc/config/smb.conf", "global", "os level", "65");
                               system("/etc/init.d/smb.sh restart");
                            }	
                      }
                }
             else{
                    if(Domain_Master_Enabled())
                      {    
                          Conf_Remove_Field("/etc/config/smb.conf", "global", "domain master");
                          Conf_Remove_Field("/etc/config/smb.conf", "global", "local master");
                          Conf_Remove_Field("/etc/config/smb.conf", "global", "preferred master");
                          Conf_Remove_Field("/etc/config/smb.conf", "global", "os level");
	            //Conf_Set_Field("/etc/config/smb.conf", "global", "os level", "1");
                          system("/etc/init.d/smb.sh restart");
                      }	
                 }
          }
       else {
               Conf_Remove_Field("/etc/config/smb.conf", "global", "domain master");
               Conf_Remove_Field("/etc/config/smb.conf", "global", "local master");		 
               Conf_Remove_Field("/etc/config/smb.conf", "global", "preferred master");
               Conf_Remove_Field("/etc/config/smb.conf", "global", "os level");   
	 //Conf_Set_Field("/etc/config/smb.conf", "global", "os level", "1"); 
            }    

	do_ms_main();
        return NIC_SUCCESS;
}

void do_ms_error(int code, int *menu_select)
{
        char            error[30]={""};
        HEADER_ITEM     header;
        ERRMSG          errmsg;

        if (code==0)
                return;

        /* header */
        CGI_Output_Html1(NIC_HEADER_HTML, "$", ms_replace, NULL);
        show_ms_header ();
        header.back[0]=0x0;
        header.home[0]=0x0;
        header.logout[0]=0x0;
	if(Is_Version_22())
		CGI_Get_Help(header.help, "help_warning.html");
	else
		CGI_Get_Help(header.help, "help_warning.html");

        sprintf(error, "NIC_ERROR_MSG%d", code*(-1));
        errmsg.type=CGI_ERROR;
        strcpy(errmsg.msg, error);
        strcpy(errmsg.note, "IEI_NAS_NONE");
	strcpy(errmsg.title, "NIC_MS_STR01");
	CGI_Show_Error_V3(&errmsg);

        /* tail */
        show_ms_tail ();
        CGI_Output_Html1(NIC_TAIL_HTML, "$", ms_replace, NULL);
}

