#include <stdio.h>
#include <string.h>

/* include NAS lib */
#include <cgi.h>
#include <cfg_nic.h>
#include <config.h>
#include <v2_menu.h>
#include <cfg_printer.h>
#include <cfg_dns.h>
#include <cfg_qdownload.h>

/* include local file */
#include "network.h"
#include "nic_download.h"

int download_replace(FILE *fptr, char *name, void *arg)
{
        if (!strcmp(name, "ONLOAD"))
        {
        }
        else
        if (!strcmp(name, "bDOWNLOAD"))
        {
                if (Is_Qdownload_Enabled()!=0)
                        fprintf(fptr, "checked");
        }
        else
        if (!strcmp(name, "IP"))
        {
		        NIC_INFO	nic_info;
		        NIC_Get_Info(&nic_info, NIC_LAN01);
		        fprintf(fptr, "%s", nic_info.ipaddr);
	
        }
        else
                return CGI_REPLACE_FAIL;
        return CGI_REPLACE_OK;
}

int show_download_header ()
{
	HEADER_ITEM     header;
	int	nic_count;

	header.back[0]=0x0;
	header.home[0]=0x0;
	header.logout[0]=0x0;

	if(Is_Version_22())
		CGI_Get_Help(header.help, "help_network.html#network_download_main");
	else
		CGI_Get_Help(header.help, "network_download_main.html");

	CGI_Show_Menu_V3_1(FUNC_NETWORK, &header);
	CGI_Output_Html1(MENU_V3_HEADER_HTML, "$", download_replace, NULL);
	nic_count=NIC_Count_Interface();
	CGI_Show_Menu_V3_2("/home/httpd/cgi-bin/network/network.def", 7);
	CGI_Output_Html1(MENU_V3_MIDDLE_HTML, "$", download_replace, NULL);
	return NIC_SUCCESS;
}

int show_download_tail ()
{
	return CGI_Output_Html1(MENU_V3_TAIL_HTML, "$", download_replace, NULL);
}

int do_download_main()
{
        CGI_Output_Html1(NIC_HEADER_HTML, "$", download_replace, NULL);
        show_download_header ();
        CGI_Output_Html1(NIC_DOWNLOAD_MAIN_HTML, "$", download_replace, NULL);
        show_download_tail ();
        CGI_Output_Html1(NIC_TAIL_HTML, "$", download_replace, NULL);
        return NIC_SUCCESS;
}

int do_download_main_submit(INPUT *input)
{
        INPUT   *tmp;

        if ((tmp=CGI_Find_Parameter(input, "bDOWNLOAD"))!=NULL)
                Enable_Qdownload(1);
        else
                Enable_Qdownload(0);
        do_download_main();
        return NIC_SUCCESS;
}


