#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

/* include NAS lib */
#include <cgi.h>
#include <cfg_nic.h>
#include <config.h>
#include <cfg_system.h>
#include <cfg_printer.h>
#include <cfg_fw.h>
#include <v2_menu.h>
#include <cfg_dns.h>

/* include local file */
#include "network.h"
#include "nic_wan.h"
#include "nic_lan.h"
#include "nic_ms.h"
#include "nic_apple.h"
#include "nic_nfs.h"
#include "nic_webfs.h"
#include "nic_view.h"
#include "nic_web.h"
#include "nic_photo.h"
#include "nic_download.h"

//#define _DEBUG		1

int support_misc()
{
	if (Is_Support_DNS()==0 && Is_Support_Printer()==0)
		return 0;
	return 1;
}

int get_func(INPUT *input, int *menu_select)
{
	INPUT   *tmp;
	int     ret=NIC_NONE;

#ifdef _DEBUG
        CGI_Debug_Input(input);
#endif
	tmp=CGI_Find_Parameter(input, "func");
	if (tmp==NULL)
		ret=NIC_NONE;
	else
	{
		if (!strcmp(tmp->val, "main"))
		{
			ret=NIC_MAIN;
			*menu_select=SELECT_WAN;
		}
		else
		if (!strcmp(tmp->val, "wan_main"))
		{
			ret=NIC_WAN_MAIN;
			*menu_select=SELECT_WAN;
		}
		else
		if (!strcmp(tmp->val, "lan_main"))
		{
			ret=NIC_LAN_MAIN;
			*menu_select=SELECT_LAN;
		}
		else
		if (!strcmp(tmp->val, "wan_main_ok"))
		{
			ret=NIC_WAN_MAIN_OK;
			*menu_select=SELECT_WAN;
		}
		else
		if (!strcmp(tmp->val, "lan_main_ok"))
		{
			ret=NIC_LAN_MAIN_OK;
			*menu_select=SELECT_LAN;
		}
		else
		if (!strcmp(tmp->val, "microsoft_main"))
		{
			ret=NIC_MS_MAIN;
			*menu_select=SELECT_MS;
		}
		else
		if (!strcmp(tmp->val, "microsoft_main_ok"))
		{
			ret=NIC_MS_MAIN_OK;
			*menu_select=SELECT_MS;
		}
		else
		if (!strcmp(tmp->val, "apple_main"))
		{
			ret=NIC_APPLE_MAIN;
			*menu_select=SELECT_APPLE;
		}
		else
		if (!strcmp(tmp->val, "apple_main_ok"))
		{
			ret=NIC_APPLE_MAIN_OK;
			*menu_select=SELECT_APPLE;
		}
		else
		if (!strcmp(tmp->val, "nfs_main"))
		{
			ret=NIC_NFS_MAIN;
			*menu_select=SELECT_NFS;
		}
		else
		if (!strcmp(tmp->val, "nfs_main_ok"))
		{
			ret=NIC_NFS_MAIN_OK;
			*menu_select=SELECT_NFS;
		}
		else
		if (!strcmp(tmp->val, "webfs_main"))
		{
			ret=NIC_WEBFS_MAIN;
			*menu_select=SELECT_WEBFS;
		}
		else
		if (!strcmp(tmp->val, "webfs_main_ok"))
		{
			ret=NIC_WEBFS_MAIN_OK;
			*menu_select=SELECT_WEBFS;
		}
		else
		if (!strcmp(tmp->val, "view_main"))
		{
			ret=NIC_VIEW_MAIN;
			*menu_select=SELECT_VIEW;
		}
		else
		if (!strcmp(tmp->val, "view_main1"))
		{
			ret=NIC_VIEW_MAIN1;
			*menu_select=SELECT_VIEW;
		}
		else
		if (!strcmp(tmp->val, "view_main2"))
		{
			ret=NIC_VIEW_MAIN2;
			*menu_select=SELECT_VIEW;
		}
		else
		if (!strcmp(tmp->val, "view_main_ok"))
		{
			ret=NIC_VIEW_MAIN_OK;
			*menu_select=SELECT_VIEW;
		}
		else
		if (!strcmp(tmp->val, "restart"))
		{
			if ((tmp=CGI_Find_Parameter(input, "OK"))!=NULL)
				ret=NIC_RESTART_MAIN_OK;
			else
			if ((tmp=CGI_Find_Parameter(input, "CANCEL"))!=NULL)
				ret=NIC_RESTART_MAIN_CANCEL;
			else
				ret=NIC_RESTART_MAIN;
		}
//add by jeffrey hsieh 2005/07/22
		else
		if (!strcmp(tmp->val, "web_main"))
		{
			ret=NIC_WEB_MAIN;
			*menu_select=SELECT_WEB;
		}
		else
		if (!strcmp(tmp->val, "web_main_ok"))
		{
			ret=NIC_WEB_MAIN_OK;
			*menu_select=SELECT_WEB;
		}
		else
		if (!strcmp(tmp->val, "photo_main"))
		{
			ret=NIC_PHOTO_MAIN;
			*menu_select=SELECT_PHOTO;
		}
		else
		if (!strcmp(tmp->val, "photo_main_ok"))
		{
			ret=NIC_PHOTO_MAIN_OK;
			*menu_select=SELECT_PHOTO;
		}
		else
		if (!strcmp(tmp->val, "download_main"))
		{
			ret=NIC_DOWNLOAD_MAIN;
			*menu_select=SELECT_DOWNLOAD;
		}
		else
		if (!strcmp(tmp->val, "download_main_ok"))
		{
			ret=NIC_DOWNLOAD_MAIN_OK;
			*menu_select=SELECT_DOWNLOAD;
		}
//end
	}
	return ret;
}

int my_replace(FILE *fptr, char *name, void *arg);

void do_nic_error(int code, int *menu_select)
{
        char            error[30]={""};
        HEADER_ITEM     header;
        ERRMSG          errmsg;

        if (code==FW_SUCCESS)
                return;

        /* header */
        CGI_Output_Html1(NIC_HEADER_HTML, "$", my_replace, NULL);
        header.back[0]=0x0;
        header.home[0]=0x0;
        header.logout[0]=0x0;
	if(Is_Version_22())
		CGI_Get_Help(header.help, "help_warning.html");
	else
		CGI_Get_Help(header.help, "help_warning.html");
        CGI_Show_Menu_V3_1(FUNC_NETWORK, &header);
        CGI_Output_Html1(MENU_V3_HEADER_HTML, "$", my_replace, NULL);
        CGI_Show_Menu_V3_2(DEF_NETWORK2, *menu_select);
        CGI_Output_Html1(MENU_V3_MIDDLE_HTML, "$", my_replace, NULL);

        sprintf(error, "NIC_ERROR_MSG%d", code*(-1));
        errmsg.type=CGI_ERROR;
        strcpy(errmsg.msg, error);
        strcpy(errmsg.note, "IEI_NAS_NONE");
	strcpy(errmsg.title, "NIC_WAN_STR01");
	CGI_Show_Error_V3(&errmsg);
        /* tail */
        CGI_Output_Html1(MENU_V3_TAIL_HTML, "$", my_replace, NULL);
        CGI_Output_Html1(NIC_TAIL_HTML, "$", my_replace, NULL);
}

//====================================================================
//      src = 0.1.2.3
//      pos is below
//      0 : ip1
//      1 : ip2
//      2 : ip3
//      3 : ip4
//====================================================================
char *parser_ipaddr(char *dest, const char *src, int pos)
{
        char *ptr;

        strcpy(dest, src);
        ptr=strtok(dest, ".");
        if (pos==0)
                return ptr;
        ptr=strtok(NULL, ".");
        if (pos==1)
                return ptr;
        ptr=strtok(NULL, ".");
        if (pos==2)
                return ptr;
        ptr=strtok(NULL, ".");
        if (pos==3)
                return ptr;
        return NULL;
}

int my_replace(FILE *fptr, char *name, void *arg)
{
        if (!strcmp(name, "ONLOAD"))
        {
        }
        else
	if (!strcmp(name, "restart_object"))
	{
		int *object;
		object=(int *)arg;
		fprintf(fptr, "%d", *object);
	}
	else
	if (!strcmp(name, "INTERNET_URL"))
	{
		int		port;

		if (Get_Web_Access(SYSTEM_WAN_ACCESS)==1)
		{
			port=Get_Web_Access_Port();
			if (port!=80)
				fprintf(fptr, "http://wan ip address:%d/", port);
			else
				fprintf(fptr, "http://wan ip address/");
			fprintf(fptr, "<br>");
		}
		else
			fprintf(fptr, "Disable");
	}
	else
	if (!strcmp(name, "INTRANET_URL"))
	{
		NIC_INFO	nic_info;
		int		port;

		if (Get_Web_Access(SYSTEM_LAN_ACCESS)==1)
		{
			port=Get_Web_Access_Port();
	                NIC_Get_Info(&nic_info, NIC_LAN01);
        	        if (port!=80)
                	        fprintf(fptr, "http://%s:%d/", nic_info.ipaddr, port);
	                else
        	                fprintf(fptr, "http://%s/", nic_info.ipaddr);
		}
		else
			fprintf(fptr, "Disable");
	}
	else
		return CGI_REPLACE_FAIL;
	return CGI_REPLACE_OK;
}

int do_nic_main()
{
	int num=NIC_Count_Interface();

	if  (num == 1 || (num == 2 && NIC_Is_Bonding_Support()) || (num==3 && NIC_Is_Bonding_Support())){
		CGI_Load_Html("/cgi-bin/network/lan_setting/lan_setting.cgi?func=main");
	}
	else {
		do_wan_main();
	}
		

/*        CGI_Output_Html1(NIC_HEADER_HTML, "$", my_replace, NULL);
	CGI_Output_Html1(NIC_MAIN_HEADER_HTML, "$", my_replace, NULL);
	if (NIC_Count_Interface()!=1)
		CGI_Output_Html1(NIC_MAIN_WAN_HTML, "$", my_replace, NULL);
	CGI_Output_Html1(NIC_MAIN_LAN_HTML, "$", my_replace, NULL);
	CGI_Output_Html1(NIC_MAIN_MS_HTML, "$", my_replace, NULL);
	CGI_Output_Html1(NIC_MAIN_APPLE_HTML, "$", my_replace, NULL);
	CGI_Output_Html1(NIC_MAIN_NFS_HTML, "$", my_replace, NULL);
	CGI_Output_Html1(NIC_MAIN_WEBFS_HTML, "$", my_replace, NULL);
	CGI_Output_Html1(NIC_MAIN_FTP_HTML, "$", my_replace, NULL);
	CGI_Output_Html1(NIC_MAIN_DNS_HTML, "$", my_replace, NULL);
	if (Is_Support_Printer())
		CGI_Output_Html1(NIC_MAIN_PRN_HTML, "$", my_replace, NULL);
	CGI_Output_Html1(NIC_MAIN_PDC_HTML, "$", my_replace, NULL);
	CGI_Output_Html1(NIC_MAIN_SNMP_HTML, "$", my_replace, NULL);
	CGI_Output_Html1(NIC_MAIN_VIEW_HTML, "$", my_replace, NULL);
	CGI_Output_Html1(NIC_MAIN_TAIL_HTML, "$", my_replace, NULL);
        CGI_Output_Html1(NIC_TAIL_HTML, "$", my_replace, NULL);
*/
	return NIC_SUCCESS;
}

int show_restart_header()
{
	HEADER_ITEM	header;
	int		nic;

	nic=NIC_Count_Interface();
	header.back[0]=0x0;
	header.home[0]=0x0;
	header.logout[0]=0x0;
	if (nic==2)
	{
		if(Is_Version_22())
			CGI_Get_Help(header.help, "help_network.html#network_wset_main");
		else
			CGI_Get_Help(header.help, "network_wset_main.html");
	}
	else
	{
		if(Is_Version_22())
			CGI_Get_Help(header.help, "help_network.html#network_lset_main");
		else
			CGI_Get_Help(header.help, "network_lset_main.html");
	}
        CGI_Show_Menu_V3_1(FUNC_NETWORK, &header);

        CGI_Output_Html1(MENU_V3_HEADER_HTML, "$", my_replace, NULL);
	if (	(nic==1 && !Is_Support_DNS()) ||
		(nic==2 && NIC_Is_Bonding_Support() && !Is_Support_DNS()) ||
		(nic==3 && NIC_Is_Bonding_Support() && !Is_Support_DNS())) {

		CGI_Show_Menu_V3_2("/home/httpd/cgi-bin/network/network-1.def", 1);
	}
	else {
	        CGI_Show_Menu_V3_2("/home/httpd/cgi-bin/network/network-2.def", 1);
	}
        CGI_Output_Html1(MENU_V3_MIDDLE_HTML, "$", my_replace, NULL);
        return NIC_SUCCESS;
}

int show_restart_tail()
{
        return CGI_Output_Html1(MENU_V3_TAIL_HTML, "$", my_replace, NULL);
}

int do_restart_main(int action)
{
        CGI_Output_Html1(NIC_HEADER_HTML, "$", my_replace, NULL);
	show_restart_header();
	switch (action)
	{
		case NIC_RESTART_WEB:
			break;
		case NIC_RESTART_WAN:
			break;
		case NIC_RESTART_WAN_WEB:
			break;
	}
        CGI_Output_Html1(NIC_RESTART_HTML, "$", my_replace, &action);
        CGI_Output_Html1(NIC_TAIL_HTML, "$", my_replace, NULL);
	show_restart_tail();
	system("/sbin/write_log \"Network setting has been changed, system need to restart.\" 4");
	return NIC_SUCCESS;
}

int do_restart_main_enable()
{
        CGI_Output_Html1(NIC_HEADER_HTML, "$", my_replace, NULL);
        show_restart_header();
        CGI_Output_Html1(NIC_RESTART_OK_HTML, "$", my_replace, NULL);
        CGI_Output_Html1(NIC_TAIL_HTML, "$", my_replace, NULL);
        show_restart_tail();
        return NIC_SUCCESS;
}

int do_restart_main_submit(INPUT *input, int action)
{
	INPUT	*p;
	int	object;
	pid_t	mypid;
	pid_t	parent;
	char	dir[128], buf[128];

	if (action==NIC_RESTART_MAIN_OK)
	{
		if ((p=CGI_Find_Parameter(input, "object"))!=NULL)
		{
			object=atoi(p->val);
		}
		else
		{
			do_nic_main();
			return NIC_SUCCESS;
		}
		if (object==NIC_RESTART_WAN || object==NIC_RESTART_WAN_WEB)
		{
			parent=getpid();
			sprintf(dir, "/proc/%d/exe", parent);
			mypid=fork();
			if (mypid==0)
			{	/* child */
				close(0);
				close(1);
				close(2);
				while (1)
				{
					if (readlink(dir, buf, 256)==-1)
						break;
					sleep(1);
				}
				system("/etc/init.d/network.sh start wan 2>/dev/null 1>/dev/null &");
				exit(1);
			}
			else
				do_restart_main_enable();
		}
		else
		if (object==NIC_RESTART_WEB || object==NIC_RESTART_WAN_WEB)
		{
			parent=getpid();
			sprintf(dir, "/proc/%d/exe", parent);
			mypid=fork();
			if (mypid==0)
			{	/* child */
				close(0);
				close(1);
				close(2);
				while (1)
				{
					if (readlink(dir, buf, 256)==-1)
						break;
					sleep(1);
				}
				system("/etc/init.d/thttpd restart 2>/dev/null 1>/dev/null &");
				exit(1);
			}
			else
				do_restart_main_enable();
		}
		else
			do_nic_main();
	}
	else
	if (action==NIC_RESTART_MAIN_CANCEL)
	{
		do_nic_main();
	}
	return NIC_SUCCESS;
}

int main()
{
	INPUT	*input;
	int	func;
	int	ret=0, menu_select=0;

	CGI_Init();
	CGI_Check_User();
	input=CGI_Get_Input();
	func=get_func(input, &menu_select);
	//CGI_Debug_Input(input);
	switch (func)
	{
		case NIC_MAIN:
			ret=do_nic_main();
			do_nic_error(ret, &menu_select);
			break;
		case NIC_WAN_MAIN:
			ret=do_wan_main();
			do_nic_error(ret, &menu_select);
			break;
		case NIC_WAN_MAIN_OK:
			ret=do_wan_main_submit(input);
			do_nic_error(ret, &menu_select);
			break;
		case NIC_LAN_MAIN:
			ret=do_lan_main();
			do_nic_error(ret, &menu_select);
			break;
		case NIC_LAN_MAIN_OK:
			ret=do_lan_main_submit(input);
			do_nic_error(ret, &menu_select);
			break;
		case NIC_RESTART_MAIN:
			ret=do_nic_main();
			do_nic_error(ret, &menu_select);
			break;
		case NIC_RESTART_MAIN_OK:
			ret=do_restart_main_submit(input, func);
			do_nic_error(ret, &menu_select);
			break;
		case NIC_RESTART_MAIN_CANCEL:
			ret=do_restart_main_submit(input, func);
			do_nic_error(ret, &menu_select);
			break;
		case NIC_MS_MAIN:
			ret=do_ms_main();
			do_ms_error(ret, &menu_select);
			break;
		case NIC_MS_MAIN_OK:
			ret=do_ms_main_submit(input);
			do_ms_error(ret, &menu_select);
			break;
		case NIC_APPLE_MAIN:
			ret=do_apple_main();
			do_nic_error(ret, &menu_select);
			break;
		case NIC_APPLE_MAIN_OK:
			ret=do_apple_main_submit(input);
			do_nic_error(ret, &menu_select);
			break;
		case NIC_NFS_MAIN:
			ret=do_nfs_main();
			do_nic_error(ret, &menu_select);
			break;
		case NIC_NFS_MAIN_OK:
			ret=do_nfs_main_submit(input);
			do_nic_error(ret, &menu_select);
			break;
		case NIC_WEBFS_MAIN:
			ret=do_webfs_main();
			do_nic_error(ret, &menu_select);
			break;
		case NIC_WEBFS_MAIN_OK:
			ret=do_webfs_main_submit(input);
			do_nic_error(ret, &menu_select);
			break;
		case NIC_VIEW_MAIN:
			ret=do_view_main();
			do_nic_error(ret, &menu_select);
			break;
		case NIC_VIEW_MAIN1:
			ret=do_view_main1();
			do_nic_error(ret, &menu_select);
			break;
		case NIC_VIEW_MAIN2:
			ret=do_view_main2();
			do_nic_error(ret, &menu_select);
			break;
		case NIC_VIEW_MAIN_OK:
			ret=do_view_main_submit(input);
			do_nic_error(ret, &menu_select);
			break;
		case NIC_NONE:
			do_nic_error(0, &menu_select);
			break;
//add by jeffrey hsieh 2005/07/22
		case NIC_WEB_MAIN:
			ret=do_web_main();
			break;
		case NIC_WEB_MAIN_OK:
			ret=do_web_main_submit(input);
			break;
		case NIC_PHOTO_MAIN:
			ret=do_photo_main();
			break;
		case NIC_PHOTO_MAIN_OK:
			ret=do_photo_main_submit(input);
			break;
		case NIC_DOWNLOAD_MAIN:
			ret=do_download_main();
			break;
		case NIC_DOWNLOAD_MAIN_OK:
			ret=do_download_main_submit(input);
			break;
//end
	}
	CGI_Free_Input(input);
	return NIC_SUCCESS;
}
