#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "cgi.h"
#include <cfg_nic.h>
#include <config.h>
#include <v2_menu.h>
#include <cfg_printer.h>
#include <cfg_dns.h>
#include "uLinux.h"
#include "config.h"
#include "Util.h"
#include "netware.h"


#define NETWARE_CONF				"/etc/config/uLinux.conf"
#define NETWARE_SERVER_SECTION_NAME		"System"
#define NETWARE_SERVER_SECTION_FIELD		"Netware Server Name"
#define NETWARE_SECTION_NAME			"Netware"
#define	NETWARE_ENABLE_FIELD			"Enable"
#define	NETWARE_SERVER_NAME_FIELD		"Novell Server Name"
#define	NETWARE_Frame_Type_FIELD		"Frame Type"
#define	NETWARE_Internal_Network_Number_FIELD	"Internal Network Number"
#define	NETWARE_External_Network_Number_FIELD	"External Network Number"


char buf[BUF_SIZE];
char Parameter[MAX_PARAMETER_NUMBER][BUF_SIZE];

int g_page = 0;

int get_page (INPUT * input)
{
	int ret = 0;
	INPUT * p = NULL;
	if ((p = CGI_Find_Parameter (input, "page")) != NULL)
		ret = atoi (p->val);
	return ret;
}

static char * get_value (char * keyname, char * default_value)
{
	static char ret[256];
	char buf[256];
	GetProfileString(NETWARE_SECTION_NAME, keyname, default_value, buf, sizeof(buf));
	strcpy (ret, buf);
	return ret;
}

int get_func(INPUT *arg)
{
	int	ret=NETWARE_NOFUNC;
	INPUT	*result;

	if((result=CGI_Find_Parameter(arg, "func")))
	{
		if (!strcmp(result->val, "main"))
			ret=NETWARE_MAIN;
		else if(!strcmp(result->val, "main_ok"))
			ret=NETWARE_OK;
		else if(!strcmp(result->val, "main_ok1"))
			ret=NETWARE_OK1;
	}
	return ret;
}


int Set_Netware_FrameType(char *buff)
{
	int val, ret = SUCCESS;

	val = WriteProfileString(NETWARE_SECTION_NAME, NETWARE_Frame_Type_FIELD, buff);
	if(!val)
		return ERROR_WRITE_FILE;

	return ret;
}

BOOL Is_Internal_Network_Number_Enabled()
{
	GetProfileString(NETWARE_SECTION_NAME, NETWARE_Internal_Network_Number_FIELD, "FALSE", buf, sizeof(buf));
	return IS_TRUE(buf);
}

int Set_Netware_Internal_Network_Number(char *buff)
{
	int val, ret = SUCCESS;
	char processed_buf[64];

	if (strcasecmp(buff, "auto"))
	{
		strcpy (processed_buf, "0x");
		strcat (processed_buf, buff);
	}
	else
		strcpy (processed_buf, buff);

	val = WriteProfileString(NETWARE_SECTION_NAME, NETWARE_Internal_Network_Number_FIELD, processed_buf);
	if(!val)
		return ERROR_WRITE_FILE;

	return ret;
}

BOOL Is_External_Network_Number_Enabled()
{
	GetProfileString(NETWARE_SECTION_NAME, NETWARE_External_Network_Number_FIELD, "FALSE", buf, sizeof(buf));
	return IS_TRUE(buf);
}


int Set_Netware_External_Network_Number(char *buff)
{
	int val, ret = SUCCESS;
	char processed_buf[64];

	if (strcasecmp(buff, "auto"))
	{
		strcpy (processed_buf, "0x");
		strcat (processed_buf, buff);
	}
	else
		strcpy (processed_buf, buff);

	val = WriteProfileString(NETWARE_SECTION_NAME, NETWARE_External_Network_Number_FIELD, processed_buf);
	if(!val)
		return ERROR_WRITE_FILE;

	return ret;
}


int netware_replace(FILE *fptr, char *name, void *arg)
{
	char buf[256];
	char * p = NULL;
	if (!strcmp(name, "Frame_Type"))
	{
		fprintf (fptr, "%s", get_value (NETWARE_Frame_Type_FIELD, "auto"));
	}
	else if (!strcmp(name, "Internal_Network_Number"))
	{
		fprintf (fptr, "%s", get_value (NETWARE_Internal_Network_Number_FIELD, "auto"));
	}
        else if (!strcmp(name, "Internal_Network_Number_Value"))
	{
		strcpy (buf, get_value (NETWARE_Internal_Network_Number_FIELD, "auto"));
		if (strcmp (buf, "auto"))
		{
			p = strchr (buf, 'x');
			if (p && strlen (p + 1) > 0)
				fprintf (fptr, "%s", p + 1);
			else
				fprintf (fptr, "%s", buf);
		}
	}
        else if (!strcmp(name, "Internal_Network_Number_Value_disabled"))
	{
		strcpy (buf, get_value (NETWARE_Internal_Network_Number_FIELD, "auto"));
		if (!strcmp ("auto", buf))
			fprintf (fptr, "disabled");
	}
        else if (!strcmp(name, "External_Network_Number"))
	{
		fprintf (fptr, "%s", get_value (NETWARE_External_Network_Number_FIELD, "auto"));
	}
        else if (!strcmp(name, "External_Network_Number_Value"))
	{
		strcpy (buf, get_value (NETWARE_External_Network_Number_FIELD, "auto"));
		if (strcmp (buf, "auto"))
		{
			p = strchr (buf, 'x');
			if (p && strlen (p + 1) > 0)
				fprintf (fptr, "%s", p + 1);
			else
				fprintf (fptr, "%s", buf);
		}
	}
        else if (!strcmp(name, "External_Network_Number_Value_disabled"))
	{
		strcpy (buf, get_value (NETWARE_External_Network_Number_FIELD, "auto"));
		if (!strcmp ("auto", buf))
			fprintf (fptr, "disabled");
	}
        else if (!strcmp(name, "ENABLE"))
        {
               	if (g_page == 0 || g_page == 1)
               	{
               		if (Is_Netware_Enabled())
               			fprintf(fptr, "checked");
                }
                else
                {
                	if(Is_Netware_Enabled())
                		fprintf (fptr, "ON");
                	else
                		fprintf (fptr, "OFF");
                }
        }
	else if (!strcmp(name, "Server_Name_NW_disabled"))
        {
		if (!Is_Netware_Enabled())
			fprintf(fptr, "disabled");
        }
        else if (!strcmp(name, "Server_Name_NW"))
	{
		Get_Netware_Server_Name (buf, sizeof (buf));
		fprintf (fptr, "%s", buf);
	}
        else if (!strcmp(name, "Frame_Type_Auto"))
	{
		strcpy (buf, get_value (NETWARE_Frame_Type_FIELD, "auto"));
		if (!strcmp (buf, "auto"))
			fprintf (fptr, "selected");
	}
        else if (!strcmp(name, "Frame_Type_Ethernet"))
	{
		strcpy (buf, get_value (NETWARE_Frame_Type_FIELD, "auto"));
		if (!strcmp (buf, "ethernet_ii"))
			fprintf (fptr, "selected");
	}
        else if (!strcmp(name, "Frame_Type_Snap"))
	{
		strcpy (buf, get_value (NETWARE_Frame_Type_FIELD, "auto"));
		if (!strcmp (buf, "snap"))
			fprintf (fptr, "selected");
	}
        else if (!strcmp(name, "Frame_Type_802_2"))
	{
		strcpy (buf, get_value (NETWARE_Frame_Type_FIELD, "auto"));
		if (!strcmp (buf, "802.2"))
			fprintf (fptr, "selected");
	}
        else if (!strcmp(name, "Frame_Type_802_3"))
	{
		strcpy (buf, get_value (NETWARE_Frame_Type_FIELD, "auto"));
		if (!strcmp (buf, "802.3"))
			fprintf (fptr, "selected");
	}
        else if (!strcmp(name, "Internal_Network_Number_auto"))
	{
		strcpy (buf, get_value (NETWARE_Internal_Network_Number_FIELD, "auto"));
		if (!strcmp ("auto", buf))
			fprintf (fptr, "checked");
	}
        else if (!strcmp(name, "Internal_Network_Number_manual"))
	{
		strcpy (buf, get_value (NETWARE_Internal_Network_Number_FIELD, "auto"));
		if (strcmp ("auto", buf))
			fprintf (fptr, "checked");
	}
        else if (!strcmp(name, "External_Network_Number_auto"))
	{
		strcpy (buf, get_value (NETWARE_External_Network_Number_FIELD, "auto"));
		if (!strcmp ("auto", buf))
			fprintf (fptr, "checked");
	}
        else if (!strcmp(name, "External_Network_Number_manual"))
	{
		strcpy (buf, get_value (NETWARE_External_Network_Number_FIELD, "auto"));
		if (strcmp ("auto", buf))
			fprintf (fptr, "checked");
	}
	else if (!strcmp (name, "page"))
	{
		fprintf (fptr, "0");
	}
        else
        	return CGI_REPLACE_FAIL;

	return CGI_REPLACE_OK;
}

int select_replace(FILE *fptr, char *name, void *arg)
{
	INPUT * input = (INPUT *)arg, * p = NULL;

	if (!strcmp(name, "Frame_Type"))
	{
		if (g_page == 1)
		{
			if ((p = CGI_Find_Parameter (input, "Frame_Type")) != NULL)
				fprintf (fptr, "%s", p->val);
		}

	}
	else if (!strcmp(name, "Internal_Network_Number"))
	{
		if (g_page == 1)
		{
			if ((p = CGI_Find_Parameter (input, "Internal_Network_Number")) != NULL)
				fprintf (fptr, "%s", p->val);
		}
	}
        else if (!strcmp(name, "Internal_Network_Number_Value"))
	{
		if ((p = CGI_Find_Parameter (input, "Internal_Network_Number_Value")) != NULL)
			fprintf (fptr, "%s", p->val);
	}
        else if (!strcmp(name, "Internal_Network_Number_Value_disabled"))
	{
		strcpy (buf, get_value (NETWARE_Internal_Network_Number_FIELD, "auto"));
		if (!strcmp ("auto", buf))
			fprintf (fptr, "disabled");
	}
        else if (!strcmp(name, "External_Network_Number"))
	{
		if (g_page == 1)
		{
			if ((p = CGI_Find_Parameter (input, "External_Network_Number")) != NULL)
				fprintf (fptr, "%s", p->val);
		}
	}
        else if (!strcmp(name, "External_Network_Number_Value"))
	{
		if ((p = CGI_Find_Parameter (input, "External_Network_Number_Value")) != NULL)
			fprintf (fptr, "%s", p->val);
	}
        else if (!strcmp(name, "ENABLE"))
        {
                if (g_page == 1)
                {
                	if ((p = CGI_Find_Parameter (input, "ENABLE")) != NULL)
                		fprintf(fptr, "checked");
                }
                else
                {
                	if ((p = CGI_Find_Parameter (input, "ENABLE")) != NULL)
                		fprintf (fptr, "ON");
                	else
                		fprintf (fptr, "OFF");
                }
        }
        else if (!strcmp(name, "Server_Name_NW"))
	{
		if ((p = CGI_Find_Parameter (input, "Server_Name_NW")) != NULL)
			fprintf (fptr, "%s", p->val);
	}
        else if (!strcmp(name, "Frame_Type_Auto"))
	{
		if ((p = CGI_Find_Parameter (input, "Frame_Type")) != NULL)
		{
			if(!strcmp(p->val,"auto"))
				fprintf (fptr, "selected");
		}
	}
        else if (!strcmp(name, "Frame_Type_Ethernet"))
	{
		if ((p = CGI_Find_Parameter (input, "Frame_Type")) != NULL)
		{
			if(!strcmp(p->val,"ethernet_ii"))
				fprintf (fptr, "selected");
		}
	}
        else if (!strcmp(name, "Frame_Type_Snap"))
	{
		if ((p = CGI_Find_Parameter (input, "Frame_Type")) != NULL)
		{
			if(!strcmp(p->val,"snap"))
				fprintf (fptr, "selected");
		}
	}
        else if (!strcmp(name, "Frame_Type_802_2"))
	{
		if ((p = CGI_Find_Parameter (input, "Frame_Type")) != NULL)
		{
			if(!strcmp(p->val,"802.2"))
				fprintf (fptr, "selected");
		}
	}
        else if (!strcmp(name, "Frame_Type_802_3"))
	{
		if ((p = CGI_Find_Parameter (input, "Frame_Type")) != NULL)
		{
			if(!strcmp(p->val,"802.3"))
				fprintf (fptr, "selected");
		}
	}
	else if (!strcmp(name, "Internal_Network_Number_auto"))
	{
		if ((p = CGI_Find_Parameter (input, "Internal_Network_Number")) != NULL)
		{
			if (!strcmp ("auto", p->val))
				fprintf (fptr, "checked");
		}
	}
        else if (!strcmp(name, "Internal_Network_Number_manual"))
	{
		if ((p = CGI_Find_Parameter (input, "Internal_Network_Number")) != NULL)
		{
			if (strcmp ("auto", p->val))
				fprintf (fptr, "checked");
		}
	}
        else if (!strcmp(name, "External_Network_Number_auto"))
	{
		if ((p = CGI_Find_Parameter (input, "External_Network_Number")) != NULL)
		{
			if (!strcmp ("auto", p->val))
				fprintf (fptr, "checked");
		}
	}
        else if (!strcmp(name, "External_Network_Number_manual"))
	{
		if ((p = CGI_Find_Parameter (input, "External_Network_Number")) != NULL)
		{
			if (strcmp ("auto", p->val))
				fprintf (fptr, "checked");
		}
	}
	else if (!strcmp (name, "page"))
	{
		if ((p = CGI_Find_Parameter (input, "page")) != NULL)
			fprintf (fptr, "%s", p->val);
	}
        else
        	return CGI_REPLACE_FAIL;

	return CGI_REPLACE_OK;
}

int set_checked()
{
	char buf[256];

	// Frame_type
	GetProfileString(NETWARE_SECTION_NAME, NETWARE_Frame_Type_FIELD, "auto", buf, sizeof(buf));
	if(!strcmp(buf,"auto"))
		strncpy(Parameter[3], "checked", sizeof(Parameter[3]));
	else if(!strcmp(buf,"ethernet_ii"))
		strncpy(Parameter[4], "checked", sizeof(Parameter[4]));
	else if(!strcmp(buf,"snap"))
		strncpy(Parameter[5], "checked", sizeof(Parameter[5]));
	else if(!strcmp(buf,"802.2"))
		strncpy(Parameter[6], "checked", sizeof(Parameter[6]));
	else if(!strcmp(buf,"802.3"))
		strncpy(Parameter[7], "checked", sizeof(Parameter[7]));
	// Internal Network number
	GetProfileString(NETWARE_SECTION_NAME, NETWARE_Internal_Network_Number_FIELD, "auto", buf, sizeof(buf));
	if(strcmp(buf,"auto")) {
		strncpy(Parameter[9], "checked", sizeof(Parameter[9]));
		strcpy(Parameter[1], buf);
	}
	else
		strncpy(Parameter[8], "checked", sizeof(Parameter[8]));

	// External network number
	GetProfileString(NETWARE_SECTION_NAME, NETWARE_External_Network_Number_FIELD, "auto", buf, sizeof(buf));
	if(strcmp(buf,"auto")) {
		strncpy(Parameter[11], "checked", sizeof(Parameter[11]));
		strcpy(Parameter[2], buf);
	}
	else
		strncpy(Parameter[10], "checked", sizeof(Parameter[10]));
	return SUCCESS;
}


int show_netware_header ()
{
        HEADER_ITEM     header;
	int	nic_count;

	CGI_Output_Html1(NETWARE_HEADER_HTML, "$", netware_replace,NULL);

	header.back[0]=0x0;
        header.home[0]=0x0;
        header.logout[0]=0x0;
	if(Is_Version_22())
		CGI_Get_Help(header.help, "help_network.html#network_netware_main");
	else
		CGI_Get_Help(header.help, "network_netware_main.html");
        CGI_Show_Menu_V3_1(FUNC_NETWORK, &header);

	CGI_Output_Html1(MENU_V3_HEADER_HTML, "$", netware_replace, NULL);
	nic_count=NIC_Count_Interface();
	if (	(nic_count==1 && !Is_Support_DNS()) ||
		(nic_count==2 && NIC_Is_Bonding_Support() && !Is_Support_DNS()) ||
		(nic_count==3 && NIC_Is_Bonding_Support() && !Is_Support_DNS()))
		if(!Is_Support_Printer())
			CGI_Show_Menu_V3_2("/home/httpd/cgi-bin/network/network-1.noprndns.def", 5);
		else
			CGI_Show_Menu_V3_2("/home/httpd/cgi-bin/network/network-1.nodns.def", 5);
	else
		CGI_Show_Menu_V3_2("/home/httpd/cgi-bin/network/nas_services.def", 4);
	CGI_Output_Html1(MENU_V3_MIDDLE_HTML, "$", netware_replace, NULL);
	return NIC_SUCCESS;
}


int show_netware_tail ()
{
	CGI_Output_Html1(MENU_V3_TAIL_HTML, "$", netware_replace, NULL);
	CGI_Output_Html1(NETWARE_TAIL_HTML, "$", netware_replace, NULL);

	return SUCCESS;
}


void show_nw_server_name()
{
	Get_Netware_Server_Name(Parameter[0], sizeof(Parameter[0]));
}


//
// Basic page description
//
int do_netware_main(INPUT * form, int func)
{
	int i;

	show_netware_header();
	if (g_page == 1)
	{
		CGI_Output_Html1(NETWARE_BASIC_HTML, "$", select_replace, form);
	}
	else if (g_page == 2)
	{
		CGI_Output_Html1(NETWARE_ADVANCE_HTML, "$", select_replace, form);
	}
	else
	{
		if (func == NETWARE_MAIN || func == NETWARE_OK)
			CGI_Output_Html1(NETWARE_BASIC_HTML, "$", netware_replace, NULL);
		else
			CGI_Output_Html1(NETWARE_ADVANCE_HTML, "$", netware_replace, NULL);
	}

	for(i = 0; i < MAX_PARAMETER_NUMBER; i++)
		memset(Parameter[i], 0, BUF_SIZE);

	show_nw_server_name();

	if (g_page == 1)
	{
		CGI_Output_Html1(NETWARE_MAIN_HTML, "$", select_replace, form);
	}
	else if (g_page == 2)
	{
		set_checked();
                CGI_Output_Html1(NETWARE_MAIN_HTML1, "$", select_replace, form);
	}
	else
	{
		if (func == NETWARE_MAIN || func == NETWARE_OK)
		{
			CGI_Output_Html1(NETWARE_MAIN_HTML, "$", netware_replace, NULL);
		}
		else
		{
			set_checked();
                	CGI_Output_Html1(NETWARE_MAIN_HTML1, "$", netware_replace, form);
		}
	}

	show_netware_tail();

        return 1;
}

int do_netware_submit_basic(INPUT *input)
{
        INPUT   *tmp;
        char buf[256];

	if((tmp = CGI_Find_Parameter(input, "Server_Name_NW"))) {
		Get_Netware_Server_Name(buf, sizeof(buf)) ;
		if(strcmp(buf, tmp->val))
			Set_Netware_Server_Name(tmp->val, 0);
	}

        if (CGI_Find_Parameter(input, "ENABLE"))
               	Enable_Netware(1);
	else
		Enable_Netware(0);

        return NIC_SUCCESS;
}

int do_netware_submit_adv(INPUT *input)
{
        INPUT   *tmp,*tmp1;

       if ((tmp=CGI_Find_Parameter(input, "Frame_Type")))
		Set_Netware_FrameType(tmp->val);

       if ((tmp=CGI_Find_Parameter(input, "Internal_Network_Number"))) {
    		if (!strcmp(tmp->val, "auto"))
               		Set_Netware_Internal_Network_Number(tmp->val);
  		else if (!strcmp(tmp->val, "Manual")){
  			if ((tmp1=CGI_Find_Parameter(input, "Internal_Network_Number_Value")))
				Set_Netware_Internal_Network_Number(tmp1->val);
   		}
  	}


	if ((tmp=CGI_Find_Parameter(input, "External_Network_Number")))
	{
		if (!strcmp(tmp->val, "auto"))
               		Set_Netware_External_Network_Number(tmp->val);
  		else if (!strcmp(tmp->val, "Manual"))
  		{
  			if ((tmp1=CGI_Find_Parameter(input, "External_Network_Number_Value")))
  				Set_Netware_External_Network_Number(tmp1->val);
   		}
  	}

        return NIC_SUCCESS;
}


int main()
{
	INPUT	*arg=NULL, *form=NULL;
	int	func;

	CGI_Init();
	CGI_Check_User();
	arg=CGI_Get_Input_URL();
	form=CGI_Get_Input_FORM();
//	CGI_Debug_Input(form);
//	CGI_Debug_Input(arg);

	func=get_func(arg);
	g_page = get_page (form);

	switch (func)
	{
	case NETWARE_MAIN:  //  basic page
		do_netware_main(form, func);
		break;
	case NETWARE_OK:
	case NETWARE_OK1:
		if (!g_page) {
			do_netware_submit_adv(form);
			do_netware_submit_basic(form);
		}
		do_netware_main(form, func);
		break;
	case NETWARE_NOFUNC:
		break;
	}

	CGI_Free_Input(arg);
	CGI_Free_Input(form);
	return SUCCESS;
}

