//**************************************************************************
//
//	Copyright (c) 2001  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		lan_main.c
//
//	Abstract:
//		LAN main cgi
//
//	FUNCTIONS:
//
//	COMMENTS:
//
//	HISTORY:
//		V1.0  2001/07/21		Tiger Fu created
//		V2.11 2002/02/23		Tiger Fu added function
//						add tab link (WLAN)
//
//**************************************************************************
#include 	<stdio.h>
#include 	<string.h>
#include 	<stdlib.h>

/* NAS lib */
#include	<cgi.h>
#include	<Util.h>
#include	<cfg_dhcp.h>
#include	<cfg_nic.h>
#include 	<cfg_fw.h>
#include 	<v2_menu.h>
#include	<stdarg.h>

//#include	"dhcpdconf.h"
#include 	"lan_main.h"
#include "../../CGI2.1/icp.h"

extern void LOG_TABLE_COL(FILE *fp, int, char *, char *, char *);
extern ACTIVE_USER_INFO *count_active_user(int *real);
extern void show_active_user(FILE *fp, ACTIVE_USER_INFO *active, int);

#define		OBJSTARTRANGE				"ObjStartAddress"
#define		OBJENDRANGE				"ObjEndAddress"
#define		OBJRESERVESTART1			"ObjReserveStartAddress1_"
#define		OBJRESERVEEND1				"ObjReserveEndAddress1_"
#define		OBJRESERVESTART2			"ObjReserveStartAddress2_"
#define		OBJRESERVEEND2				"ObjReserveEndAddress2_"

#define		LAST_PAGE				"/cgi-bin/network/lan_setting/lan_setting.cgi?func=main&counter=%d"

#define		QUERY_RESTART_PAGE			"/home/httpd/cgi-bin/network/lan_setting/html/templet_restart.html"
#define		RESTARTING_PAGE				"/home/httpd/cgi-bin/network/lan_setting/html/restarting.html"

#define		MAIN_TITLE_PAGE				"/home/httpd/cgi-bin/network/lan_setting/html/main_title.html"
#define		SWITCH_TITLE_PAGE			"/home/httpd/cgi-bin/network/lan_setting/html/switch_title.html"
#define		ERROR_TITLE_PAGE			"/home/httpd/cgi-bin/network/lan_setting/html/error_title.html"
#define		RESTART_TITLE_PAGE			"/home/httpd/cgi-bin/network/lan_setting/html/restart_title.html"
#define		RESTARTING_TITLE_PAGE			"/home/httpd/cgi-bin/network/lan_setting/html/restarting_title.html"

#define		TABLE_TITLE_PAGE			"/home/httpd/cgi-bin/network/lan_setting/html/lan_table_title.html"
#define		TAB_SELECT_PAGE				"/home/httpd/cgi-bin/network/lan_setting/html/tab_select.html"
#define		CAPTION_PAGE				"/home/httpd/cgi-bin/network/lan_setting/html/lan_caption.html"
#define		CAPTION2_PAGE				"/home/httpd/cgi-bin/network/lan_setting/html/lan_caption2.html"
#define		LAN_SETTING				"/home/httpd/cgi-bin/network/lan_setting/html/templet_lan_setting.html"
#define		IP_SETTING_PAGE				"/home/httpd/cgi-bin/network/lan_setting/html/templet_static_ip.html"
#define		DHCP_MAIN_PAGE				"/home/httpd/cgi-bin/network/lan_setting/html/templet_dhcp_main.html"
#define		DNS_SETTING_PAGE			"/home/httpd/cgi-bin/network/lan_setting/html/dns_setting.html"
#define		DNS_SETTING_EX_PAGE			"/home/httpd/cgi-bin/network/lan_setting/html/dns_setting_ex.html" //added by YFHUANG 2004/4/21
#define		NAT_PAGE				"/home/httpd/cgi-bin/network/lan_setting/html/templet_nat_setting.html"
#define		RESERVE_RANGE_PAGE			"/home/httpd/cgi-bin/network/lan_setting/html/templet_dhcp_reserve_range.html"
#define		BONDING_PAGE				"/home/httpd/cgi-bin/network/lan_setting/html/templet_bonding.html"
#define		MAIN_SUBMIT_PAGE			"/home/httpd/cgi-bin/network/lan_setting/html/templet_main_submit.html"
#define		TABLE_TAIL_PAGE				"/home/httpd/cgi-bin/network/lan_setting/html/lan_table_tail.html"
#define		NETLINKS_SETTING_PAGE			"/home/httpd/cgi-bin/network/lan_setting/html/templet_NetLinks_setting.html"
#define		NETLINKS_TABS				"/home/httpd/cgi-bin/network/lan_setting/html/NetLink_Tabs.html"
//#define		NETLINKS_CONF_PATH			"/home/httpd/cgi-bin/network/lan_setting/NetLinks.conf"
#define		LAN_ASSIGN_SETTING_HEAD			"/home/httpd/cgi-bin/network/lan_setting/html/lan_assign_setting_head.html"
#define		LAN_ASSIGN_SETTING_TAIL			"/home/httpd/cgi-bin/network/lan_setting/html/lan_assign_setting_tail.html"

#define		MAIN_TAIL_PAGE				"/home/httpd/cgi-bin/network/lan_setting/html/main_tail.html"
#define		REDIRECT_PAGE				"/home/httpd/cgi-bin/network/lan_setting/html/redirect.html"
#define		LINK_WARNING_PAGE			"/home/httpd/cgi-bin/network/lan_setting/html/link_add_warning.html"
#define		NETWORK_SPEED_PAGE			"/home/httpd/cgi-bin/network/lan_setting/html/network_speed.html"
#define		MULTI_LAN_TAB_PAGE			"/home/httpd/cgi-bin/network/lan_setting/html/mlan_tab.html"
#define		MULTI_LAN_STATIC_IP_PAGE		"/home/httpd/cgi-bin/network/lan_setting/html/mlan_static_ip.html"

#define		ERROR_INPUT				"ERROR_INPUT"

#define 	NETLINKS_CONF_FILE			"/etc/config/NetLinks.conf"
//#define		_DEBUG

#if	0
  #define		SYSTEM_RESTART				"date +%Y/%m/%d-%H:%M:%S > /root/lan_restart_test"
#else
  #define		SYSTEM_RESTART				"/sbin/reboot"
#endif
//--add by KenChen 20060330
#define JUMBO_FRAME_SET_PAGE		"/home/httpd/cgi-bin/network/lan_setting/html/jumbo_frame_setting.html"
//--end here
//modified by jeffrey hsieh
char *szDefineFilePath[] = {"/home/httpd/cgi-bin/network/network.def"};
/*
char *szDefineFilePath[] = {"/home/httpd/cgi-bin/network/network-1.def",
			    "/home/httpd/cgi-bin/network/network-1.nodns.def",
			    "/home/httpd/cgi-bin/network/network-1.noprn.def",
			    "/home/httpd/cgi-bin/network/network.def",
			    "/home/httpd/cgi-bin/network/network-2.def",
			    "/home/httpd/cgi-bin/network/network-2.nodns.def",
			    "/home/httpd/cgi-bin/network/network-2.noprn.def",
			    "/home/httpd/cgi-bin/network/network-2.noprndns.def"};
*/
char szRangeArray[] = "\n\t\t\t<b>.</b><input type=text name=%s%d size=3 maxlength=3 value=\"%d\" tabindex=\"2\" onFocus=\"onInput(this.form)\">";

char szReserveRangeArray[] = "\n\t\t\t<b>.</b><input type=text name=%s%d size=3 maxlength=3 value=\"%d\" tabindex=\"12\">";

char szCheckInput[] = "	\n\t\t\t\tif (form.%s%d.value == \"\" || isNaN (form.%s%d.value) || \
				    Number(form.%s%d.value) >= %d || Number(form.%s%d.value) <= %d) { \
					alert (\"%s\"); \
					return false; \
				}";

static NIC_NAS_INFO	g_nic_nas_info;
static struct dhcp_conf g_config;
int g_def_file_type = 0; //  0 -->  1 network interface support all
			 //  1 -->  1 network interface without dns
			 //  2 -->  1 network interface without printer
			 //  3 -->  1 network interface without all

			 //  4 -->  2 network interface support all
			 //  5 -->  2 network interface without dns
			 //  6 -->  2 network interface without printer
			 //  7 -->  2 network interface without all
// Catherine ==>
BOOL is_switch_support = TRUE;	// TRUE		--> support switch
				// FALSE	--> no switch

BOOL is_lan_page = TRUE;	// TRUE		--> LAN setting
				// FALSE	--> Switch setting

BOOL Tab_Clicked = FALSE;	// YF		
char tab_name[16] = "";		// YF
char cur_tab_name[32];		// YF
char tab_style[] = "TAB-2";	// YF
char speed[80]="";

void show_switch (void);
// <== Catherine

INPUT *arg=NULL;
INPUT *form=NULL;

void DebugOutput(char *msg, ...)
{
	FILE *dout;
	char buf[2048];
	va_list args;

	va_start(args, msg);
	vsnprintf(buf, sizeof(buf)-1, msg, args);
	va_end(args);

	dout = fopen("/home/httpd/cgi-bin/cgi.debug", "a");
	fputs(buf, dout);
	fclose(dout);
}


int main ()
{
	INPUT	*tmp = NULL;//*arg=NULL, *form=NULL, 
	char	buf[256];
	int	func;
	int	errno;

	sprintf (buf, LAST_PAGE, time (NULL));
	memset (&g_nic_nas_info, '\0', sizeof (g_nic_nas_info));
	memset (&g_config, '\0', sizeof (g_config));

	CGI_Init();
	CGI_Check_User ();

// Catherine ==>
//	NIC_Get_Info_From_uLinux (&g_nic_nas_info, NIC_LAN01);
//	g_def_file_type = get_def_type ();
	is_switch_support = NIC_Is_Switch_Support();
// <== Catherine
		
#ifdef	_USE_PRIVATE_CONF
	if (!check_dhcp_conf_exist ())
		create_dhcp_conf ();
#endif
	
	arg=(INPUT *)CGI_Get_Input_URL();
	form=(INPUT *)CGI_Get_Input_FORM();

#ifdef _DEBUG
	CGI_Debug_Input(arg);
	CGI_Debug_Input(form);
#endif

	read_dhcp_conf (&g_config);
	if (g_config.nOperate == 1)
		create_dhcpd_conf (g_config);
			
	func=get_func(arg);
#ifdef _DEBUG
	printf ("func = %d<br>\n", func);
#endif

	switch (func)
	{ 
		case LANMAIN:
		case MLAN_FAIL_OVER:
		case MLAN_LOAD_BALANCE:
		case MLAN_STANDALONE:
			show_main ();
			break;
		case LANOK:
			{
				int check_result = 0,ret;
				check_result = check_input (form);

				if (check_result)
				{
					show_error (ERROR_INPUT);
				}
				else
				{
					ret=lan_submit(form);			
					if (ret == NIC_RESTART)
					{
						show_reboot ();
					}
					else if (ret==LAN_PROCEED )//Shone
					       show_main ();
					else if(ret==LAN_REPEATED)
					         show_error("ERROR_IP_REPEATED");       
					else
					{
#ifndef _DEBUG
						CGI_Load_Html (buf);
#endif
					}
				}
			}
			break;
		case SWITCH_MAIN:
			show_switch ();
			break;
		case SWITCH_OK:
			{
				if (switch_submit(form) == NIC_RESTART)
				{
					show_reboot ();
				}
				else
				{
#ifndef _DEBUG
					CGI_Load_Html (buf);
#endif
				}
			}
			break;
		case LAN_QUERY_RESTART:
			if (query_restart (arg))
			{
				show_restarting ();
				begin_restart ();
			}
			else
				CGI_Load_Html (buf);
			break;

		case LANNOFUNC:
			break;
	}

	CGI_Free_Input(arg);
	CGI_Free_Input(form);

	return LANSUCCESS;
}

int get_func (INPUT *arg)
{
	int	ret = LANNOFUNC;
	INPUT	*parg;

	parg=arg;
	while (parg!=NULL)
	{
		if (!strcmp (parg->name, "func"))
		{
			if (!strcmp (parg->val, "main"))
				ret = LANMAIN;
			else if (!strcmp (parg->val, "mlan_failover"))
				ret = MLAN_FAIL_OVER;
			else if (!strcmp (parg->val, "mlan_loadbalance"))
				ret = MLAN_LOAD_BALANCE;
			else if (!strcmp (parg->val, "mlan_standalone"))
				ret = MLAN_STANDALONE;
			else if (!strcmp (parg->val, "switch_main"))
				ret = SWITCH_MAIN;
			else if (!strcmp (parg->val, "OK"))
				ret = LANOK;
			else if (!strcmp (parg->val, "Switch_OK"))
				ret = SWITCH_OK;
			else if (!strcmp (parg->val, "query-restart"))
				ret = LAN_QUERY_RESTART;
			break;
		}
		parg=(INPUT *)parg->next;
	}
	return ret;
}

int nat_replace (FILE * fp, char * oldstr)
{
	if (fp == NULL)
		return -1;
	if (!strcmp (oldstr, "use_nat"))
	{
		if (!FW_Is_NAT_Enable ())
			fprintf (fp, "checked");
	} else if(!strcmp(oldstr, "START_HERE")){
		int real_count = 0;
		//marked by jeffrey 2005/09/15
		//ACTIVE_USER_INFO *active = count_active_user(&real_count);
		//Shone marked 2006,01,10
		//fprintf(fp, "<p>&nbsp;</p>\n");
		//fprintf(fp, "<SCRIPT Language=\"JavaScript\">document.write(IEI_IDS_STRING160)</SCRIPT><br>\n");
		//show_active_user(fp, active, real_count);
		//if (active != NULL)
		//	free(active);
	}
	else
		return CGI_REPLACE_FAIL;
	return CGI_REPLACE_OK;
}

int ip_replace (FILE * fp, char * oldstr)
{
	if (fp == NULL)
		return -1;
	if (!strcmp (oldstr, "StaticIP1"))
		fprintf (fp, "%d", parser_ip (g_nic_nas_info.ifconfig.ipaddr, 1));
	else if (!strcmp (oldstr, "StaticIP2"))
		fprintf (fp, "%d", parser_ip (g_nic_nas_info.ifconfig.ipaddr, 2));
	else if (!strcmp (oldstr, "StaticIP3"))
		fprintf (fp, "%d", parser_ip (g_nic_nas_info.ifconfig.ipaddr, 3));
	else if (!strcmp (oldstr, "StaticIP4"))
		fprintf (fp, "%d", parser_ip (g_nic_nas_info.ifconfig.ipaddr, 4));
	else if (!strcmp (oldstr, "StaticIP_disabled")) {
		if (get_usage () == NIC_USE_DHCP)
			fprintf (fp, "disabled");
	}
	else if (strstr (oldstr, "net_mask2"))
	{
		char buf[5];
		memset (buf, '\0', sizeof (buf));
		sprintf (buf, "_%d", parser_ip (g_nic_nas_info.ifconfig.netmask, 2));

		if (strstr (oldstr, buf))
			fprintf (fp, "selected");
	}
	else if (strstr (oldstr, "net_mask3"))
	{
		char buf[5];
		memset (buf, '\0', sizeof (buf));
		sprintf (buf, "_%d", parser_ip (g_nic_nas_info.ifconfig.netmask, 3));

		if (strstr (oldstr, buf))
			fprintf (fp, "selected");
	}
	else if (strstr (oldstr, "net_mask4"))
	{
		char buf[5];
		memset (buf, '\0', sizeof (buf));
		sprintf (buf, "_%d", parser_ip (g_nic_nas_info.ifconfig.netmask, 4));

		if (strstr (oldstr, buf))
			fprintf (fp, "selected");
	}
	else if (!strcmp (oldstr, "Gateway1"))
		fprintf (fp, "%d", parser_ip (g_nic_nas_info.ifconfig.gateway, 1));
	else if (!strcmp (oldstr, "Gateway2"))
		fprintf (fp, "%d", parser_ip (g_nic_nas_info.ifconfig.gateway, 2));
	else if (!strcmp (oldstr, "Gateway3"))
		fprintf (fp, "%d", parser_ip (g_nic_nas_info.ifconfig.gateway, 3));
	else if (!strcmp (oldstr, "Gateway4"))
		fprintf (fp, "%d", parser_ip (g_nic_nas_info.ifconfig.gateway, 4));
	else
		return CGI_REPLACE_FAIL;
	return CGI_REPLACE_OK;
}


int NLK_ip_replace (FILE * fp, char * oldstr)
{
	if (fp == NULL)
		return -1;
	if (!strcmp (oldstr, "StaticIP1"))
		fprintf (fp, "%d", parser_ip (g_nic_nas_info.ifconfig.ipaddr, 1));
	else if (!strcmp (oldstr, "StaticIP2"))
		fprintf (fp, "%d", parser_ip (g_nic_nas_info.ifconfig.ipaddr, 2));
	else if (!strcmp (oldstr, "StaticIP3"))
		fprintf (fp, "%d", parser_ip (g_nic_nas_info.ifconfig.ipaddr, 3));
	else if (!strcmp (oldstr, "StaticIP4"))
		fprintf (fp, "%d", parser_ip (g_nic_nas_info.ifconfig.ipaddr, 4));
	else if (!strcmp (oldstr, "StaticIP_disabled")) {
		if (get_usage () == NIC_USE_DHCP)
			fprintf (fp, "disabled");
	}
	else if (strstr (oldstr, "net_mask2"))
	{
		char buf[5];
		memset (buf, '\0', sizeof (buf));
		sprintf (buf, "_%d", parser_ip (g_nic_nas_info.ifconfig.netmask, 2));

		if (strstr (oldstr, buf))
			fprintf (fp, "selected");
	}
	else if (strstr (oldstr, "net_mask3"))
	{
		char buf[5];
		memset (buf, '\0', sizeof (buf));
		sprintf (buf, "_%d", parser_ip (g_nic_nas_info.ifconfig.netmask, 3));

		if (strstr (oldstr, buf))
			fprintf (fp, "selected");
	}
	else if (strstr (oldstr, "net_mask4"))
	{
		char buf[5];
		memset (buf, '\0', sizeof (buf));
		sprintf (buf, "_%d", parser_ip (g_nic_nas_info.ifconfig.netmask, 4));

		if (strstr (oldstr, buf))
			fprintf (fp, "selected");
	}
	else if (!strcmp (oldstr, "Gateway1"))
		fprintf (fp, "%d", parser_ip (g_nic_nas_info.ifconfig.gateway, 1));
	else if (!strcmp (oldstr, "Gateway2"))
		fprintf (fp, "%d", parser_ip (g_nic_nas_info.ifconfig.gateway, 2));
	else if (!strcmp (oldstr, "Gateway3"))
		fprintf (fp, "%d", parser_ip (g_nic_nas_info.ifconfig.gateway, 3));
	else if (!strcmp (oldstr, "Gateway4"))
		fprintf (fp, "%d", parser_ip (g_nic_nas_info.ifconfig.gateway, 4));
	else
		return CGI_REPLACE_FAIL;
	return CGI_REPLACE_OK;
}

int dns_replace (FILE * fp, char * oldstr)
{
	char buf1[32], buf2[32];
	char link_section[80];
	
	if (fp == NULL)
		return -1;
	
	memset (buf1, '\0', 32);
	GET_PROFILE_STRING (DHCP_SECTION, "Domain Name Server 1", "0.0.0.0", buf1, 32);
	memset (buf2, '\0', 32);
	GET_PROFILE_STRING (DHCP_SECTION, "Domain Name Server 2", "0.0.0.0", buf2, 32);

	if (!strcmp (oldstr, "Primary_DNS1"))
	{
		fprintf (fp,"%d", parser_ip (buf1, 1));
	}
	else if (!strcmp (oldstr, "Primary_DNS2"))
	{
		fprintf (fp,"%d", parser_ip (buf1, 2));
	}
	else if (!strcmp (oldstr, "Primary_DNS3"))
	{
		fprintf (fp,"%d", parser_ip (buf1, 3));
	}
	else if (!strcmp (oldstr, "Primary_DNS4"))
	{
		fprintf (fp,"%d", parser_ip (buf1, 4));
	}
	else if (!strcmp (oldstr, "Secondary_DNS1"))
	{
		fprintf (fp,"%d", parser_ip (buf2, 1));
	}
	else if (!strcmp (oldstr, "Secondary_DNS2"))
	{
		fprintf (fp,"%d", parser_ip (buf2, 2));
	}
	else if (!strcmp (oldstr, "Secondary_DNS3"))
	{
		fprintf (fp,"%d", parser_ip (buf2, 3));
	}
	else if (!strcmp (oldstr, "Secondary_DNS4"))
	{
		fprintf (fp,"%d", parser_ip (buf2, 4));
	}
	else
		return CGI_REPLACE_FAIL;
	return CGI_REPLACE_OK;
}

int dns_replace_ex (FILE * fp, char * oldstr) //added by YFHUANG 2004/04/21
{
	char buf1[32], buf2[32];
	char link_section[80];
	INPUT	*tmp = CGI_Find_Parameter(arg, "nic_select");
	int	nic_sel = 0;//,lan_next=-1;
//	char	ethdev[5]="eth0"; //Shone marked 

	if ( tmp ) {
		nic_sel = atoi(&(tmp->val[3]));
		//strcpy(ethdev, tmp->val); //Shone marked 
	}
/* Shone marked  'cause DNS settings of LAN 2 and LAN 3 are disabled 2005/3/24	
	tmp = CGI_Find_Parameter(arg, "submit");//Shone
	if ( tmp ) lan_next = atoi(&(tmp->val[0]));
	if(lan_next==0 && NIC_Count_Interface()>1 ) ethdev[3]='1';
	if(lan_next==1 && NIC_Count_Interface()>2 ) ethdev[3]='2'; */
	
	if (fp == NULL)
		return -1;
	
	memset (buf1, '\0', 32);
	//GET_PROFILE_STRING (ethdev, "Domain Name Server 1", "0.0.0.0", buf1, 32);
	GET_PROFILE_STRING ("Network", "Domain Name Server 1", "0.0.0.0", buf1, 32);//Shone mod 2005/3/24
	memset (buf2, '\0', 32);
	//GET_PROFILE_STRING (ethdev, "Domain Name Server 2", "0.0.0.0", buf2, 32);
	GET_PROFILE_STRING ("Network", "Domain Name Server 2", "0.0.0.0", buf2, 32);//Shone mod 2005/3/24

	if (!strcmp(oldstr, "dns_section_start") || !strcmp(oldstr, "dns_section_end")) //Shone added for disabling LAN2 LAN3 DNS field
	  {
		//if ( lan_next>=0 || nic_sel != 0 ) 
		if ( nic_sel != 0 ) 
		 {
			if ( !strcmp(oldstr, "dns_section_start") )
				fprintf(fp, "<!--");
			else if ( !strcmp(oldstr, "dns_section_end") )
				fprintf(fp, "-->");
		 }
	  }
	else if (!strcmp (oldstr, "Primary_EX_DNS1"))
	{
		fprintf (fp,"%d", parser_ip (buf1, 1));
	}
	else if (!strcmp (oldstr, "Primary_EX_DNS2"))
	{
		fprintf (fp,"%d", parser_ip (buf1, 2));
	}
	else if (!strcmp (oldstr, "Primary_EX_DNS3"))
	{
		fprintf (fp,"%d", parser_ip (buf1, 3));
	}
	else if (!strcmp (oldstr, "Primary_EX_DNS4"))
	{
		fprintf (fp,"%d", parser_ip (buf1, 4));
	}
	else if (!strcmp (oldstr, "DNS_disabled"))
	{
		if (g_config.nOperate == 1)
			fprintf (fp, "%s", "");
		else
			fprintf (fp, "%s", "disabled");
	}
	else if (!strcmp (oldstr, "Secondary_EX_DNS1"))
	{
		fprintf (fp,"%d", parser_ip (buf2, 1));
	}
	else if (!strcmp (oldstr, "Secondary_EX_DNS2"))
	{
		fprintf (fp,"%d", parser_ip (buf2, 2));
	}
	else if (!strcmp (oldstr, "Secondary_EX_DNS3"))
	{
		fprintf (fp,"%d", parser_ip (buf2, 3));
	}
	else if (!strcmp (oldstr, "Secondary_EX_DNS4"))
	{
		fprintf (fp,"%d", parser_ip (buf2, 4));
	}
	else
		return CGI_REPLACE_FAIL;
	return CGI_REPLACE_OK;
}

int switch_ip_replace (FILE * fp, char * oldstr)
{
	if (fp == NULL)
		return -1;
	if (!strcmp (oldstr, "StaticIP1"))
		fprintf (fp, "%d", parser_ip (g_nic_nas_info.ifconfig.ipaddr, 1));
	else if (!strcmp (oldstr, "StaticIP2"))
		fprintf (fp, "%d", parser_ip (g_nic_nas_info.ifconfig.ipaddr, 2));
	else if (!strcmp (oldstr, "StaticIP3"))
		fprintf (fp, "%d", parser_ip (g_nic_nas_info.ifconfig.ipaddr, 3));
	else if (!strcmp (oldstr, "StaticIP4"))
		fprintf (fp, "%d", parser_ip (g_nic_nas_info.ifconfig.ipaddr, 4));
	else if (!strcmp (oldstr, "StaticIP_disabled")) {
		if (get_dev_lan_usage (NIC_LAN03) == NIC_USE_DHCP)
			fprintf (fp, "disabled");
	}
	else if (strstr (oldstr, "net_mask2"))
	{
		char buf[5];
		memset (buf, '\0', sizeof (buf));
		sprintf (buf, "_%d", parser_ip (g_nic_nas_info.ifconfig.netmask, 2));

		if (strstr (oldstr, buf))
			fprintf (fp, "selected");
	}
	else if (strstr (oldstr, "net_mask3"))
	{
		char buf[5];
		memset (buf, '\0', sizeof (buf));
		sprintf (buf, "_%d", parser_ip (g_nic_nas_info.ifconfig.netmask, 3));

		if (strstr (oldstr, buf))
			fprintf (fp, "selected");
	}
	else if (strstr (oldstr, "net_mask4"))
	{
		char buf[5];
		memset (buf, '\0', sizeof (buf));
		sprintf (buf, "_%d", parser_ip (g_nic_nas_info.ifconfig.netmask, 4));

		if (strstr (oldstr, buf))
			fprintf (fp, "selected");
	}
	else if (!strcmp (oldstr, "Gateway1"))
		fprintf (fp, "%d", parser_ip (g_nic_nas_info.ifconfig.gateway, 1));
	else if (!strcmp (oldstr, "Gateway2"))
		fprintf (fp, "%d", parser_ip (g_nic_nas_info.ifconfig.gateway, 2));
	else if (!strcmp (oldstr, "Gateway3"))
		fprintf (fp, "%d", parser_ip (g_nic_nas_info.ifconfig.gateway, 3));
	else if (!strcmp (oldstr, "Gateway4"))
		fprintf (fp, "%d", parser_ip (g_nic_nas_info.ifconfig.gateway, 4));
	else
		return CGI_REPLACE_FAIL;
	return CGI_REPLACE_OK;
}

int bonding_replace(FILE *fp, char *str)
{
	char	buf[1024];

	if (!strcmp(str, "b_fail_over"))
	{
		if (NIC_Get_Bonding_Type()==BONDING_FAIL_OVER)
			fprintf(fp, "checked");
	}
	else
	if (!strcmp(str, "b_load_balance"))
	{
		if (NIC_Get_Bonding_Type()==BONDING_LOAD_BALANCE)
			fprintf(fp, "checked");
	}
	return CGI_REPLACE_OK;
}

int lan_switch_support_replace(FILE * fp, char * oldstr)
{
	if (!strcmp(oldstr, "is_switch_support_tab_title_0"))
	{
		if (is_switch_support)
			fprintf(fp, "<!--\n");
		else
			fprintf(fp, "");
	}
	else if (!strcmp(oldstr, "is_switch_support_tab_title_1"))
	{
		if (is_switch_support)
			fprintf(fp, "-->\n");
		else
			fprintf(fp, "<!--\n");
	}
	else if (!strcmp(oldstr, "is_switch_support_tab_title_2"))
	{
		if (is_switch_support)
			fprintf(fp, "");
		else
			fprintf(fp, "-->\n");
	}
	else if (!strcmp(oldstr, "is_switch_support_cap_0"))
	{
		if (is_switch_support)
			fprintf(fp, "");
		else
			fprintf(fp, "<!--\n");
	}
	else if (!strcmp(oldstr, "is_switch_support_cap_1"))
	{
		if (is_switch_support)
			fprintf(fp, "");
		else
			fprintf(fp, "-->\n");
	}
	else if (!strcmp(oldstr, "is_switch_support_cap_2"))
	{
		if (is_switch_support)
			fprintf(fp, "");
		else
			fprintf(fp, "<!--\n");
	}
	else if (!strcmp(oldstr, "is_switch_support_cap_3"))
	{
		if (is_switch_support)
			fprintf(fp, "<!--\n");
		else
			fprintf(fp, "-->\n");
	}
	else if (!strcmp(oldstr, "is_switch_support_cap_4"))
	{
		if (is_switch_support)
			fprintf(fp, "-->\n");
		else
			fprintf(fp, "");
	}
	else if (!strcmp(oldstr, "is_switch_support_tab_tail_0"))
	{
		if (is_switch_support)
			fprintf(fp, "");
		else
			fprintf(fp, "<!--\n");
	}
	else if (!strcmp(oldstr, "is_switch_support_tab_tail_1"))
	{
		if (is_switch_support)
			fprintf(fp, "");
		else
			fprintf(fp, "-->\n");
	}
	else
		return FALSE;

	return TRUE;
}
/* jeffrey marked
int tab_replace(FILE * fp, char * oldstr)
{
	char buf[1024], buf1[512];
	INPUT	*tmp = CGI_Find_Parameter(arg, "nic_select");
	int	nic_sel = 0,lan_next=-1;

	if ( tmp ) nic_sel = atoi(&(tmp->val[3]));
	tmp = CGI_Find_Parameter(arg, "submit");//Shone
	if ( tmp ) lan_next = atoi(&(tmp->val[0]));
	if(lan_next==0 && NIC_Count_Interface()>1 ) nic_sel=1;
	if(lan_next==1 && NIC_Count_Interface()>2 ) nic_sel=2;
	
	if ( nic_sel == 0 )
		NIC_Get_Info_From_uLinux (&g_nic_nas_info, NIC_LAN01);
	else if ( nic_sel == 1 )
		NIC_Get_Info_From_uLinux (&g_nic_nas_info, NIC_LAN02);
	else if ( nic_sel == 2 )
		NIC_Get_Info_From_uLinux (&g_nic_nas_info, NIC_LAN03);
	g_def_file_type = get_def_type ();

	if (fp == NULL)
		return -1;
	
	GetProfileString("eth0", "Network Speed", "0", speed, 80);//Shone added
	
	if (!strcmp(oldstr, "chk_failover")) {
		int	func = get_func(arg);
		if ( func == MLAN_FAIL_OVER || (func == LANMAIN && NIC_Get_Bonding_Type() == BONDING_FAIL_OVER) )
			fprintf(fp, "checked");
	}
	else if (!strcmp(oldstr, "chk_loadbalance")) {
		int	func = get_func(arg);
		if ( func == MLAN_LOAD_BALANCE || (func == LANMAIN && NIC_Get_Bonding_Type() == BONDING_LOAD_BALANCE) )
			fprintf(fp, "checked");
	}
	else if (!strcmp(oldstr, "chk_standalone")) {
		int	func = get_func(arg);
		if ( func == MLAN_STANDALONE || (func == LANMAIN && NIC_Get_Bonding_Type() == BONDING_STANDALONE) || lan_next>=0)//Shone
		   {
			fprintf(fp, "checked");
		   }	
	}
	else if (!strcmp(oldstr, "one_eth_mark_start") || !strcmp(oldstr, "one_eth_mark_end")) {//Shone added 2005,04,26		
		if (NIC_Count_Interface() == 1 ) {
			if ( !strcmp(oldstr, "one_eth_mark_start") )
				fprintf(fp, "<!--");
			else if ( !strcmp(oldstr, "one_eth_mark_end") )
				fprintf(fp, "-->");
		}
	}	
	else if (!strcmp(oldstr, "no_1000_start") || !strcmp(oldstr, "no_1000_end")) {//Shone added 2005,04,26
		char tmp[80];
		Conf_Get_Field("/etc/config/uLinux.conf","System","Model",tmp,80);		
		if (!strcmp(tmp,"NAS-2100") || !strcmp(tmp, "ND-23000") ) {
			if ( !strcmp(oldstr, "no_1000_start") )
				fprintf(fp, "<!--");
			else if ( !strcmp(oldstr, "no_1000_end") )
				fprintf(fp, "-->");
		}
	}	
	else if (!strcmp(oldstr, "speed0"))//Shone added 
	{
		if (!strcmp(speed, "auto"))
			fprintf(fp, "selected");
		else
			fprintf(fp, "");
	}
	else if (!strcmp(oldstr, "speed1"))
	{
		if (!strcmp(speed, "10"))
			fprintf(fp, "selected");
		else
			fprintf(fp, "");
	}
	else if (!strcmp(oldstr, "speed2"))
	{
		if (!strcmp(speed, "100"))
			fprintf(fp, "selected");
		else
			fprintf(fp, "");
	}
	else if (!strcmp(oldstr, "speed3"))
	{
		if (!strcmp(speed, "1000"))
			fprintf(fp, "selected");
		else
			fprintf(fp, "");
	}
	else if (!strcmp(oldstr, "onlylan1"))//Disable LAN2 & LAN3 speed selection
	{
		if(nic_sel==1||nic_sel==2)
		  fprintf(fp, "disabled");
		else 
			 fprintf(fp, "");
	}
	else if (!strcmp(oldstr, "MLAN_TAB")) {
		int	mlan_type = NIC_Get_Bonding_Type();
		int	func = get_func(arg);
		
		if (  NIC_Count_Interface() > 1 && (func == MLAN_FAIL_OVER || func == MLAN_LOAD_BALANCE || (func == LANMAIN && (mlan_type == BONDING_FAIL_OVER || mlan_type == BONDING_LOAD_BALANCE))) ) {
			char	tab_title[128];

			if ( func == MLAN_FAIL_OVER || (func == LANMAIN && mlan_type == BONDING_FAIL_OVER) ) {
				sprintf(tab_title, "NIC_TAB_FAIL_OVER");
			} else {
				sprintf(tab_title, "NIC_TAB_LOAD_BALANCE");
			}
			fprintf(fp, " \
            <table align=\"left\" width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"12-blue\"> \
              <tr> \
                <td> \
                  <table align=left cellpadding=\"0\" cellspacing=\"0\"> \
                    <tr> \
                      <td width=\"150\"> \
                        <table width=\"150\" border=\"0\" cellpadding=\"5\" cellspacing=\"0\" class=\"Tab-1\"> \
                          <tr> \
                            <td> <font color=\"#FFFFFF\"> \
                              <script language=\"JavaScript\">document.write(%s)</script> \
                              </font> </td> \
                          </tr> \
                        </table> \
                      </td> \
                    </tr> \
                  </table> \
                </td> \
              </tr> \
            </table> \
				", tab_title);
		} else {	//standalone
			int	nic_num = NIC_Count_Interface();
			if(NIC_Is_Switch_Support())//Shone added to normalize lan setting page for models with switch support, '05,06,03
				nic_num--;
			
			fprintf(fp, " \
            <table align=\"left\" width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"12-blue\"> \
              <tr> \
                <td> \ 
                  <table align=left cellpadding=\"0\" cellspacing=\"0\"> \
                    <tr> \
                      <td width=\"150\"> \
				");

			if ( nic_num == 1 ) {
				fprintf(fp, " \
                        <table width=\"150\" border=\"0\" cellpadding=\"5\" cellspacing=\"0\" class=\"Tab-1\"> \
                          <tr> \
                            <td> <font color=\"#FFFFFF\"> \
                              <script language=\"JavaScript\">document.write(%s+'%d')</script> \
                              </font> </td> \
                          </tr> \
                        </table> \
                      </td> \
                    </tr> \
                  </table> \
                </td> \
              </tr> \
            </table> \
	  <input type=\"hidden\" name=\"NIC_SELECT\" value=\"eth0\"> \
					", "NIC_TAB_TITLE", 1);//Shone

			} else if ( nic_num == 2 ) {
				char 	table0[512];
				char	table1[512];
				char	tr0[512];
				char	tr1[512];
				char	font_color0[16];
				char	font_color1[16];
				char	nic_hidden_input[256];

				if ( nic_sel == 0 ) {
					sprintf(nic_hidden_input, "<input type=\"hidden\" name=\"NIC_SELECT\" value=\"eth0\">");
					sprintf(table0, " \
                        <table width=\"150\" border=\"0\" cellpadding=\"5\" cellspacing=\"0\" class=\"Tab-1\"> \
						");
					sprintf(tr0, " \
                          <tr> \
						");
					sprintf(font_color0, "#FFFFFF");
					sprintf(table1, " \
                        <table width=\"150\" border=\"0\" cellpadding=\"5\" cellspacing=\"0\" class=\"Tab-2\" onClick=\"MM_goToURL('parent','/cgi-bin/network/lan_setting/lan_setting.cgi?func=mlan_standalone&nic_select=eth1&counter=%lu');\"> \
						", time(NULL));
					sprintf(tr1, " \
                          <tr onMouseOver=\"this.style.backgroundColor='#cccccc';this.style.cursor='hand';\" onMouseOut=\"this.style.backgroundColor='#eeeeee';\"> \
						");
					sprintf(font_color1, "#666666");
				} else {
					sprintf(nic_hidden_input, "<input type=\"hidden\" name=\"NIC_SELECT\" value=\"eth1\">");
					sprintf(table0, " \
                        <table width=\"150\" border=\"0\" cellpadding=\"5\" cellspacing=\"0\" class=\"Tab-3\" onClick=\"MM_goToURL('parent','/cgi-bin/network/lan_setting/lan_setting.cgi?func=mlan_standalone&nic_select=eth0&counter=%lu');\"> \
						", time(NULL));
					sprintf(tr0, " \
                          <tr onMouseOver=\"this.style.backgroundColor='#cccccc';this.style.cursor='hand';\" onMouseOut=\"this.style.backgroundColor='#eeeeee';\"> \
						");
					sprintf(font_color0, "#666666");
					sprintf(table1, " \
                        <table width=\"150\" border=\"0\" cellpadding=\"5\" cellspacing=\"0\" class=\"Tab-1\"> \
						");
					sprintf(tr1, " \
                          <tr> \
						");
					sprintf(font_color1, "#FFFFFF");
				}
				fprintf(fp, "%s%s \
                            <td> <font color=\"%s\"> \
                              <script language=\"JavaScript\">document.write(%s+'%d')</script> \
                              </font> </td> \
                          </tr> \
                        </table> \
                      </td> \
                      <td width=\"150\"> %s%s \
                            <td> <font color=\"%s\"> \
                              <script language=\"JavaScript\">document.write(%s+'%d')</script> \
                              </font> </td> \
                          </tr> \
                        </table> \
                      </td> \
                    </tr> \
                  </table> \
                </td> \
              </tr> \
            </table> \
	  %s \
			  		", table0, tr0, font_color0, "NIC_TAB_TITLE", 1, table1, tr1, font_color1, "NIC_TAB_TITLE", 2, nic_hidden_input);//Shone
			} else if ( nic_num == 3 ) {
				char 	table0[512];
				char	table1[512];
				char	table2[512];
				char	tr0[512];
				char	tr1[512];
				char	tr2[512];
				char	font_color0[16];
				char	font_color1[16];
				char	font_color2[16];
				char	nic_hidden_input[256];

				if ( nic_sel == 0 ) {
					sprintf(nic_hidden_input, "<input type=\"hidden\" name=\"NIC_SELECT\" value=\"eth0\">");
					sprintf(table0, " \
                        <table width=\"150\" border=\"0\" cellpadding=\"5\" cellspacing=\"0\" class=\"Tab-1\"> \
						");
					sprintf(tr0, " \
                          <tr> \
						");
					sprintf(font_color0, "#FFFFFF");
					sprintf(table1, " \
                        <table width=\"150\" border=\"0\" cellpadding=\"5\" cellspacing=\"0\" class=\"Tab-2\" onClick=\"MM_goToURL('parent','/cgi-bin/network/lan_setting/lan_setting.cgi?func=mlan_standalone&nic_select=eth1&counter=%lu');\"> \
						", time(NULL));
					sprintf(tr1, " \
                          <tr onMouseOver=\"this.style.backgroundColor='#cccccc';this.style.cursor='hand';\" onMouseOut=\"this.style.backgroundColor='#eeeeee';\"> \
						");
					sprintf(font_color1, "#666666");
					sprintf(table2, " \
                        <table width=\"150\" border=\"0\" cellpadding=\"5\" cellspacing=\"0\" class=\"Tab-2\" onClick=\"MM_goToURL('parent','/cgi-bin/network/lan_setting/lan_setting.cgi?func=mlan_standalone&nic_select=eth2&counter=%lu');\"> \
						", time(NULL));
					sprintf(tr2, " \
                          <tr onMouseOver=\"this.style.backgroundColor='#cccccc';this.style.cursor='hand';\" onMouseOut=\"this.style.backgroundColor='#eeeeee';\"> \
						");
					sprintf(font_color2, "#666666");
				} else if ( nic_sel == 1 ) {
					sprintf(nic_hidden_input, "<input type=\"hidden\" name=\"NIC_SELECT\" value=\"eth1\">");
					sprintf(table0, " \
                        <table width=\"150\" border=\"0\" cellpadding=\"5\" cellspacing=\"0\" class=\"Tab-3\" onClick=\"MM_goToURL('parent','/cgi-bin/network/lan_setting/lan_setting.cgi?func=mlan_standalone&nic_select=eth0&counter=%lu');\"> \
						", time(NULL));
					sprintf(tr0, " \
                          <tr onMouseOver=\"this.style.backgroundColor='#cccccc';this.style.cursor='hand';\" onMouseOut=\"this.style.backgroundColor='#eeeeee';\"> \
						");
					sprintf(font_color0, "#666666");
					sprintf(table1, " \
                        <table width=\"150\" border=\"0\" cellpadding=\"5\" cellspacing=\"0\" class=\"Tab-1\"> \
						");
					sprintf(tr1, " \
                          <tr> \
						");
					sprintf(font_color1, "#FFFFFF");
					sprintf(table2, " \
                        <table width=\"150\" border=\"0\" cellpadding=\"5\" cellspacing=\"0\" class=\"Tab-2\" onClick=\"MM_goToURL('parent','/cgi-bin/network/lan_setting/lan_setting.cgi?func=mlan_standalone&nic_select=eth2&counter=%lu');\"> \
						", time(NULL));
					sprintf(tr2, " \
                          <tr onMouseOver=\"this.style.backgroundColor='#cccccc';this.style.cursor='hand';\" onMouseOut=\"this.style.backgroundColor='#eeeeee';\"> \
						");
					sprintf(font_color2, "#666666");
				} else {
					sprintf(nic_hidden_input, "<input type=\"hidden\" name=\"NIC_SELECT\" value=\"eth2\">");
					sprintf(table0, " \
                        <table width=\"150\" border=\"0\" cellpadding=\"5\" cellspacing=\"0\" class=\"Tab-3\" onClick=\"MM_goToURL('parent','/cgi-bin/network/lan_setting/lan_setting.cgi?func=mlan_standalone&nic_select=eth0&counter=%lu');\"> \
						", time(NULL));
					sprintf(tr0, " \
                          <tr onMouseOver=\"this.style.backgroundColor='#cccccc';this.style.cursor='hand';\" onMouseOut=\"this.style.backgroundColor='#eeeeee';\"> \
						");
					sprintf(font_color0, "#666666");
					sprintf(table1, " \
                        <table width=\"150\" border=\"0\" cellpadding=\"5\" cellspacing=\"0\" class=\"Tab-3\" onClick=\"MM_goToURL('parent','/cgi-bin/network/lan_setting/lan_setting.cgi?func=mlan_standalone&nic_select=eth1&counter=%lu');\"> \
						", time(NULL));
					sprintf(tr1, " \
                          <tr onMouseOver=\"this.style.backgroundColor='#cccccc';this.style.cursor='hand';\" onMouseOut=\"this.style.backgroundColor='#eeeeee';\"> \
						");
					sprintf(font_color1, "#666666");
					sprintf(table2, " \
                        <table width=\"150\" border=\"0\" cellpadding=\"5\" cellspacing=\"0\" class=\"Tab-1\"> \
						");
					sprintf(tr2, " \
                          <tr> \
						");
					sprintf(font_color2, "#FFFFFF");
				}
				fprintf(fp, "%s%s \
                            <td> <font color=\"%s\"> \
                              <script language=\"JavaScript\">document.write(%s+'%d')</script> \
                              </font> </td> \
                          </tr> \
                        </table> \
                      </td> \
                      <td width=\"150\"> %s%s \
                            <td> <font color=\"%s\"> \
                              <script language=\"JavaScript\">document.write(%s+'%d')</script> \
                              </font> </td> \
                          </tr> \
                        </table> \
                      </td> \
                      <td width=\"150\"> %s%s \
                            <td> <font color=\"%s\"> \
                              <script language=\"JavaScript\">document.write(%s+'%d')</script> \
                              </font> </td> \
                          </tr> \
                        </table> \
                      </td> \
                    </tr> \
                  </table> \
                </td> \
              </tr> \
            </table> \
	  %s \
					", table0, tr0, font_color0, "NIC_TAB_TITLE", 1,  
					table1, tr1, font_color1, "NIC_TAB_TITLE", 2, 
					table2, tr2, font_color2, "NIC_TAB_TITLE", 3, 
					nic_hidden_input);//Shone
			}
		}

	}
	else
		return CGI_REPLACE_FAIL;
	return CGI_REPLACE_OK;
} 
*/
//mark end here jeffrey

int lan_replace(FILE * fp, char * oldstr)
{
	char buf[1024], buf1[512];
	INPUT	*tmp = CGI_Find_Parameter(arg, "nic_select");
	int	nic_sel = 0,lan_next=-1;
	char	ethdev[5]="eth0";

	if ( tmp ) {
		nic_sel = atoi(&(tmp->val[3]));
		strcpy(ethdev, tmp->val);
	}
	tmp = CGI_Find_Parameter(arg, "submit");//Shone
	if ( tmp ) lan_next = atoi(&(tmp->val[0]));
	if(lan_next==0 && NIC_Count_Interface()>1) { nic_sel=1; ethdev[3]='1'; }
	if(lan_next==1 && NIC_Count_Interface()>2) { nic_sel=2; ethdev[3]='2'; }
 
	if ( nic_sel == 0 ) {
		NIC_Get_Info_From_uLinux (&g_nic_nas_info, NIC_LAN01);
	}
	else if ( nic_sel == 1 ) {
		NIC_Get_Info_From_uLinux (&g_nic_nas_info, NIC_LAN02);
	}
	else if ( nic_sel == 2 ) {
		NIC_Get_Info_From_uLinux (&g_nic_nas_info, NIC_LAN03);
	}

	//GetProfileString(ethdev, "Network Speed", "0", speed, 80); //Shone
	//NIC_Debug_NAS_Info(&g_nic_nas_info);
	//GetProfileString("Network", "Network Speed", "0", speed, 80);
	
	g_def_file_type = get_def_type ();

	if (fp == NULL)
		return -1;
	
	if (!strcmp(oldstr, "dhcp_section_start") || !strcmp(oldstr, "dhcp_section_end")) {
		int	mlan_type = NIC_Get_Bonding_Type();
		int	func = get_func(arg);
		
		if ( (func == MLAN_STANDALONE || lan_next>=0) && nic_sel != 0 ) {//Shone
			if ( !strcmp(oldstr, "dhcp_section_start") )
				fprintf(fp, "<!--");
			else if ( !strcmp(oldstr, "dhcp_section_end") )
				fprintf(fp, "-->");
		}
	}
	else if (lan_switch_support_replace(fp, oldstr) == TRUE) {
		return CGI_REPLACE_OK;
	}
	else if (!strcmp(oldstr, "tabname")) {
        		fprintf(fp, "&tabname=%s", tab_name);
	}
        else if (!strcmp(oldstr, "lan_url")) {
        	if (is_lan_page)
        	{
        		fprintf(fp, "/cgi-bin/network/lan_setting/lan_setting.cgi?func=OK&submit=%d",nic_sel);//Shone
        	}
        	else
        		fprintf(fp, "/cgi-bin/network/lan_setting/lan_setting.cgi?func=Switch_OK");
	}
        else if (!strcmp (oldstr, "lan_title")){
        	if (g_def_file_type == 3)
	    		fprintf(fp, "NIC_DEF_STR16");
	    	else
	    		//fprintf(fp, "NIC_DEF_STR04");//Shone modified 'cause it seems to be non sense putting this string here... 2005,04,26
	    		fprintf(fp, "NIC_DEF_STR16");
        }
	else if (!strcmp (oldstr, "default_value"))
	{
		if (g_config.nOperate == 1)
			fprintf (fp, "%d", 1);
		else
			fprintf (fp, "%d", 0);
	}
	else if (!strcmp (oldstr, "usage"))
	{
		fprintf (fp, "%d", g_nic_nas_info.usage);//get_usage ());
	}
	else if (!strcmp (oldstr, "lan_use_dhcp"))
	{
		if (g_nic_nas_info.usage == NIC_USE_DHCP)
			fprintf (fp, "checked");
	}
	else if (!strcmp (oldstr, "lan_use_static"))
	{
		if (g_nic_nas_info.usage == NIC_USE_STATIC)
			fprintf (fp, "checked");
	}
	else if (!strcmp (oldstr, "operate_dhcp"))
	{
		if (g_config.nOperate == 1)
			fprintf (fp, "%s", "checked");
		else
			fprintf (fp, "%s", "");
	}
	else if (!strcmp (oldstr, "DHCP_SERVER_disabled"))
	{
		if (g_config.nOperate == 1)
			fprintf (fp, "%s", "");
		else
			fprintf (fp, "%s", "disabled");
	}
	else if (strstr (oldstr, "StartIP"))
	{
		static int start_idx;
		fprintf (fp, "%d", parser_ip (g_config.sStartAddress, ++start_idx));
	}
	else if (strstr (oldstr, "EndIP"))
	{
		static int end_idx;
		fprintf (fp, "%d", parser_ip (g_config.sEndAddress, ++end_idx));
	}
	else if (!strcmp (oldstr , "MaxLeaseTimeDay"))
	{
		if (g_config.nMax_lease_time_day == 0)
			g_config.nMax_lease_time_day = 1;
		fprintf (fp, "%d", g_config.nMax_lease_time_day);
	}
	else if (!strcmp (oldstr , "MaxLeaseTimeHour"))
	{
		fprintf (fp, "%d", g_config.nMax_lease_time_hour);
	}
	else if (!strcmp (oldstr , "interface"))
	{
		if (NIC_Count_Interface()==2 && NIC_Is_Bonding_Support())
			fprintf(fp, "%d", 1);
		else
		if (NIC_Count_Interface()==3 && NIC_Is_Bonding_Support())
			fprintf(fp, "%d", 1);
		else
			fprintf (fp, "%d", NIC_Count_Interface ());
	}
	else if (!strcmp (oldstr , "browser_type"))
	{
		HTTP_INFO http_info;
		CGI_Get_Http_Info(&http_info);
		fprintf (fp, "%d", http_info.browser);
	}
	else if (!strcmp (oldstr, "support_wlan"))
	{
		if (Is_WLAN_Supported () && Is_WLAN_Card_Exist ())
		{
			CGI_Output_Html(TAB_SELECT_PAGE, "$", NULL);
		}
	}
	else if (!strcmp (oldstr, "support_wlan_border"))
	{
		if (Is_WLAN_Supported () && Is_WLAN_Card_Exist ())
		{
			fprintf (fp, "Table_Border");
		}
	}
	else if (!strcmp (oldstr, "dns_setting"))
	{
		if (g_def_file_type < 4)
			CGI_Output_Html(DNS_SETTING_PAGE, "$", dns_replace);
	}
	else if (!strcmp (oldstr, "dns_setting_ex"))   //added by YFHUANG 2004/4/21
	{
		CGI_Output_Html(DNS_SETTING_EX_PAGE, "$", dns_replace_ex);
	}
	else if (!strcmp(oldstr, "b_fail_over"))
	{
		if (NIC_Get_Bonding_Type()==BONDING_FAIL_OVER)
			fprintf(fp, "checked");
	}
	else if (!strcmp(oldstr, "b_load_balance"))
	{
		if (NIC_Get_Bonding_Type()==BONDING_LOAD_BALANCE)
			fprintf(fp, "checked");
	}
	else if ((strstr (oldstr, "eth_mtu")))
	{		
			char mtu_value[5];
			Get_Profile_String("eth0", "MTU", "1500",mtu_value, 5);
			if (strstr (oldstr, mtu_value))
				fprintf (fp, "selected");
	}
	/*Shone marked 
	else if (!strcmp(oldstr, "speed0"))
	{
		if (!strcmp(speed, "auto"))
			fprintf(fp, "selected");
		else
			fprintf(fp, "");
	}
	else if (!strcmp(oldstr, "speed1"))
	{
		if (!strcmp(speed, "10"))
			fprintf(fp, "selected");
		else
			fprintf(fp, "");
	}
	else if (!strcmp(oldstr, "speed2"))
	{
		if (!strcmp(speed, "100"))
			fprintf(fp, "selected");
		else
			fprintf(fp, "");
	}
	else if (!strcmp(oldstr, "speed3"))
	{
		if (!strcmp(speed, "1000"))
			fprintf(fp, "selected");
		else
			fprintf(fp, "");
	}*/
	else
		return CGI_REPLACE_FAIL;
	return CGI_REPLACE_OK;
}

int get_dev_lan_usage(int dev_no)
{
	NIC_NAS_INFO info;

	memset (&info, '\0', sizeof (info));

	NIC_Get_Info_From_uLinux (&info, dev_no);
	return info.usage;
}

int switch_switch_support_replace(FILE * fp, char * oldstr)
{
	if (!strcmp(oldstr, "is_switch_support_tab_title_0") ||
		!strcmp(oldstr, "is_switch_support_tab_title_1") ||
		!strcmp(oldstr, "is_switch_support_tab_title_2") ||
		!strcmp(oldstr, "is_switch_support_tab_tail_0") ||
		!strcmp(oldstr, "is_switch_support_tab_tail_1"))
	{
		fprintf(fp, "");
	}
	else
		return FALSE;

	return TRUE;
}

int switch_replace(FILE * fp, char * oldstr)
{
	char buf[1024], buf1[512];

	if (fp == NULL)
		return -1;

	NIC_Get_Info_From_uLinux (&g_nic_nas_info, NIC_LAN03);
	g_def_file_type = get_def_type ();

	if (switch_switch_support_replace(fp, oldstr) == TRUE)
		return CGI_REPLACE_OK;

        else if (!strcmp (oldstr, "lan_title")){
        	if (g_def_file_type == 3)
	    		fprintf(fp, "NIC_DEF_STR16");
	    	else
	    		fprintf(fp, "NIC_DEF_STR04");
        }
        else if (!strcmp(oldstr, "lan_url")) {
        	if (is_lan_page)
        		fprintf(fp, "/cgi-bin/network/lan_setting/lan_setting.cgi?func=OK");
        	else
        		fprintf(fp, "/cgi-bin/network/lan_setting/lan_setting.cgi?func=Switch_OK");
	}
	else if (!strcmp (oldstr, "usage"))
	{
		fprintf (fp, "%d", get_dev_lan_usage(NIC_LAN03));
	}
	else if (!strcmp (oldstr, "lan_use_dhcp"))
	{
		if (get_dev_lan_usage(NIC_LAN03) == NIC_USE_DHCP)
			fprintf (fp, "checked");
	}
	else if (!strcmp (oldstr, "lan_use_static"))
	{
		if (get_dev_lan_usage(NIC_LAN03) == NIC_USE_STATIC)
			fprintf (fp, "checked");
	}
	else if (!strcmp (oldstr, "support_wlan"))
	{
		fprintf(fp, "");
	}
	else if (!strcmp (oldstr , "browser_type"))
	{
		HTTP_INFO http_info;
		CGI_Get_Http_Info(&http_info);
		fprintf (fp, "%d", http_info.browser);
	}
	else
		return CGI_REPLACE_FAIL;
	return CGI_REPLACE_OK;
}

int query_restart (INPUT * form)
{
	INPUT		*pform;

	pform=form;
	while (pform!=NULL)
	{
		if (!strcmp (pform->name, "Yes"))
			return 1;  //  restart
		else if (!strcmp (pform->name, "No"))
			return 0;  //  do not restart
		pform=(INPUT *)pform->next;
	}
	return 0;  //  do not restart
}

int begin_restart (void)
{
	pid_t	mypid;
	pid_t	parent;
	char	dir[128], buf[128];
	int result = 1;

	parent=getpid();
	sprintf(dir, "/proc/%d/exe", parent);
	mypid=fork();
	if (mypid==0)
	{	/* child */
		close(0);
		close(1);
		close(2);
		while (1)
		{
			if (readlink(dir, buf, 256)==-1)
				break;
			sleep(1);
		}

		Restart_System();
		exit (0);
	}
	else
		result = 0;
	return result;
}

int lan_submit (INPUT * form)
{
	INPUT		*pform;
	char		command[256];
	int 		action = 0;
	struct dhcp_conf config;
	NIC_NAS_INFO info;
	int use_nat = 0, restart = 0;
	INPUT	*tmp = CGI_Find_Parameter(form, "NIC_SELECT");
	int	nic_sel	= -1;
	int 	Nic_Num=NIC_Count_Interface ();
	char	ethdev[5]="eth0";

	char	dns_new[4][16];
	char	dns_old[4][16];
	BOOL	dhcpd_web = FALSE;

	memset (&info, '\0', sizeof (info));
	memset (&config, '\0', sizeof (struct dhcp_conf));
	memset (dns_new, '\0', sizeof (dns_new));
	memset (dns_old, '\0', sizeof (dns_old));

	if ( tmp ) {
		nic_sel = atoi(&(tmp->val[3]));
		strcpy(ethdev, tmp->val);
	}
	if ( nic_sel == 0 )
	{
		NIC_Get_Info_From_uLinux (&info, NIC_LAN01);
		if(info.bonding_type!=BONDING_STANDALONE)//Shone
		{
			if(Nic_Num>=2)
			{
				Conf_Set_Field("/etc/config/uLinux.conf","eth1","Use DHCP","TRUE");
				Conf_Set_Field("/etc/config/uLinux.conf","eth1","Usage","DHCP");
			}
			if(Nic_Num>=3)
			{       
				Conf_Set_Field("/etc/config/uLinux.conf","eth2","Use DHCP","TRUE");
				Conf_Set_Field("/etc/config/uLinux.conf","eth2","Usage","DHCP");
			}     
		}
	}	
	else if ( nic_sel == 1 )
	{
		NIC_Get_Info_From_uLinux (&info, NIC_LAN02);
		if(info.bonding_type!=BONDING_STANDALONE)//Shone
		{
			if(Nic_Num>=3)
			{       
				Conf_Set_Field("/etc/config/uLinux.conf","eth2","Use DHCP","TRUE");
				Conf_Set_Field("/etc/config/uLinux.conf","eth2","Usage","DHCP");
			}     
		}
	}	 
	else if ( nic_sel == 2 )
		NIC_Get_Info_From_uLinux (&info, NIC_LAN03);
	else  {
		 NIC_Get_Info_From_uLinux (&info, NIC_LAN01);	
		 nic_sel=0;
	}	 

	tmp = CGI_Find_Parameter(form, "Bonding");
	if ( tmp ) {
		if (!strcmp(tmp->val, "FAILOVER")) {
			info.bonding_type=BONDING_FAIL_OVER;
		} else if (!strcmp(tmp->val, "LOADBALANCE")) {
			info.bonding_type=BONDING_LOAD_BALANCE;
		} else {
			info.bonding_type=BONDING_STANDALONE;
		}
	}

	GetProfileString(ethdev, "Network Speed", "0", speed, 80);
	if ( CGI_Find_Parameter(form, "ObjDHCPOperate") ) {
		dhcpd_web = TRUE;
		read_dhcp_conf (&config);
		action = config.nOperate;
		config.nOperate = 1;
		GetProfileString(ethdev, "Domain Name Server 1", "0.0.0.0", dns_old[0], sizeof(dns_old[0]));
		GetProfileString(ethdev, "Domain Name Server 2", "0.0.0.0", dns_old[1], sizeof(dns_old[1]));
		GetProfileString(DHCP_SECTION, "Domain Name Server 1", "0.0.0.0", dns_old[2], sizeof(dns_old[2]));
		GetProfileString(DHCP_SECTION, "Domain Name Server 2", "0.0.0.0", dns_old[3], sizeof(dns_old[3]));
	} else {
		if ( info.bonding_type == BONDING_FAIL_OVER || info.bonding_type == BONDING_LOAD_BALANCE || nic_sel == 0 ) {
			dhcpd_web = TRUE;
			read_dhcp_conf (&config);
			action = config.nOperate;
			config.nOperate = 0;
		}
	}


	pform=form;
	while (pform!=NULL)
	{
/*		if (!strcmp (pform->name, "ObjDHCPOperate"))
		{
			config.nOperate = 1;
		}
		else if (!strcmp(pform->name, "Bonding"))
		{
			if (!strcmp(pform->val, "FAILOVER"))
				info.bonding_type=BONDING_FAIL_OVER;
			else
			if (!strcmp(pform->val, "LOADBALANCE"))
				info.bonding_type=BONDING_LOAD_BALANCE;
			else
			if (!strcmp(pform->val, "STANDALONE"))
				info.bonding_type=BONDING_STANDALONE;
			else
				info.bonding_type=BONDING_STANDALONE;
		}*/
		if (!strcmp (pform->name, "NetSelect"))
		{
			if (!strcmp (pform->val, "DHCP"))
			{
				info.usage = NIC_USE_DHCP;
//				break;
			}
			else if (!strcmp (pform->val, "Static"))
				info.usage = NIC_USE_STATIC;
		}	
		else if (strstr (pform->name, "StaticIP"))
		{
			if (strstr (pform->name, "1"))
			{
				memset (info.ifconfig.ipaddr, '\0', sizeof (info.ifconfig.ipaddr));
				strcat (info.ifconfig.ipaddr, pform->val);
			}
			else
			{
				strcat (info.ifconfig.ipaddr, ".");
				strcat (info.ifconfig.ipaddr, pform->val);
			}
		}
		else if (strstr (pform->name, "Netmask"))
		{
			if (info.usage!=NIC_USE_DHCP)
			{
				if (strstr (pform->name, "1"))
					strcpy (info.ifconfig.netmask, pform->val);
				else
				{
					strcat (info.ifconfig.netmask, ".");
					strcat (info.ifconfig.netmask, pform->val);
				}
			}
		}
		else if (strstr (pform->name, "Gateway"))
		{
			if (strstr (pform->name, "1"))
				strcpy (info.ifconfig.gateway, pform->val);
			else
			{
				strcat (info.ifconfig.gateway, ".");
				strcat (info.ifconfig.gateway, pform->val);
			}
		}
		else if (strstr (pform->name, "StartIP"))
		{
			if (strstr (pform->name, "1"))
				strcpy (config.sStartAddress, pform->val);
			else
			{
				strcat (config.sStartAddress, ".");
				strcat (config.sStartAddress, pform->val);
			}
		}
		else if (strstr (pform->name, "EndIP"))
		{
			if (strstr (pform->name, "1"))
				strcpy (config.sEndAddress, pform->val);
			else
			{
				strcat (config.sEndAddress, ".");
				strcat (config.sEndAddress, pform->val);
			}
		}
		else if (!strcmp (pform->name, "ObjMaxLeaseTimeDay"))
		{
			config.nMax_lease_time_day = atoi (pform->val);
		}
		else if (!strcmp (pform->name, "ObjMaxLeaseTimeHour"))
		{
			config.nMax_lease_time_hour = atoi (pform->val);
		}
		else if (!strncmp (pform->name, "Primary_EX_DNS", strlen("Primary_EX_DNS")))
		{
			if (!strstr (pform->name, "1")) {
				strcat (dns_new[0], ".");
			}
			strcat (dns_new[0], pform->val);
			if (strstr (pform->name, "4")) {
				//SET_PROFILE_STRING (ethdev, "Domain Name Server 1", dns_new[0]);
				SET_PROFILE_STRING ("Network", "Domain Name Server 1", dns_new[0]);//Shone mod 2005/3/24
				if (strcmp(dns_old[0], dns_new[0]))
					restart = 1;
			}
		}
		else if (!strncmp (pform->name, "Secondary_EX_DNS", strlen("Secondary_EX_DNS")))
		{
			if (!strstr (pform->name, "1"))
				strcat (dns_new[1], ".");
			strcat (dns_new[1], pform->val);
			if (strstr (pform->name, "4")) {
				//SET_PROFILE_STRING (ethdev, "Domain Name Server 2", dns_new[1]);
				SET_PROFILE_STRING ("Network", "Domain Name Server 2", dns_new[1]);//Shone mod 2005/3/24
				if (strcmp(dns_old[1], dns_new[1]))
					restart = 1;
			}
		}
		else if (!strncmp (pform->name, "Primary_DNS", strlen("Primary_DNS")))
		{
			if (!strstr (pform->name, "1"))
				strcat (dns_new[2], ".");
			strcat (dns_new[2], pform->val);
			if (strstr (pform->name, "4")) {
				strcpy(config.sDomain_name_server, dns_new[2]);
				if (strcmp(dns_old[2], dns_new[2]))
					restart = 1;
			}
		}
		else if (!strncmp (pform->name, "Secondary_DNS", strlen("Secondary_DNS")))
		{
			if (!strstr (pform->name, "1"))
				strcat (dns_new[3], ".");
			strcat (dns_new[3], pform->val);
			if (strstr (pform->name, "4")) {
				strcpy(config.sDomain_name_server2, dns_new[3]);
				if (strcmp(dns_old[3], dns_new[3]))
					restart = 1;
			}
		}
		//---add by KenChen 20060330
		else if (!strcmp (pform->name, "mtu"))
		{
			int mtu,ori_mtu,eth0_speed;
			
			mtu = atoi(pform->val);
			ori_mtu = Get_Profile_Integer("eth0", "MTU", 1500);
			eth0_speed = Get_Profile_Integer("eth0", "Speed", 100);
			
			if (eth0_speed == 1000 && mtu>0 && mtu<=9000 && mtu!=ori_mtu){
				Set_Profile_Integer("eth0", "MTU", mtu);
				restart = 1;
			}
		}
		//---end here
		else if (!strcmp (pform->name, "Use_Nat"))
		{
			use_nat = 1;
		}
		else if(!strcmp (pform->name, "Switch_Speed"))
		{
			//WriteProfileString(ethdev, "Network Speed", pform->val);//Shone modified
			
			WriteProfileString("eth0", "Network Speed", pform->val);
			if (Nic_Num>=2)
			   WriteProfileString("eth1", "Network Speed", pform->val);
			if (Nic_Num>=3)   
			   WriteProfileString("eth2", "Network Speed", pform->val);
			if(strcmp(speed, pform->val))
				restart = 1;
		}

		pform=(INPUT *)pform->next;
	}
	
	if (Nic_Num > 1 && !NIC_Is_Bonding_Support())
		info.usage = NIC_USE_STATIC;
			
	if (NIC_Set_Info_To_uLinux (&info) == NIC_RESTART) {
		if ( dhcpd_web ) {
			if (config.nOperate == 0)
				Set_Profile_String ("DHCP Server", "Enable", "FALSE");
			else
				Set_Profile_String ("DHCP Server", "Enable", "TRUE");
		}
		if(info.bonding_type==BONDING_STANDALONE)//Shone
		  {
		      //if (Nic_Num>=2 && nic_sel == 1)
		      if (Nic_Num==2)	
		        {
		        	char tmp[4][80];
		        	Conf_Get_Field("/etc/config/uLinux.conf","eth0","IP Address",tmp[0],80);
		        	Conf_Get_Field("/etc/config/uLinux.conf","eth1","IP Address",tmp[1],80);
		        	Conf_Get_Field("/etc/config/uLinux.conf","eth0","Use DHCP",tmp[2],80);
		        	Conf_Get_Field("/etc/config/uLinux.conf","eth1","Use DHCP",tmp[3],80);
		        	if(!strcmp(tmp[0],tmp[1])&&!strcmp(tmp[2],"FALSE")&&!strcmp(tmp[3],"FALSE"))
		        	 { 
		        	   Conf_Set_Field("/etc/config/uLinux.conf","eth1","Use DHCP","TRUE");
		        	   Conf_Set_Field("/etc/config/uLinux.conf","eth1","Usage","DHCP");	
		        	   return LAN_REPEATED;
		        	 } 
		        }
		       if (Nic_Num==3)// && nic_sel == 2)	
	               {
		 	char tmp[6][80];
		 	Conf_Get_Field("/etc/config/uLinux.conf","eth0","IP Address",tmp[0],80);
		 	Conf_Get_Field("/etc/config/uLinux.conf","eth1","IP Address",tmp[1],80);
		 	Conf_Get_Field("/etc/config/uLinux.conf","eth2","IP Address",tmp[2],80);
		 	Conf_Get_Field("/etc/config/uLinux.conf","eth0","Use DHCP",tmp[3],80);
		 	Conf_Get_Field("/etc/config/uLinux.conf","eth1","Use DHCP",tmp[4],80);
		 	Conf_Get_Field("/etc/config/uLinux.conf","eth2","Use DHCP",tmp[5],80);
		 	if(!strcmp(tmp[0],tmp[1]) &&!strcmp(tmp[3],"FALSE")&&!strcmp(tmp[4],"FALSE")) 
		 	  {
		 	      if(!strcmp(tmp[1],tmp[2]) &&!strcmp(tmp[4],"FALSE")&&!strcmp(tmp[5],"FALSE"))
		 	        {
		 	        	Conf_Set_Field("/etc/config/uLinux.conf","eth2","Use DHCP","TRUE");
	        	                Conf_Set_Field("/etc/config/uLinux.conf","eth2","Usage","DHCP");
		 	        }	
		 	      Conf_Set_Field("/etc/config/uLinux.conf","eth1","Use DHCP","TRUE");
	        	      Conf_Set_Field("/etc/config/uLinux.conf","eth1","Usage","DHCP");	
		 	      return LAN_REPEATED;	
		 	  }
		 	if(!strcmp(tmp[1],tmp[2]) &&!strcmp(tmp[4],"FALSE")&&!strcmp(tmp[5],"FALSE")) 
		 	  {
		 	       	Conf_Set_Field("/etc/config/uLinux.conf","eth2","Use DHCP","TRUE");
        	                Conf_Set_Field("/etc/config/uLinux.conf","eth2","Usage","DHCP");
		        	              return LAN_REPEATED;
		 	  }
		     	if(!strcmp(tmp[0],tmp[2]) &&!strcmp(tmp[3],"FALSE")&&!strcmp(tmp[5],"FALSE"))
		     	  {
		     	      Conf_Set_Field("/etc/config/uLinux.conf","eth2","Use DHCP","TRUE");
	        	      Conf_Set_Field("/etc/config/uLinux.conf","eth2","Usage","DHCP");	
		    	      return LAN_REPEATED;
		    	  }  
	               }    
		     /*Disable proceed function
		      if ( (Nic_Num>1 && nic_sel == 0) || (Nic_Num>2 && nic_sel ==1))
	                       return LAN_PROCEED;
	                    else*/                    
		         return NIC_RESTART;   
	                }      
	              else
		   return NIC_RESTART;
	}
	//  enable | disable DHCP
	if ( dhcpd_web ) {
		if (config.nOperate == 0) {
			Enable_DHCP (0);
		} else {
			strcpy (config.sRouter, g_config.sRouter);
			set_to_file (&config);
			create_dhcpd_conf (config);
			Enable_DHCP (1);
		}
	}
	if (use_nat)
		FW_Set_NAT (1);
	else
		FW_Set_NAT (0);
	
	if(info.bonding_type==BONDING_STANDALONE)//Shone	
	  {
	     //if (Nic_Num>=2 && nic_sel == 1)	
	     if (Nic_Num==2)
	       {
		char tmp[4][80];
		Conf_Get_Field("/etc/config/uLinux.conf","eth0","IP Address",tmp[0],80);
		Conf_Get_Field("/etc/config/uLinux.conf","eth1","IP Address",tmp[1],80);
		Conf_Get_Field("/etc/config/uLinux.conf","eth0","Use DHCP",tmp[2],80);
		Conf_Get_Field("/etc/config/uLinux.conf","eth1","Use DHCP",tmp[3],80);
		if(!strcmp(tmp[0],tmp[1])&&!strcmp(tmp[2],"FALSE")&&!strcmp(tmp[3],"FALSE"))
		   { 
		       Conf_Set_Field("/etc/config/uLinux.conf","eth1","Use DHCP","TRUE");	
		       Conf_Set_Field("/etc/config/uLinux.conf","eth1","Usage","DHCP");
		       return LAN_REPEATED;
		   } 
	       }	
	      if (Nic_Num==3)// && nic_sel == 2)	
	         {
		 char tmp[6][80];
		 Conf_Get_Field("/etc/config/uLinux.conf","eth0","IP Address",tmp[0],80);
		 Conf_Get_Field("/etc/config/uLinux.conf","eth1","IP Address",tmp[1],80);
		 Conf_Get_Field("/etc/config/uLinux.conf","eth2","IP Address",tmp[2],80);
		 Conf_Get_Field("/etc/config/uLinux.conf","eth0","Use DHCP",tmp[3],80);
		 Conf_Get_Field("/etc/config/uLinux.conf","eth1","Use DHCP",tmp[4],80);
		 Conf_Get_Field("/etc/config/uLinux.conf","eth2","Use DHCP",tmp[5],80);
		 if(!strcmp(tmp[0],tmp[1]) &&!strcmp(tmp[3],"FALSE")&&!strcmp(tmp[4],"FALSE")) 
		   {
		 	      if(!strcmp(tmp[1],tmp[2]) &&!strcmp(tmp[4],"FALSE")&&!strcmp(tmp[5],"FALSE"))
		 	        {
		 	        	Conf_Set_Field("/etc/config/uLinux.conf","eth2","Use DHCP","TRUE");
	        	                Conf_Set_Field("/etc/config/uLinux.conf","eth2","Usage","DHCP");
		 	        }	
		 	      Conf_Set_Field("/etc/config/uLinux.conf","eth1","Use DHCP","TRUE");
	        	      Conf_Set_Field("/etc/config/uLinux.conf","eth1","Usage","DHCP");	
		 	      return LAN_REPEATED;	
		 	  }
		 	if(!strcmp(tmp[1],tmp[2]) &&!strcmp(tmp[4],"FALSE")&&!strcmp(tmp[5],"FALSE")) 
		 	  {
		 	       	Conf_Set_Field("/etc/config/uLinux.conf","eth2","Use DHCP","TRUE");
        	                Conf_Set_Field("/etc/config/uLinux.conf","eth2","Usage","DHCP");
        	                return LAN_REPEATED;
		 	  }
		     	if(!strcmp(tmp[0],tmp[2]) &&!strcmp(tmp[3],"FALSE")&&!strcmp(tmp[5],"FALSE"))
		     	  {
		     	      Conf_Set_Field("/etc/config/uLinux.conf","eth2","Use DHCP","TRUE");
	        	      Conf_Set_Field("/etc/config/uLinux.conf","eth2","Usage","DHCP");	
		    	      return LAN_REPEATED;
		    	  }  
	        }    
	     /*Disable proceed function	        
	     if ( (Nic_Num>1 && nic_sel == 0 ) || (Nic_Num>2 && nic_sel ==1))
	         return LAN_PROCEED;
	     else 
	     if (restart)*/
		return NIC_RESTART;    
	  }       
	else if (restart)
		return NIC_RESTART;

	return LANSUCCESS;
}

int switch_submit (INPUT * form)
{
	INPUT		*pform;
	char		command[256], buf[512];
	int 		action = 0;
	NIC_NAS_INFO info;

	memset (&info, '\0', sizeof (info));
	NIC_Get_Info_From_uLinux (&info, NIC_LAN03);
#ifdef	_DEBUG
	printf("switch old gateway = %s<br>\n", info.ifconfig.gateway);
#endif
	pform=form;
	while (pform!=NULL)
	{
		memset (buf, '\0', sizeof (buf));
		if (!strcmp (pform->name, "NetSelect"))
		{
			if (!strcmp (pform->val, "DHCP"))
			{
				info.usage = NIC_USE_DHCP;
			}
			else if (!strcmp (pform->val, "Static"))
				info.usage = NIC_USE_STATIC;
		}
		else if (strstr (pform->name, "StaticIP"))
		{
			if (strstr (pform->name, "1"))
			{
				memset (info.ifconfig.ipaddr, '\0', sizeof (info.ifconfig.ipaddr));
				strcat (info.ifconfig.ipaddr, pform->val);
			}
			else
			{
				strcat (info.ifconfig.ipaddr, ".");
				strcat (info.ifconfig.ipaddr, pform->val);
			}
		}
		else if (strstr (pform->name, "Netmask"))
		{
			if (info.usage!=NIC_USE_DHCP)
			{
				if (strstr (pform->name, "1"))
					strcpy (info.ifconfig.netmask, pform->val);
				else
				{
					strcat (info.ifconfig.netmask, ".");
					strcat (info.ifconfig.netmask, pform->val);
				}
			}
		}
		else if (strstr (pform->name, "Gateway"))
		{
			if (strstr (pform->name, "1"))
				strcpy (info.ifconfig.gateway, pform->val);
			else
			{
				strcat (info.ifconfig.gateway, ".");
				strcat (info.ifconfig.gateway, pform->val);
			}
		}
		pform=(INPUT *)pform->next;
	}
#ifdef	_DEBUG
	printf("switch old gateway = %s<br>\n", info.ifconfig.gateway);
#endif

	if (NIC_Set_Info_To_uLinux (&info) == NIC_RESTART) {
		return NIC_RESTART;
	}

	return LANSUCCESS;
}

//  if the input is invalid then return none zero
int check_input (INPUT * form)
{
	INPUT		*pform;
	int localip[4], netmask[4], startaddr[4], endaddr[4];
	int dhcp_enable = 0, idx = 4;

	memset (startaddr, 0, sizeof (startaddr));
	memset (endaddr, 0, sizeof (endaddr));
	memset (localip, 0, sizeof (localip));
	memset (netmask, 0, sizeof (netmask));

	pform = form;
	//  parser input to array
	while (pform!=NULL)
	{
		if (!strcmp(pform->name, "ObjDHCPOperate"))
			dhcp_enable = 1;
		else if (strstr (pform->name, "StaticIP"))
		{
			static int static_idx;
			localip[static_idx++] = atoi (pform->val);
		}
		else if (strstr (pform->name, "Netmask"))
		{
			static int netmask_idx;
			netmask[netmask_idx++] = atoi (pform->val);
		}
		else if (strstr (pform->name, "StartIP"))
		{
			static int start_idx;
			startaddr[start_idx++] = atoi (pform->val);
		}
		else if (strstr (pform->name, "EndIP"))
		{
			static int end_idx;
			endaddr[end_idx++] = atoi (pform->val);
		}

		pform=(INPUT *)pform->next;
	}

	if (dhcp_enable == 0)
		return 0;
#ifdef _DEBUG
	printf ("local IP = %d.%d.%d.%d<br>\n", localip[0], localip[1], localip[2], localip[3]);
	printf ("netmask IP = %d.%d.%d.%d<br>\n", netmask[0], netmask[1], netmask[2], netmask[3]);
	printf ("start IP = %d.%d.%d.%d<br>\n", startaddr[0], startaddr[1], startaddr[2], startaddr[3]);
	printf ("end IP = %d.%d.%d.%d<br>\n", endaddr[0], endaddr[1], endaddr[2], endaddr[3]);
#endif
	while (idx--)
	{
		if ((localip[idx] & netmask[idx]) != (startaddr[idx] & netmask[idx]) ||
		    (localip[idx] & netmask[idx]) != (endaddr[idx] & netmask[idx]))
		    return 1;
	}

	idx = 0;
	while (idx < 4)
	{
		if ( (startaddr[idx] & (~netmask[idx] & 0x000000ff) ) >= (endaddr[idx] & (~netmask[idx] & 0x000000ff) ) )
		{
			if ( (startaddr[idx] & (~netmask[idx] & 0x000000ff) ) == (endaddr[idx] & (~netmask[idx] & 0x000000ff) ) )
			{
				if (idx == 3)
					return 1;
			}
			else if ( (startaddr[idx] & (~netmask[idx] & 0x000000ff) ) > (endaddr[idx] & (~netmask[idx] & 0x000000ff) ) )
				return 1;
		}
		else if ( (startaddr[idx] & (~netmask[idx] & 0x000000ff) ) < (endaddr[idx] & (~netmask[idx] & 0x000000ff) ) )
			return 0;
		idx++;
	}
	return 0;
}

#ifdef _USE_PRIVATE_CONF

BOOL check_dhcp_conf_exist (void)
{
	FILE * fp = NULL;

	fp = fopen (DHCP_CONF, "r");
	if (fp == NULL)
		return FALSE;
	fclose (fp);
	return TRUE;
}

void create_dhcp_conf (void)
{
	FILE * fp = NULL;
	struct dhcp_conf config;

	memset (&config, '\0', sizeof (config));
	fp = fopen (DHCP_CONF, "w");
	if (fp)
		fclose (fp);
	config.nOperate = 0;
	config.nMax_lease_time_day = 0;
	config.nMax_lease_time_hour = 0;
	strcpy (config.sStartAddress, "0.0.0.0");
	strcpy (config.sEndAddress, "0.0.0.0");
	/*strcpy (config.ReserveRange1.sStartadd, "0.0.0.0");
	strcpy (config.ReserveRange1.sEndadd, "0.0.0.0");
	strcpy (config.ReserveRange2.sStartadd, "0.0.0.0");
	strcpy (config.ReserveRange2.sEndadd, "0.0.0.0");
	strcpy (config.sDomain_name_server, "0.0.0.0");*/
	set_to_file (&config);
}

#endif

int set_to_file (struct dhcp_conf * p_config)
{
	//Enable_DHCP (p_config->nOperate, get_dhcp_device ());  //if use private config file, do not mark this line
	Set_DHCP_Range (0, p_config->sStartAddress);
	Set_DHCP_Range (1, p_config->sEndAddress);
	Set_Max_Lease_Time ((unsigned long)(p_config->nMax_lease_time_day * 60 * 60 * 24) + (unsigned long)(p_config->nMax_lease_time_hour * 60 * 60));
	Set_Max_Lease_Time_Day (p_config->nMax_lease_time_day);
	Set_Max_Lease_Time_Hour(p_config->nMax_lease_time_hour);
	/*Set_Reserve_Range (0, 0, p_config->ReserveRange1.sStartadd);
	/*Set_Reserve_Range (0, 0, p_config->ReserveRange1.sStartadd);
	Set_Reserve_Range (0, 1, p_config->ReserveRange1.sEndadd);
	Set_Reserve_Range (1, 0, p_config->ReserveRange2.sStartadd);
	Set_Reserve_Range (1, 1, p_config->ReserveRange2.sEndadd);*/
	//  set dns to uLinux.conf
	set_dns (p_config->sDomain_name_server);
	set_dns2 (p_config->sDomain_name_server2);
}

int set_to_file_netlinks (struct dhcp_conf * p_config, int link_num)
{
	unsigned long time;
	char time_str[32];
	char link_section[32];
	
	sprintf(link_section, "link%d", link_num);
	Conf_Set_Field(NETLINKS_CONF_FILE,link_section, "DHCP Start Range", p_config->sStartAddress);
	Conf_Set_Field(NETLINKS_CONF_FILE,link_section, "DHCP End Range", p_config->sEndAddress);
	time = (unsigned long)(p_config->nMax_lease_time_day * 60 * 60 * 24) + (unsigned long)(p_config->nMax_lease_time_hour * 60 * 60);
	sprintf(time_str, "%lu", time);
	Conf_Set_Field(NETLINKS_CONF_FILE,link_section, "DHCP Max Lease Time", time_str);
	//  set dns to NetLinks.conf
	Conf_Set_Field(NETLINKS_CONF_FILE,link_section, "DHCP Primary DNS", p_config->sDomain_name_server);
	Conf_Set_Field(NETLINKS_CONF_FILE,link_section, "DHCP Secondary DNS", p_config->sDomain_name_server2);
}

/*
int tab_replace (FILE * fp, char * oldstr)
{	
	if (fp == NULL)
		return -1;
		
	if (!strcmp (oldstr, "tab_style"))
	{
		fprintf (fp, tab_style);
	} 
	else if(!strcmp(oldstr, "ftcolor"))
	{
		if(!Tab_Clicked)
			fprintf (fp, "\"#666666\"");
		else
			fprintf (fp, "\"#ffffff\"");
	}
	else if(!strcmp(oldstr, "bgcolor"))
	{
		if(Tab_Clicked)
			fprintf (fp, "bgcolor=\"#ffffff\"");
		else
			fprintf (fp, "bgcolor=\"#ffffff\"");
	}
	else if(!strcmp(oldstr, "tab_name"))
	{
		fprintf (fp, "%s", cur_tab_name);
	}
	else if(!strcmp(oldstr, "link_path"))
	{
		fprintf(fp, "\"MM_goToURL('parent','/cgi-bin/network/lan_setting/lan_setting.cgi?func=main&tabname=%s", cur_tab_name);
	}
	else if(!strcmp(oldstr, "tab_non_selected_begin"))
	{
		if(Tab_Clicked)
			fprintf(fp, "<!--");
		else
			fprintf(fp, "");
	}
	else if(!strcmp(oldstr, "tab_non_selected_end"))
	{
		if(Tab_Clicked)
			fprintf(fp, "-->");
		else
			fprintf(fp, "");
	}
	else if(!strcmp(oldstr, "tab_selected_begin"))
	{
		if(!Tab_Clicked)
			fprintf(fp, "<!--");
		else
			fprintf(fp, "");
	}
	else if(!strcmp(oldstr, "tab_selected_end"))
	{
		if(!Tab_Clicked)
			fprintf(fp, "-->");
		else
			fprintf(fp, "");
	}
	else
		return CGI_REPLACE_FAIL;
	return CGI_REPLACE_OK;	
}
*/

void show_main (void)
{
	int index = 0;
	HEADER_ITEM	header;
	INPUT *tmp;

	bzero (&header, sizeof (header));
	header.back[0] = 0x0;
	header.home[0] = 0x0;
	header.logout[0] = 0x0;
	if(Is_Version_22())
		CGI_Get_Help(header.help, "help_network.html#network_lset_main");
	else
		CGI_Get_Help(header.help, "network_lset_main.html");

	if (g_def_file_type < 4)
		index = 1;
	else
		index = 2;

	CGI_Output_Html (MAIN_TITLE_PAGE, "$", lan_replace);
	CGI_Show_Menu_V3_1(FUNC_NETWORK, &header);
	CGI_Output_Html1(MENU_V3_HEADER_HTML, "$", NULL, NULL);
	CGI_Show_Menu_V3_2(szDefineFilePath [g_def_file_type], index);
	CGI_Output_Html1(MENU_V3_MIDDLE_HTML, "$", NULL, NULL);
	CGI_Output_Html(TABLE_TITLE_PAGE, "$", lan_replace);
	CGI_Output_Html(CAPTION_PAGE, "$", lan_replace);

//	CGI_Output_Html(MULTI_LAN_TAB_PAGE,  "$", tab_replace);  //jeffrey marked
	if (g_def_file_type < 4)
		CGI_Output_Html(LAN_SETTING, "$", lan_replace);

	CGI_Output_Html(MULTI_LAN_STATIC_IP_PAGE, "$", ip_replace);
	
	CGI_Output_Html(DNS_SETTING_EX_PAGE, "$", dns_replace_ex);  //jeffrey add
//	CGI_Output_Html(DHCP_MAIN_PAGE, "$", lan_replace);  //jeffrey marked
		
	//CGI_Output_Html(NETWORK_SPEED_PAGE, "$", lan_replace);//Shone marked
	
	CGI_Output_Html(JUMBO_FRAME_SET_PAGE, "$", lan_replace); // added by KenChen
	
	CGI_Output_Html(MAIN_SUBMIT_PAGE, "$", lan_replace);
	CGI_Output_Html(TABLE_TAIL_PAGE, "$", lan_replace);
	CGI_Output_Html1(MENU_V3_TAIL_HTML, "$", NULL, NULL);
	CGI_Output_Html(MAIN_TAIL_PAGE, "$", lan_replace);
}

void show_switch (void)
{
	int index = 0;
	HEADER_ITEM	header;

	is_lan_page = FALSE;

	bzero (&header, sizeof (header));
	header.back[0] = 0x0;
	header.home[0] = 0x0;
	header.logout[0] = 0x0;
	if(Is_Version_22())
		CGI_Get_Help(header.help, "help_network.html#network_lset_main");
	else
		CGI_Get_Help(header.help, "network_lset_main.html");

	if (g_def_file_type < 4)
		index = 1;
	else
		index = 2;

	CGI_Output_Html (SWITCH_TITLE_PAGE, "$", switch_replace);

	CGI_Show_Menu_V3_1(FUNC_NETWORK, &header);
	CGI_Output_Html1(MENU_V3_HEADER_HTML, "$", NULL, NULL);
	CGI_Show_Menu_V3_2(szDefineFilePath [g_def_file_type], index);
	CGI_Output_Html1(MENU_V3_MIDDLE_HTML, "$", NULL, NULL);

	CGI_Output_Html(TABLE_TITLE_PAGE, "$", switch_replace);
	CGI_Output_Html(CAPTION2_PAGE, "$", switch_replace);

	if (g_def_file_type < 4)
		CGI_Output_Html(LAN_SETTING, "$", switch_replace);

	CGI_Output_Html(IP_SETTING_PAGE, "$", switch_ip_replace);
	CGI_Output_Html(MAIN_SUBMIT_PAGE, "$", switch_replace);
	CGI_Output_Html(TABLE_TAIL_PAGE, "$", switch_replace);
	CGI_Output_Html1(MENU_V3_TAIL_HTML, "$", NULL, NULL);
	CGI_Output_Html(MAIN_TAIL_PAGE, "$", switch_replace);
}

void show_error (char * error)
{
	int index = 0;
	HEADER_ITEM	header;
	ERRMSG errormsg;

	bzero (&header, sizeof (header));
	header.back[0] = 0x0;
	header.home[0] = 0x0;
	header.logout[0] = 0x0;
	if(Is_Version_22())
		CGI_Get_Help(header.help, "help_network.html#network_lset_main");
	else
		CGI_Get_Help(header.help, "network_lset_main.html");

	if (g_def_file_type < 4)
		index = 1;
	else
		index = 2;

	CGI_Output_Html (ERROR_TITLE_PAGE, "$", lan_replace);

	  CGI_Show_Menu_V3_1(FUNC_NETWORK, &header);
	  CGI_Output_Html1(MENU_V3_HEADER_HTML, "$", NULL, NULL);
	  CGI_Show_Menu_V3_2(szDefineFilePath [g_def_file_type], index);
	  CGI_Output_Html1(MENU_V3_MIDDLE_HTML, "$", NULL, NULL);

	  errormsg.type = CGI_ERROR;
	  sprintf (errormsg.title, "NIC_DEF_STR01");
	  sprintf (errormsg.msg, "%s", error);
	  strcpy (errormsg.note, "");
	  CGI_Show_Error_V3 (&errormsg);

	  CGI_Output_Html1(MENU_V3_TAIL_HTML, "$", NULL, NULL);
	CGI_Output_Html (MAIN_TAIL_PAGE, "$", lan_replace);
}

void show_reboot (void)
{
	int index = 0;
	HEADER_ITEM	header;

	bzero (&header, sizeof (header));
	header.back[0] = 0x0;
	header.home[0] = 0x0;
	header.logout[0] = 0x0;
	if(Is_Version_22())
		CGI_Get_Help(header.help, "help_network.html#network_lset_main");
	else
		CGI_Get_Help(header.help, "network_lset_main.html");

	if (g_def_file_type < 4)
		index = 1;
	else
		index = 2;

	CGI_Output_Html (RESTART_TITLE_PAGE, "$", lan_replace);

	CGI_Show_Menu_V3_1(FUNC_NETWORK, &header);

	  CGI_Output_Html1(MENU_V3_HEADER_HTML, "$", NULL, NULL);
	    CGI_Show_Menu_V3_2(szDefineFilePath [g_def_file_type], index);
	  CGI_Output_Html1(MENU_V3_MIDDLE_HTML, "$", NULL, NULL);

	  CGI_Output_Html(QUERY_RESTART_PAGE, "$", nat_replace);

	  CGI_Output_Html1(MENU_V3_TAIL_HTML, "$", NULL, NULL);

	CGI_Output_Html (MAIN_TAIL_PAGE, "$", lan_replace);
}

void show_restarting (void)
{
	HEADER_ITEM	header;

	bzero (&header, sizeof (header));
	header.back[0] = 0x0;
	header.home[0] = 0x0;
	header.logout[0] = 0x0;
	if(Is_Version_22())
		CGI_Get_Help(header.help, "help_network.html#network_lset_main");
	else
		CGI_Get_Help(header.help, "network_lset_main.html");

	CGI_Output_Html (RESTARTING_TITLE_PAGE, "$", lan_replace);

	CGI_Show_Menu_V3_1(FUNC_WEBFS_1, &header);
        CGI_Output_Html(RESTARTING_PAGE, "$", nat_replace);
	CGI_Output_Html(MAIN_TAIL_PAGE, "$", lan_replace);
}

int get_def_type (void)
{
	return 0;
}

void set_lan_usage (int usage)
{
	NIC_NAS_INFO info;
	memset (&info, '\0', sizeof (info));

	NIC_Get_Info_From_uLinux (&info, NIC_LAN01);

	info.usage = usage;

	NIC_Set_Info_To_uLinux (&info);
}
