#!/bin/bash
# dhcpd         This shell script takes care of starting and stopping
#               dhcpd.
#
# description: dhcpd provide access to Dynamic Host Control Protocol.

DEV=''

# See how we were called.
case "$1" in
  start)
	# Stop daemons
	/bin/kill -HUP `/bin/pidof dhcpd`
	# Start daemons
	/usr/sbin/create_dhcpd_conf > /dev/null
	
	echo -n "Starting dhcpd: "
	if [ `/sbin/getcfg "DHCP Server" "Enable" -u -d "FALSE"` = FALSE ]
	then
		echo disabled
		exit 0
	fi
	if [ `/sbin/wlan_chk` = TRUE -a `/sbin/getcfg "WLAN" Support -u -d FALSE` = TRUE -a `/sbin/getcfg "WLAN" Enable -u -d FALSE` = TRUE ]; then
		DEV="br0"
	elif [ `/sbin/getcfg Network "BONDING Support" -u -d FALSE` = TRUE ]; then
		if [ `/sbin/getcfg eth0 "Bonding" -u -d TEST` = STANDALONE ]; then
			DEV="eth0"
		else
			DEV="bond0"
		fi
	else
		DEV=`/sbin/getcfg "Network" "Interface1" -d "eth0"`
	fi
	/sbin/daemon_mgr dhcpd start "/usr/bin/setsid /usr/sbin/dhcpd -q $DEV 2>/dev/null 1>/dev/null"
	echo -n "dhcpd"
	echo "."
	touch /var/lock/subsys/dhcpd
	
	echo -n "ddns update"
	/etc/init.d/ddns_update.sh > /dev/null
	echo "."
	
	
	;;
  stop)
	# Stop daemons.
	echo -n "Shutting down dhcpd: "
	/sbin/daemon_mgr dhcpd stop /usr/sbin/dhcpd
	kill -HUP `/bin/pidof dhcpd`
	echo -n "dhcpd"
	echo "."
	rm -f /var/lock/subsys/dhcpd
	;;
  restart)
	$0 start
	RETVAL=$?
	;;
  *)
#	echo "Usage: dhcpd { [start]|stop|[restart] }"
	exit 1
esac

exit 0
