//**************************************************************************
//
//	Copyright (c) 2001  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		dhcp_log.c
//
//	Abstract: 
//		dhcp_log
//
//	FUNCTIONS:
//
//	COMMENTS:
//
//	HISTORY:
//		V0.1 2001/09/30		Tiger Fu created
//		V1.0 2001/10/23		V1.0 Final
//
//**************************************************************************
#include 	<stdio.h>
#include 	<string.h>
#include 	<stdlib.h>
#include	<unistd.h>
#include	<time.h>

/* NAS lib */
#include	<cgi.h>
#include	<Util.h>
#include	<cfg_dhcp.h>
#include	<cfg_nic.h>
#include 	<cfg_fw.h>
#include 	<v2_menu.h>

#include	"dhcp_log.h"

#define		DEFINE_FILE_PATH			"/home/httpd/cgi-bin/network/lan_setting/dhcp_log/logs.def"
#define		DHCP_LOG_POSITION			3
#define		LAST_MAIN_PAGE				"/cgi-bin/index.cgi"

#define		PAGE_DO_NOT_EXIST			"/cgi-bin/data/help_notexist.html"

#define		HTML_TITLE_PAGE				"/home/httpd/cgi-bin/network/lan_setting/dhcp_log/html/html_title.html"
#define		HEAD_TITLE_PAGE				"/home/httpd/cgi-bin/network/lan_setting/dhcp_log/html/dhcp_log_head_title.html"
#define		FUNCTION_PAGE				"/home/httpd/cgi-bin/network/lan_setting/dhcp_log/html/dhcp_log_function.html"
#define		INCLUDE_PAGE				"/home/httpd/cgi-bin/network/lan_setting/dhcp_log/html/dhcp_log_include.html"
#define		HEAD_TAIL_PAGE				"/home/httpd/cgi-bin/network/lan_setting/dhcp_log/html/dhcp_log_head_title.html"
#define		BODY_TITLE_PAGE				"/home/httpd/cgi-bin/network/lan_setting/dhcp_log/html/dhcp_log_body_title.html"
#define		FORM_TITLE_PAGE				"/home/httpd/cgi-bin/network/lan_setting/dhcp_log/html/dhcp_log_form_title.html"

#define		LOG_TITLE_TITLE_PAGE			"/home/httpd/cgi-bin/network/lan_setting/dhcp_log/html/dhcp_log_title_title.html"
#define		DHCP_LOG_TITLE_PAGE			"/home/httpd/cgi-bin/network/lan_setting/dhcp_log/html/dhcp_log_title.html"
#define		DHCP_USAGE_PAGE 			"/home/httpd/cgi-bin/network/lan_setting/dhcp_log/html/dhcp_usage.html"
#define		SELECT_INDEX_PAGE			"/home/httpd/cgi-bin/network/lan_setting/dhcp_log/html/option_index.html"
#define		LAST_PAGE				"/home/httpd/cgi-bin/network/lan_setting/dhcp_log/html/last_page.html"
#define		NULL_LAST_PAGE				"/home/httpd/cgi-bin/network/lan_setting/dhcp_log/html/null_last_page.html"
#define		NEXT_PAGE				"/home/httpd/cgi-bin/network/lan_setting/dhcp_log/html/next_page.html"
#define		NULL_NEXT_PAGE				"/home/httpd/cgi-bin/network/lan_setting/dhcp_log/html/null_next_page.html"
#define		DHCP_LOG_CONTENT_PAGE			"/home/httpd/cgi-bin/network/lan_setting/dhcp_log/html/dhcp_log_content.html"
#define		DHCP_LOG_STATUS_PAGE			"/home/httpd/cgi-bin/network/lan_setting/dhcp_log/html/dhcp_log_status.html"

#define		DHCP_LOG_DISABLE_PAGE			"/home/httpd/cgi-bin/network/lan_setting/dhcp_log/html/dhcp_log_disable.html"

#define		FORM_TAIL_PAGE				"/home/httpd/cgi-bin/network/lan_setting/dhcp_log/html/form_tail.html"
#define		BODY_TAIL_PAGE				"/home/httpd/cgi-bin/network/lan_setting/dhcp_log/html/body_tail.html"
#define		HTML_TAIL_PAGE				"/home/httpd/cgi-bin/network/lan_setting/dhcp_log/html/html_tail.html"

int g_page_index = 1;
int g_page_count = 1;
int g_log_total = 0;
//#define	_DEBUG

int how_many_log ()
{
	int index = 0;
	char s[80];
	FILE * log_fp = fopen (DHCP_LOG_FILE, "r");
	if (log_fp)
	{
		while (fgets (s, sizeof (s), log_fp))
			index++;
		g_log_total = index;
		fclose (log_fp);
	}
	return index;
}

int get_btn (INPUT * form)
{
	INPUT		*pform;
	
/*	pform=form;
	while (pform != NULL)
	{

		if (strstr (pform->name, "CLOSE"))
			return LOG_CLOSE;
		else if (strstr (pform->name, "REFRESH"))
			return LOG_REFRESH;
		else if (strstr (pform->name, "LogClear"))
			return LOG_CLEAR;
		pform=(INPUT *)pform->next;
	}
*/	
	
	pform=form;
	while (pform != NULL)
	{
		if (strstr (pform->name, "select_page"))
			return SELECT_PAGE;
		pform=(INPUT *)pform->next;
	}

	return NOT_FOUND;	
}

int clear_database (void)
{
	return unlink (DHCP_LOG_FILE);
}

int get_current_page (INPUT * form)
{
	INPUT	*pform = NULL;
	
	pform=form;
	while (pform != NULL)
	{
		if (strstr (pform->name, "select_page"))
		{
			if (!strcmp (pform->val, "All"))
				return -1;
			return atoi (pform->val);
		}

		pform=(INPUT *)pform->next;
	}
	return DHCP_LOG_SUCCESS;	
}

int msg_replace (FILE * fp, char * oldstr, void * err_msg)
{
	char buf[80];
	if (fp == NULL)
		return -1;

	if (!strcmp (oldstr, "error_message"))
	{
		fprintf (fp, "%s", (char *)err_msg);
	}
	else
		return CGI_REPLACE_FAIL;
	return CGI_REPLACE_OK;
}

void show_message (char * msg)
{
	HEADER_ITEM	header;
	
	bzero (&header, sizeof (header));
	header.back[0] = 0x0;
	header.home[0] = 0x0;
	header.logout[0] = 0x0;
	if(Is_Version_22())
		CGI_Get_Help(header.help, "help_logs.html#help_dhcplogs");
	else
		CGI_Get_Help(header.help, "help_dhcplogs.html");
	
	CGI_Output_Html (HTML_TITLE_PAGE, "$", dhcp_log_replace);
	CGI_Output_Html (HEAD_TITLE_PAGE, "$", dhcp_log_replace);
	CGI_Output_Html (FUNCTION_PAGE, "$", dhcp_log_replace);
	CGI_Output_Html (INCLUDE_PAGE, "$", dhcp_log_replace);
	CGI_Output_Html (HEAD_TAIL_PAGE, "$", dhcp_log_replace);
	CGI_Output_Html (BODY_TITLE_PAGE, "$", dhcp_log_replace);
	
	CGI_Show_Menu_V3_1 (FUNC_STATISTICS, &header);

	  CGI_Output_Html1 (MENU_V3_HEADER_HTML, "$", NULL, NULL);
	    CGI_Show_Menu_V3_2 (DEFINE_FILE_PATH, DHCP_LOG_POSITION);
	  CGI_Output_Html1 (MENU_V3_MIDDLE_HTML, "$", NULL, NULL);

	    CGI_Output_Html (FORM_TITLE_PAGE, "$", dhcp_log_replace);
	    
	    CGI_Output_Html1 (DHCP_LOG_DISABLE_PAGE, "$", msg_replace, msg);

	    CGI_Output_Html (FORM_TAIL_PAGE, "$", dhcp_log_replace);
	    

	  CGI_Output_Html1 (MENU_V3_TAIL_HTML, "$", NULL, NULL);
	
	CGI_Output_Html (BODY_TAIL_PAGE, "$", dhcp_log_replace);
	CGI_Output_Html (HTML_TAIL_PAGE, "$", dhcp_log_replace);
}

int main ()
{
	INPUT	*arg=NULL, *form=NULL;
	char	buf[256];
	int	func = 0, btn = 0;
	int	errno;
	
	CGI_Init();
	CGI_Check_User ();

	arg=(INPUT *)CGI_Get_Input_URL();
	form=(INPUT *)CGI_Get_Input_FORM();
#ifdef _DEBUG
	CGI_Debug_Input(arg);
	CGI_Debug_Input(form);
#endif	
	remove_overdue_record (DHCP_LOG_FILE);
	how_many_log ();

	func=get_func(arg);
#ifdef _DEBUG
	printf ("func = %d<br>\n", func);
#endif

	switch (func)
	{
		case DHCP_LOG_MAIN:
			if (Is_DHCP_Enable ())
			{
				if (g_log_total > 0)
					show_main ();
				else
					show_message ("NO_ASSIGNED_MSG");
			}
			else
				show_message ("DISABLE_MSG");
			break;
			
		case DHCP_LOG_OK:
			if (form == NULL)
				btn = LOG_REFRESH;
			else
				btn = get_btn (form);
			if (btn == LOG_CLOSE)
				CGI_Load_Html (LAST_MAIN_PAGE);
			else if (btn == LOG_REFRESH || btn == SELECT_PAGE)
			{
				if (Is_DHCP_Enable ())
				{
					if (g_log_total > 0)
					{
						g_page_index = get_current_page (form);
						if (g_log_total < (LINE_PER_PAGE * (g_page_index - 1) + 1))
						{
							g_page_index = g_log_total / LINE_PER_PAGE;
							if (g_log_total % LINE_PER_PAGE)
								g_page_index ++;
						}
						show_main ();
					}
					else
						show_message ("NO_ASSIGNED_MSG");
				}
				else
					show_message ("DISABLE_MSG");
			}
			else if (btn == LOG_CLEAR)
			{
				if (Is_DHCP_Enable ())
				{
					clear_database ();
					show_message ("NO_ASSINGED_MSG");
				}
				else
					show_message ("DISABLE_MSG");
			}
			break;
			
		case DHCP_NO_FUN:
			break;
	}

	CGI_Free_Input(arg);
	CGI_Free_Input(form);
	
	return DHCP_LOG_SUCCESS;
}

int get_func (INPUT *arg)
{
	int	ret = DHCP_NO_FUN;
	INPUT	*parg;

	parg=arg;
	while (parg!=NULL)
	{
		if (!strcmp (parg->name, "func"))
		{
			if (!strcmp (parg->val, "main"))
				ret = DHCP_LOG_MAIN;
			else if (!strcmp (parg->val, "OK"))
				ret = DHCP_LOG_OK;
			break;
		}
		else if (!strcmp (parg->name, "page"))
		{
			ret = DHCP_LOG_MAIN;
			g_page_index = atoi (parg->val);
			if (g_log_total < (LINE_PER_PAGE * (g_page_index - 1) + 1))
			{
				g_page_index = g_log_total / LINE_PER_PAGE;
				if (g_log_total % LINE_PER_PAGE)
					g_page_index ++;
			}
		}
		parg=(INPUT *)parg->next;
	}
	return ret;
}

//#undef	_DEBUG
int remove_overdue_record (char * file_name)
{
	int number_of_log_overdue = 0;
	char buffer[80], s[256];
	struct tm record_end_tm;
	time_t record_end_time = 0, current_time;
	
	FILE * log_fp = fopen (file_name, "r");
	FILE * tmp_fp = tmpfile ();
	
	current_time = time (NULL);

	if (log_fp && tmp_fp)
	{
		while (fgets (s, sizeof (s), log_fp))
		{
			//EX: 2002/02/29-14:13:24
			if (!strstr (s, "#"))
			{
				number_of_log_overdue ++;
				continue;
			}
			sprintf (buffer, "%s", parser_log_endtime (s));
#ifdef _DEBUG
			printf ("buffer = %s<br>\n", buffer);
#endif
			sscanf (buffer, "%d/%d/%d-%d:%d:%d", &record_end_tm.tm_year,
							     &record_end_tm.tm_mon,
							     &record_end_tm.tm_mday,
							     &record_end_tm.tm_hour,
							     &record_end_tm.tm_min,
							     &record_end_tm.tm_sec);
#ifdef _DEBUG
			//  print the struct
			printf ("year = %d, month = %d, day = %d, hour = %d, min = %d, sec = %d<br>", 
				record_end_tm.tm_year, record_end_tm.tm_mon, record_end_tm.tm_mday,
	 			record_end_tm.tm_hour, record_end_tm.tm_min, record_end_tm.tm_sec);
#endif	 
	 		record_end_tm.tm_year -= 1900;	//  2002 = 102 and so on...
	 		record_end_tm.tm_mon -= 1;	//  May = 4 and so on...
	 		record_end_time = mktime (&record_end_tm);
#ifdef _DEBUG
			printf ("current  = %d, record = %d<br>\n", current_time, record_end_time);
#endif
	 		if (current_time < record_end_time)
	 		{
	 			fprintf (tmp_fp, "%s", s);
	 		}
	 		else
			{
#ifdef _DEBUG
				printf ("overtime<br>\n");
#endif
				number_of_log_overdue ++;

			}
		}
		fclose (log_fp);
		
		if (number_of_log_overdue)
		{
			log_fp = fopen (file_name, "w");
			fseek (tmp_fp, 0, SEEK_SET);

			if (log_fp)
			{
				while (fgets (s, sizeof (s), tmp_fp))
				{
					if (strstr (s, "#"))
						fprintf (log_fp, "%s", s);
				}
				fclose (log_fp);
			}
		}
	}
	fclose (tmp_fp);
	return number_of_log_overdue;
}

// don't care follow code
#if 0
int compare_time (struct tm * current_tm, struct tm * record_end_tm)
{
	
	int result = 0;
	if (current_tm->tm_year > record_end_tm->tm_year)
		result = -1;
	else if (current_tm->tm_year < record_end_tm->tm_year)
		result = 1;
	else
	{
		if (current_tm->tm_mon > record_end_tm->tm_mon)
			result = -1;
		else if (current_tm->tm_mon < record_end_tm->tm_mon)
			result = 1;
		else
		{
			if (current_tm->tm_hour > record_end_tm->tm_hour)
				result = -1;
			else if (current_tm->tm_hour < record_end_tm->tm_hour)
				result = 1;
			else 
			{
				if (current_tm->tm_min > record_end_tm->tm_min)
					result = -1;
				else if (current_tm->tm_min < record_end_tm->tm_min)
					result = 1;
				else
				{
					if (current_tm->tm_sec > record_end_tm->tm_sec)
						result = -1;
					else if (current_tm->tm_sec < record_end_tm->tm_sec)
						result = 1;
					else
						result = 0;
				}
			}
		}
	}
	return result;
}
#endif

int get_file_size (void * fp)
{
	int size = 0;
	if (fp != NULL)
	{
		fseek (fp, 0, SEEK_END);
		size = ftell (fp);
		fseek (fp, 0, SEEK_SET);
	}
	return size;
}

int dhcp_log_replace (FILE * fp, char * oldstr)
{
	char s[256];

	if (fp == NULL)
		return -1;

	if (!strcmp (oldstr, "dhcp_state"))
	{
		CGI_Output_Html1 (DHCP_USAGE_PAGE, "$", dhcp_log_title_replace, NULL);
	}
	else if (!strcmp (oldstr, "log_option")) 
	{
		FILE * log_fp = fopen (DHCP_LOG_FILE, "r");
		int index = 0;

		if (log_fp)
		{
			
			while (fgets (s, sizeof (s), log_fp))
			{
				index++;
				if ((index >= (LINE_PER_PAGE * (g_page_index - 1) + 1) && index <= LINE_PER_PAGE * g_page_index) || g_page_index == -1)
				{
					if (strstr (s, "#"))
						CGI_Output_Html1 (DHCP_LOG_CONTENT_PAGE, "$", dhcp_log_content_replace, (void *)s);
					else
						CGI_Output_Html1 (DHCP_LOG_STATUS_PAGE, "$", dhcp_log_status_replace, (void *)s);
				}
			}
			fclose (log_fp);
		}
	}
	else if (!strcmp (oldstr, "option_index"))
	{
		int index = 0, page_index = 0, file_size = 0;
		FILE * log_fp = NULL;
		
		log_fp = fopen (DHCP_LOG_FILE, "r");
		
		if (log_fp)
		{
			file_size = get_file_size (log_fp);
			while (fgets (s, sizeof (s), log_fp))
			{
				index++;
				if (index == LINE_PER_PAGE)
				{
					page_index++;
					if (page_index != 1 || (ftell (log_fp) < file_size))
						CGI_Output_Html1 (SELECT_INDEX_PAGE, "$", dhcp_log_title_replace, (void *)&page_index);
					index = 0;
				}
			}
			if (index != 0)
				page_index++;
			g_page_count = page_index;
			if ((g_page_count > 1) && (index != 0))
				CGI_Output_Html1 (SELECT_INDEX_PAGE, "$", dhcp_log_title_replace, (void *)&page_index);
			fclose (log_fp);
		}
	}
	else if (!strcmp (oldstr, "last_page"))
	{
		if (g_page_index > 1 && g_page_index != -1)
			CGI_Output_Html1 (LAST_PAGE, "$", which_page_replace, NULL);
		else
			CGI_Output_Html1 (NULL_LAST_PAGE, "$", which_page_replace, NULL);
	}
	else if (!strcmp (oldstr, "next_page"))
	{
		if (g_page_index < g_page_count && g_page_index != -1)
			CGI_Output_Html1 (NEXT_PAGE, "$", which_page_replace, NULL);
		else
			CGI_Output_Html1 (NULL_NEXT_PAGE, "$", which_page_replace, NULL);
	}
	else if (!strcmp (oldstr, "log_number"))
	{
		fprintf (fp, "%d", g_log_total);
	}
	else if (!strcmp (oldstr, "title"))
	{
		if (g_log_total > 0)
		{
			CGI_Output_Html (LOG_TITLE_TITLE_PAGE, "$", dhcp_log_replace);
		}
	}
	else
		return CGI_REPLACE_FAIL;
	return CGI_REPLACE_OK;
}

int which_page_replace (FILE * fp, char * oldstr, void * index)
{
	if (fp == NULL)
		return -1;

	if (!strcmp (oldstr, "next_page_index"))
	{
		fprintf (fp, "%d", g_page_index + 1);
	}
	else if (!strcmp (oldstr, "last_page_index"))
	{
		fprintf (fp, "%d", g_page_index - 1);
	}
	else
		return CGI_REPLACE_FAIL;
	return CGI_REPLACE_OK;
}

int dhcp_log_title_replace (FILE * fp, char * oldstr, void * index)
{
	char s[256];

	if (fp == NULL)
		return -1;

	if (!strcmp (oldstr, "usage"))
	{
		if (Is_DHCP_Enable ())
			fprintf (fp, "DHCP_ENABLE");
		else
			fprintf (fp, "DHCP_DISABLE");
	}
	else if (!strcmp (oldstr, "index"))
	{
		fprintf (fp, "%d", *((int *)index));
	}
	else if (!strcmp (oldstr, "index_selected"))
	{
		if (*((int *)index) == g_page_index)
			fprintf (fp, "selected");
	}
	else
		return CGI_REPLACE_FAIL;
	return CGI_REPLACE_OK;
}

int dhcp_log_content_replace (FILE * fp, char * oldstr, void * record)
{
	char buf[80];
	if (fp == NULL)
		return -1;

	if (!strcmp (oldstr, "ip_addr"))
	{
		fprintf (fp, "%s", parser_log_ipaddr ((char *)record));
	}
	else if (!strcmp (oldstr, "hw_addr"))
	{
		fprintf (fp, "%s", parser_log_hwaddr ((char *)record));
	}
	else if (!strcmp (oldstr, "starts_time"))
	{
		fprintf (fp, "%s", parser_log_startstime ((char *)record));
	}
	else if (!strcmp (oldstr, "end_time"))
	{
		fprintf (fp, "%s", parser_log_endtime ((char *)record));
	}
	else
		return CGI_REPLACE_FAIL;
	return CGI_REPLACE_OK;
}

int dhcp_log_status_replace (FILE * fp, char * oldstr, void * record)
{
	char buf[80];
	if (fp == NULL)
		return -1;

	if (!strcmp (oldstr, "status"))
	{
		fprintf (fp, "%s", (char *)record);
	}
	else
		return CGI_REPLACE_FAIL;
	return CGI_REPLACE_OK;
}

void show_main (void)
{
	HEADER_ITEM	header;
	
	bzero (&header, sizeof (header));
	header.back[0] = 0x0;
	header.home[0] = 0x0;
	header.logout[0] = 0x0;
	if(Is_Version_22())
		CGI_Get_Help(header.help, "help_logs.html#help_dhcplogs");
	else
		CGI_Get_Help(header.help, "help_dhcplogs.html");
	
	CGI_Output_Html (HTML_TITLE_PAGE, "$", dhcp_log_replace);
	CGI_Output_Html (HEAD_TITLE_PAGE, "$", dhcp_log_replace);
	CGI_Output_Html (FUNCTION_PAGE, "$", dhcp_log_replace);
	CGI_Output_Html (INCLUDE_PAGE, "$", dhcp_log_replace);
	CGI_Output_Html (HEAD_TAIL_PAGE, "$", dhcp_log_replace);
	CGI_Output_Html (BODY_TITLE_PAGE, "$", dhcp_log_replace);
	
	CGI_Show_Menu_V3_1 (FUNC_STATISTICS, &header);

	  CGI_Output_Html1 (MENU_V3_HEADER_HTML, "$", NULL, NULL);
	    CGI_Show_Menu_V3_2 (DEFINE_FILE_PATH, DHCP_LOG_POSITION);
	  CGI_Output_Html1 (MENU_V3_MIDDLE_HTML, "$", NULL, NULL);

	    CGI_Output_Html (FORM_TITLE_PAGE, "$", dhcp_log_replace);
	    
	    CGI_Output_Html (DHCP_LOG_TITLE_PAGE, "$", dhcp_log_replace);

	    CGI_Output_Html (FORM_TAIL_PAGE, "$", dhcp_log_replace);
	    

	  CGI_Output_Html1 (MENU_V3_TAIL_HTML, "$", NULL, NULL);
	
	CGI_Output_Html (BODY_TAIL_PAGE, "$", dhcp_log_replace);
	CGI_Output_Html (HTML_TAIL_PAGE, "$", dhcp_log_replace);
}

static char * parser_log_ipaddr (char * src)
{
	static char buf[16];
	int index = 0, len = strlen (src);

	bzero (buf, sizeof (buf));
	while (index < len)
	{
		if (src[index] == '#')
			break;
		buf[index] = src[index++];
	}
	return buf;
}

static char * parser_log_hwaddr (char * src)
{
	static char buf[32];
	int index = 0, index1 = 0, len = strlen (src);

	bzero (buf, sizeof (buf));
	
	while (index < len)
	{
		if (src[index++] == '#')
			break;
	}

	while (index < len)
	{
		if (src[index] == '#')
			break;
		buf[index1++] = src[index++];
	}
	return buf;
}

static char * parser_log_startstime (char * src)
{	
	static char buf[64];
	int index = 0, index1 = 0, index2 = 0, len = strlen (src);

	bzero (buf, sizeof (buf));
	while (index < len)
	{
		if (src[index++] == '#')
			index2++;
		if (index2 == 2)
			break;
	}

	while (index < len)
	{
		if (src[index] == '#')
			break;
		buf[index1++] = src[index++];
	}
	return buf;
}

static char * parser_log_endtime (char * src)
{
	static char buf[64];
	int index = 0, index1 = 0, index2 = 0, len = strlen (src);

	bzero (buf, sizeof (buf));
	while (index < len)
	{
		if (src[index++] == '#')
			index2++;
		if (index2 == 3)
			break;
	}

	while (index < len)
	{
		buf[index1++] = src[index++];
	}
	return buf;
}
