#include <stdio.h>
#include <string.h>

/* NAS lib */
#include <cgi.h>
#include <NAS.h>
#include <cfg_ftp.h>
#include <v2_menu.h>
#include <cfg_printer.h>
#include <cfg_dns.h>

/* local include */
#include "ftp_setting.h"

//#define _DEBUG		1

TAG_FTP		g_ftp;

int get_func(INPUT *arg)
{
	int	ret=FTP_NOFUNC;
	INPUT	*result;

	result=CGI_Find_Parameter(arg, "func");
	if (result!=NULL)
	{
		if (!strcmp(result->val, "main"))
			ret=FTP_MAIN;
		else
		if (!strcmp(result->val, "main_ok"))
			ret=FTP_OK;
	}
	return ret;
}

int ftp_replace(FILE *fptr, char *oldstr)
{
	if (!strcmp(oldstr, "ftp_enable"))
	{
		(g_ftp.enable==1)?fprintf(fptr, "checked"):fprintf(fptr, "");
	}
	else
	if (!strcmp(oldstr, "ftp_disalbed"))
	{
		(g_ftp.enable==1)?fprintf(fptr, ""):fprintf(fptr, "disabled");
	}
	else
	if (!strcmp(oldstr, "ftp_port"))
	{
		fprintf(fptr, "%d", g_ftp.port);
	}
	else
	if (!strcmp(oldstr, "ftp_maxinstances"))
	{
		fprintf(fptr, "%d", g_ftp.maxinstances);
	}
	else
	if (!strcmp(oldstr, "ftp_allowanonymous"))
	{
		(g_ftp.allowanonymous==1)?fprintf(fptr, "checked"):fprintf(fptr, "");
	}
	else
	if (!strcmp(oldstr, "ftp_maxanonymous"))
	{
		fprintf(fptr, "%d", g_ftp.maxanonymous);
	}
	else
	if (strcasecmp(oldstr, "ftp_unicode_enable") == 0) {
		(g_ftp.unicode==1)?fprintf(fptr, "checked"):fprintf(fptr, "");
	}
	else
	if (strcasecmp(oldstr, "ftp_unicode_disable") == 0) {
		(g_ftp.unicode==0)?fprintf(fptr, "checked"):fprintf(fptr, "");
	}
	else
	if (strcasecmp(oldstr, "CODEPAGE_LIST") == 0) {
		int i, ftp_codepage;
		char *codepage_sorted[11]=
		{
			"999",
			"936",
			"950",
			"866",
			"437",
			"737",
			"861",
			"932",
			"949",
			"852",
			"850"
		};
		ftp_codepage = g_ftp.charsetremote;
		//replace the codepage_value with codepage_sorted by Andy Wu Apr. 9 2003
		for (i = 0; i < 11; i++) {
			if (atoi(codepage_sorted[i]) == ftp_codepage) {
				fprintf(fptr, "<OPTION Value=%d SELECTED>\' + IEI_IDS_STRING%d + \'</OPTION>", ftp_codepage, ftp_codepage);
			}
			else {
				fprintf(fptr, "<OPTION Value=%d>\' + IEI_IDS_STRING%d + \'</OPTION>", atoi(codepage_sorted[i]), atoi(codepage_sorted[i]));
			}
		}
	}
	else
		return CGI_REPLACE_FAIL;
	return CGI_REPLACE_OK;
}

int ftp_submit(INPUT *form)
{
	TAG_FTP		ftp;
	INPUT		*pform;
	char		command[256];

	pform=form;
	memset(&ftp, 0x0, sizeof(TAG_FTP));
	ftp.charsetremote = 999;
	while (pform!=NULL)
	{
		if (!strcmp(pform->name, "ftp_enable"))
		{
			ftp.enable=1;
		}
		else
		if (!strcmp(pform->name, "ftp_port"))
		{
			ftp.port=atoi(pform->val);
		}
		else
		if (!strcmp(pform->name, "ftp_maxinstances"))
		{
			ftp.maxinstances=atoi(pform->val);
		}
		else
		if (!strcmp(pform->name, "ftp_allowanonymous"))
		{
			ftp.allowanonymous=1;
		}
		else
		if (!strcmp(pform->name, "ftp_maxanonymous"))
		{
			ftp.maxanonymous=atoi(pform->val);
		}
		else
		if (!strcmp(pform->name, "CODEPAGE"))
		{
			ftp.charsetremote = atoi(pform->val);
		}
		else
		if (!strcmp(pform->name, "ftp_unicode"))
		{
			ftp.unicode = atoi(pform->val);
		}
		pform=(INPUT *)pform->next;
	}
	ftp.maxanonymous=ftp.maxinstances;
	ftp.allowanonymous=0;
	strcpy(ftp.servername, g_ftp.servername);
	strcpy(ftp.user, g_ftp.user);
	strcpy(ftp.group, g_ftp.group);
	strcpy(ftp.defaultroot, g_ftp.defaultroot);
	Ftp_Write_Tag(&ftp);
	FTP_Create_Conf();
//	if (ftp.enable!=g_ftp.enable)
//	{
	if (ftp.enable==1)
		sprintf(command, "%s restart", FTP_SHELL);
	else
		sprintf(command, "%s stop", FTP_SHELL);
#ifdef _DEBUG
	printf("command=%s<br>\n", command);
#endif
	system(command);

	Ftp_Read_Tag(&g_ftp);	/* update g_ftp setting */
	return 1;
}

int show_ftp_header ()
{
	HEADER_ITEM	header;
	int	nic_count;

	CGI_Output_Html(FTP_HEADER_HTML, "$", ftp_replace);
        header.back[0]=0x0;
        header.home[0]=0x0;
        header.logout[0]=0x0;
	if(Is_Version_22())
		CGI_Get_Help(header.help, "help_network.html#network_ftp_main");
	else
		CGI_Get_Help(header.help, "network_ftp_main.html");
        CGI_Show_Menu_V3_1(FUNC_NETWORK, &header);
        CGI_Output_Html(MENU_V3_HEADER_HTML, "$", ftp_replace);
        nic_count=NIC_Count_Interface();

        CGI_Show_Menu_V3_2("/home/httpd/cgi-bin/network/network.def", 5);

        CGI_Output_Html(MENU_V3_MIDDLE_HTML, "$", ftp_replace);
	return 1;
}

int show_ftp_tail()
{
	CGI_Output_Html(MENU_V3_TAIL_HTML, "$", ftp_replace);
        return CGI_Output_Html(FTP_TAIL_HTML, "$", ftp_replace);
}

int do_ftp_main()
{
	show_ftp_header();
	CGI_Output_Html(FTP_MAIN_HTML, "$", ftp_replace);
	show_ftp_tail();
	return 1;
}

int do_ftp_main_submit(INPUT *form)
{
	ftp_submit(form);
//	CGI_Load_Html("/cgi-bin/network/network.cgi?func=main");
	do_ftp_main();
	return 1;
}

int main()
{
	INPUT	*arg=NULL, *form=NULL;
	int	func, ret;

	CGI_Init();
	CGI_Check_User();
	arg=(INPUT *)CGI_Get_Input_URL();
	form=(INPUT *)CGI_Get_Input_FORM();

#ifdef _DEBUG
	CGI_Debug_Input(arg);
	CGI_Debug_Input(form);
#endif

	func=get_func(arg);
	Ftp_Read_Tag(&g_ftp);
	switch (func)
	{
		case FTP_MAIN:
			do_ftp_main();
			break;
		case FTP_OK:
			do_ftp_main_submit(form);
			break;
		case FTP_NOFUNC:
			break;
	}

	CGI_Free_Input(arg);
	CGI_Free_Input(form);
	return FTP_SUCCESS;
}

