//**************************************************************************
//
//	Copyright (c) 2001  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		dns_main.c
//
//	Abstract:
//		DNS main cgi
//
//	FUNCTIONS:
//
//	COMMENTS:
//
//	HISTORY:
//		V1.0 2001/08/09		Tiger Fu created
//
//**************************************************************************
#include 	<stdio.h>
#include 	<string.h>
#include 	<stdlib.h>

/* NAS lib */
#include	<Util.h>
#include	<cgi.h>
#include	<cfg_dns.h>
#include	<cfg_dhcp.h>
#include 	<v2_menu.h>

#include	"dns_zone.h"
#include 	"dns_main.h"

#define		DEFINIENS_FILE_PATE			"/home/httpd/cgi-bin/network/dns_server.def"
#define		BASIC_HELP_PAGE				"/cgi-bin/network/dns_setting/html/dns_help.html"
#define		ADVANCE_MASTER_HELP_PAGE		"/cgi-bin/network/dns_setting/html/dns_help.html"
#define		ADVANCE_SLAVE_HELP_PAGE			"/cgi-bin/network/dns_setting/html/dns_help.html"
#define		LAST_PAGE				"/cgi-bin/network/dns_setting/dns_setting.cgi?func=main&counter=%d"
#define		EMPTY_TITLE_PAGE			"/home/httpd/cgi-bin/network/dns_setting/html/dns_title.html"
#define		FORM_TITLE_PAGE				"/home/httpd/cgi-bin/network/dns_setting/html/form_title.html"
#define		ERROR_PAGE				"/home/httpd/cgi-bin/network/dns_setting/html/error_message.html"

#define		BODY_TITLE_PAGE				"/home/httpd/cgi-bin/network/dns_setting/html/body_title.html"
#define		BASIC_ADVANCE_PAGE			"/home/httpd/cgi-bin/network/dns_setting/html/basic_advance.html"
#define		BASIC_MOTION_PAGE			"/home/httpd/cgi-bin/network/dns_setting/html/basic_motion.html"
#define		BASIC_STATIC_PAGE			"/home/httpd/cgi-bin/network/dns_setting/html/basic_static.html"
#define		ADVANCE_MOTION_PAGE			"/home/httpd/cgi-bin/network/dns_setting/html/advance_motion.html"
#define		ADVANCE_STATIC_PAGE			"/home/httpd/cgi-bin/network/dns_setting/html/advance_static.html"
#define		TITLE_PAGE				"/home/httpd/cgi-bin/network/dns_setting/html/templet_dns_title.html"
#define		BASIC_BODY_TITLE_PAGE			"/home/httpd/cgi-bin/network/dns_setting/html/basic_body_title.html"
#define		ADVANCE_BODY_TITLE_PAGE			"/home/httpd/cgi-bin/network/dns_setting/html/advance_body_title.html"

#define		TABLE_TITLE_PAGE			"/home/httpd/cgi-bin/network/dns_setting/html/dns_table_title.html"
#define		BASIC_FORM_TITLE_PAGE			"/home/httpd/cgi-bin/network/dns_setting/html/dns_basic_form_title.html"
#define		CAPTION_PAGE				"/home/httpd/cgi-bin/network/dns_setting/html/dns_caption.html"
#define		MAIN_PAGE				"/home/httpd/cgi-bin/network/dns_setting/html/templet_dns_main.html"
#define		FORM_TAIL_PAGE				"/home/httpd/cgi-bin/network/dns_setting/html/form_tail.html"
#define		TABLE_TAIL_PAGE				"/home/httpd/cgi-bin/network/dns_setting/html/dns_table_tail.html"

#define		ADVANCE_FORM_TITLE_PAGE			"/home/httpd/cgi-bin/network/dns_setting/html/dns_advance_form_title.html"
#define		MASTER_SETTING_PAGE			"/home/httpd/cgi-bin/network/dns_setting/html/templet_master_setting.html"
#define		SLAVE_SETTING_PAGE			"/home/httpd/cgi-bin/network/dns_setting/html/templet_slave_setting.html"
#define		SERVER_TYPE_PAGE			"/home/httpd/cgi-bin/network/dns_setting/html/templet_server_type.html"
#define		RECORD_PAGE				"/home/httpd/cgi-bin/network/dns_setting/html/templet_record_option.html"
#define		SLAVE_INFO_PAGE				"/home/httpd/cgi-bin/network/dns_setting/html/templet_slave_zone.html"
#define		SUBMIT_PAGE				"/home/httpd/cgi-bin/network/dns_setting/html/templet_main_submit.html"
#define		TAIL_PAGE				"/home/httpd/cgi-bin/network/dns_setting/html/templet_dns_tail.html"

#define		CONF_TMP_FILE				"/tmp/uLinux.dns.tmp"

char *szDefineFilePath[] = {"/home/httpd/cgi-bin/network/network-1.def",
			    "/home/httpd/cgi-bin/network/network-1.noprn.def",
			    "/home/httpd/cgi-bin/network/network-2.def",
			    "/home/httpd/cgi-bin/network/network-2.noprn.def"};
int g_def_file_type = 0; //  0 -->  1 network interface without printer
			 //  1 -->  1 network interface support printer
			 //  2 -->  2 network interface without printer
			 //  3 -->  2 network interface support printer

int g_index = 0, g_server_type;
int g_temp_index = 0;
char g_temp_file_name[256];

//#define		_DEBUG

int main ()
{
	INPUT	*arg=NULL, *form=NULL;
	int	func, ret;
	char buf[256];
	int errno;

	CGI_Init();
	CGI_Check_User ();

	arg=(INPUT *)CGI_Get_Input_URL();
	form=(INPUT *)CGI_Get_Input_FORM();

	g_server_type = get_ns_type ();
	g_def_file_type = get_def_type ();
#ifdef _DEBUG
	CGI_Debug_Input(arg);
	CGI_Debug_Input(form);
#endif
	func=get_func(arg);
#ifdef _DEBUG
	printf ("func = %d<br>\n", func);
#endif

	switch (func)
	{
		case DNSMAIN:
			g_temp_index = generate_temp_file_index ();
			sprintf (g_temp_file_name, "/tmp/uLinux.dns.tmp.%d", g_temp_index);
			load_conf_to_tmp ();
			do_main ();
			break;

		case DNSLEVEL:
			switch (select_function (form))
			{
			case 0:  //  change type
				set_modify_action (TRUE);
				//  get tmp file name for do_main () use  ***************************
				get_temp_file_name (form, g_temp_file_name, sizeof (g_temp_file_name));
				select_type (form);
				ret = do_main ();
				set_modify_action (FALSE);
				break;

			case 1:  //  select page
				set_modify_action (TRUE);
				//  get tmp file name for do_main () use  ***************************
				get_temp_file_name (form, g_temp_file_name, sizeof (g_temp_file_name));
				select_page (form);
				ret = do_main ();
				set_modify_action (FALSE);
				break;

			case 2:  //  edit resource record
				set_modify_action (TRUE);
				//  get tmp file name for do_main () use  ***************************
				get_temp_file_name (form, g_temp_file_name, sizeof (g_temp_file_name));
				set_private_ns_type (E_Master, g_temp_file_name);
				ret = modify_master (form);
				if (ret == INPUT_IP_ERROR)
					show_error ("ERROR_INVALID_IP");
				else if (ret == INPUT_NAME_ERROR)
					show_error ("ERROR_INVALUE_CHARACTER");
				else
					ret = do_main ();
				set_modify_action (FALSE);
				break;

			case 3:  //  edit slave zone
				set_modify_action (TRUE);
				//  get tmp file name for do_main () use  ***************************
				get_temp_file_name (form, g_temp_file_name, sizeof (g_temp_file_name));
				set_private_ns_type (E_Slave, g_temp_file_name);
				ret = modify_slave (form);
				if (ret == INPUT_IP_ERROR)
					show_error ("ERROR_INVALID_IP");
				else if (ret == INPUT_NAME_ERROR)
					show_error ("ERROR_INVALUE_CHARACTER");
				else
					ret = do_main ();
				set_modify_action (FALSE);
				break;

			case -1:
				//  get tmp file name  ***************************
				get_temp_file_name (form, g_temp_file_name, sizeof (g_temp_file_name));
				if (dns_submit (form) == CHECK_FAIL)
					show_error ("ERROR_INVALID_FORWARD_IP");
				else
				{
					unlink (g_temp_file_name);
					sprintf (buf, LAST_PAGE, time(NULL));
					ret = CGI_Load_Html (buf);
					set_modify_action (FALSE);
				}
				break;
			}
			break;

		case DNSOK:
			set_modify_action (FALSE);
			//  get tmp file name  ***************************
			get_temp_file_name (form, g_temp_file_name, sizeof (g_temp_file_name));
			if (dns_submit (form) == CHECK_FAIL)
					show_error ("ERROR_INVALID_FORWARD_IP");
			else
			{
				unlink (g_temp_file_name);
				sprintf (buf, LAST_PAGE, time(NULL));
				ret = CGI_Load_Html (buf);
			}

			break;

		//  old function
		/*case DNSBASIC:
			ret = do_basic ();
			break;

		case DNSADVANCE:
			ret = do_advance ();
			break;

		case MASTER_DNS_EDIT:
			set_modify_action (TRUE);
			set_private_ns_type (E_Master, );
			modify_master (form);
			ret = do_main ();
			set_modify_action (FALSE);
			break;

		case SLAVE_DNS_EDIT:
			set_modify_action (TRUE);
			set_private_ns_type (E_Slave, );
			modify_slave (form);
			ret = do_main ();
			set_modify_action (FALSE);
			break;

		case SELECT_SERVER_TYPE:
			set_modify_action (TRUE);
			select_type (form);
			ret = do_main ();
			set_modify_action (FALSE);*/
		case DNSNOFUNC:
			break;
	}

	CGI_Free_Input(arg);
	CGI_Free_Input(form);

	return DNSSUCCESS;
}

int get_func (INPUT *arg)
{
	int	ret = DNSNOFUNC;
	INPUT	*parg;
	parg=arg;
	while (parg!= NULL)
	{
		if (!strcmp (parg->name, "func"))
		{
			if (!strcmp (parg->val, "main"))
				ret = DNSMAIN;
			else if (!strcmp (parg->val, "level"))
				ret = DNSLEVEL;
			/*else if (!strcmp (parg->val, "basic"))
				ret = DNSBASIC;
			else if (!strcmp (parg->val, "advance"))
				ret = DNSADVANCE;*/
			else if (!strcmp (parg->val, "OK"))
				ret = DNSOK;
			/*else if (!strcmp (parg->val, "master"))
				ret = MASTER_DNS_EDIT;
			else if (!strcmp (parg->val, "slave"))
				ret = SLAVE_DNS_EDIT;*/
			else if (!strcmp (parg->val, "change_type"))
				ret = SELECT_SERVER_TYPE;
			break;
		}
		parg=(INPUT *)parg->next;
	}
	return ret;
}

int basic_advance_replace (FILE * fp, char * oldstr, void * action)
{
	if (fp == NULL)
		return -1;

	if (!strcmp (oldstr, "basic_pic"))
	{
		if ((*(int *)action) == 0)
			CGI_Output_Html1 (BASIC_STATIC_PAGE, "$", basic_advance_replace, action);
		else
			CGI_Output_Html1 (BASIC_MOTION_PAGE, "$", basic_advance_replace, action);

	}
	else if (!strcmp (oldstr, "advance_pic"))
	{
		if ((*(int *)action) == 1)
			CGI_Output_Html1 (ADVANCE_STATIC_PAGE, "$", basic_advance_replace, action);
		else
			CGI_Output_Html1 (ADVANCE_MOTION_PAGE, "$", basic_advance_replace, action);
	}
	else
		return CGI_REPLACE_FAIL;
	return CGI_REPLACE_OK;
}

int dns_error_replace (FILE * fp, char * oldstr, void * error)
{
	if (fp == NULL)
		return CGI_REPLACE_FAIL;

	if (!strcmp (oldstr, "error_message"))
	{
		fprintf (fp, "%s", (char *)error);
	}
	else
		return CGI_REPLACE_FAIL;
	return CGI_REPLACE_OK;
}

int dns_replace(FILE * fp, char * oldstr)
{
	if (fp == NULL)
		return CGI_REPLACE_FAIL;

	if (!strcmp (oldstr, "dns_operate"))
	{
		if (is_private_dns_enable (g_temp_file_name))
			fprintf (fp, "checked");
		else
			fprintf (fp, "");
	}
	else if (!strcmp (oldstr, "DomainName"))
	{
		fprintf (fp, "%s", get_private_domain_name (g_temp_file_name));
	}
	else if (!strcmp (oldstr, "slave_dns"))
	{
		if (get_private_ns_type (g_temp_file_name)  == E_Slave)
			fprintf (fp, "checked");
	}
	else if (!strcmp (oldstr, "master_dns"))
	{
		if (get_private_ns_type (g_temp_file_name)  == E_Master)
			fprintf (fp, "checked");
	}
	else if (!strcmp (oldstr, "ns_type"))
	{
		fprintf (fp, "%d", get_private_ns_type (g_temp_file_name));
		switch (get_private_ns_type (g_temp_file_name) )
		{
		case 0:
			fprintf (fp, "MASTER");
			break;
		case 1:
			fprintf (fp, "SLAVE");
			break;
		}
	}
	else if (!strcmp (oldstr, "dns_active"))
	{
		fprintf (fp, "%d", Is_DNS_Enable ());
	}
	else if (!strcmp (oldstr, "name_server_type"))
	{
		switch (get_private_ns_type (g_temp_file_name))
		{
		case E_Master:
			CGI_Output_Html (MASTER_SETTING_PAGE, "$", master_dns_replace);
			break;
		case E_Slave:
			CGI_Output_Html (SLAVE_SETTING_PAGE, "$", slave_dns_replace);
			break;
		}
	}
	else if (!strcmp (oldstr, "forwardzone"))
	{
		int index = 0, total = get_private_forwarders_number (g_temp_file_name);

		while (index++ < total)
		{
			fprintf (fp, "%s%%0D%%0A", get_private_forwarders (index, g_temp_file_name));
		}
	}
	else if (!strcmp (oldstr, "TempFileIndex"))
	{
		fprintf (fp, "%d", g_temp_index);
	}
	else
		return CGI_REPLACE_FAIL;
	return CGI_REPLACE_OK;
}

int master_dns_replace (FILE * fp, char * oldstr)
{
	if (fp == NULL)
		return CGI_REPLACE_FAIL;

	if (!strcmp (oldstr, "ForwardersZone"))
	{
		int num = 0, total = get_private_forwarders_number (g_temp_file_name);
		while (num++ < total)
		{
			fprintf (fp, "%s\n", get_private_forwarders (num, g_temp_file_name));
		}
	}
	else if (!strcmp (oldstr, "master_dns"))
	{
		if (get_private_ns_type (g_temp_file_name) == E_Master)
			fprintf (fp, "checked");
	}
	else if (!strcmp (oldstr, "ResourceRecord"))
	{
		int total = get_private_resource_record_number (get_private_master_zone_name (1, g_temp_file_name)
								, g_temp_file_name);
		g_index = 0;
		while (g_index++ < total)
		{
			CGI_Output_Html (RECORD_PAGE, "$", resrouce_record_replace);
		}
	}
	else
		return CGI_REPLACE_FAIL;
	return CGI_REPLACE_OK;
}

int resrouce_record_replace (FILE * fp, char * oldstr)
{
	char rr_buf[128];
	RESOURCE_RECORD rr_info;
	if (fp == NULL)
		return CGI_REPLACE_FAIL;

	strcpy (rr_buf, get_private_resource_record (get_private_master_zone_name (1, g_temp_file_name)
								, g_index, g_temp_file_name));
	parser_resource_record (rr_buf, sizeof (rr_buf), &rr_info, sizeof (rr_info));

	if (!strcmp (oldstr, "Record_Index"))
	{
		fprintf (fp, "%d", g_index);
	}
	else if (!strcmp (oldstr, "Record_Value"))
	{
		fprintf (fp, "%s", rr_buf);
	}
	else if (!strcmp (oldstr, "Record_Name"))
	{
		fprintf (fp, "%s", rr_info.name);
	}
	else if (!strcmp (oldstr, "Record_Type"))
	{
		fprintf (fp, "%s", rr_info.type2);
	}
	else if (!strcmp (oldstr, "Record_Mapping"))
	{
		fprintf (fp, "%s", rr_info.mapping);
	}
	else
		return CGI_REPLACE_FAIL;
	return CGI_REPLACE_OK;
}

int slave_dns_replace (FILE * fp, char * oldstr)
{
	char s[80];
	FILE * tmpfp = NULL;
	memset (s, '\0', sizeof (s));

	if (fp == NULL)
		return -1;

	if (!strcmp (oldstr, "SlaveZone"))
	{
		int total = get_private_slave_zone_number (g_temp_file_name);
		g_index = 0;
		while (g_index++ < total)
			CGI_Output_Html (SLAVE_INFO_PAGE, "$", slave_zone_replace);
	}
	else if (!strcmp (oldstr, "slave_dns"))
	{
		if (get_private_ns_type (g_temp_file_name) == E_Slave)
			fprintf (fp, "checked");
	}
	else
		return -2;
	return 0;
}

int slave_zone_replace (FILE * fp, char * oldstr)
{
	SLAVE_ZONE_INFO zone_info;
	memset (&zone_info, '\0', sizeof (zone_info));

	if (fp == NULL)
		return -1;

	get_private_slave_zone_info (get_private_slave_zone_name (g_index, g_temp_file_name), &zone_info, g_temp_file_name);

	if (!strcmp (oldstr, "Slave_Index"))
	{
		fprintf (fp, "%d", g_index);
	}
	else if (!strcmp (oldstr, "Slave_Name"))
	{
		fprintf (fp, "%s", zone_info.zone_info.zone_name);
	}
	else if (!strcmp (oldstr, "Masters_IP"))
	{
		fprintf (fp, "%s", zone_info.masters_ip);
	}
	else
		return -2;
	return 0;
}

char * get_server_name ()
{
	static char servername[32];
	memset (servername, '\0', sizeof (servername));

	Get_Server_Name (servername, sizeof (servername));

	return servername;
}

int select_function (INPUT * form)
{
	INPUT *pform;
	int count = 0;
	pform=form;

	while (pform!= NULL)
	{
		if (!strcmp (pform->name, "action"))
		{
			if (!strcmp (pform->val, "change_type"))
				return 0;  //  change type
			else if (!strcmp (pform->val, "select_page"))
				return 1;  //  select page
			else if (!strcmp (pform->val, "edit_rr"))
				return 2; //  edit resource record
			else if (!strcmp (pform->val, "edit_slave_zone"))
				return 3;  //  edit slave zone
		}
		pform=(INPUT *)pform->next;
	}
	return -1;
}

int select_page (INPUT * form)
{
	INPUT *pform;
	FILE * tmpfp = NULL;
	char s[256];
	int count = 0;

	pform = form;
	while (pform!= NULL)
	{
		if (!strcmp (pform->name, "basic_advance"))
		{
			if (!strcmp (pform->val, "Advance"))
				set_private_which_page (1, g_temp_file_name);
			else
				set_private_which_page (0, g_temp_file_name);
		}
		else if (!strcmp (pform->name, "DNS_Type"))
		{
			if (!strcmp (pform->val, "Master"))
				set_private_ns_type (E_Master, g_temp_file_name);
			else if (!strcmp (pform->val, "Slave"))
				set_private_ns_type (E_Slave, g_temp_file_name);
			else
				set_private_ns_type (E_Master, g_temp_file_name);
		}
		else if (!strcmp (pform->name, "DNSOperate"))
		{
			if (!strcmp (pform->val, "Enable") || !strcmp (pform->val, "checked"))
				set_private_dns_enable (TRUE, g_temp_file_name);
			else
				set_private_dns_enable (FALSE, g_temp_file_name);
		}
		else if (!strcmp (pform->name, "DomainName"))
		{
			set_private_domain_name (pform->val, g_temp_file_name);
		}
		else if (!strcmp (pform->name, "TempFileIndex"))
		{
			g_temp_index = atoi (pform->val);
		}
		pform=(INPUT *)pform->next;
	}

	pform = form;

	if (get_private_which_page (g_temp_file_name) == 0)
	{
		while (pform != NULL)
		{
			if (!strcmp (pform->name, "ForwardZone"))
			{
				int index = get_private_forwarders_number (g_temp_file_name);
				tmpfp = tmpfile ();
				paser_input (tmpfp, pform->val);
				rewind (tmpfp);
				while (index)
					remove_private_forwarders (index--, g_temp_file_name);
				while (fgets (s, sizeof (s), tmpfp))
				{
					if (s[strlen (s) - 1] == '\n')
						s[strlen (s) - 1] = '\0';  //  erease '\n'
					if (strcmp (s, ""))
					{
						//if (!check_ip_input (s))
							set_private_forwarders (s, g_temp_file_name);
					}
				}
				fclose (tmpfp);
				break;
			}
			pform=(INPUT *)pform->next;
		}
	}
}

//  0 == correct, 1 == fail
int check_name_input (char * input)
{
	char name_input[] = "~!#$%^&*()-_+={}[]:;\" <>,?/\\|";
	int len = strlen (input);
	char substr[2];

	bzero (substr, sizeof (substr));
	while (len--)
	{
		substr[0] = input[len];
		if (strstr (name_input, substr))
			return CHECK_FAIL;
	}
	return CHECK_OK;
}

//  0 == correct, 1 == fail
int check_ip_input (char * input)
{
	int index = 0, dot_number = 0, ip = 0, len = strlen (input);
	char ipaddr[20], sigle_ip_addr[5];

	bzero (ipaddr, sizeof (ipaddr));
	bzero (sigle_ip_addr, sizeof (sigle_ip_addr));

	if (input[len - 1] == '.')
		return CHECK_FAIL;

	while (index < len)
	{
		if ((input[index] < 48 || input[index] > 57 || input[index] == ' ') && input[index] != '.')
			return CHECK_FAIL;
		if (input[index] == '.')
			dot_number++;
		index++;
	}

	if (dot_number != 3)
		return CHECK_FAIL;
	index = 0;
	while (index++ < 4)
	{
		ip = parser_ip (input, index);

		if (ip > 254)
			return CHECK_FAIL;
		else
		{
			if (index == 1)
				sprintf (ipaddr, "%d", ip);
			else
			{
				sprintf (sigle_ip_addr, ".%d", ip);
				strcat (ipaddr, sigle_ip_addr);
			}
		}
	}
	strcpy (input, ipaddr);
	return CHECK_OK;
}

int modify_master (INPUT * form)
{
	INPUT *pform;
	int edit_action = 0;
	FILE * tmpfp = NULL;
	char rr_buf[128], s[256];
	RESOURCE_RECORD rr_info;
	ZONE_INFO zone_info;

	strcpy (rr_info.type1, "IN");

	pform=form;
	while (pform!= NULL)
	{
		if (!strcmp (pform->name, "AddResourceRecord"))
		{
			edit_action = 1;
			break;
		}
		else if (strstr (pform->name, "RemoveResourceRecord"))
		{
			edit_action = 2;
			break;
		}
		else if (!strcmp (pform->name, "ResourceRecordType"))
		{
			strcpy (rr_info.type2, pform->val);
		}
		if (!strcmp (pform->name, "LHS"))
		{
			strcpy (rr_info.name, pform->val);
		}
		else if (!strcmp (pform->name, "RHS"))
		{
			strcpy (rr_info.mapping, pform->val);
		}
		pform=(INPUT *)pform->next;
	}

	if (edit_action == 1)
	{
		if (!strcmp (rr_info.type2, "A"))
		{
			if (check_name_input (rr_info.name))
				return INPUT_NAME_ERROR;
			if (check_ip_input (rr_info.mapping))
				return INPUT_IP_ERROR;
		}
	}
#ifdef _DEBUG
	printf ("master zone edit_action = %d<br>\n", edit_action);
#endif
	pform=form;
	while (pform!= NULL)
	{
#ifdef _DEBUG
	printf ("pform->name = %s, pform->val = %s<br>\n", pform->name, pform->val);
#endif
		switch (edit_action)
		{
		case 1:
			if (!strcmp (pform->name, "ResourceRecordType"))
			{
				strcpy (rr_info.type2, pform->val);
			}

			break;
		case 2:
			if (strstr (pform->name, "RemoveResourceRecord"))
			{
				remove_private_record_by_index (get_private_master_zone_name (1, g_temp_file_name)
							, atoi (pform->name), g_temp_file_name);
			}
			break;
		}

		if (!strcmp (pform->name, "DomainName"))
		{
			set_private_domain_name (pform->val, g_temp_file_name);
			strcpy (zone_info.zone_name, pform->val);
		}
		else if (!strcmp (pform->name, "ForwardZone"))
		{
			int index = get_private_forwarders_number (g_temp_file_name);
			while (index)
				remove_private_forwarders (index--, g_temp_file_name);

			tmpfp = tmpfile ();
			paser_input (tmpfp, pform->val);
			rewind (tmpfp);

			while (fgets (s, sizeof (s), tmpfp))
			{
				if (s[strlen (s) - 1] == '\n')
					s[strlen (s) - 1] = '\0';  //  erease '\n'
				if (strcmp (s, ""))
				{
					//if (!check_ip_input (s))
						set_private_forwarders (s, g_temp_file_name);
				}
			}
			fclose (tmpfp);
		}
		else if (!strcmp (pform->name, "TempFileIndex"))
		{
			g_temp_index = atoi (pform->val);
		}
		pform=(INPUT *)pform->next;
	}

	strcpy (zone_info.zone_type, "master");
	if (!check_private_value_exist ("MasterZone1", g_temp_file_name))
		set_private_master_zone_info (&zone_info, g_temp_file_name);
	else
		modify_private_master_zone_info (zone_info.zone_name, 1, g_temp_file_name);

	switch (edit_action)
	{
	case 1:
		sprintf (rr_buf, "%s/%s/%s/%s", rr_info.name, rr_info.type1, rr_info.type2, rr_info.mapping);
		set_private_resource_record (get_private_master_zone_name (1, g_temp_file_name), rr_buf, g_temp_file_name);
		break;
	case 2:
		//remove_zone_record_by_value (get_private_master_zone_name (1, g_temp_file_name), pform->val);
		break;
	}

	return 0;
}

int modify_slave (INPUT * form)
{
	INPUT *pform;
	int edit_action = 0;
	SLAVE_ZONE_INFO zone_info;

	strcpy (zone_info.zone_info.zone_type, "slave");

	pform=form;
	while (pform!= NULL)
	{
		if (!strcmp (pform->name, "AddSlaveZone"))
		{
			edit_action = 1;
			break;
		}
		else if (strstr (pform->name, "RemoveSlaveZone"))
		{
			edit_action = 2;
			break;
		}
		else if (!strcmp (pform->name, "SlaveZoneName"))
		{
			strcpy (zone_info.zone_info.zone_name, pform->val);
		}
		else if (strstr (pform->name, "SlaveZoneIP"))
		{
			if (strstr (pform->name, "1"))
				strcpy (zone_info.masters_ip, pform->val);
			else
			{
				strcat (zone_info.masters_ip, ".");
				strcat (zone_info.masters_ip, pform->val);
			}
		}
		pform=(INPUT *)pform->next;
	}

	if (edit_action == 1)
	{
		if (check_name_input (zone_info.zone_info.zone_name))
			return INPUT_NAME_ERROR;
		if (check_ip_input (zone_info.masters_ip))
			return INPUT_IP_ERROR;
	}
#ifdef _DEBUG
	printf ("slave zone edit_action = %d<br>\n", edit_action);
#endif
	pform=form;
	while (pform!= NULL)
	{
#ifdef _DEBUG
	printf ("pform->name = %s, pform->val = %s<br>\n", pform->name, pform->val);
#endif
		if (edit_action == 2)
		{
			if (strstr (pform->name, "RemoveSlaveZone"))
				remove_private_slave_zone_by_index (atoi (pform->name), g_temp_file_name);
		}

		if (!strcmp (pform->name, "DomainName"))
		{
			set_domain_name (pform->val);
		}
		else if (!strcmp (pform->name, "TempFileIndex"))
		{
			g_temp_index = atoi (pform->val);
		}
		pform=(INPUT *)pform->next;
	}
	switch (edit_action)
	{
	case 1:
		set_private_slave_zone_info (&zone_info, g_temp_file_name);
		break;
	case 2:
		//remove_slave_zone_by_value (pform->val);
		break;
	}
}

int dns_submit (INPUT * form)
{
	INPUT *pform;
	FILE * tmpfp = NULL;
	int operate = 1, page = 0;
	char s[256];
	CONF_FILE_INFO conf;
	ZONE_INFO zone_info;

	memset (s, '\0', sizeof (s));

	strcpy (conf.conf_file_name, get_conf_file_name ());
	strcpy (conf.NAS_name, get_server_name ());
	conf.behind_firewall = 0;

	pform = form;
	while (pform!= NULL)
	{
		if (!strcmp (pform->name, "DNSType"))
		{
			if (!strcmp (pform->val, "MASTER"))
				page = E_Master;
			if (!strcmp (pform->val, "SLAVE"))
				page = E_Slave;
			if (!strcmp (pform->val, "CACHE"))
				page = E_Cache;
			break;
		}
		pform=(INPUT *)pform->next;
	}

	pform = form;
	while (pform!= NULL)
	{
		if (!strcmp (pform->name, "ForwardZone"))
		{
			tmpfp = tmpfile ();
			paser_input (tmpfp, pform->val);
			rewind (tmpfp);

			while (fgets (s, sizeof (s), tmpfp))
			{
				if (s[strlen (s) - 1] == '\n')
					s[strlen (s) - 1] = '\0';  //  erease '\n'
				if (strcmp (s, ""))
				{
					if (check_ip_input (s))
					{
						if (get_private_which_page (g_temp_file_name) == 1 && page == E_Master)  //  in advance page
						{
							fclose (tmpfp);
							return CHECK_FAIL;
						}
					}
				}
			}
			fclose (tmpfp);
			break;
		}
		pform=(INPUT *)pform->next;
	}

	pform = form;
	while (pform!= NULL)
	{
#ifdef	_DEBUG
	printf ("name = %s, val = %s<br>\n", pform->name, pform->val);
#endif

		if (!strcmp (pform->name, "DNSOperate"))
		{
			if (!strcmp (pform->val, "Enable"))
				operate = 1;
			else
			{
				operate = 0;
				break;
			}
		}
		else if (!strcmp (pform->name, "DomainName"))
		{
			set_domain_name (pform->val);
			strcpy (conf.local_zone_name, pform->val);
		}
		else if (!strcmp (pform->name, "ForwardZone"))
		{
			int index = get_forwarders_number ();

			while (index)
				remove_forwarders (index--);

			tmpfp = tmpfile ();
			paser_input (tmpfp, pform->val);
			rewind (tmpfp);

			while (fgets (s, sizeof (s), tmpfp))
			{
				if (s[strlen (s) - 1] == '\n')
					s[strlen (s) - 1] = '\0';  //  erease '\n'
				if (strcmp (s, ""))
				{
					if (check_ip_input (s) == CHECK_OK)
						set_forwarders (s);
				}
			}
			fclose (tmpfp);
		}
		pform=(INPUT *)pform->next;
	}

	//  dump tmp file content to default config file
	dump_tmp_to_conf ();

	//  Enable/Disable DNS
	//	:
	if (operate == 1)
	{
		if (get_which_page () == 0)  //  in basic page
		{
			create_cache_only (&conf);
		}
		else
		{
			//  Create config file and zone file
			switch (get_ns_type ())
			{
			case E_Master:
				strcpy (zone_info.zone_name, conf.local_zone_name);
				strcpy (zone_info.zone_type, "master");
				if (!check_value_exist ("MasterZone1"))
					set_private_master_zone_info (&zone_info, g_temp_file_name);
				else
					modify_private_master_zone_info (conf.local_zone_name, 1, g_temp_file_name);
				create_master_ns (&conf);
				break;
			case E_Slave:
				create_slave_ns (&conf);
				break;
			}
		}

		if (!Is_DNS_Enable ())
		{
			Enable_DNS (TRUE);
			Reload_DHCP_Config ();
		}
		else
			Reload_DNS_Config ();
	}
	else
	{
		if (Is_DNS_Enable ())
		{
			Enable_DNS (FALSE);
			Reload_DHCP_Config ();
		}
		else
			Enable_DNS (FALSE);
	}

	return DNSSUCCESS;
}

int do_main (void)
{
	int ret;
	if (get_private_which_page (g_temp_file_name) == 0)
	{
		ret = do_basic ();
	}
	else
	{
		ret = do_advance ();
	}
}

void show_error (char * error)
{
	int advance = 1, index = 3;
	HEADER_ITEM	header;
	ERRMSG errormsg;  //  add by Tiger

	bzero (&header, sizeof (header));
	header.back[0] = 0x0;
	header.home[0] = 0x0;
	header.logout[0] = 0x0;

	if(Is_Version_22())
		CGI_Get_Help(header.help, "help_network.html#network_dns_main");
	else
		CGI_Get_Help(header.help, "network_dns_main.html");

	if (g_def_file_type <= 1)
		index = 3;
	else
		index = 4;

	CGI_Output_Html (EMPTY_TITLE_PAGE, "$", dns_replace);
	CGI_Output_Html (BODY_TITLE_PAGE, "$", dns_replace);

	CGI_Show_Menu_V3_1 (FUNC_NETWORK, &header);

	  CGI_Output_Html1 (MENU_V3_HEADER_HTML, "$", NULL, NULL);
	    CGI_Show_Menu_V3_2 (szDefineFilePath[g_def_file_type], index);
	    CGI_Output_Html1 (MENU_V3_MIDDLE_HTML, "$", NULL, NULL);

	    CGI_Output_Html (FORM_TITLE_PAGE, "$", dns_replace);

	    errormsg.type =	CGI_ERROR;
	    sprintf (errormsg.title, "NIC_OTHER_SERVICE_STR02");
	    sprintf (errormsg.msg, "%s", error);
	    strcpy (errormsg.note, "");
	    CGI_Show_Error_V3 (&errormsg);

	    //CGI_Output_Html1 (ERROR_PAGE, "$", dns_error_replace, error);
	    CGI_Output_Html (FORM_TAIL_PAGE, "$", dns_replace);

	    CGI_Output_Html1 (MENU_V3_TAIL_HTML, "$", NULL, NULL);
	CGI_Output_Html (TAIL_PAGE, "$", dns_replace);
}

int do_basic (void)
{
	int ret, basic = 0, index = 3;
	HEADER_ITEM	header;

	bzero (&header, sizeof (header));
	header.back[0] = 0x0;
	header.home[0] = 0x0;
	header.logout[0] = 0x0;
	if(Is_Version_22())
		CGI_Get_Help(header.help, "help_network.html#network_dns_main");
	else
		CGI_Get_Help(header.help, "network_dns_main.html");

	if (g_def_file_type <= 1)
		index = 3;
	else
		index = 4;

	CGI_Output_Html (TITLE_PAGE, "$", dns_replace);
	CGI_Output_Html (BASIC_BODY_TITLE_PAGE, "$", dns_replace);
	  CGI_Show_Menu_V3_1(FUNC_NETWORK, &header);

	    CGI_Output_Html1 (MENU_V3_HEADER_HTML, "$", NULL, NULL);
	    CGI_Show_Menu_V3_2 (szDefineFilePath[g_def_file_type], index);
	    CGI_Output_Html1 (MENU_V3_MIDDLE_HTML, "$", NULL, NULL);

	      ret = CGI_Output_Html (BASIC_FORM_TITLE_PAGE, "$", dns_replace);
	      ret = CGI_Output_Html1 (BASIC_ADVANCE_PAGE, "$", basic_advance_replace, &basic);
	      //ret = CGI_Output_Html (TABLE_TITLE_PAGE, "$", dns_replace);
	      //ret = CGI_Output_Html (CAPTION_PAGE, "$", dns_replace);

	      ret = CGI_Output_Html (MAIN_PAGE, "$", dns_replace);

	      //ret = CGI_Output_Html (TABLE_TAIL_PAGE, "$", dns_replace);
	      //ret = CGI_Output_Html (FORM_TAIL_PAGE, "$", dns_replace);
	      ret = CGI_Output_Html (SUBMIT_PAGE, "$", dns_replace);

	    CGI_Output_Html1(MENU_V3_TAIL_HTML, "$", NULL, NULL);
	CGI_Output_Html (TAIL_PAGE, "$", dns_replace);
	return ret;
}

int do_advance (void)
{
	int ret, advance = 1, index = 3;
	HEADER_ITEM	header;

	bzero (&header, sizeof (header));
	header.back[0] = 0x0;
	header.home[0] = 0x0;
	header.logout[0] = 0x0;

	if(Is_Version_22())
		CGI_Get_Help(header.help, "help_network.html#network_dns_main");
	else
		CGI_Get_Help(header.help, "network_dns_main.html");

	if (g_def_file_type <= 1)
		index = 3;
	else
		index = 4;

	CGI_Output_Html (TITLE_PAGE, "$", dns_replace);
	CGI_Output_Html (ADVANCE_BODY_TITLE_PAGE, "$", dns_replace);

	CGI_Show_Menu_V3_1 (FUNC_NETWORK, &header);

	  CGI_Output_Html1 (MENU_V3_HEADER_HTML, "$", NULL, NULL);
	    CGI_Show_Menu_V3_2 (szDefineFilePath[g_def_file_type], index);
	    CGI_Output_Html1 (MENU_V3_MIDDLE_HTML, "$", NULL, NULL);

	      ret = CGI_Output_Html (ADVANCE_FORM_TITLE_PAGE, "$", dns_replace);
	      ret = CGI_Output_Html1 (BASIC_ADVANCE_PAGE, "$", basic_advance_replace, &advance);
	      //ret = CGI_Output_Html (TABLE_TITLE_PAGE, "$", dns_replace);
	      //ret = CGI_Output_Html (CAPTION_PAGE, "$", dns_replace);

	      ret = CGI_Output_Html (SERVER_TYPE_PAGE, "$", dns_replace);

	      //ret = CGI_Output_Html (TABLE_TAIL_PAGE, "$", dns_replace);
	      ret = CGI_Output_Html (FORM_TAIL_PAGE, "$", dns_replace);
	      ret = CGI_Output_Html (SUBMIT_PAGE, "$", dns_replace);

	    CGI_Output_Html1 (MENU_V3_TAIL_HTML, "$", NULL, NULL);
	CGI_Output_Html (TAIL_PAGE, "$", dns_replace);
	return ret;
}

void select_type (INPUT * form)
{
	FILE * tmpfp = NULL;
	char s[256];
	INPUT * pform;

	pform = form;
	while (pform!= NULL)
	{
		if (!strcmp (pform->name, "DNS_Type"))
		{
			if (!strcmp (pform->val, "Master"))
				set_private_ns_type (E_Master, g_temp_file_name);
			else if (!strcmp (pform->val, "Slave"))
				set_private_ns_type (E_Slave, g_temp_file_name);
			else
				set_private_ns_type (E_Master, g_temp_file_name);
		}
		else if (!strcmp (pform->name, "DomainName"))
		{
			set_private_domain_name (pform->val, g_temp_file_name);
		}
		else if (!strcmp (pform->name, "ForwardZone"))
		{
			int index = get_private_forwarders_number (g_temp_file_name);
			while (index)
				remove_private_forwarders (index--, g_temp_file_name);

			tmpfp = tmpfile ();
			paser_input (tmpfp, pform->val);
			rewind (tmpfp);

			while (fgets (s, sizeof (s), tmpfp))
			{
				if (s[strlen (s) - 1] == '\n')
					s[strlen (s) - 1] = '\0';  //  erease '\n'
				if (strcmp (s, ""))
				{
					//if (!check_ip_input (s))
						set_private_forwarders (s, g_temp_file_name);
				}
			}
			fclose (tmpfp);
		}
		else if (!strcmp (pform->name, "TempFileIndex"))
		{
			g_temp_index = atoi (pform->val);
		}
		pform=(INPUT *)pform->next;
	}
}

int load_conf_to_tmp ()
{
	FILE * fp = NULL;
	char valuebuf[128], sectionbuf[128], buf[256];
	int index = 0, index1 = 0, total = 0, total1 = 0;
	SLAVE_ZONE_INFO slave_zone_info;
	ZONE_INFO zone_info;

	fp = fopen (g_temp_file_name, "w");
	if (fp)
		fclose (fp);

	set_private_ns_type (get_ns_type (), g_temp_file_name);

	strcpy (buf, get_domain_name ());
	set_private_domain_name (buf, g_temp_file_name);
	if (!strcmp (buf, ""))  //  if domain name == NULL string then set page to "basic"
	{
		Enable_DNS (FALSE);
		set_private_dns_enable (FALSE, g_temp_file_name);
		set_private_which_page (0, g_temp_file_name);  //  set to basic page
	}
	else
	{
		set_private_dns_enable (Is_DNS_Enable (), g_temp_file_name);
		set_private_which_page (get_which_page (), g_temp_file_name);
	}



	total = get_master_zone_number ();
	while (index++ < total)
	{
		strcpy (valuebuf, get_master_zone_name (index));
		if (get_master_zone_info (valuebuf, &zone_info) >= 0)
		{
			set_private_master_zone_info (&zone_info, g_temp_file_name);
			strcpy (sectionbuf, get_private_master_zone_name (index, g_temp_file_name));
			total1 = get_zone_resource_record_number (sectionbuf);
			while (index1++ < total1)
			{
				strcpy (valuebuf, get_zone_resource_record (sectionbuf, index1));
				set_private_resource_record (sectionbuf, valuebuf, g_temp_file_name);
			}
		}
	}

	index = 0;
	total = get_forwarders_number ();
	while (index++ < total)
	{
		strcpy (valuebuf, get_forwarders (index));
		set_private_forwarders (valuebuf, g_temp_file_name);
	}

	index = 0;
	total = get_slave_zone_number ();
	while (index++ < total)
	{

		strcpy (valuebuf, get_slave_zone_name (index));
		get_slave_zone_info (valuebuf, &slave_zone_info);
		set_private_slave_zone_info (&slave_zone_info, g_temp_file_name);
	}
	return DNSSUCCESS;

}

int dump_tmp_to_conf (void)
{
	ZONE_INFO zone_info;
	SLAVE_ZONE_INFO slave_zone_info;
	char buf[256], buf1[256];
	int index = 0, index1 = 0, total = 0, total1 = 0;

	//set_domain_name (get_private_domain_name (g_temp_file_name));
	set_ns_type (get_private_ns_type (g_temp_file_name));
	set_which_page (get_private_which_page (g_temp_file_name));


	total = get_master_zone_number ();
	while (index++ < total)
		remove_master_zone_info (index);

	index = 0;
	total = get_private_master_zone_number (g_temp_file_name);
	while (index++ < total)
	{
		strcpy (buf, get_private_master_zone_name (index, g_temp_file_name));
		get_private_master_zone_info (buf, &zone_info, g_temp_file_name);
		set_master_zone_info (&zone_info);

		total1 = get_private_resource_record_number (buf, g_temp_file_name);
		while (index1++ < total1)
		{
			strcpy (buf1, get_private_resource_record (buf, index1, g_temp_file_name));
			set_zone_resource_record (buf, buf1);
		}
	}

	index = 0;
	total = get_slave_zone_number ();
	while (index++ < total)
		remove_slave_zone_by_index (index);

	index = 0;
	total = get_private_slave_zone_number (g_temp_file_name);
	while (index++ < total)
	{
		strcpy (buf, get_private_slave_zone_name (index, g_temp_file_name));
		get_private_slave_zone_info (buf, &slave_zone_info, g_temp_file_name);
		set_slave_zone_info (&slave_zone_info);
	}
}

int get_def_type (void)
{
	int result = 0;
	int count = NIC_Count_Interface();
	BOOL support_prn = Is_Support_Printer ();

	if (count == 1)
	{
		if (support_prn)
			result = 0;
		else
			result = 1;
	}
	else if (count == 2)
	{
		if (support_prn)
			result = 2;
		else
			result = 3;
	}
	return result;
}

int generate_temp_file_index (void)
{
	return getpid ();
}

void get_temp_file_name (INPUT * form, char * tmpfile, int size)
{
	int index;
	INPUT * tmpfile_index = CGI_Find_Parameter (form, "TempFileIndex");

	bzero (tmpfile, size);
	if (tmpfile_index)
	{
		index = atoi (tmpfile_index->val);
		if (index == 0)
			index = 1;
		sprintf (tmpfile, "/tmp/uLinux.dns.tmp.%d", index);
	}
}

#ifdef _USE_PRIVATE_CONF
BOOL check_dns_conf_exist (void)
{
	FILE * fp = NULL;

	fp = fopen (DNS_CONF, "r");
	if (fp == NULL)
		return FALSE;
	fclose (fp);
	return TRUE;
}

void create_dns_conf (void)
{
	FILE * fp = NULL;

	memset (&config, '\0', sizeof (config));
	fp = fopen (DNS_CONF, "w");
	if (fp)
		fclose (fp);
}
#endif

