#!/bin/sh
# ddns_update.sh         This shell script takes care of ddns updating
#
# description: ez_ipupdate provide register domain name from special server.

echo -n "Starting ddns update: "
rm /tmp/ddns.result -f
if [ `/sbin/getcfg "DDNS" "Support" -u -d "TRUE"` = TRUE ]
then
	if [ `/sbin/getcfg "DDNS" "Enable" -u -d "FALSE"` = FALSE ]
	then
		echo disabled
		exit 0
	fi

	/usr/sbin/create_ddns_conf > /dev/null
	result=$?
	if [ $result -ne 0 ] 
	then
		echo error
		exit 1
	fi

	config_file=`/sbin/getcfg "DDNS" "Config File" -d "/etc/ddns_update.conf"`
	/usr/sbin/ez-ipupdate -c $config_file 2>/dev/null
	result=$?
	if [ $result -ne 0 ]
	then
		echo $result > /tmp/ddns.result
	fi
	echo -n "ez-ipupdate"
	echo "."
	touch /var/lock/subsys/ez-ipupdate
	exit $result
else
	echo "Un-support"
fi

exit 1
