#include	<stdio.h>
#include	<stdlib.h>
#include 	<config.h>

#include        <cgi.h>
#include 	<cfg_nic.h>
#include	<cfg_ddns.h>
#include 	"ddns_main.h"

int main (int argc, char * argv[])
{
	int result;
	NIC_INFO nic_info;
	struct DDNS_Information conf;
	bzero (&conf, sizeof (conf));

	//  bause we have to record the IP address, so call Get_DDNS_Info first,
	//  then call Set_DDNS_Info to record IP
	Get_DDNS_Info (&conf);

	//  get wan ip address
	NIC_Get_Info (&nic_info, NIC_WAN);
	strcpy (conf.IP_Address, nic_info.ipaddr);

	if (argc == 2)
	{
		if (!strcmp (argv[1], "-d") || !strcmp (argv[1], "-D"))
		{
			if (conf.Support == 1)
				printf ("Support DDNS update!\n");
			else
				printf ("Not support DDNS update!\n");

			if (conf.Enable == 1)
				printf ("DDNS was enabled!\n");
			else
				printf ("DDNS was disabled!\n");

			printf ("User Name : %s\n", conf.UserName);
			printf ("Password : %s\n", conf.Password);
			printf ("Host Name : %s\n", conf.HostName);
			printf ("Your WAN IP address : %s\n", conf.IP_Address);
			if (conf.Wildcard == ENABLE_DDNS)
				printf ("Support wildcard!\n");
			else
				printf ("Not support wildcard!\n");

			printf ("Mail Exchanger : %s\n", conf.MailExchanger);

			if (conf.BackupMX == ENABLE_DDNS)
				printf ("This mail exchanger is backup server!\n");
			else
				printf ("This mail exchanger is primary server!\n");

			if (conf.DDNS_Type == DDNS_DYNAMIC)
				printf ("Your ip is dynamic!\n");
			else
				printf ("Your ip is static!\n");

			if (conf.DDNS_Server < MAX_SUPPORT_SERVER_NUM)
			{
				printf ("Your DDNS server is %s URL:%s\n", 
					serverinfo[conf.DDNS_Server].ServerName, 
					serverinfo[conf.DDNS_Server].Web_Side);
			}
			
			printf ("Config file : %s\n", conf.ConfigFile);
		}
		else
		{
			printf ("Usage: %s [option]\n", argv[0]);
			printf ("	-d, -D	dump information\n");
			exit (1);
		}
			
	}
	else if (argc > 2)
	{
		printf ("Usage: %s [option]\n", argv[0]);
		printf ("	-d, -D	dump information\n");
		exit (1);
	}
	
	result = create_ddns_conf (&conf);
	exit (result);
}

int create_ddns_conf (struct DDNS_Information * conf)
{
	FILE * fp = NULL;
	int ret = 0, i = 0, len = 0;
	
	if (!strcmp (conf->ConfigFile, ""))
		return 1;  //  config file name is NULL
	fp = fopen (conf->ConfigFile, "w");
	if (fp)
	{
		fprintf (fp, "#\n");
		fprintf (fp, "#\tDDNS config file for ez-ipupdate\n");
		fprintf (fp, "#\tCreate by create_ddns_conf\n");
		fprintf (fp, "#\tCopyright 2002 IEI\n");
		fprintf (fp, "#\n");
#if 0
		fprintf (fp, "server=%s\n", serverinfo[conf->DDNS_Server].ServerName);
#endif
		len = strlen (serverinfo[conf->DDNS_Server].ServerName);
		while (i < len)
		{
			if (isupper (serverinfo[conf->DDNS_Server].ServerName[i]))
				serverinfo[conf->DDNS_Server].ServerName[i] += 32;
			i++;
		}
		if (conf->DDNS_Type == DDNS_DYNAMIC)
			fprintf (fp, "service-type=%s\n", serverinfo[conf->DDNS_Server].ServerName);
		else
			fprintf (fp, "service-type=%s-static\n", serverinfo[conf->DDNS_Server].ServerName);
		fprintf (fp, "user=%s:%s\n", conf->UserName, conf->Password);
		fprintf (fp, "host=%s\n", conf->HostName);
		fprintf (fp, "interface=%s\n", conf->Device);
#if 0
		fprintf (fp, "max-interval=%u\n", conf->Refresh_Time * 24 * 60 * 60);  //  for daemon mode use only
#endif
		if (strcmp (conf->MailExchanger, ""))
			fprintf (fp, "mx=%s\n", conf->MailExchanger);
		if (conf->Wildcard == ENABLE_DDNS)
			fprintf (fp, "wildcard\n");
		if (conf->BackupMX == ENABLE_DDNS)
			fprintf (fp, "backmx\n");
		if (strcmp (conf->IP_Address, ""))
			fprintf (fp, "address=%s\n", conf->IP_Address);
#if 0
		fprintf (fp, "cache-file=/tmp/ez-ipupdate.cache\n");
		fprintf (fp, "daemon\n");  //  running daemon mode
#endif
		fclose (fp);
	}
	else
		ret = 2;  //  open config file error
	return ret;
}
