#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/wait.h>
#include <pthread.h>
#include <unistd.h>

#include <cgi.h>
#include <config.h>
#include <v2_menu.h>
#include <NAS.h>
#include <backup.h>
#include <cfg_system.h>
#include "misc.h"
#include "snmp.h"

int is_blank_str(char *str)
{
	int i;
	for(i = 0; i < strlen(str); i++)
		if(str[i] != ' ')
			return 0;
	return 1;
}

int misc_snmp_replace(FILE* fp, char* src)
{
	char community[128]={""},location[128]={""},contact[128]={""},ip[60]={""},community1[128]={""};
	
	Get_SNMP_Conf(community,contact,location);
	Get_SNMPTrap_Conf(community1,ip);
	if (!strcmp(src, "PARAMETER_2"))
		fprintf(fp, "%s", Is_SNMP_Enable()?" checked":"");
	else if (!strcmp(src, "PARAMETER_11"))
		fprintf(fp, "%s", Is_SNMP_Enable()?"1":"0");	
	else if(!strcmp(src,"PARAMETER_3")) 
		fprintf(fp, "%s", Is_SNMP_Enable()?community:"");
	else if(!strcmp(src,"PARAMETER_4")) 
		fprintf(fp, "%s", Is_SNMP_Enable()?contact:"");
	else if(!strcmp(src,"PARAMETER_5")) 
		fprintf(fp, "%s", Is_SNMP_Enable()?location:"");
	else if (!strcmp(src, "PARAMETER_7"))
		fprintf(fp, "%s", Is_SNMPTrap_Enable()?" checked":"");
	else if (!strcmp(src, "PARAMETER_12"))	
		fprintf(fp, "%s", Is_SNMPTrap_Enable()?"1":"0");
	else if(!strcmp(src,"PARAMETER_8")) 
		fprintf(fp, "%s", Is_SNMPTrap_Enable()?community1:"");
	else if(!strcmp(src,"PARAMETER_9")) 
		fprintf(fp, "%s", Is_SNMPTrap_Enable()?ip:"");	
	else
		return CGI_REPLACE_FAIL;
	return CGI_REPLACE_OK;	
}	

int set_snmp(INPUT *input)
{
	int ret=SUCCESS;
	INPUT *tmp;
	pid_t child_pid;
	
	
	tmp = CGI_Find_Parameter(input,"SNMPSELECT");
	
	if (tmp == NULL) {
		Disable_SNMP();
	}
	else {//SNMP enable
		char set_value[4][128];

		tmp = CGI_Find_Parameter(input,"community");
		if(tmp!=NULL) {
			if ((strlen(tmp->val) == 0) || (is_blank_str(tmp->val))) {
				return SNMP_ERROR_CODE2;
			}
			else 
				strcpy(set_value[0],tmp->val);
		}
		else
			return SNMP_ERROR_CODE1;
			
		tmp = CGI_Find_Parameter(input,"contact");
		if(tmp!=NULL) {
			if ((strlen(tmp->val) == 0) || (is_blank_str(tmp->val))) {
				return SNMP_ERROR_CODE3;
			}
			else 
				strcpy(set_value[1],tmp->val);
		}
		else
			return SNMP_ERROR_CODE1;

		tmp = CGI_Find_Parameter(input,"location");
		if(tmp!=NULL) {
			if ((strlen(tmp->val) == 0) || (is_blank_str(tmp->val))) {
				return SNMP_ERROR_CODE4;
			}
			else 
				strcpy(set_value[2],tmp->val);
		}
		else
			return SNMP_ERROR_CODE1;

		ret = Set_SNMP_Conf(set_value[0],set_value[1],set_value[2]);
		if(ret != SUCCESS) return SNMP_ERROR_CODE1;
		Enable_SNMP();
		child_pid = fork();
		if(child_pid == 0) { // child process
			close(0);
			close(1);
    			close(2);			
			system("/etc/init.d/snmp restart >/dev/null");
			exit(0);	
		}
	} 		
		
	tmp = CGI_Find_Parameter(input,"SNMPTRAPSELECT");
	
	if (tmp == NULL) {
		Disable_SNMPTrap();
	}
	else {//SNMP Trap enable
		char set_value[4][128];

		tmp = CGI_Find_Parameter(input,"trapcom");
		if(tmp!=NULL) {
			if ((strlen(tmp->val) == 0) || (is_blank_str(tmp->val))) {
				return SNMP_ERROR_CODE5;
			}
			else 
				strcpy(set_value[3],tmp->val);
		}
		else
			return SNMP_ERROR_CODE1;
			
		tmp = CGI_Find_Parameter(input,"hostip");
		if(tmp!=NULL) {
			if ((strlen(tmp->val) == 0) || (is_blank_str(tmp->val))) {
				return SNMP_ERROR_CODE6;
			}
			else 
				strcpy(set_value[4],tmp->val);
		}
		else
			return SNMP_ERROR_CODE1;

		tmp = CGI_Find_Parameter(input,"TESTRAP");
		if(tmp!=NULL) 
			strcpy(set_value[5],tmp->val);
		else
			strcpy(set_value[5],"");
		
		Enable_SNMPTrap();
		ret = Set_SNMPTrap_Conf(set_value[3],set_value[4]);
		if(ret != SUCCESS) return SNMP_ERROR_CODE1;
		
		if(strcmp(set_value[5],"1")==0) 
			SNMPTrap_Send_Alert("This is test",99);
	} 			
	return ret;	
}


int do_snmp_main(INPUT* input, int select)
{
	show_misc_header(input, select);
	CGI_Output_Html(SNMP_MAIN_HTML, "$", misc_snmp_replace);
	show_misc_tail();
	return MISC_SUCCESS;
}
int do_snmp_main_submit(INPUT* input)
{
	int btn, ret = MISC_SUCCESS;
	
	btn = get_btn(input);
	switch(btn)
	{
		case MISC_BTN_APPLY:
			ret = set_snmp(input);
			break;	
	}
	if (!ret)	
		do_snmp_main(input, SELECT_SNMP);
	return ret;
}
