#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <dirent.h>
#include <time.h>
#include <cgi.h>
#include <cfg_backup.h>
#include <cfg_tape.h>
#include <cfg_ups.h>
#include <v2_menu.h>
#include <NAS.h>
#include <backup.h>
#include "misc.h"
#include "rtrr.h"

#define OUTPUT_TEST_REMOTE_FIELD(i, s) ((tmp = CGI_Find_Parameter(i, s)))?fprintf(fp, "%s", tmp->val):fprintf(fp, "%s", "");
/*Shone
static char *szDefineFilePath[] = {"/home/httpd/cgi-bin/misc/misc.notapeups.def",
			    "/home/httpd/cgi-bin/misc/misc.def"};*/
static char *szDefineFilePath[] = {MISC_DEF};
static int g_def_type = 0;//globe 
static int show_rtrr_tail_html();
void get_rtrr_from_string(RTRR_CLIENT* job, char* str);
char **rsync_server_share_list=NULL;
int rsync_server_share_list_num=0;


char* parser_rtrr(char* dest, const char* src, int pos)
{
	static	char	ptr[1024];
	int	i = 0, j = 0;
	int	Cfind=0; 

	strcpy(dest, src);
	bzero(ptr, 1024);
	
	for (i = 0; i < strlen(src); i++) {
		if ( src[i] == ':' ) {
			Cfind++;
		} else {
			if ( Cfind == pos )
				ptr[j++] = src[i];
		}
	}
	return ptr;
}

	
int del_rtrr(INPUT* checkbox)
{
	INPUT* tmp = checkbox;
	char 	dest[2048]={""};
	char	job_name[MAX_JOB_NAME_LEN];

	while(tmp!=NULL){
		strncpy(job_name, parser_rtrr(dest, tmp->val, 2), MAX_JOB_NAME_LEN);
		del_rtrrc_job(job_name);
		tmp = (INPUT*)tmp->next;
	}

	return MISC_SUCCESS;	
}


int del_rtrrs(INPUT* checkbox)
{
	char	share_name[SHARE_NAME_LENGTH];
	INPUT* tmp = checkbox;
	char dest[2048]={""};

	while(tmp!=NULL){
		strncpy(share_name, parser_rtrr(dest, tmp->val, 0), SHARE_NAME_LENGTH-1);
		share_name[SHARE_NAME_LENGTH-1]=0;	
		del_rtrrs_job(share_name);
		tmp = (INPUT*)tmp->next;
	}

	return MISC_SUCCESS;	
}


int rtrr_replace(FILE* fp, char* str, void* arg)
{
	SECTION_INFO *vol = NULL;
	RTRR_CLIENT* job = NULL;
	RTRR_SERVER* srv = NULL;
	INPUT* tmp=NULL, *input=NULL; //*tmp1=NULL;
	int num, i;//, dm=0, type;
	char buf[1024]={""};//,selected[15]={""}, *ptr = NULL;

	if (!strcasecmp(str, "ON_LOAD")){
		;	//do nothing
	}		
	else if ( !strcmp(str, "refresh_page") ) {
		if ( need_refresh == 1 ) {
			char *subfun = (char *)arg;
			fprintf(fp, "<meta http-equiv=\"refresh\" content=\"0; url=misc.cgi?func=%s&count=%lu\">", subfun, time(NULL));
		}
		need_refresh = 0;
	}
	else if (!strcmp(str, "VOL")){
		char	local_share_name[SHARE_NAME_LENGTH];
		char	selected[10]={""};
		input = (INPUT*)arg;
		num = Get_NAS_Share_List_Ex(&vol);
		strcpy(local_share_name, parser_rtrr(buf, input->val, 3));

		for (i = 0; i<num; i++) {
			if ( !strcmp(local_share_name, (vol+i)->section_name) )
				strcpy(selected, "selected");
			if ( strncmp((vol+i)->section_name, "_sn_", 4) )
				fprintf(fp,"<option value=\"%s\" %s>%s</option>", (vol+i)->section_name, selected, (vol+i)->section_name);
		}
		if (vol != NULL)
			Release_List(vol);		
	}	
	else if (!strcmp(str, "rtrr_job_name")){
		char* ptr=NULL;
		input = (INPUT*)arg;
		ptr = parser_rtrr(buf, input->val, 2);
		((tmp = CGI_Find_Parameter(input, "RTRR_JOB_NAME")))?fprintf(fp, "%s", tmp->val):
			fprintf(fp, "%s", ptr);
	}
	else if (!strcmp(str, "rtrr_new_job_name")){
		input = (INPUT*)arg;
		OUTPUT_TEST_REMOTE_FIELD(input, "RTRR_JOB_NAME");
	}
	else if (!strcmp(str,"rtrr_server_location")){
		char* ptr=NULL;
		input = (INPUT*)arg;
		ptr = parser_rtrr(buf, input->val, 6);
		((tmp = CGI_Find_Parameter(input, "RTRR_SRV_LOCATION")))?fprintf(fp, "%s", tmp->val):
			fprintf(fp, "%s", ptr);
	}
	else if (!strcmp(str,"rtrr_server_port")){
		char* ptr=NULL;
		input = (INPUT*)arg;
		ptr = parser_rtrr(buf, input->val, 7);
		((tmp = CGI_Find_Parameter(input, "RTRR_SRV_PORT")))?fprintf(fp, "%s", tmp->val):
			fprintf(fp, "%s", (ptr?ptr:"873"));
	}
	else if (!strcmp(str,"rtrr_local_dir_name")){
		char* ptr=NULL;
		input = (INPUT*)arg;
		ptr = parser_rtrr(buf, input->val, 4);
		((tmp = CGI_Find_Parameter(input, "RTRR_LOCAL_DIR_NAME")))?fprintf(fp, "%s", tmp->val):
			fprintf(fp, "%s", (ptr?ptr:""));
	}
	else if (!strcmp(str,"rtrr_remote_dir_name")){
		char* ptr=NULL;
		input = (INPUT*)arg;
		ptr = parser_rtrr(buf, input->val, 9);
		((tmp = CGI_Find_Parameter(input, "REMOTE_SHARE_SUBDIR")))?fprintf(fp, "%s", tmp->val):
			fprintf(fp, "%s", (ptr?ptr:""));
	}
	else if (!strcmp(str, "server_status")){		
		if ( rsync_server_share_list_num == -1 )
			fprintf(fp,"MISC_RTRR_STR19");
		else if ( rsync_server_share_list_num == 0 )
			fprintf(fp,"MISC_RTRR_STR21");
		else
			fprintf(fp,"MISC_RTRR_STR20");
	}
	/*else if (!strcmp(str, "job_chkbox_checked")){
		int	job_enable;
		input = (INPUT*)arg;
		
		job_enable = atoi(parser_rtrr(buf, input->val, 1))?1:0;
		if ( job_enable == 1 )
			fprintf(fp,"checked");

	}*/
	else if (!strcmp(str, "remote_share_list")){
		for (i=0; i < rsync_server_share_list_num; i++){
			fprintf(fp,"<option value=\"%s\">%s</option>\n", 
				rsync_server_share_list[i], rsync_server_share_list[i]);
			if ( rsync_server_share_list[i] ) {
				free(rsync_server_share_list[i]);
				rsync_server_share_list[i] = NULL;
			}
		}
		if ( rsync_server_share_list ) {
			free(rsync_server_share_list);
			rsync_server_share_list = NULL;
		}
	}
	else if (!strcmp(str, "edit_remote_share_list")){
		char	ip[16];
		int	port=873;
		char	remote_share_name[SHARE_NAME_LENGTH];
		char	selected[10]={""};

		input = (INPUT*)arg;
		strncpy(ip, parser_rtrr(buf, input->val, 6), 15); ip[15]=0;
		port = atoi(parser_rtrr(buf, input->val, 7));
		strcpy(remote_share_name, parser_rtrr(buf, input->val, 8));

		if ( !rsync_server_share_list )
			rsync_server_share_list_num = rtrr_get_remote_server_share_list(
				ip, port, &rsync_server_share_list);

		for (i=0; i < rsync_server_share_list_num; i++){
			if ( !strcmp(remote_share_name, rsync_server_share_list[i]) )
				strcpy(selected, "selected");
			fprintf(fp,"<option value=\"%s\" %s>%s</option>\n", 
				rsync_server_share_list[i], selected, rsync_server_share_list[i]);
			if ( rsync_server_share_list[i] ) {
				free(rsync_server_share_list[i]);
				rsync_server_share_list[i] = NULL;
			}
		}
		if ( rsync_server_share_list ) {
			free(rsync_server_share_list);
			rsync_server_share_list = NULL;
		}
	}
	else if ( !strcmp(str, "list_checkbox") ){
		job = (RTRR_CLIENT*)arg;
		fprintf(fp, "%d:%d:%s:%s:%s:%s:%s:%d:%s:%s:", 
			job->job_id, 
			job->job_enable, 
			job->job_name, 
			job->local_share_name, 
			job->local_dir_name, 
			job->local_path, 
			job->remote_server_ip, 
			job->remote_server_port, 
			job->remote_share_name, 
			job->remote_dir_name
			);
	}
	else if ( !strcmp(str, "old_rtrr_job") ) {
		input = (INPUT*)arg;
		tmp = CGI_Find_Parameter(input, "checkbox");
		if ( !tmp )
			tmp = input;
		fprintf(fp, "%s", tmp->val);
	}
	else if (!strcmp(str, "list_job_name")){
		job = (RTRR_CLIENT*)arg;
		fprintf(fp, "%s", job->job_name);
	}
	else if (!strcmp(str, "list_local_path")){
		job = (RTRR_CLIENT*)arg;
		fprintf(fp, "%s", job->local_share_name);
		if ( strlen(job->local_dir_name) > 0 )
			fprintf(fp, "/%s", job->local_dir_name);
	}
	else if (!strcmp(str, "list_remote_ip")){
		job = (RTRR_CLIENT*)arg;
		fprintf(fp, "%s", job->remote_server_ip);
	}
	else if (!strcmp(str, "list_remote_share")){
		job = (RTRR_CLIENT*)arg;
		fprintf(fp, "%s", job->remote_share_name);
		if (job->remote_dir_name)
			fprintf(fp, "/%s", job->remote_dir_name);
	}
	else if (!strcmp(str, "list_remote_port")){
		job = (RTRR_CLIENT*)arg;
		fprintf(fp, "%d", job->remote_server_port);
	}
	else if (!strcmp(str, "rtrrd_server_port")){
		char	buf[10];
		Conf_Get_Field("/etc/config/uLinux.conf", "RTRR", "Port", buf, sizeof(buf));
		if ( atoi(buf) > 0 )
			fprintf(fp, "%s", buf);
		else
			fprintf(fp, "873");
	}
	else if (!strcmp(str, "RTRR_Server_enabled")){
		char	buf[10];

		Conf_Get_Field("/etc/config/uLinux.conf", "RTRR", "Enable", buf, sizeof(buf));
		if ( !strcmp( buf, "True") )
			fprintf(fp, "checked");
	}
	else if ( !strcmp(str, "rtrrs_list_chkbox") ){
		srv = (RTRR_SERVER*)arg;
		fprintf(fp, "%s:%s:%s:%s:", 
			srv->share_name, 
			/*srv->share_comment, */	//to avoid snapshot : xxxx error
			srv->share_path, 
			srv->hosts_allow, 
			srv->hosts_deny
			);
	}
	else if (!strcmp(str, "rtrr_server_share")){
		char	buf[FILE_NAME_MAX_LENGTH];

		input = (INPUT*)arg;
		strncpy(buf, parser_rtrr(buf, input->val, 0), FILE_NAME_MAX_LENGTH-1);
		buf[FILE_NAME_MAX_LENGTH-1]=0;
		fprintf(fp, "%s", buf);
	}
	/*else if (!strcmp(str, "rtrr_server_share_comment")){
		char	buf[SHARE_COMMENT_LENGTH];

		input = (INPUT*)arg;
		strncpy(buf, parser_rtrr(buf, input->val, 1), SHARE_COMMENT_LENGTH-1);
		buf[SHARE_COMMENT_LENGTH-1]=0;
		fprintf(fp, "%s", buf);
	}*/
	else if (!strcmp(str, "rtrrs_Hosts_Allow")){
		char	buf[32];

		input = (INPUT*)arg;
		strncpy(buf, parser_rtrr(buf, input->val, 2), 31); buf[31]=0;
		fprintf(fp, "%s", buf);
	}
	else if (!strcmp(str, "rtrrs_Hosts_Deny")){
		fprintf(fp, "0.0.0.0/0");
	}
	else if (!strcmp(str, "rtrrs_share_name")){
		srv = (RTRR_SERVER*)arg;
		fprintf(fp, "%s", srv->share_name);
	}
	else if (!strcmp(str, "rtrrs_share_comment")){
		srv = (RTRR_SERVER*)arg;
		fprintf(fp, "%s", srv->share_comment);
	}
	else if (!strcmp(str, "rtrrs_hosts_allow")){
		srv = (RTRR_SERVER*)arg;
		fprintf(fp, "%s", srv->hosts_allow);
	}
	else if ( !strcmp(str, "old_rtrrs_share") ) {
		input = (INPUT*)arg;
		tmp = CGI_Find_Parameter(input, "checkbox");
		fprintf(fp, "%s", tmp->val);
	}
	else 
		return CGI_REPLACE_FAIL;	
	return CGI_REPLACE_OK;
}

RTRR_CLIENT* get_new_rtrr(INPUT* input)
{
	RTRR_CLIENT* job = NULL;
	INPUT* tmp = NULL;
	int	ret = 0;
	
	if (!(job = calloc (1, sizeof(RTRR_CLIENT))))
		return NULL;

	job->remote_server_port = 873;
	job->job_enable = 1;

	if ( (tmp = CGI_Find_Parameter(input, "RTRR_JOB_NAME")) ) {
		strncpy(job->job_name, tmp->val, MAX_JOB_NAME_LEN-1);
		job->job_name[MAX_JOB_NAME_LEN-1] = 0;
	}

	if ( (tmp = CGI_Find_Parameter(input, "LOCAL_VOL")) ) {
		strcpy(job->local_share_name, tmp->val);
		ret = Conf_Get_Field(SAMBA_CONF_PATH, job->local_share_name, 
				"path", job->local_path, FILE_NAME_MAX_LENGTH);
		if ( ret != SUCCESS )
			return NULL;
		if ( (tmp = CGI_Find_Parameter(input, "RTRR_LOCAL_DIR_NAME")) ) {
			strcpy(job->local_dir_name, tmp->val);
		}
		job->local_dir_name[FILE_NAME_MAX_LENGTH-1] = 0;
	}

	if ( (tmp = CGI_Find_Parameter(input, "RTRR_SRV_LOCATION")) ) {
		strncpy(job->remote_server_ip, tmp->val, 15);
		job->remote_server_ip[15] = 0;
	}	
	
	if ( (tmp = CGI_Find_Parameter(input, "RTRR_SRV_PORT")) ) {
		job->remote_server_port = atoi(tmp->val);
	}

	if ( (tmp = CGI_Find_Parameter(input, "REMOTE_SHARE")) ) {
		strcpy(job->remote_share_name, tmp->val);
		if ( (tmp = CGI_Find_Parameter(input, "REMOTE_SHARE_SUBDIR")) ) {
			strcpy(job->remote_dir_name, tmp->val);
		}
		job->remote_dir_name[FILE_NAME_MAX_LENGTH-1] = 0;
	}	
	
	/*
	if ( (tmp = CGI_Find_Parameter(input, "JOB_CHKBOX")) ) {
		if ( tmp && !strcmp(tmp->val, "YES") )
			job->job_enable = 1;
		else
			job->job_enable = 0;
	}
	*/
	//DEBUG_rtrr(job);

	return job;
}	

RTRR_SERVER* get_new_rtrr_srv(INPUT* input)
{
	RTRR_SERVER* pnt = NULL;
	INPUT* tmp = NULL;
	
	if (!(pnt = calloc (1, sizeof(RTRR_SERVER))))
		return NULL;

	strcpy(pnt->share_name, "");
	strcpy(pnt->hosts_allow, "0.0.0.0/0");
	strcpy(pnt->hosts_deny, "0.0.0.0/0");

	/*
	if ( (tmp = CGI_Find_Parameter(input, "Hosts_Deny")) ) {
		strncpy(pnt->hosts_deny, tmp->val, 31);
		//should do some checks here!!
		pnt->hosts_deny[31] = 0;
	}
	*/

	if ( (tmp = CGI_Find_Parameter(input, "Hosts_Allow")) ) {
		strncpy(pnt->hosts_allow, tmp->val, 31);
		//should do some checks here!!
		pnt->hosts_allow[31] = 0;
	}

	if ( (tmp = CGI_Find_Parameter(input, "LOCAL_VOL")) ) {
		strncpy(pnt->share_name, tmp->val, SHARE_NAME_LENGTH-1);
		pnt->share_name[SHARE_NAME_LENGTH-1] = 0;
	}	
	
	//DEBUG_rtrr(job);

	return pnt;
}

void get_rtrr_from_string(RTRR_CLIENT* job, char* str)
{
	char buf[1024]={""};

	job->job_id = atoi(parser_rtrr(buf, str, 0));
	//job->job_enable = (atoi(parser_rtrr(buf, str, 1))?1:0);
	job->job_enable = 1;
	strcpy(job->job_name, parser_rtrr(buf, str, 2));
	strcpy(job->local_share_name, parser_rtrr(buf, str, 3));
	strcpy(job->local_dir_name, parser_rtrr(buf, str, 4));
	strcpy(job->local_path, parser_rtrr(buf, str, 5));
	strcpy(job->remote_server_ip, parser_rtrr(buf, str, 6));
	job->remote_server_port = atoi(parser_rtrr(buf, str, 7));
	strcpy(job->remote_share_name, parser_rtrr(buf, str, 8));
	strcpy(job->remote_dir_name, parser_rtrr(buf, str, 9));
	
	return;
}

int check_valid_rtrr(RTRR_CLIENT* rtrr)
{
	
	int ret = MISC_SUCCESS;
	
	
	if (rtrr->job_name[0] == 0x0)
		return MISC_RTRR_EMPTY_NAME;
	else if (strlen(rtrr->job_name)>32)
		return MISC_RTRR_BAD_NAME_LEN;
	else if (rtrr->local_share_name[0] == 0x0)
		return MISC_RTRR_REMOTE_VOL_EMPTY;

	if (rtrr->remote_server_ip[0] == 0x0)
		return MISC_RTRR_SERVER_EMPTY;

	if (rtrr->remote_server_port == 0)
		return MISC_RTRR_SERVER_PORT_EMPTY;
	//else if (rtrr->user.name[0] == 0x0)
		//return MISC_RTRR_USER_NAME_EMPTY;
	//else if (rtrr->user.passwd[0] == 0x0)
		//return MISC_RTRR_PASSWD_EMPTY; 
					
	return ret;		
}


int show_header_rtrr(int type, INPUT* input)
{
	HEADER_ITEM head;
	int index;
	static char func[20];
	
	if ((g_def_type = get_def_type ()) > 0)	
		index = SELECT_BACKUP;
	else 
		index = SELECT_BACKUP-1;	
	head.back[0]=0x0;
        head.home[0]=0x0;
        head.logout[0]=0x0;
        switch(type){
        	case HELP_RTRRC_MAIN:
        		CGI_Get_Help(head.help, "help_misc.html#help_rtrrc_main");
			strcpy(func, "rtrr_main");
        		break;
        	case HELP_RTRRC_NEW:
        		CGI_Get_Help(head.help, "help_misc.html#help_rtrrc_new");
			strcpy(func, "rtrr_man");
        		break;
        	case HELP_RTRRC_EDIT:
        		CGI_Get_Help(head.help, "help_misc.html#help_rtrrc_edit");
			strcpy(func, "rtrr_man");
        		break;
        	case HELP_RTRRS_MAIN:
        		CGI_Get_Help(head.help, "help_misc.html#help_rtrrs_main");
			strcpy(func, "rtrr_server_main");
        		break;
        	case HELP_RTRRS_NEW:
        		CGI_Get_Help(head.help, "help_misc.html#help_rtrrs_new");
			strcpy(func, "rtrr_server_main");
        		break;
        	case HELP_RTRRS_EDIT:
        		CGI_Get_Help(head.help, "help_misc.html#help_rtrrs_edit");
			strcpy(func, "rtrr_server_main");
        		break;
        }
        init_rtrr_system();
        CGI_Output_Html1(MISC_HEADER_HTML, "$", rtrr_replace, (void*)func);
        CGI_Show_Menu_V3_1(FUNC_MISC, &head);         
       	CGI_Output_Html1(MENU_V3_HEADER_HTML, "$", rtrr_replace, NULL);                    		
        CGI_Show_Menu_V3_2(szDefineFilePath[g_def_type], index);
        CGI_Output_Html1(MENU_V3_MIDDLE_HTML, "$", rtrr_replace, NULL);
        return 1;	
		
}

static int show_rtrr_tail_html()
{
	CGI_Output_Html1(MENU_V3_TAIL_HTML, "$", rtrr_replace, NULL);
	CGI_Output_Html1(MISC_TAIL_HTML, "$", rtrr_replace, NULL);
	return 1;
}


int do_rtrrc_new(INPUT* input)
{
	SECTION_INFO	*list=NULL;
	int		num = 0, share_num = 0;
	int		i = 0;
	
	num = Get_NAS_Share_List_Ex(&list);
	for (i = 0; i<num; i++) {
		if ( strncmp((list+i)->section_name, "_sn_", 4) )
			share_num++;
	}
	if( share_num > 0 ) {
		show_header_rtrr(HELP_RTRRC_NEW, input);
		CGI_Output_Html1(RTRR_CLIENT_NEW_HTML, "$", rtrr_replace, (void* )input);
		show_rtrr_tail_html();
		if(list != NULL)
			Release_List(list);
		return MISC_SUCCESS;
	}
	else {
		return MISC_RTRR_NEW_NO_SHARE;	
	}
}

int do_rtrrs_new(INPUT* input)
{
	SECTION_INFO	*list=NULL;
	int		num = 0, share_num = 0;
	int		i = 0;
	
	num = Get_NAS_Share_List_Ex(&list);
	for (i = 0; i<num; i++) {
		if ( strncmp((list+i)->section_name, "_sn_", 4) )
			share_num++;
	}	
	if( share_num > 0 ) {
		show_header_rtrr(HELP_RTRRS_NEW, input);
		CGI_Output_Html1(RTRR_SERVER_NEW_HTML, "$", rtrr_replace, (void* )input);
		show_rtrr_tail_html();
		if(list != NULL)
			Release_List(list);
		return MISC_SUCCESS;
	}
	else {
		return MISC_RTRR_NEW_NO_SHARE;	
	}
}

int do_rtrrc_edit(INPUT* input)
{
	SECTION_INFO	*list=NULL;
	int		num = 0, share_num = 0;
	int		i = 0;
	
	num = Get_NAS_Share_List_Ex(&list);
	for (i = 0; i<num; i++) {
		if ( strncmp((list+i)->section_name, "_sn_", 4) )
			share_num++;
	}
	if( share_num > 0 ) {
		show_header_rtrr(HELP_RTRRC_EDIT, input);
		CGI_Output_Html1(RTRR_CLIENT_EDIT_HTML, "$", rtrr_replace, (void* )input);
		show_rtrr_tail_html();
		if(list != NULL)
			Release_List(list);
		return MISC_SUCCESS;
	}
	else {
		return MISC_RTRR_NO_SHARE;	
	}
}

int do_rtrrs_edit(INPUT* input)
{
	SECTION_INFO	*list=NULL;
	int		num = 0, share_num = 0;
	int		i = 0;
	
	num = Get_NAS_Share_List_Ex(&list);
	for (i = 0; i<num; i++) {
		if ( strncmp((list+i)->section_name, "_sn_", 4) )
			share_num++;
	}
	if ( share_num > 0 ) {
		show_header_rtrr(HELP_RTRRS_EDIT, input);
		CGI_Output_Html1(RTRR_SERVER_EDIT_HTML, "$", rtrr_replace, (void* )input);
		show_rtrr_tail_html();
		if(list != NULL)
			Release_List(list);
		return MISC_SUCCESS;
	}
	else {
		return MISC_RTRR_NO_SHARE;	
	}
}

int do_rtrrc_main(INPUT* input)
{
	RTRR_CLIENT * jobs=NULL;
	int	ret = 0;
	
	show_header_rtrr(HELP_RTRRC_MAIN, input);
	CGI_Output_Html1(RTRR_MAIN_HEADER_HTML, "$", rtrr_replace, NULL);
	ret = get_rtrr_jobs(&jobs);
	if (!jobs) {
		char	buf[128];
		CGI_Output_Html1(RTRR_MAIN_NONE_HTML, "$", rtrr_replace, NULL);
		sprintf(buf, "/etc/init.d/rtrrd.sh stop 1>/dev/null 2>/dev/null");
		system(buf);
	}
	else{
		int	i = 0;
		for(i=0; i<ret; i++) {
			//DEBUG_rtrr(&jobs[i]);
			CGI_Output_Html1(RTRR_MAIN_BODY_HTML, "$", rtrr_replace, (void*)&jobs[i]);
		}
	}

	CGI_Output_Html1(RTRR_MAIN_TAIL_HTML, "$", rtrr_replace, NULL);
	show_rtrr_tail_html();
	
	return 	MISC_SUCCESS;
}

int do_rtrrs_main(INPUT* input)
{
	RTRR_SERVER *	all_shares=NULL;
	int		share_num=0;
	
	show_header_rtrr(HELP_RTRRS_MAIN, input);
	CGI_Output_Html1(RTRR_SERVER_MAIN_HEADER_HTML, "$", rtrr_replace, NULL);
	share_num = get_rtrr_server_shares(&all_shares);

	if ( share_num==0 ) {
		CGI_Output_Html1(RTRR_SERVER_MAIN_NONE_HTML, "$", rtrr_replace, NULL);
		stop_rsyncd();
	}
	else {
		int	i;
		char	buf[10]={'\0'};
		
		for (i=0; i<share_num; i++) {
			CGI_Output_Html1(RTRR_SERVER_MAIN_BODY_HTML, "$", rtrr_replace, (void*)&all_shares[i]);
		}
		free(all_shares);	

		Conf_Get_Field("/etc/config/uLinux.conf", 
			"RTRR", "Enable", buf, sizeof(buf));
		if ( !strcasecmp(buf, "True") ) {
			sleep(1);	//for daemon_mgr's bug
			start_rsyncd();
			//Start rsync daemon
		}
	}
	CGI_Output_Html1(RTRR_SERVER_MAIN_TAIL_HTML, "$", rtrr_replace, NULL);
	show_rtrr_tail_html();
	
	return 	MISC_SUCCESS;
}

int do_rtrrs_main_submit(INPUT* input)
{
	int btn = MISC_BTN_UNKNOWN, ret = 0;
	INPUT* tmp = NULL;
	btn = get_btn(input);

	switch(btn){
		case MISC_BTN_NEW:
			ret = do_rtrrs_new(input);
			return ret;
		case MISC_BTN_DEL:
			tmp = select_checkbox(input, &ret);
			if (ret == 0)
				return MISC_RTRR_DEL_NONE;
			else 
				del_rtrrs(tmp);
			if (tmp) free(tmp);
			tmp=NULL;

			do_rtrrs_main(input);
			break;
		case MISC_BTN_EDIT:
			tmp = select_checkbox(input, &ret);			
			if (ret == 0)
				return MISC_RTRR_EDIT_NONE;
			else if (ret > 1)
				return MISC_RTRR_EDIT_MUTL;
			ret = do_rtrrs_edit(tmp);
			return ret;
		case MISC_BTN_APPLY:
			if ( (tmp = CGI_Find_Parameter(input, "RTRR_Server_enable_checkbox")) ) {
				if ( !strcasecmp(tmp->val, "enable") ) {
					char	buf[10]={'\0'};

					Conf_Get_Field("/etc/config/uLinux.conf", 
						"RTRR", "Enable", buf, sizeof(buf));
					Conf_Set_Field("/etc/config/uLinux.conf",
						"RTRR", "Enable", "True");
					if ( !strcasecmp(buf, "True") )
						stop_rsyncd();
					if ( (tmp = CGI_Find_Parameter(input, "rtrrd_server_port")) ) {
						Conf_Get_Field("/etc/config/uLinux.conf", 
							"RTRR", "Port", buf, sizeof(buf));
						if ( strcmp(tmp->val, buf) ) {
							Conf_Set_Field("/etc/config/uLinux.conf",
								"RTRR", "Port", tmp->val);
						}
					} else {
						Conf_Set_Field("/etc/config/uLinux.conf",
							"RTRR", "Port", "873");
					}
					//start_rsyncd() in do_rtrrs_main()
				} else {
					Conf_Set_Field("/etc/config/uLinux.conf",
						"RTRR", "Enable", "False");
					stop_rsyncd();
					//Stop rsync daemon
				}			
			} else {
					Conf_Set_Field("/etc/config/uLinux.conf",
						"RTRR", "Enable", "False");
					stop_rsyncd();
			}
			do_rtrrs_main(input);
			break;
	}
	return 	MISC_SUCCESS;
}


int do_rtrrc_main_submit(INPUT* input)
{
	int btn = MISC_BTN_UNKNOWN, ret = 0;
	INPUT* tmp = NULL;
	char	buf[1024];

	switch((btn = get_btn(input))){
		case MISC_BTN_NEW:
			ret = do_rtrrc_new(input);
			return ret;
		case MISC_BTN_DEL:
			tmp = select_checkbox(input, &ret);
			if (ret == 0)
				return MISC_RTRR_DEL_NONE;
			else 
				del_rtrr(tmp);
			if (tmp) free(tmp);
			tmp=NULL;
			sprintf(buf, "/bin/kill -HUP `/sbin/pidof rtrrd`");
			system(buf);

			do_rtrrc_main(input);
			break;
		case MISC_BTN_EDIT:
			tmp = select_checkbox(input, &ret);
			if (ret == 0)
				return MISC_RTRR_EDIT_NONE;
			else if (ret > 1)
				return MISC_RTRR_EDIT_MUTL;
			ret = do_rtrrc_edit(tmp);
			return ret;		
	}
	return 	MISC_SUCCESS;
}

int do_rtrrc_new_submit (INPUT* input)
{
	RTRR_CLIENT* 	job = NULL;
	int 		btn = MISC_BTN_UNKNOWN, ret = 0;
	char		path[FILE_NAME_MAX_LENGTH];

	btn = get_btn(input);
	job = get_new_rtrr(input);

	if ( btn == MISC_BTN_GET_SHARE_LIST ) {
		rsync_server_share_list_num = rtrr_get_remote_server_share_list(
					job->remote_server_ip, 
					job->remote_server_port, 
					&rsync_server_share_list);
		goto new_rtrrc_show;	
	}
	else if (btn == MISC_BTN_CANCEL || btn != MISC_BTN_OK)
		goto rtrrc_new_not_found;

	if (job == NULL) {
		goto rtrrc_new_not_found;
	} else{
		char	buf[1024];

		/*
		strcpy(RTRR_CLIENT.job_name, job->job_name);
		RTRR_CLIENT.job_enable = job->job_enable;
		strcpy(RTRR_CLIENT.local_share_name, job->local_share_name);
		strcpy(RTRR_CLIENT.local_dir_name, job->local_dir_name);
		strcpy(RTRR_CLIENT.remote_server_ip, job->remote_server_ip);
		strcpy(RTRR_CLIENT.remote_share_name, job->remote_share_name);
		strcpy(RTRR_CLIENT.remote_dir_name, job->remote_dir_name);
		RTRR_CLIENT.remote_server_port = job->remote_server_port;
		*/
		//DEBUG_rtrr(job);
		strcpy(path, job->local_path);
		if ((ret = check_valid_rtrr(job))!=MISC_SUCCESS){
			free(job);
			job = NULL;
			return ret;
		}	
		else if ((ret = add_rtrrc_job(job)) != RTRR_SUCCESS){
				free(job);
				job = NULL;
				return ret;
		}
		
		sprintf(buf, "/etc/init.d/rtrrd.sh start 1>/dev/null 2>/dev/null");
		system(buf);
		sprintf(buf, "/bin/kill -HUP `/sbin/pidof rtrrd` 1>/dev/null 2>/dev/null");
		system(buf);
		sprintf(buf, "/bin/chmod 777 %s/%s 1>/dev/null 2>/dev/null", path, job->local_dir_name);
		system(buf);
		free(job);
		job = NULL;
	}
	
rtrrc_new_not_found:	
	need_refresh = 1;
	do_rtrrc_main(input);
	return 	MISC_SUCCESS;
new_rtrrc_show:
	do_rtrrc_new(input);		
	return 	MISC_SUCCESS;
}

int do_rtrrs_new_submit (INPUT* input)
{
	int 		btn = MISC_BTN_UNKNOWN, ret = 0;
	RTRR_SERVER*	rtrr_srv;
	
	
	btn = get_btn(input);
	rtrr_srv = get_new_rtrr_srv(input);

	if (btn == MISC_BTN_CANCEL || btn != MISC_BTN_OK)
		goto rtrrs_new_not_found;


	if (rtrr_srv == NULL) {
		goto new_rtrrs_show;
	} else{
		if ((ret = add_rtrrs_job(rtrr_srv)) != BACKUP_SUCCESS){
				free(rtrr_srv);
				rtrr_srv = NULL;
				return ret;
		}
		free(rtrr_srv);
		rtrr_srv = NULL;
	}

rtrrs_new_not_found:	
	need_refresh = 1;
	do_rtrrs_main(input);
	
	return 	MISC_SUCCESS;
new_rtrrs_show:
	do_rtrrs_new(input);		
	return 	MISC_SUCCESS;
}

int do_rtrrc_edit_submit (INPUT* input)
{
	RTRR_CLIENT 	*job = NULL, *old=NULL;
	int 		btn = MISC_BTN_UNKNOWN, ret = 0;
	char		path[FILE_NAME_MAX_LENGTH]="\0";

	INPUT* tmp = NULL;	

	btn = get_btn(input);
	job = get_new_rtrr(input);
	tmp = CGI_Find_Parameter(input, "old_rtrr_job");

	if (btn == MISC_BTN_GET_SHARE_LIST){
		char		*buf1 = NULL;
		char		*buf2 = NULL;
		char		tmpbuf[2048]={""};
		int		i = 0;

		rsync_server_share_list_num = rtrr_get_remote_server_share_list(
					job->remote_server_ip, 
					job->remote_server_port, 
					&rsync_server_share_list);
		//DEBUG_rtrr(job);
		buf1 = (char *)calloc(strlen(tmp->val) + 5, sizeof(char));
		for (i=0;i<=9;i++) {
			if ( i == 6 ) {
				strcat(buf1, job->remote_server_ip);
			} else if ( i == 7 ) {
				char portno[6];
				
				sprintf(portno, "%d", job->remote_server_port);
				strcat(buf1, portno);
			} else {
				strcat(buf1, parser_rtrr(tmpbuf, tmp->val, i));
			}
			strcat(buf1, ":");
		}
		buf2 = (char *)realloc(tmp->val, strlen(buf1));
		tmp->val = buf2;
		strcpy(tmp->val, buf1);
		if ( buf1 ) free(buf1);
		goto edit_rtrrc_show;	
	}
	else if (btn == MISC_BTN_CANCEL || btn != MISC_BTN_OK)
		goto rtrrc_edit_not_found;		

	if (job == NULL){
		goto rtrrc_edit_not_found;
	}	
	else{
		char	buf[FILE_NAME_MAX_LENGTH+1024];

		if ((ret = check_valid_rtrr(job))!=MISC_SUCCESS){
			if (job) free(job);
			job=NULL;			
			return ret;
		}	

		if (tmp != NULL){
			old = calloc(1, sizeof(RTRR_CLIENT));
			get_rtrr_from_string(old, tmp->val);
			//DEBUG_rtrr(old);
			//DEBUG_rtrr(job);
			job->job_id = old->job_id;
			strncpy(path, job->local_path, FILE_NAME_MAX_LENGTH-1);
			if ((ret = ren_rtrrc_job(job, old)) != BACKUP_SUCCESS){
				free(job); job=NULL;
				free(old); old=NULL;
				return ret;
			}
		}

		sprintf(buf, "/etc/init.d/rtrrd.sh start 1>/dev/null 2>/dev/null");
		system(buf);
		sprintf(buf, "/bin/kill -HUP `/sbin/pidof rtrrd` 1>/dev/null 2>/dev/null");
		system(buf);
		sprintf(buf, "/bin/chmod 777 %s/%s 1>/dev/null 2>/dev/null", path, job->local_dir_name);
		system(buf);
		free(job); job=NULL;
		free(old); old=NULL;
	}

rtrrc_edit_not_found:
	need_refresh = 1;
	do_rtrrc_main(input);
	return 	MISC_SUCCESS;
edit_rtrrc_show:
	do_rtrrc_edit(tmp);		
	return 	MISC_SUCCESS;
}

int do_rtrrs_edit_submit (INPUT* input)
{
	RTRR_SERVER 	*new = NULL, *old=NULL;
	int 		btn = MISC_BTN_UNKNOWN, ret = 0;

	INPUT* tmp = NULL;	

	//CGI_Debug_Input(input);
	btn = get_btn(input);
	new = get_new_rtrr_srv(input);

	if (btn == MISC_BTN_CANCEL || btn != MISC_BTN_OK)
		goto rtrrs_edit_not_found;		

	if (new == NULL){		
		goto rtrrs_edit_not_found;
	}	
	else{
		tmp = CGI_Find_Parameter(input, "old_rtrrs_share");

		if (tmp != NULL){
			char		buf[1024]={""};

			old = calloc(1, sizeof(RTRR_SERVER));
			strncpy(old->share_name, parser_rtrr(buf, tmp->val, 0), SHARE_NAME_LENGTH-1);
			old->share_name[SHARE_NAME_LENGTH-1]=0;
			//strcpy(new->share_name, old->share_name);
			if ((ret = ren_rtrrs_job(new, old)) != BACKUP_SUCCESS){
				free(new);
				free(old);
				new=NULL;
				old=NULL;
				return ret;
			}
			free(new);
			free(old);
			new=NULL;
			old=NULL;
		}
		free(new);
		free(old);
		new=NULL;
		old=NULL;	
	}

rtrrs_edit_not_found:
	need_refresh = 1;
	do_rtrrs_main(input);
	return 	MISC_SUCCESS;

}	


