#include <stdio.h>
#include <string.h>
#include "cfg_rsync.h"

int main(int argc, char **argv)
{
	if ( argc != 2 ) {
			fprintf(stderr, "Usage: %s [cron | 2rsync | 2backup]\n", argv[0]);
			return -1;
	}
	
	if ( !strcmp(argv[1], "cron") ) {
		fprintf(stdout, "refreshing /etc/config/crontab ...\n");
		rsync_refresh_crontab();
	} else
	if ( !strcmp(argv[1], "2rsync") ) {
		fprintf(stdout, "converting old RR conf to new format ...\n");
		convert_conf_backup_to_rsync();
	} else
	if ( !strcmp(argv[1], "2backup") ) {
		fprintf(stdout, "converting new RR conf to old format ...\n");
		convert_conf_rsync_to_backup();
	}
	return 0;
}
