#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>


#include <uLinux.h>
#include <cgi.h>
#include <config.h>
#include <v2_menu.h>
#include <Util.h>
#include <NAS.h>

#include <cfg_system.h>

#include "misc.h"
#include "restart.h"

int do_restart_main(INPUT* input, int select)
{
	show_misc_header(input, select);
	CGI_Output_Html(RESTART_MAIN_HTML, "$", NULL);
	show_misc_tail();
	return MISC_SUCCESS;
}	

int do_restart_main_submit(INPUT* input)
{
	INPUT* t = NULL;
	int btn;
	btn = get_btn(input);
	switch(btn)
	{
		case MISC_BTN_RESTART:
			set_misc_restart(0);
			CGI_Load_Html("misc.cgi?func=restart_main_ok&restart=0");
			CGI_Free_Input(input);
			exit(0);
			break;
		case MISC_BTN_SHUTDOWN:
			set_misc_restart(1);
			do_restarting(input, SELECT_RESTART);
			break;
		default:
			if((t=CGI_Find_Parameter(input, "restart")) != NULL) {
				if(!strcmp(t->val, "0")) {					
					do_restarting(input, SELECT_RESTART);
				}
			}
			break;	
	}	
	return MISC_SUCCESS;
}	
