#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <stdarg.h>

#include <sys/stat.h>
/* include NAS lib */
#include <cfg_tape.h>
#include <cfg_ups.h>
#include <cgi.h>
#include <cfg_backup.h>
#include <cfg_save_restore.h>
#include <v2_menu.h>
//#include <cfg_dvd.h>
#include <cfg_logo.h>
/* include local file */
#include "misc.h"
#include "backup.h"
#include "snmp.h"
#include "failure.h"
#include "hardware.h"
#include "restart.h"
#include "save_restore.h"
#include "logo.h"
#include "uLinux.h"
#include "config.h"
#include "../CGI2.1/icp.h"
#include "auto_bs.h"
#include "rtrr.h"
#include "cfg_smtp.h"
//#include "cfg_dvd.h"

extern void LOG_TABLE_COL(FILE *fp, int, char *, char *, char *);
extern ACTIVE_USER_INFO *count_active_user(int *real);
extern void show_active_user(FILE *fp, ACTIVE_USER_INFO *active, int);
extern int do_sr_restart_submit(INPUT* input);
extern int do_ba_main(INPUT* input, int select);
extern int do_ba_submit_remove(INPUT* input, int select);
extern int do_ba_submit_install(INPUT* input, int select);
extern int do_ba_submit_apply(INPUT* input, int select);


int g_update_hd;
int need_refresh;

/*
int mischeader_replace(FILE *fptr, char *name, void *arg)
{
	if ( !strcmp(name, "refresh_page") ) {
		if ( need_refresh == 1 ) {
			char *subfun = (char *)arg;
			fprintf(fptr, "<meta http-equiv=\"refresh\" content=\"0; url=snapshot.cgi?function=SNAPSHOT&subfun=%s&count=%lu\">", subfun, time(NULL));
		}
		need_refresh = 0;
	}
	else                         
		return CGI_REPLACE_FAIL;

	return CGI_REPLACE_OK;
}
*/
int set_misc_restart(int type)
{

	pid_t	mypid, parent;
	char	dir[128], buf[128];

	parent=getpid();
	sprintf(dir, "/proc/%d/exe", parent);
	mypid=fork();
	if (mypid==0)
	{	/* child */
		close(0);
		close(1);
		close(2);
		while (1)
		{
			/* check parent exist? */
			if (readlink(dir, buf, 256)==-1)
				break;
			sleep(1);
		}
		if (type==0)
			//printf("restart system<br>");
			Restart_System();
		else
		if (type==1)
			//printf("shutdown system<br>");
			Shutdown_System();
		exit(1);
	}
	else
	{	/* parent */
		return SUCCESS;
	}
}

int restart_replace(FILE* fp, char* str, void* arg)
{
	INPUT* t = NULL, *input = (INPUT*)arg;
	if (!strcmp(str, "ERROR_TITLE")){
    		char message[128];
    		if((t = CGI_Find_Parameter(input, "restart")) != NULL) {
			if(!strcmp(t->val, "0"))
				strncpy(message, "<SCRIPT Language=\"JavaScript\">document.write(IEI_NAS_MISC2_TITLE2)</SCRIPT>", sizeof(message));
		}
		else if((t = CGI_Find_Parameter(input, "YES")) != NULL) {
			strncpy(message, "<SCRIPT Language=\"JavaScript\">document.write(IEI_NAS_MISC2_TITLE2)</SCRIPT>", sizeof(message));
		}
		if((t = CGI_Find_Parameter(input, "SHUTDOWN")) != NULL) {	
			strncpy(message, "<SCRIPT Language=\"JavaScript\">document.write(IEI_NAS_MISC2_TITLE3)</SCRIPT>", sizeof(message));
		}
		fprintf(fp, "%s", message);
    	}	
	else if(!strcmp(str, "ERROR_MSG")){
		char message[128];

		if((t = CGI_Find_Parameter(input, "restart")) != NULL) {
			if(!strcmp(t->val, "0"))
				strncpy(message, "<SCRIPT Language=\"JavaScript\">document.write(IEI_IDS_STRING78)</SCRIPT>", sizeof(message));
		}
		else if((t = CGI_Find_Parameter(input, "YES")) != NULL) {
			strncpy(message, "<SCRIPT Language=\"JavaScript\">document.write(IEI_IDS_STRING78)</SCRIPT>", sizeof(message));
		}
		if((t = CGI_Find_Parameter(input, "SHUTDOWN")) != NULL) {	
			strncpy(message, "<SCRIPT Language=\"JavaScript\">document.write(IEI_IDS_STRING80)</SCRIPT>", sizeof(message));
		}
		fprintf(fp, "%s", message);

	}
	else if(!strcmp(str, "PARAMETER_2")){
		if((t = CGI_Find_Parameter(input, "restart")) != NULL) {
			if(!strcmp(t->val, "0"))
				fprintf(fp, "1");
		}
		else if((t = CGI_Find_Parameter(input, "YES")) != NULL) {
			fprintf(fp, "1");
		}
		else
			fprintf(fp, "0");
		
	}
	else 
		return CGI_REPLACE_FAIL;
	return CGI_REPLACE_OK;	
}	

int do_restarting(INPUT* input, int select)
{
	HEADER_ITEM     header;
	
	CGI_Output_Html1(MISC_HEADER_HTML, "$",  my_replace, (void*)input);
        header.back[0]=0x0;
        header.home[0]=0x0;
        header.logout[0]=0x0;	
	get_misc_help_path(header.help, select);	
        CGI_Show_Menu_V3_1(FUNC_NONE, &header);        
	CGI_Output_Html1(RESTARTING_HTML, "$", restart_replace,(void*)input);
	show_misc_tail();
	return MISC_SUCCESS;
}	

int get_reset_disk_status_file(char *status)
{
	FILE *fptr = NULL;
	
	if((fptr=fopen("/tmp/reset_disk_status", "r+")) == NULL) {
		return ERROR_FAIL;
	}
	else {
		fscanf(fptr, "%s", status);
		fclose(fptr);
	}
	return SUCCESS;	
}

int set_reset_disk_status_file(char *status)
{
	FILE *fptr = NULL;
	
	if((fptr=fopen("/tmp/reset_disk_status", "w+")) == NULL) {
		return ERROR_FAIL;
	}
	else {
		fprintf(fptr, "%s", status);
		fclose(fptr);
	}
	return SUCCESS;	
}

int get_def_type (void)
{
	return 0;
}

int my_replace(FILE* fp, char* str, void* arg)
{
	if (!strcasecmp(str, "ON_LOAD"))
	{
		INPUT* input = (INPUT*)arg;
		if (CGI_Find_Parameter(input, "SHUTDOWN") || CGI_Find_Parameter(input, "restart"))
			fprintf(fp, "OnLoad();");
		else
			fprintf(fp, "%s", "");	
	}		
	else
	if(!strcasecmp(str, "refresh_page")){
		;
	}
	/*else
	if(!strcasecmp(str, "START_HERE")){
		int real_count = 0;
		ACTIVE_USER_INFO *active = count_active_user(&real_count);
		fprintf(fp, "<p>&nbsp;</p>\n");
		fprintf(fp, "<SCRIPT Language=\"JavaScript\">document.write(IEI_IDS_STRING160)</SCRIPT><br>\n<p>&nbsp;</p>\n");
		show_active_user(fp, active, real_count);
		if (active != NULL)
			free(active);
	}*/
	else
	if(!strcasecmp(str, "refresh_html")){
		long count = 0L;
		INPUT *input = (INPUT*)arg;
		INPUT *tmp = NULL;
		char status[BUF_SIZE] = {0};

		if(get_reset_disk_status_file(status) != SUCCESS) {
			fprintf(fp, "%s", "");
		}
		
		if(!strcasecmp(status, "BUSY")) {
			if((tmp=CGI_Find_Parameter(input, "counter")) == NULL) {
				return CGI_REPLACE_FAIL;
			}
			count = atol(tmp->val);
			fprintf(fp, "<meta http-equiv=\"refresh\" content=\"5;url=/cgi-bin/misc/misc.cgi?func=sr_main&counter=%ld&refresh=\">\n", count);
			return CGI_REPLACE_OK;
		}
		else {	
			fprintf(fp, "%s", "");
		}
	} 
	else
	if(!strcasecmp(str, "STATUS")){
		char status[BUF_SIZE] = {0};

		if(get_reset_disk_status_file(status) != SUCCESS) { // /tmp/reset_disk_status not exists
			fprintf(fp, "%s", "");
		}
		else {
			if(!strcasecmp(status, "BUSY")) {
				fprintf(fp, "%s\n", "( <SCRIPT Language=\"JavaScript\">document.write(IEI_NAS_BACKUP_SETTINGS12 + \' : \' + IEI_NAS_BACKUP_SETTINGS13)</SCRIPT> )");
			}
			else if(!strcasecmp(status, "OK")) {
				fprintf(fp, "%s\n", "( <SCRIPT Language=\"JavaScript\">document.write(IEI_NAS_BACKUP_SETTINGS12 + \' : \' + IEI_NAS_BACKUP_SETTINGS14)</SCRIPT> )");
			}
		}
	}
	else
	if(!strcasecmp(str, "DISABLE_RESTORE_BUTTON")){
		char status[BUF_SIZE] = {0};

		if(get_reset_disk_status_file(status) != SUCCESS) { // /tmp/reset_disk_status not exists
			fprintf(fp, "%s", "");
		}
		else {
			if(!strcasecmp(status, "BUSY")) {
				fprintf(fp, "%s", "disabled");
			}
			else if(!strcasecmp(status, "OK")) {
				fprintf(fp, "%s", "");
			}
		}
	}
	else
	if(!strcasecmp(str, "DISABLE_BACKUP_BUTTON")){
		char status[BUF_SIZE] = {0};

		if(get_reset_disk_status_file(status) != SUCCESS) { // /tmp/reset_disk_status not exists
			fprintf(fp, "%s", "");
		}
		else {
			if(!strcasecmp(status, "BUSY")) {
				fprintf(fp, "%s", "disabled");
			}
			else if(!strcasecmp(status, "OK")) {
				fprintf(fp, "%s", "");
			}
		}
	}
	else
	if(!strcasecmp(str, "DISABLE_RESET_BUTTON")){
		char status[BUF_SIZE] = {0};

		if(get_reset_disk_status_file(status) != SUCCESS) { // /tmp/reset_disk_status not exists
			fprintf(fp, "%s", "");
		}
		else {
			if(!strcasecmp(status, "BUSY")) {
				fprintf(fp, "%s", "disabled");
			}
			else if(!strcasecmp(status, "OK")) {
				fprintf(fp, "%s", "");
			}
		}
	}
	else
		return CGI_REPLACE_FAIL;
        return CGI_REPLACE_OK;
}

void get_misc_help_path(char* path, int select)
{
	char *p = NULL;
	switch(select)
	{
		case SELECT_SNMP:
			p = MISC_SNMP_HELP_PATH;
			break;
		case SELECT_FAILURE:
		 	p = MISC_FAILURE_HELP_PATH;
			break;
		case SELECT_RESTART:
			p = MISC_RESTART_HELP_PATH;
			break;
		case SELECT_HARD:
			p = MISC_HARD_HELP_PATH;
			break;
		case SELECT_UPDATE:
			p = MISC_UPDATE_HELP_PATH;
			break;
		case SELECT_LOGO:
			p = MISC_LOGO_HELP_PATH;
			break;				
		case SELECT_RESET:
			p = MISC_RESET_HELP_PATH;
			break;
		case SELECT_SR:
			p = MISC_SR_HELP_PATH;
			break;
		case SELECT_BA:
			p = MISC_BA_HELP_PATH;
			break;
		case SELECT_AUTO_BS:
			p = MISC_AUTO_BS_HELP_PATH;
			break;			
		case SELECT_DVD_BA:
			p = MISC_DVD_HELP_PATH;
			break;
		case SELECT_AUTO_POWER:
			p = MISC_AUTO_POWER_HELP_PATH;
			break;
	}	
	CGI_Get_Help(path, (p)?p:"");
}	
//---------------------------------------------------------------------------
// show misc common webpage header & tail
//--------------------------------------------------------------------------
int show_misc_header(INPUT* input, int select)
{
	HEADER_ITEM     header;
	static char*    misc_def[]={MISC_DEF};
	int def_type,index;
	
	def_type = get_def_type ();
	
	index = select;
	
        CGI_Output_Html1(MISC_HEADER_HTML, "$",  my_replace, (void*)input);
        header.back[0]=0x0;
        header.home[0]=0x0;
        header.logout[0]=0x0;
	
	get_misc_help_path(header.help, select);	
        CGI_Show_Menu_V3_1(FUNC_MISC, &header);
        CGI_Output_Html(MENU_V3_HEADER_HTML, "$", NULL);
        CGI_Show_Menu_V3_2(misc_def[def_type], index);
        CGI_Output_Html(MENU_V3_MIDDLE_HTML, "$", NULL);
        return 1;
}	

void show_misc_tail()
{
	CGI_Output_Html(MENU_V3_TAIL_HTML, "$", NULL);
	CGI_Output_Html(MISC_TAIL_HTML, "$", NULL);
}	
//-------------------------------------------------------------------------------

char *create_update_working_directory(int *hd_init_flag)
{
	static char update_dir[BUF_SIZE];
	char buf[BUF_SIZE];
	int result = 0;
	int hd_size;
	char dev[256];
	int drive_cnt, i, find=0;
	char tmp_path[]={"/mnt/HDA_ROOT/update"};

	g_update_hd = -1;
	drive_cnt=Get_Profile_Integer("Storage","Disk Drive Number",0);
	for (i=0;i<drive_cnt;i++)
	{
		Get_HD_DevName(i+1, dev);
		hd_size=Get_Dev_Blksize(dev);
		if (Is_HD_Ready(i+1) && hd_size>64000) // 64000 is about 32MB
		{
			g_update_hd = i;
			find=1;
			break;
		}
	}
	
	if (find)
	{
		*hd_init_flag = 1;
	        sprintf(buf, "/bin/rm -rf %s", FLASH_UPDATE_WORKING_DIR);
        	system(buf);
		tmp_path[7]='A'+g_update_hd;
		sprintf(buf, "/bin/mkdir %s", tmp_path);
		system(buf);
		sprintf(buf, "/bin/ln -s %s %s", tmp_path, FLASH_UPDATE_WORKING_DIR);
		system(buf);	
	}
	else { // no Hard exist, use ram disk
// Albert: Set hd_init_flag to 0 if there's no hard disk initialized.
		*hd_init_flag = 0;
		sprintf(buf, "/sbin/mke2fs -m0 /dev/ram1 > /dev/null; /bin/mount /dev/ram1 %s > /dev/null", FLASH_UPDATE_WORKING_DIR);
		result = system(buf);
	}
	strcpy(update_dir, FLASH_UPDATE_WORKING_DIR);
	return update_dir;
}

void clear_update_tmp_data()
{
	char buf[BUF_SIZE];
	char dev[256];
	int hd_size;
	char tmp_path[]={"/mnt/HDA_ROOT/update"};

	if(g_update_hd >= 0) {
		tmp_path[7]='A'+g_update_hd;
		Get_HD_DevName(g_update_hd+1, dev);
		hd_size=Get_Dev_Blksize(dev);
		if (Is_HD_Ready(g_update_hd+1) && hd_size>64000) {
			sprintf(buf, "/bin/rm -rf %s", tmp_path);
			system(buf);
			/* add by Kent	*/
			sprintf(buf, "/bin/rm %s -f", FLASH_UPDATE_WORKING_DIR);
			system(buf);
			if (mkdir(FLASH_UPDATE_WORKING_DIR, S_IRWXU | S_IRWXG | S_IRWXO)==0)
				chmod(FLASH_UPDATE_WORKING_DIR, S_IRWXU | S_IRWXG | S_IRWXO);
			/* end	*/
		}
	}
	else if(g_update_hd == -1) {
		sprintf(buf, "/bin/umount %s > /dev/null", FLASH_UPDATE_WORKING_DIR);
		system(buf);	
	}
}

int get_btn(INPUT* input)
{
	INPUT *tmp;
	int ret = MISC_BTN_UNKNOWN;
	
	if ((tmp = CGI_Find_Parameter(input, "NEW")))
		ret = MISC_BTN_NEW;
	else if ((tmp = CGI_Find_Parameter(input, "EDIT")))
		ret = MISC_BTN_EDIT;
	else if ((tmp = CGI_Find_Parameter(input, "DEL")))
		ret = MISC_BTN_DEL;
	else if ((tmp = CGI_Find_Parameter(input, "OK")))
		ret = MISC_BTN_OK;
	else if ((tmp = CGI_Find_Parameter(input, "APPLY")))
		ret = MISC_BTN_APPLY;		
	else if ((tmp = CGI_Find_Parameter(input, "CANCEL")))
		ret = MISC_BTN_CANCEL;
	else if ((tmp = CGI_Find_Parameter(input, "RESTART")))
		ret = MISC_BTN_RESTART;
	else if ((tmp = CGI_Find_Parameter(input, "SHUTDOWN")))
		ret = MISC_BTN_SHUTDOWN;
	else if ((tmp = CGI_Find_Parameter(input, "RESTORE")))
		ret = MISC_BTN_RESTORE;
	else if ((tmp = CGI_Find_Parameter(input, "BACKUP")))
		ret = MISC_BTN_BACKUP;	
	else if ((tmp = CGI_Find_Parameter(input, "RESET")))
		ret = MISC_BTN_RESET;	
	else if ((tmp = CGI_Find_Parameter(input, "LOGO_BUTTON")))								
		ret = MISC_BTN_LOGO;
	else if ((tmp = CGI_Find_Parameter(input, "test")))
		ret = MISC_BTN_TEST;	
	else if ((tmp = CGI_Find_Parameter(input, "YES")))
		ret = MISC_BTN_YES;	
	else if ((tmp = CGI_Find_Parameter(input, "NO")))
		ret = MISC_BTN_NO;	
	else if ((tmp = CGI_Find_Parameter(input, "refresh")))
		ret = MISC_BTN_REFRESH;	
	else if ((tmp = CGI_Find_Parameter(input, "GetShareList")))
		ret = MISC_BTN_GET_SHARE_LIST;	
	else if ((tmp = CGI_Find_Parameter(input, "detect")))
		ret = MISC_BTN_DETECT;
	else if	((tmp = CGI_Find_Parameter(input, "eject")))
		ret = MISC_BTN_EJECT;
	else if ((tmp = CGI_Find_Parameter(input, "burn")))
		ret = MISC_BTN_BURN;
	else if ((tmp = CGI_Find_Parameter(input, "burning_refresh")))
		ret = MISC_BTN_BN_REFRESH;
	else if ((tmp = CGI_Find_Parameter(input, "erase")))
		ret = MISC_BTN_ERASE;
	else if ((tmp = CGI_Find_Parameter(input, "burning_cancel")))
		ret = MISC_BTN_BN_CANCEL;
	else if ((tmp = CGI_Find_Parameter(input, "load")))
		ret = MISC_BTN_LOAD;
	else if ((tmp = CGI_Find_Parameter(input, "stop_load")))
		ret = MISC_BTN_STOP_LOAD;
	return ret;				
		
}

INPUT* select_checkbox(INPUT* input, int* ret)
{
	INPUT *tmp, *checkbox;
	
	if (!(checkbox = CGI_Get_Parameter(input, "checkbox")))
		return NULL;
	tmp = checkbox;	
	while (tmp){		
		tmp = (INPUT*)tmp->next;
		(*ret)++;
	}		
	return checkbox;
}	

int get_func(INPUT* input, int* select)
{
	INPUT* tmp;
	int ret = MISC_NONE;
	if (!(tmp = CGI_Find_Parameter(input, "func")))
		ret = MISC_NONE;
	else {
		if (!strcmp(tmp->val, "schedule_main")){
			ret = MISC_SCHEDULE_MAIN;
			*select = SELECT_BACKUP;
		}
		else if (!strcmp(tmp->val, "schedule_main_ok")){
			ret = MISC_SCHEDULE_MAIN_SUBMIT;
			*select = SELECT_BACKUP;
		}
		else if (!strcmp(tmp->val, "schedule_new_ok")){
			ret = MISC_SCHEDULE_NEW_SUBMIT;
			*select = SELECT_BACKUP;
		}	
		else if (!strcmp(tmp->val, "schedule_edit_ok")){
			ret = MISC_SCHEDULE_EDIT_SUBMIT;
			*select = SELECT_BACKUP;
		}
		/*else if (!strcmp(tmp->val, "snmp_main")){
			ret = MISC_SNMP_MAIN;
			*select = SELECT_SNMP;
		}
		else if (!strcmp(tmp->val, "snmp_main_ok")){
			ret = MISC_SNMP_MAIN_SUBMIT;
			*select = SELECT_SNMP;
		}*/	
		else if (!strcmp(tmp->val, "failure_main")){
			ret = MISC_FAILURE_MAIN;
			*select = SELECT_FAILURE;
		}
		else if (!strcmp(tmp->val, "failure_main_ok")){
			ret = MISC_FAILURE_MAIN_SUBMIT;
			*select = SELECT_FAILURE;
		}		
		else if (!strcmp(tmp->val, "hardware_main")){
			ret = MISC_HARD_MAIN;
			*select = SELECT_HARD;
		}
		else if (!strcmp(tmp->val, "hardware_main_ok")){
			ret = MISC_HARD_MAIN_SUBMIT;
			*select = SELECT_HARD;
		}	
		else if (!strcmp(tmp->val, "restart_main")){
			ret = MISC_RESTART_MAIN;
			*select = SELECT_RESTART;
		}
		else if (!strcmp(tmp->val, "restart_main_ok")){
			ret = MISC_RESTART_MAIN_SUBMIT;
			*select = SELECT_RESTART;
		}	
		else if (!strcmp(tmp->val, "logo_main")){
			ret = MISC_LOGO_MAIN;
			*select = SELECT_LOGO;
		}
		else if (!strcmp(tmp->val, "logo_main_ok")){
			ret = MISC_LOGO_MAIN_SUBMIT;
			*select = SELECT_LOGO;
		}	
		else if (!strcmp(tmp->val, "sr_main")){
			if ((tmp = CGI_Find_Parameter(input, "refresh")) != NULL) {
				ret = MISC_RESET_MAIN_SUBMIT;
			}
			else {
				ret = MISC_SR_MAIN;
			}
			*select = SELECT_SR;
		}
		else if (!strcmp(tmp->val, "sr_main_ok")){
			ret = MISC_SR_MAIN_SUBMIT;
			*select = SELECT_SR;
		}
		/*else if (!strcmp(tmp->val, "reset_main")){
			ret = MISC_RESET_MAIN;
			*select = SELECT_RESET;
		}*/
		else if (!strcmp(tmp->val, "reset_main_ok")){
			ret = MISC_RESET_MAIN_SUBMIT;
			*select = SELECT_RESET;
		}									
		else if (!strcmp(tmp->val, "sr_main_restart")){
			ret = MISC_SR_RESTART_SUBMIT;
			*select = SELECT_SR_RESTART;
		}	
		else if (!strcmp(tmp->val, "ba_main")){
			ret = MISC_BA_MAIN;
			*select = SELECT_BA;
		}	
		else if (!strcmp(tmp->val, "ba_submit_remove")){
			ret = MISC_BA_SUBMIT_REMOVE;
			*select = SELECT_BA;
		}
		else if (!strcmp(tmp->val, "ba_submit_install")){
			ret = MISC_BA_SUBMIT_INSTALL;
			*select = SELECT_BA;
		}
		else if (!strcmp(tmp->val, "ba_submit_apply")){
			ret = MISC_BA_SUBMIT_APPLY;
			*select = SELECT_BA;
		}
		else if (!strcmp(tmp->val, "auto_bs_submit_close")){
			ret = MISC_SNMP_MAIN;
			*select = SELECT_SNMP;
		}
		else if (!strcmp(tmp->val, "auto_bs_submit_apply")){
			ret = MISC_AUTO_BS_APPLY;
			*select = SELECT_AUTO_BS;
		}
		else if (!strcmp(tmp->val, "auto_bs_main")){
			ret = MISC_AUTO_BS_MAIN;
			*select = SELECT_AUTO_BS;
		}
		else if (!strcmp(tmp->val, "rtrr_main")){
			ret = MISC_RTRR_CLIENT_MAIN;
			*select = SELECT_BACKUP;
		}
		else if (!strcmp(tmp->val, "rtrr_server_main")){
			ret = MISC_RTRR_SERVER_MAIN;
			*select = SELECT_BACKUP;
		}
		else if (!strcmp(tmp->val, "rtrrc_main_ok")){
			ret = MISC_RTRR_CLIENT_MAIN_SUBMIT;
			*select = SELECT_BACKUP;
		}
		else if (!strcmp(tmp->val, "rtrrc_new_ok")){
			ret = MISC_RTRR_CLIENT_NEW_SUBMIT;
			*select = SELECT_BACKUP;
		}
		else if (!strcmp(tmp->val, "rtrrc_edit_ok")){
			ret = MISC_RTRR_CLIENT_EDIT_SUBMIT;
			*select = SELECT_BACKUP;
		}
		else if (!strcmp(tmp->val, "rtrrs_main_ok")){
			ret = MISC_RTRR_SERVER_MAIN_SUBMIT;
			*select = SELECT_BACKUP;
		}
		else if (!strcmp(tmp->val, "rtrrs_new_ok")){
			ret = MISC_RTRR_SERVER_NEW_SUBMIT;
			*select = SELECT_BACKUP;
		}
		else if (!strcmp(tmp->val, "rtrrs_edit_ok")){
			ret = MISC_RTRR_SERVER_EDIT_SUBMIT;
			*select = SELECT_BACKUP;
		}
		/*else if (!strcmp(tmp->val, "dvd_main")){
			ret = MISC_DVD_BACKUP_MAIN;
			*select = SELECT_DVD_BA;
		}
		else if (!strcmp(tmp->val, "dvd_main_submit")){
			ret = MISC_DVD_BACKUP_MAIN_SUBMIT;
			*select = SELECT_DVD_BA;
		}*/
	}
	return ret;
		
}	



void do_misc_error(int code, int select)
{
	HEADER_ITEM head;
	ERRMSG msg;
	//char errmsg[40] = {""};	
	static char* misc_defs[] = {MISC_DEF};
	int type = get_def_type (),index;

              if(code == -1)
                 return;
	index = select;
	//index = (select >= SELECT_BACKUP)?((!type)?select-1:select):select;

	if (code == 0)
		return;
	CGI_Output_Html1(MISC_HEADER_HTML, "$", my_replace, NULL);
	head.back[0] = 0x0;
	head.home[0] = 0x0;
	head.logout[0] = 0x0;	
	CGI_Get_Help(head.help, "help_warning.html");
	CGI_Show_Menu_V3_1(FUNC_MISC, &head);        
       	CGI_Output_Html1(MENU_V3_HEADER_HTML, "$", my_replace, NULL);
        CGI_Show_Menu_V3_2(misc_defs[type], index);
        CGI_Output_Html1(MENU_V3_MIDDLE_HTML, "$", my_replace, NULL);
        
        if (code >= -102 && code <= -101 )//Remote replication warning
        	strcpy(msg.title, "MISC_SCH_NEW_STR41");
        else if ((code >= -214 && code <= -201 )|| code == -10)
        	strcpy(msg.title, "MISC_SCH_NEW_STR01");
        else if (code >= -305 && code <= -301)
        	strcpy(msg.title, "MISC_SCH_NEW_STR02");
        else if (code >= -1019 && code <= -1010)	//RTRRC ERROR
		strcpy(msg.title, "MISC_BACKUP_ERROR_MSG10");
	else if (code >= -1029 && code <= -1020)	//RTRRS ERROR
		strcpy(msg.title, "MISC_BACKUP_ERROR_MSG10");

        if (code == MISC_SR_RESTORE_ERROR){//Save /Restore warning
        	strcpy(msg.title, "IEI_NAS_BACKUP_SETTINGS_WARNING_TITLE");
        	strcpy(msg.msg, "IEI_NAS_BACKUP_SETTINGS_WARNING_MSG");
        }
        else if (code == MISC_LOGO_UPLOAD_ERROR){//logo warning
        	strcpy(msg.title, "IEI_IDS_STRING126_TITLE");
        	strcpy(msg.msg, "IEI_IDS_STRING126");
        }
        else if (code >= SNMP_ERROR_CODE6 && code <= SNMP_ERROR_CODE1){// SNMP Setting Warning
        	if (code == SNMP_ERROR_CODE1){
        		strcpy(msg.title, "IEI_NAS_SNMP_ERROR_TITLE00"); // "SNMP Setting Warning"
			strcpy(msg.msg, "IEI_NAS_SNMP_ERROR_MSG00");
        	}
        	else {
        		sprintf(msg.title, SNMP_ERROR_TITLE, (code > SNMP_ERROR_CODE5)?1:2);
        		sprintf(msg.msg, SNMP_ERROR_MSG, ((code%1100)*(-1))-1);
        	}

        }			
        else if(code == ADD_BK_SNAP_OPTION_INVALID) {
		strcpy(msg.title, "MISC_SCH_NEW_STR01");
	        strcpy(msg.msg, "MISC_SCH_NEW_STR64");
	}
        else if(code == ADD_BK_SNAP_CREATE_FAIL) {
		strcpy(msg.title, "MISC_SCH_NEW_STR01");
	        strcpy(msg.msg, "MISC_SCH_NEW_STR65");
	}
        else if(code == EDIT_BK_SNAP_OPTION_INVALID) {
		strcpy(msg.title, "MISC_SCH_NEW_STR02");
	        strcpy(msg.msg, "MISC_SCH_NEW_STR64");
	}
        else if(code == EDIT_BK_SNAP_CREATE_FAIL) {
		strcpy(msg.title, "MISC_SCH_NEW_STR02");
	        strcpy(msg.msg, "MISC_SCH_NEW_STR65");
	}
	else if(code == MISC_BA_AGENT_NOT_EXIST) {
		strcpy(msg.title, "MISC_BA_ERROR_MSG001");
	        strcpy(msg.msg, "MISC_BA_ERROR_MSG102");
	}
	else if(code == MISC_BA_DISK_NOT_READY) {
		strcpy(msg.title, "MISC_BA_ERROR_MSG001");
	        strcpy(msg.msg, "MISC_BA_ERROR_MSG201");
	}
	else if(code == MISC_BA_AGENT_EXIST) {
		strcpy(msg.title, "MISC_BA_ERROR_MSG001");
	        strcpy(msg.msg, "MISC_BA_ERROR_MSG202");
	}
	else if(code == MISC_BA_SOFTWARE_ERROR) {
		strcpy(msg.title, "MISC_BA_ERROR_MSG001");
	        strcpy(msg.msg, "MISC_BA_ERROR_MSG203");
	}
	else if(code == MISC_BA_NULL_PASSWORD) {
		strcpy(msg.title, "MISC_BA_ERROR_MSG001");
	        strcpy(msg.msg, "MISC_BA_ERROR_MSG302");
	}
	else if(code == MISC_DVD_LABEL_EMPTY) {
                strcpy(msg.title, "MISC_DVD_ERROR_MSG01");
                strcpy(msg.msg, "MISC_DVD_ERROR_MSG250");
        }
	else if(code == MISC_DVD_OUT_SPACE) {
		strcpy(msg.title, "MISC_DVD_ERROR_MSG01");
                strcpy(msg.msg, "MISC_DVD_ERROR_MSG251");
	}
	else if(code == MISC_DVD_LABEL_HAS_BLANK) {
		strcpy(msg.title, "MISC_DVD_ERROR_MSG01");
                strcpy(msg.msg, "MISC_DVD_ERROR_MSG252");
	}
	else if(code == MISC_DVD_CD_CLOSED) {
		strcpy(msg.title, "MISC_DVD_ERROR_MSG01");
                strcpy(msg.msg, "MISC_DVD_ERROR_MSG253");
	}
	else if(code == MISC_DVD_DIR_N_EXIST) {
		strcpy(msg.title, "MISC_DVD_ERROR_MSG01");
                strcpy(msg.msg, "MISC_DVD_ERROR_MSG254");
	}
	else if(code == MISC_DVD_NO_DISC) {
		strcpy(msg.title, "MISC_DVD_ERROR_MSG01");
                strcpy(msg.msg, "MISC_DVD_ERROR_MSG255");
	}
	else if(code == MISC_OUT_DISK_SPACE) {
		strcpy(msg.title, "MISC_DVD_ERROR_MSG01");
                strcpy(msg.msg, "MISC_DVD_ERROR_MSG256");
	}
	else {
        	sprintf(msg.msg, "MISC_BACKUP_ERROR_MSG%d", code*(-1));
        }
        msg.type=CGI_ERROR;
        
        strcpy(msg.note, "IEI_NAS_NONE");
        
        
//#define DEBUG
#ifdef 	DEBUG
	printf("error code=%d<br>", code);	
#endif        		
        CGI_Show_Error_V3(&msg);
	 CGI_Output_Html1(MENU_V3_TAIL_HTML, "$", my_replace, NULL);
        CGI_Output_Html1(MISC_TAIL_HTML, "$", my_replace, NULL);
	return;
}	

void DebugOutput(char *msg, ...)
{
	FILE *dout;
	char buf[2048];
	va_list args;

	va_start(args, msg);
	vsnprintf(buf, sizeof(buf)-1, msg, args);
	va_end(args);

	dout = fopen("/home/httpd/cgi-bin/cgi.debug", "a");
	fputs(buf, dout);
	fclose(dout);
}

void do_misc_smtp_error(int code, int select) //Shone added 2006,01,10
{
        HEADER_ITEM head;
        ERRMSG msg;
        //char errmsg[40] = {""};
        static char* misc_defs[] = {MISC_DEF};
        int type = get_def_type (),index;
	FILE *fp;

              if(code == -1)
                 return;
        index = select;
//printf("code = %d",code);//Shone tmp
        if (code == 0)
                return;

        CGI_Output_Html1(MISC_HEADER_HTML, "$", my_replace, NULL);
        head.back[0] = 0x0;
        head.home[0] = 0x0;
        head.logout[0] = 0x0;
        CGI_Get_Help(head.help, "help_warning.html");
        CGI_Show_Menu_V3_1(FUNC_MISC, &head);
        CGI_Output_Html1(MENU_V3_HEADER_HTML, "$", my_replace, NULL);
        CGI_Show_Menu_V3_2(misc_defs[type], index);
        CGI_Output_Html1(MENU_V3_MIDDLE_HTML, "$", my_replace, NULL);

        strcpy(msg.title, "IEI_NAS_MISC1");
        //if(CODE_RANGE(code))
        
/*Shone marked 2006,01,13		
	if((fp=fopen(SMTP_TMP_LOG_FILE,"r"))==NULL)
		strcpy(msg.msg, "IEI_NAS_STORAGE32");//Unknown Error
	else 
	{
		//char buf[BUF_SIZE]="";
		char buf[62]="";
		fgets(buf,sizeof(buf),fp);
		if(strcmp(buf,""))
		{
			char *p=NULL,*p1=NULL;
	
			Trim(buf);
			p=strstr(buf," ");
			if(p!=NULL) p++;//Cut unnecessary part to shorten the string to let it fit the buffer of msg.msg(62 characters)
			p1=strstr(p,"(");
			if(p1!=NULL) *p1=0x0;
			if(p!=NULL)	
				sprintf(msg.msg,"\"%s\"",p);
			else	strcpy(msg.msg, "IEI_NAS_STORAGE32");
		}
		else strcpy(msg.msg, "IEI_NAS_STORAGE32");
		
		fclose(fp);
		//Authentication failed -- 535 authorization failed 
		//Password not inputted -- 501 malformed auth input
		//E-Mail not in SMTP server -- 553 sorry, that domain isn't in my list of allowed rcpthosts 
	}	       */ 
	//sprintf(msg.msg, "\"Test%03d\"", code);
	strcpy(msg.msg, "MISC_SMTP_MSG04");

        msg.type=CGI_ERROR;

        strcpy(msg.note, "IEI_NAS_NONE");

#ifdef  DEBUG
        printf("error code=%d<br>", code);
#endif
        CGI_Show_Error_V3(&msg);
         CGI_Output_Html1(MENU_V3_TAIL_HTML, "$", my_replace, NULL);
        CGI_Output_Html1(MISC_TAIL_HTML, "$", my_replace, NULL);
        return;
}

int main()
{
	INPUT* input = NULL;
	int menu_select=0, func, ret = MISC_SUCCESS;
	
	CGI_Check_User();
	input = CGI_Get_Input();
	func = get_func(input, &menu_select);
	if (func == MISC_SR_MAIN_SUBMIT){
		if (get_btn(input) == MISC_BTN_BACKUP){
			INPUT *tmp = NULL, *start = NULL;
			int cnt = 0, nSave_type = 0;

			if((tmp=CGI_Get_Parameter(input, "br_type"))!=NULL) {
				for(start = tmp; tmp != NULL; cnt++) {	
					nSave_type += atoi(tmp->val);		
					tmp = tmp->next;	
				}
				CGI_Free_Input(start);
				Misc_Save_Profile(nSave_type);
//				DebugOutput("nSave_type = %d\n", nSave_type);
				exit(0);
			}	
		}	
		
	}	
		
	CGI_Init();	
//#define _DEBUG	
//#ifdef _DEBUG
//	CGI_Debug_Input(input);
//#endif	
	/*CGI_Free_Input(input);
	exit(0);*/

	switch (func){
		case MISC_SNMP_MAIN:
			do_snmp_main(input, menu_select);
			break;
		case MISC_SNMP_MAIN_SUBMIT:
			ret = do_snmp_main_submit(input);			
			do_misc_error (ret, menu_select);
			break;
		case MISC_FAILURE_MAIN:
			do_failure_main(input, menu_select);			
			break;
		case MISC_FAILURE_MAIN_SUBMIT:
			ret = do_failure_main_submit(input);
			//do_misc_error (ret, menu_select);
			do_misc_smtp_error (ret, menu_select);
			break;
		case MISC_RESTART_MAIN:
			do_restart_main(input, menu_select);
			break;
		case MISC_RESTART_MAIN_SUBMIT:
			ret = do_restart_main_submit(input);
			do_misc_error (ret, menu_select);
			break;
		case MISC_HARD_MAIN:
			do_hardware_main(input, menu_select);
			break;
		case MISC_HARD_MAIN_SUBMIT:
			ret = do_hardware_main_submit(input);
			do_misc_error (ret, menu_select);
			break;	
		case MISC_UPDATE_MAIN:
			break;
		case MISC_UPDATE_MAIN_SUBMIT:
			break;	
		case MISC_LOGO_MAIN:
			do_logo_main(input, menu_select);
			break;
		case MISC_LOGO_MAIN_SUBMIT:
			ret = do_logo_main_submit(input);
			do_misc_error(ret, menu_select);
			break;	
		case MISC_TAPE_MAIN:
			break;
		case MISC_TAPE_MAIN_SUBMIT:
			break;			
					
		case MISC_SCHEDULE_MAIN:
			ret = do_schedule_main (input);
			do_misc_error (ret, menu_select);
			break;
		case MISC_SCHEDULE_MAIN_SUBMIT:
			ret = do_schedule_main_submit (input);
			do_misc_error(ret, menu_select);
			break;
		case MISC_SCHEDULE_NEW_SUBMIT:
			ret = do_schedule_new_submit (input);
			do_misc_error (ret, menu_select);
			break;
		case MISC_SCHEDULE_EDIT_SUBMIT:
			ret = do_schedule_edit_submit (input);
			do_misc_error (ret, menu_select);
			break;	
		case MISC_SR_MAIN:
			do_sr_main(input, menu_select);
			break;
		case MISC_SR_MAIN_SUBMIT:
			ret = do_sr_main_submit(input);
			do_misc_error (ret, menu_select);
			break;	
/*
		case MISC_RESET_MAIN:
			do_reset_main(input, menu_select);
			break;
*/
		case MISC_RESET_MAIN_SUBMIT:
			ret = do_reset_main_submit(input);
			do_misc_error (ret, menu_select);
			break;		
		case MISC_SR_RESTART_SUBMIT:
			ret = do_sr_restart_submit(input);
			do_misc_error (ret, menu_select);
			break;
		case MISC_BA_MAIN:
			ret = do_ba_main(input, menu_select);
			do_misc_error (ret, menu_select);
			break;
		case MISC_BA_SUBMIT_REMOVE:
			ret = do_ba_submit_remove(input, menu_select);
			do_misc_error (ret, menu_select);
			break;
		case MISC_BA_SUBMIT_INSTALL:	
			ret = do_ba_submit_install(input, menu_select);
			do_misc_error (ret, menu_select);
			break;
		case MISC_BA_SUBMIT_APPLY:
			ret = do_ba_submit_apply(input, menu_select);
			do_misc_error (ret, menu_select);
			break;
		case MISC_AUTO_BS_MAIN:
			ret = do_auto_bs_main(input, menu_select);
			do_misc_error (ret, menu_select);
			break;
		case MISC_AUTO_BS_APPLY:
			ret = do_bs_submit_apply(input, menu_select);
			do_misc_error (ret, menu_select);
			break;
		case MISC_RTRR_CLIENT_MAIN:
			ret = do_rtrrc_main(input);
			do_misc_error (ret, menu_select);
			break;
		case MISC_RTRR_SERVER_MAIN:
			ret = do_rtrrs_main(input);
			do_misc_error (ret, menu_select);
			break;
		case MISC_RTRR_SERVER_MAIN_SUBMIT:
			ret = do_rtrrs_main_submit(input);
			do_misc_error (ret, menu_select);
			break;
		case MISC_RTRR_SERVER_NEW_SUBMIT:
			ret = do_rtrrs_new_submit(input);
			do_misc_error (ret, menu_select);
			break;
		case MISC_RTRR_CLIENT_MAIN_SUBMIT:
			ret = do_rtrrc_main_submit(input);
			do_misc_error (ret, menu_select);
			break;
		case MISC_RTRR_CLIENT_NEW_SUBMIT:
			ret = do_rtrrc_new_submit(input);
			do_misc_error (ret, menu_select);
			break;
		case MISC_RTRR_CLIENT_EDIT_SUBMIT:
			ret = do_rtrrc_edit_submit(input);
			do_misc_error (ret, menu_select);
			break;
		case MISC_RTRR_SERVER_EDIT_SUBMIT:
			ret = do_rtrrs_edit_submit(input);
			do_misc_error (ret, menu_select);
			break;
		/*case MISC_DVD_BACKUP_MAIN:
			ret = do_dvd_backup_main(input, menu_select);
			break;
		case MISC_DVD_BACKUP_MAIN_SUBMIT:
			ret = do_dvd_backup_main_submit(input, menu_select);
			do_misc_error (ret, menu_select);*/
	}
	CGI_Free_Input(input);
	return MISC_SUCCESS;
}
