#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <dirent.h>
#include <time.h>
#include <cgi.h>
#include <cfg_backup.h>
#include <cfg_tape.h>
#include <cfg_ups.h>
#include <cfg_backup_agent.h>
#include <v2_menu.h>
#include <NAS.h>
#include <backup.h>
#include "misc.h"
#include "backup_agent.h"
#define JS(ID) "<SCRIPT Language=\"JavaScript\">document.write(" #ID ")</SCRIPT>" 



int ba_replace(FILE* fp, char* str, void* arg)
{
	if (!strcasecmp(str, "Agent_Type"))
	{
		if ( BA_Is_Agent_Exist() ) {
			switch (BA_Get_Agent_Type()) {
			case	AGENT_NETVAULT:
				fprintf(fp, "NetVault ");
				fprintf(fp, "%s", BA_Get_Agent_Version());
				break;
			case	AGENT_VERITAS:
				fprintf(fp, "Veritas");
				fprintf(fp, "%s", BA_Get_Agent_Version());
				break;
			case	AGENT_NONE:
			default:
				fprintf(fp, JS(MISC_BA_STR09));
			}
		} else {
			fprintf(fp, JS(MISC_BA_STR09));
		}
	}
	else
	if (!strcasecmp(str, "BA_checked"))
	{
		if (BA_Get_Backup_Agent_Enable())
			fprintf(fp, "checked");
	}
	else
	if (!strcasecmp(str, "BA_enabled"))
	{
		if ( !BA_Is_Agent_Exist() )
			fprintf(fp, "disabled");
	}
	else
	if (!strcasecmp(str, "BA_passwd_enabled"))
	{
		if (!BA_Is_Agent_Exist())
			fprintf(fp, "disabled");
	}
	else
	if (!strcasecmp(str, "BA_status"))
	{
		if (BA_Is_Agent_Exist()) {
			if (BA_Is_Agent_Run())
				fprintf(fp, "MISC_BA_STR07");
			else
				fprintf(fp, "MISC_BA_STR08");
		} else {
			fprintf(fp, "MISC_BA_STR09");
		}
	}
	else
	if (!strcasecmp(str, "BA_installed"))
	{
		if (BA_Is_Agent_Exist())
			fprintf(fp, "1");
		else
			fprintf(fp, "0");
	}
	else
		return CGI_REPLACE_FAIL;
        return CGI_REPLACE_OK;
}

char *create_install_directory(int *hd_init_flag)
{
	static char update_dir[BUF_SIZE];
	char buf[BUF_SIZE];
	int hd_size;
	char dev[256];
	int drive_cnt, i, find=0;
	int g_update_hd;
	char tmp_path[]={"/mnt/HDA_ROOT"};

	g_update_hd = -1;
	drive_cnt=Get_Profile_Integer("Storage","Disk Drive Number",0);
	for (i=0;i<drive_cnt;i++)
	{
		Get_HD_DevName(i+1, dev);
		hd_size=Get_Dev_Blksize(dev);
		if (Is_HD_Ready(i+1) && hd_size>64000) // 64000 is about 32MB
		{
			g_update_hd = i;
			find=1;
			break;
		}
	}
	
	if (find)
	{
		*hd_init_flag = 1;
	        tmp_path[7]='A'+g_update_hd;
		sprintf(buf, "/bin/mkdir %s", tmp_path);
		system(buf);
	}

	strcpy(update_dir, tmp_path);
	return update_dir;
}

int upload_file_and_install()
{
	char *install_dir = NULL;
	char src_name[267]={'\0'}, full_path_filename[256]={'\0'};
	int  ret = 0;
	int  hd_init_flag;
	char version[80], model[80], tmpstr[1024];

	//memset(src_name, '\0', sizeof(src_name));
	if ((install_dir = create_install_directory(&hd_init_flag)) == NULL) {
		return MISC_BA_DISK_NOT_READY;
	}
	strcpy(full_path_filename, install_dir);
//printf("AAA full_path_filename=%s, %s:%d<br>\n", full_path_filename, __FILE__, __LINE__);
	if( (ret=CGI_Upload(full_path_filename, NULL, src_name)) == CGI_SUCCESS ) {
		if(!hd_init_flag) {
			ret=MISC_BA_DISK_NOT_READY;
			goto install_fail;
		}

		if (BA_Is_Agent_Exist()) {
			ret=MISC_BA_AGENT_EXIST;
			goto install_fail;
		}

		strcat(full_path_filename, "/");
		strcat(full_path_filename, src_name);
		chmod(full_path_filename, S_IRWXU | S_IRWXG | S_IROTH);
		ret = BA_Extract_Backup_Agent_Info(full_path_filename, model, version);
		if (ret==AGENT_NONE) {
			ret=MISC_BA_SOFTWARE_ERROR;
			goto install_fail;
		}
		BA_Extract_Backup_Agent(full_path_filename);
		BA_Set_Backup_Agent_To_uLinux(full_path_filename, model, version);

		sprintf(tmpstr, "/sbin/write_log \"Backup Agent %s %s was installed successfully\" 4 2>/dev/null 1>/dev/null", model, version);
		system(tmpstr);
		return MISC_SUCCESS;
	}
	else {
		ret=MISC_BA_DISK_NOT_READY;
		goto install_fail;
	}
	
install_fail:
	sprintf(tmpstr, "/bin/rm -f %s", full_path_filename);
	system(tmpstr);
	return ret;
}


int do_ba_main(INPUT* input, int select)
{
	show_misc_header(input, select);	
	CGI_Output_Html1(BACKUP_AGENT_MAIN_HTML, "$", ba_replace, (void *)input);
	show_misc_tail();
	return MISC_SUCCESS;
}

int do_ba_submit_remove(INPUT* input, int select)
{
	char	tmpstr[256];
	if (BA_Is_Agent_Exist()) {
		BA_Enable_Backup_Agent(0);
		if(BA_Remove_Agent()){
			sprintf(tmpstr, "/sbin/write_log \"Backup Agent was removed successfully\" 4 2>/dev/null 1>/dev/null");
			system(tmpstr);
			show_misc_header(input, select);	
			CGI_Output_Html1(BACKUP_AGENT_MAIN_HTML, "$", ba_replace, (void *)input);
			show_misc_tail();
		}
	}
	else {
		return MISC_BA_AGENT_NOT_EXIST;
	}

	return MISC_SUCCESS;
}

int do_ba_submit_install(INPUT* input, int select)
{
	int	ret;

	ret=upload_file_and_install();
	if (ret==MISC_SUCCESS) {
		show_misc_header(input, select);	
		CGI_Output_Html1(BACKUP_AGENT_MAIN_HTML, "$", ba_replace, (void *)input);
		show_misc_tail();
	} else {
		return ret;
	}

	return MISC_SUCCESS;
}

int do_ba_submit_apply(INPUT* input, int select)
{
	INPUT	*parm;
	int	counter=0;
	char	buf[256]={""};
	
	if (!BA_Is_Agent_Exist()) {
		return MISC_BA_AGENT_NOT_EXIST;
	}

	parm=CGI_Find_Parameter(input, "BA_checkbox");
	if( parm && !strcasecmp(parm->val, "on") ) {


		parm=CGI_Find_Parameter(input, "BA_passwd");
		if ( parm && (parm->val)[0]!='\0' ) {
			pid_t	pid;

			BA_Set_Backup_Agent_Password(parm->val);

			pid=fork();			
   			if (pid < 0)
	        		exit(EXIT_FAILURE);		//error
       
			if (pid == 0) { //child 
				close(0);
				close(1);
				close(2);					
				BA_Enable_Backup_Agent(1);
				exit(0);			
			}	
		}
		else
			return MISC_BA_NULL_PASSWORD;
	} else {
		BA_Enable_Backup_Agent(0);
	}

	sleep(1);
	counter=time(NULL);
	sprintf(buf, "/cgi-bin/misc/misc.cgi?func=ba_main&counter=%d", counter);
	CGI_Load_Html(buf);

	return MISC_SUCCESS;
}
