#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <dirent.h>
#include <time.h>
#include <cgi.h>
#ifdef __RTRR_SUPPORT__
#include <cfg_backup.h>
#else
#include <cfg_rsync.h>
#endif
#include <cfg_tape.h>
#include <cfg_ups.h>
#include <v2_menu.h>
#include <NAS.h>
#include <backup.h>
#include "misc.h"
#include "backup.h"
#include <cfg_rtrr.h>

#define OUTPUT_TEST_REMOTE_FIELD(i, s) ((tmp = CGI_Find_Parameter(i, s)))?fprintf(fp, "%s", tmp->val):fprintf(fp, "%s", "");

//char *szDefineFilePath[] = {"/home/httpd/cgi-bin/misc/misc.notapeups.def",
//			    "/home/httpd/cgi-bin/misc/misc.def"


#define __dbg(format, arg...)            \
        do {\
	        FILE *fp; \
		printf(format , ## arg); \
	        fp = fopen("/debug","a+"); \
	        fprintf(fp, format , ## arg); \
	        fclose(fp); \
	} while (0);


char *szDefineFilePath[] = {MISC_DEF};

char	rsync_cmd[]={"/usr/bin/rsync"};
char	cifsmount[]={"/usr/bin/smbmount"};
char	cifsumount[]={"/bin/umount"};
int g_def_type = 0;//globe 


int create_dir(char *dirname)
{
	DIR	*dir;
	int	ret=0;

	if ((dir=opendir(dirname))==NULL)
	{
		ret=mkdir(dirname, S_IRWXU | S_IRWXG | S_IRWXO);
		if (ret==0)
			ret=chmod(dirname, S_IRWXU | S_IRWXG | S_IRWXO);
	}
	else
	{
		closedir(dir);
		ret=chmod(dirname, S_IRWXU | S_IRWXG | S_IRWXO);
	}
	return ret;
}

BOOL Is_Snapshot_Support()
{
	char buf[20];

	GetProfileString("Storage", "Snapshot Support", "FALSE", buf, sizeof(buf));//Shone modified "TRUE" to "FALSE" 2005,07,29
	return NOT_FALSE(buf);
}

char* parser_schedule(char* dest, const char* src, int pos)
{
	static	char	ptr[256];
	int	i = 0, j = 0;
	int	Cfind=0; 

	strcpy(dest, src);
	bzero(ptr, 256);
	
	for (i = 0; i < strlen(src); i++) {
		if ( src[i] == ':' ) {
			Cfind++;
		} else {
			if ( Cfind == pos )
				ptr[j++] = src[i];
		}
	}
	return ptr;
}

int backup_immediate_execute()
{
	BACKUP_SCHEDULE* s = NULL , *tmp = NULL;
#ifdef __RTRR_SUPPORT__
	s = Backup_Get_Schedule();
#else
  #ifdef __QNAP_RSYNC_RR__ 
	s = rsync_Get_Schedule();
  #else
	s = rsync_Get_Schedule();
  #endif
#endif
	if (s==NULL)
		return 0;
	tmp = s;	
	while(tmp!=NULL){
		if (tmp->t_type == BK_IMMEDIATELY && tmp->status == BK_ACTION ){
#ifdef __RTRR_SUPPORT__
			rsync_Free_Schedule(s);
#else
  #ifdef __QNAP_RSYNC_RR__
			rsync_Free_Schedule(s);
  #else
			Backup_Free_Schedule(s);
  #endif
#endif
			return 1;
		}	
		tmp = (BACKUP_SCHEDULE*)tmp->next;
	}
#ifdef __RTRR_SUPPORT__
	rsync_Free_Schedule(s);
#else
  #ifdef __QNAP_RSYNC_RR__
	rsync_Free_Schedule(s);
  #else
	Backup_Free_Schedule(s);
  #endif
#endif
	return 0;		
	
}	
	
int del_schedule(INPUT* checkbox)
{
	BACKUP_SCHEDULE sch;
	INPUT* tmp = NULL;
	char dest[254]={""};
	bzero(&sch, sizeof(BACKUP_SCHEDULE));
	tmp = checkbox;
	while(tmp!=NULL){
		strcpy(sch.name, parser_schedule(dest, tmp->val, 0));
#ifdef __RTRR_SUPPORT__
		rsync_Del_Schedule(&sch);
#else
  #ifdef __QNAP_RSYNC_RR__
		rsync_Del_Schedule(&sch);
  #else
		Backup_Del_Schedule(&sch);
  #endif
#endif
		tmp = (INPUT*)tmp->next;
	}
	return MISC_SUCCESS;	
}
	

int schedule_replace(FILE* fp, char* str, void* arg)
{
	SECTION_INFO *vol = NULL;
	BACKUP_SCHEDULE* sch = NULL;
	INPUT* tmp=NULL, *input=NULL; //*tmp1=NULL;
	int num, i, dm=0, type;
	char buf[1024]={""},selected[15]={""}, *ptr = NULL;

	/*if (!strcmp(str, "refresh_html")){
		tmp = (INPUT*)arg;
		if (CGI_Find_Parameter(tmp, "CANCEL"))
		 	fprintf(fp, "%s", "");		 	
		else if (backup_immediate_execute()){			
			tmp1 = CGI_Find_Parameter(tmp, "count");			
			fprintf(fp,"<meta http-equiv=\"refresh\" content=\"5;url=/cgi-bin/misc/misc.cgi?func=schedule_status&count=%ld&refresh=YES\">\n", atol(tmp->val));
		}	
	}*/
	if (!strcasecmp(str, "TAB_CAPTION")){
		if ( is_rtrr_support() )
			fprintf(fp, "MISC_RTRR_STR36");
		else
			fprintf(fp, "IEI_NAS_STORAGE106");	
	}		
	else if (!strcasecmp(str, "RTRR_TABS")){
		if ( is_rtrr_support() ) {
			fprintf(fp, "                <td width=\"150\">                                                                                                                                                                         ");
			fprintf(fp, "                  <table width=\"150\" border=\"0\" cellpadding=\"5\" cellspacing=\"0\" class=\"Tab-2\" onClick=\"MM_goToURL('parent','/cgi-bin/misc/misc.cgi?func=rtrr_main&counter=%lu');\">       ", time(NULL));
			fprintf(fp, "                    <tr onMouseOver=\"this.style.backgroundColor='#cccccc';this.style.cursor='hand';\" onMouseOut=\"this.style.backgroundColor='#eeeeee';\">                                               ");
			fprintf(fp, "                      <td>                                                                                                                                                                                 ");
			fprintf(fp, "                        <font color=\"#666666\"><SCRIPT Language=\"JavaScript\">document.write(MISC_RTRR_STR01)</SCRIPT></font>                                                                            ");
			fprintf(fp, "                      </td>                                                                                                                                                                                ");
			fprintf(fp, "                    </tr>                                                                                                                                                                                  ");
			fprintf(fp, "                  </table>                                                                                                                                                                                 ");
			fprintf(fp, "                </td>                                                                                                                                                                                      ");
			fprintf(fp, "                <td width=\"150\">                                                                                                                                                                         ");
			fprintf(fp, "                  <table width=\"150\" border=\"0\" cellpadding=\"5\" cellspacing=\"0\" class=\"Tab-2\" onClick=\"MM_goToURL('parent','/cgi-bin/misc/misc.cgi?func=rtrr_server_main&counter=%lu');\">", time(NULL));
			fprintf(fp, "                    <tr onMouseOver=\"this.style.backgroundColor='#cccccc';this.style.cursor='hand';\" onMouseOut=\"this.style.backgroundColor='#eeeeee';\">                                               ");
			fprintf(fp, "                      <td>                                                                                                                                                                                 ");
			fprintf(fp, "                        <font color=\"#666666\"><SCRIPT Language=\"JavaScript\">document.write(MISC_RTRR_STR02)</SCRIPT></font>                                                                            ");
			fprintf(fp, "                      </td>                                                                                                                                                                                ");
			fprintf(fp, "                    </tr>                                                                                                                                                                                  ");
			fprintf(fp, "                  </table>                                                                                                                                                                                 ");
			fprintf(fp, "                </td>                                                                                                                                                                                      ");
		}	
	}		
	else if (!strcasecmp(str, "ON_LOAD")){
		num = *(int*)arg;
		if (num == USE_SHEDULE_NEW_ONLOAD || num == USE_SHEDULE_EDIT_ONLOAD)
			fprintf(fp, "init();");
		else
			fprintf(fp, "%s", "");	
	}		
	else if ( !strcmp(str, "refresh_page") ) {
		if ( need_refresh == 1 ) {
			fprintf(fp, "<meta http-equiv=\"refresh\" content=\"0; url=misc.cgi?func=schedule_main&count=%lu\">", time(NULL));
		}
		need_refresh = 0;
	}
	else if (!strcmp(str, "VOL")){
		
		num = Get_NAS_Share_List_Ex(&vol);
		for (i = 0; i<num; i++)
			fprintf(fp,"<option value=\"%s\">%s</option>", (vol+i)->section_name, (vol+i)->section_name);
		if (vol != NULL)
			Release_List(vol);		
	}	
	else if (!strcmp(str, "b_VOL")){
		tmp = (INPUT*)arg;
		ptr = parser_schedule(buf, tmp->val, 3);
		num = Get_NAS_Share_List_Ex(&vol);
		for (i = 0; i<num; i++)
			if (!strcasecmp((vol+i)->section_name, ptr))
				fprintf(fp,"<option value=\"%s\" selected>%s</option>", (vol+i)->section_name, (vol+i)->section_name);
			else
				fprintf(fp,"<option value=\"%s\">%s</option>", (vol+i)->section_name, (vol+i)->section_name);
		if (vol != NULL)
			Release_List(vol);		
	}	
	else if (!strcmp(str, "test_status")){
		char server[BUF_SIZE]={""};
		char username[32],passwd[16],vol[64],cmd[2048],mp[64],path[MAX_PATH];
		input = (INPUT*)arg;
		if ((tmp = CGI_Find_Parameter(input, "test")) != NULL){
			if ((tmp = CGI_Find_Parameter(input, "SMB_LOCATION")) != NULL){
// 2005.11.30, Johnson Cheng
// Never need rsync_Get_Server() and Backup_Get_Server() because of no nasrpc
/*#ifdef __RTRR_SUPPORT__
				if (0 == rsync_Get_Server(server, BUF_SIZE, tmp->val))
#else
  #ifdef __QNAP_RSYNC_RR__
				if (0 == rsync_Get_Server(server, BUF_SIZE, tmp->val))
  #else
				if (0 == Backup_Get_Server(server, BUF_SIZE, tmp->val))
  #endif
#endif
					fprintf(fp, "MISC_SCH_NEW_STR60");
				else{*/
					strcpy(server, tmp->val);
					sprintf(mp, "/mnt/%d", getpid());
					create_dir(mp);
					tmp = CGI_Find_Parameter(input, "REMOTE_VOL");
					strcpy(vol, tmp->val);
					tmp = CGI_Find_Parameter(input, "REMOTE_PATH");
					if (tmp->val[0] != '/' && strlen(tmp->val) != 0 )
						sprintf(path, "/%s", tmp->val);
					else	
						strcpy(path, tmp->val);
				
					sprintf(cmd, "%s --dry-run --check-dest %s::\"%s\" > /dev/null 2>&1", rsync_cmd, server, vol);
					if(0 != system(cmd)) {
						fprintf(fp, "MISC_SCH_NEW_STR61");
					}
					else {
					    tmp = CGI_Find_Parameter(input, "SMB_USERNAME");
					    strcpy(username, tmp->val);
					    tmp = CGI_Find_Parameter(input, "SMB_PASSWD");
					    strcpy(passwd, tmp->val);
					    sprintf(cmd, "%s \"//%s/%s\" %s -o lfs,username=\"%s\",password=\"%s\" 2>/dev/null 1>/dev/null",
					              cifsmount, 
					              server,
					              vol,
					              mp,
					              username,
					              passwd);
					    if ( 0 != system(cmd)){     
						rmdir(mp);        
						fprintf(fp, "MISC_SCH_NEW_STR62");
					    }	
					    else{
						sprintf(cmd, "%s%s", mp, path);
						if (!Is_Existing_Directory(cmd)){
							sprintf(cmd, "%s -f \"%s\" 2>/dev/null 1>/dev/null", cifsumount, mp);
							if (system(cmd)==0)
								rmdir(mp);
							fprintf(fp, "MISC_SCH_NEW_STR61");	
						}
						else{
							sleep(1);
							sprintf(cmd, "%s -f \"%s\" 2>/dev/null 1>/dev/null", cifsumount, mp);
							if (system(cmd)==0)
								rmdir(mp);
							fprintf(fp, "MISC_SCH_NEW_STR59");
						}
					    }
					}		
				//}	
			}	
		}
		else
			fprintf(fp, "\'--\'");	
	}	
	else if (!strcmp(str, "HOUR")){
		for (i = 0; i<24; i++ ){
			(i < 10) ? fprintf(fp, "<option value=\"%d\">0%d</option>", i, i)
			:fprintf(fp, "<option value=\"%d\">%d</option>", i, i);												
		}	
		
	}
	else if (!strcmp(str, "MIN")){
		for (i = 0; i<60; i++ ){
			(i < 10) ? fprintf(fp, "<option value=\"%d\">0%d</option>", i, i):fprintf(fp, "<option value=\"%d\">%d</option>", i, i);	
		}	
	}	
	else if (!strcmp(str, "DAY")){
		for (i = 1; i<32; i++ ){
			(i < 10) ? fprintf(fp, "<option value=\"%d\">0%d</option>", i, i):fprintf(fp, "<option value=\"%d\">%d</option>", i, i);	
		}	
	}
	else if (!strcmp(str, "START_SNAPSHOT_COMMENT")){
		if ( !Is_Snapshot_Support() )
			fprintf(fp, "<!--");
	}
	else if (!strcmp(str, "END_SNAPSHOT_COMMENT")){
		if ( !Is_Snapshot_Support() )
			fprintf(fp, "-->");
	}
	else if (!strcmp(str, "START_SNAPSHOT_JS_COMMENT")){
		if ( !Is_Snapshot_Support() )
			fprintf(fp, "/*");
	}
	else if (!strcmp(str, "END_SNAPSHOT_JS_COMMENT")){
		if ( !Is_Snapshot_Support() )
			fprintf(fp, "*/");
	}
	else if (!strcmp(str, "schedule_name")){
		sch = (BACKUP_SCHEDULE*)arg;
		fprintf(fp, "%s", sch->name);
	}
	else if (!strcmp(str, "schedule_policy")){
		sch = (BACKUP_SCHEDULE*)arg;
		switch(sch->policy){
			case BACKUP_GET:
				fprintf(fp, "GET");
				break;
			case BACKUP_PUT:
				fprintf(fp, "PUT");
				break;									
		}		
	}	
	else if (!strcmp(str, "schedule_usage")){
		sch = (BACKUP_SCHEDULE*)arg;
		switch(sch->usage){
#ifdef __RTRR_SUPPORT__
			case BK_VIA_RSYNC:
#endif
#ifdef __QNAP_RSYNC_RR__
                        case BK_VIA_RSYNC:
#endif
			case BK_VIA_CIFS:
				fprintf(fp, "MISC_SCH_NEW_STR06");
				break;
			case BK_VIA_FTP:
				fprintf(fp, "MISC_SCH_NEW_STR07");
				break;
			case BK_VIA_NFS:
				fprintf(fp, "MISC_SCH_NEW_STR08");
				break;			
		}	
	}	
	else if (!strcmp(str, "schedule_compress")){
		sch = (BACKUP_SCHEDULE*)arg;
		switch(sch->bcompress){
			case 1:
				fprintf(fp, "MISC_SCH_MAIN_STR01");
				break;
			case 0:
				fprintf(fp, "MISC_SCH_MAIN_STR02");
				break;				
		}	
	}	
	else if (!strcmp(str, "SCHEDULE_CHECKBOX")){
		sch = (BACKUP_SCHEDULE*)arg;
		switch(sch->t_type){
			case BK_WEEK:
				dm = sch->week;
				break;
			case BK_MONTH:	
				dm = sch->month;
				break;
		}
#ifdef	__SNAPSHOT__
		fprintf(fp, "%s:%d:%d:%s:%s:%s:%s:%d:%d:%d:%d:%d:%s:%s:%d:%d:%d:%d",
			 sch->name, 
			 sch->bk_pid,  //used to be sch->policy, now sch->bk_pid
			 0, //sch->bcompress, 			 
			 sch->local.volume,
			 sch->local.path,
			 sch->remote.volume, 
			 sch->remote.path,
			 sch->t_hour,
			 sch->t_min,		
			 sch->t_type,
			 dm,
			 sch->usage,
			 sch->cifs.server.location,
			 sch->cifs.user.name,
			 0, //sch->bk_pid,
			 sch->status,
			 sch->option,
			 sch->rr_from_snapshot);

#else
		fprintf(fp, "%s:%d:%d:%s:%s:%s:%s:%d:%d:%d:%d:%d:%s:%s:%d:%d:%d",
			 sch->name, 
			 sch->bk_pid,  //used to be sch->policy, now sch->bk_pid
			 0, //sch->bcompress, 			 
			 sch->local.volume,
			 sch->local.path,
			 sch->remote.volume, 
			 sch->remote.path,
			 sch->t_hour,
			 sch->t_min,		
			 sch->t_type,
			 dm,
			 sch->usage,
			 sch->cifs.server.location,
			 sch->cifs.user.name,			 
			 0, //sch->bk_pid,
			 sch->status,
			 sch->option);
#endif
	}
	
	else if (!strcmp(str, "old_schedule")){
		tmp = (INPUT*)arg;
		fprintf(fp, "%s", tmp->val);
	}
	//add 2002/08/29
	else if (!strcmp(str, "backup_name")){
		char* ptr=NULL;
		input = (INPUT*)arg;
		ptr = parser_schedule(buf, input->val, 0);
		((tmp = CGI_Find_Parameter(input, "NAME")))?fprintf(fp, "%s", tmp->val):
			fprintf(fp, "%s", ptr);
	}
	
	else if (!strcmp(str, "a_backup_name")){
		input = (INPUT*)arg;
		OUTPUT_TEST_REMOTE_FIELD(input, "NAME");	
	}
	//
	/*else if (!strcmp(str, "p_get") || !strcmp(str, "p_put")){
		tmp = (INPUT*)arg;
		i = atoi(parser_schedule(buf, tmp->val, 1));
		
		if (!strcmp(str, "p_get") && i == BACKUP_GET)
			fprintf(fp, "selected");
		else if (!strcmp(str, "p_put") && i == BACKUP_PUT)
			fprintf(fp, "selected");
		
	}				
	else if (!strcmp(str, "com_checked")){
		tmp = (INPUT*)arg;
		i = atoi(parser_schedule(buf, tmp->val, 2));
		(i == 1) ? fprintf(fp, "checked"):fprintf(fp, "%s", "");
	}*/
	
	else if (!strcmp(str, "local_path")){
		char *ptr=NULL;
		tmp = (INPUT*)arg;
		ptr = parser_schedule(buf, tmp->val, 4);			
		if (strlen(ptr) == 1 && ptr[0] == '/')
			fprintf(fp, "%s", "");
		else	{
			ptr++;
			fprintf(fp, "%s", ptr);
		}	
			
	}	
	else if (!strcmp(str, "a_remote_vol")){		
		input = (INPUT*)arg;
		OUTPUT_TEST_REMOTE_FIELD(input, "REMOTE_VOL");		
	}
	else if (!strcmp(str, "a_remote_path")){		
		input = (INPUT*)arg;
		OUTPUT_TEST_REMOTE_FIELD(input, "REMOTE_PATH");				
	}		
	else if (!strcmp(str, "remote_vol")){
		char* ptr=NULL;
		input = (INPUT*)arg;
		ptr = parser_schedule(buf, input->val, 5);
		((tmp = CGI_Find_Parameter(input, "REMOTE_VOL")))?fprintf(fp, "%s", tmp->val):
			fprintf(fp, "%s", ptr);
	}			
	else if (!strcmp(str, "remote_path")){
		char* ptr=NULL;
		input = (INPUT*)arg;
		ptr = parser_schedule(buf, input->val, 6);
		if((tmp = CGI_Find_Parameter(input, "REMOTE_PATH")))
			fprintf(fp, "%s", tmp->val);
		else{	
			if (strlen(ptr) == 1 && ptr[0] == '/')
				fprintf(fp, "%s", "");
			else	{
				ptr++;
				fprintf(fp, "%s", ptr);
			}	
		}	
	}	
	else if (!strcmp(str, "E_HOUR")){
		
		tmp = (INPUT*)arg;
		dm = atoi(parser_schedule(buf, tmp->val, 7));
		
		for (i = 0; i<24; i++ ){
			
			if (i == dm) sprintf(selected, "%s", "selected");
			else	sprintf(selected, "%s", "");
			(i < 10) ? fprintf(fp, "<option value=\"%d\" %s>0%d</option>", i,selected, i)
			:fprintf(fp, "<option value=\"%d\" %s>%d</option>", i, selected, i);
		}
	}
	else if (!strcmp(str, "E_MIN")){
		
		tmp = (INPUT*)arg;
		dm = atoi(parser_schedule(buf, tmp->val, 8));
		for (i = 0; i<60; i++ ){
			if (i == dm) sprintf(selected, "%s", "selected");
			else	sprintf(selected, "%s", "");
			(i < 10) ? fprintf(fp, "<option value=\"%d\" %s>0%d</option>", i, selected, i)
			:fprintf(fp, "<option value=\"%d\" %s>%d</option>", i, selected, i);												
		}
	}	
	else if (!strcmp(str, "E_DAY")){
		
		tmp = (INPUT*)arg;
		type = atoi(parser_schedule(buf, tmp->val, 9));
		dm = atoi(parser_schedule(buf, tmp->val, 10));
		for (i = 1; i<32; i++ ){
			if (i == dm && type == BK_MONTH) sprintf(selected, "%s", "selected");
			else	sprintf(selected, "%s", "");
			(i < 10) ? fprintf(fp, "<option value=\"%d\" %s>0%d</option>", i, selected, i)
			:fprintf(fp, "<option value=\"%d\" %s>%d</option>", i, selected, i);												
		}
		
	}	
	else if (!strcmp(str, "week_checked") || !strcmp(str, "month_checked") || 
	 	 !strcmp(str, "immediate_checked") || !strcmp(str, "day_checked")){
		tmp = (INPUT*)arg;
		type = atoi(parser_schedule(buf, tmp->val, 9));
		
		if (!strcmp(str, "week_checked") && type == BK_WEEK)
			fprintf(fp, "checked");
		else if (!strcmp(str, "month_checked") && type == BK_MONTH)
			fprintf(fp, "checked");
		else if (!strcmp(str, "day_checked") && type == BK_DAY)
			fprintf(fp, "checked");
		else if (!strcmp(str, "immediate_checked")) {
			if ( type == BK_IMMEDIATELY )
				fprintf(fp, "checked");
			//else
			//	fprintf(fp, "disabled");
		}
	}
	else if (!strcmp(str, "week_selected1") || !strcmp(str, "week_selected2") || 
		 !strcmp(str, "week_selected3") || !strcmp(str, "week_selected4") ||
		 !strcmp(str, "week_selected5") || !strcmp(str, "week_selected6") ||
		 !strcmp(str, "week_selected7")){
		tmp = (INPUT*)arg;
		if(BK_WEEK == atoi(parser_schedule(buf, tmp->val, 9))){
			type = atoi(parser_schedule(buf, tmp->val, 10));
			if (!strcmp(str, "week_selected1") && type == 1)
				fprintf(fp, "selected");
			else if (!strcmp(str, "week_selected2") && type == 2)
				fprintf(fp, "selected");	
			else if (!strcmp(str, "week_selected3") && type == 3)
				fprintf(fp, "selected");
			else if (!strcmp(str, "week_selected4") && type == 4)
				fprintf(fp, "selected");	
			else if (!strcmp(str, "week_selected5") && type == 5)
				fprintf(fp, "selected");
			else if (!strcmp(str, "week_selected6") && type == 6)
				fprintf(fp, "selected");	
			else if (!strcmp(str, "week_selected7") && type == 7)
				fprintf(fp, "selected");			
		}
		else
			fprintf(fp, "%s", "");	
		
	}
	/*else if (!strcmp(str, "radio_smb") || !strcmp(str, "radio_ftp") || !strcmp(str, "radio_nfs")){
		tmp = (INPUT*)arg;
		type = atoi(parser_schedule(buf, tmp->val, 11));
		if (!strcmp(str, "radio_smb") && type == BK_VIA_CIFS)
			fprintf(fp, "checked");
		else if (!strcmp(str, "radio_ftp") && type == BK_VIA_FTP)	
			fprintf(fp, "checked");		
		else if (!strcmp(str, "radio_nfs") && type == BK_VIA_NFS)	
			fprintf(fp, "checked");			
		else
			fprintf(fp, "%s", "");	
	}	*/
	else if (!strcmp(str, "a_smb_server")){		
		input = (INPUT*)arg;
		OUTPUT_TEST_REMOTE_FIELD(input, "SMB_LOCATION");		
	}
	else if (!strcmp(str, "a_smb_user")){		
		input = (INPUT*)arg;
		OUTPUT_TEST_REMOTE_FIELD(input, "SMB_USERNAME");		
	}	
	else if (!strcmp(str, "smb_server") || !strcmp(str, "smb_user")){
		char* ptr=NULL;
		input = (INPUT*)arg;
		type = atoi(parser_schedule(buf, input->val, 11));
#ifdef __RTRR_SUPPORT__
		if ( !strcmp(str, "smb_server") && (type == BK_VIA_CIFS || type == BK_VIA_RSYNC) ){
#else
#ifdef __QNAP_RSYNC_RR__
		if ( !strcmp(str, "smb_server") && (type == BK_VIA_CIFS || type == BK_VIA_RSYNC) ){
#else
		if (!strcmp(str, "smb_server") && type == BK_VIA_CIFS){
#endif
#endif
			ptr = parser_schedule(buf, input->val, 12);
			((tmp = CGI_Find_Parameter(input, "SMB_LOCATION")))?fprintf(fp, "%s", tmp->val):
			fprintf(fp, "%s", ptr);
		}	
#ifdef __RTRR_SUPPORT__
		else if ( !strcmp(str, "smb_user") && (type == BK_VIA_CIFS || type == BK_VIA_RSYNC) ){
#else
#ifdef  __QNAP_RSYNC_RR__
		else if ( !strcmp(str, "smb_user") && (type == BK_VIA_CIFS || type == BK_VIA_RSYNC) ){
#else
		else if (!strcmp(str, "smb_user") && type == BK_VIA_CIFS){
#endif
#endif
			ptr = parser_schedule(buf, input->val, 13);
			((tmp = CGI_Find_Parameter(input, "SMB_USERNAME")))?fprintf(fp, "%s", tmp->val):
			fprintf(fp, "%s", (ptr)?ptr:"");
		}	
						
	}
	else if (!strcmp(str, "service_compress")) {
		tmp=(INPUT *)arg;
		type=atoi(parser_schedule(buf, tmp->val, 16));
		if (type & BACKUP_COPY_COMPRESS)
			fprintf(fp, "checked");
	}
	else if (!strcmp(str, "service_checked") || !strcmp(str, "imcremental_copy_checked") ||
		 !strcmp(str, "remove_file_checked")){
		 tmp = (INPUT*)arg;
		 type = atoi(parser_schedule(buf, tmp->val, 16));
		 if (!strcmp(str, "service_checked") && (type & BACKUP_COPY_STOP_SERVICE))
		 	fprintf(fp, "checked");
		 else if (!strcmp(str, "imcremental_copy_checked") && (type & BACKUP_COPY_TIMESTAMP))
		 	fprintf(fp, "checked");
		 else if (!strcmp(str, "remove_file_checked") && (type & BACKUP_COPY_SYNC))
		 	fprintf(fp, "checked");				 		
	}		
	else if (!strcmp(str, "schedule_type")){
		sch = (BACKUP_SCHEDULE*)arg;
		if (sch == NULL)
			fprintf(fp,"\'&nbsp;\'");
		else {
			switch(sch->t_type){
				case BK_IMMEDIATELY:
					fprintf(fp, "MISC_SCH_NEW_STR27");
					break;
				case BK_DAY:
					fprintf(fp, "MISC_SCH_NEW_STR29");					
					break;
				case BK_WEEK:
					fprintf(fp, "MISC_SCH_NEW_STR18");
					break;
				case BK_MONTH:
					fprintf(fp, "MISC_SCH_NEW_STR19");
					break;
			}	
			
		}	
	}
	else if (!strcmp(str, "schedule_time")){
		struct tm *t;
		sch = (BACKUP_SCHEDULE*)arg;		
		
		if (sch == NULL)
			fprintf(fp, "\'&nbsp;\'");
		else {
			switch(sch->t_type){
				case BK_IMMEDIATELY:
					t = localtime(&sch->latest_time);
					if ((sch->t_hour == 0 && sch->t_min == 0) && (t->tm_hour != 0 || t->tm_min != 0) ) {
						fprintf(fp, "\'%02d:%02d - \'+MISC_SCH_NEW_STR27",t->tm_hour, t->tm_min);
					} else {
						fprintf(fp, "\'%02d:%02d - \'+MISC_SCH_NEW_STR27", sch->t_hour, sch->t_min);
					}
					break;
				case BK_DAY:
					fprintf(fp, "\'%02d:%02d - \'+MISC_SCH_NEW_STR29", sch->t_hour, sch->t_min);
					break;
				case BK_WEEK:
					fprintf(fp, "\'%02d:%02d - \'+MISC_SCH_NEW_STR18+\':\'+MISC_SCH_NEW_STR%d", sch->t_hour, sch->t_min, sch->week+19);
					break;
				case BK_MONTH:
					fprintf(fp, "\'%02d:%02d - \'+MISC_SCH_NEW_STR19+\':\'+\'%d\'",sch->t_hour, sch->t_min, sch->month);	
					break;
			}	
		}		
	}	
	else if (!strcmp(str, "status")){		
		sch = (BACKUP_SCHEDULE*)arg;
		if (sch == NULL)
			fprintf(fp,"\'&nbsp;\'");
		else {
			switch(sch->status){
				case BK_NOW:
				case BK_ACTION:
					fprintf(fp, "MISC_SCH_NEW_STR31");
					break;
				case BK_NONE_ACTION:
					if (sch->latest_time == (time_t)0)
						fprintf(fp, "MISC_SCH_NEW_STR30");
					else{
						struct tm *t;
						t = localtime(&sch->latest_time);
						fprintf(fp, "MISC_SCH_NEW_STR32+\'(%02d:%02d %d/%d/%d)\'",
							t->tm_hour, 
							t->tm_min,
							t->tm_year+1900,
						    t->tm_mon+1,
						    t->tm_mday);
					}	
					break;
				case BK_SERVER_NOT_FOUND:
					fprintf(fp, "MISC_SCH_NEW_STR37");
					break;
				case BK_SERVER_ERROR:
					fprintf(fp, "MISC_SCH_NEW_STR38");
					break;
				case BK_AUTH_FAIL:
					fprintf(fp, "MISC_SCH_NEW_STR33");
					break;
				case BK_DIR_FAIL:
					fprintf(fp, "MISC_SCH_NEW_STR34");
					break;
				case BK_COPY_FAIL:
					fprintf(fp, "MISC_SCH_NEW_STR35");
					break;
				case BK_COMPRESS_FAIL:
					fprintf(fp, "MISC_SCH_NEW_STR36");
					break;				
				//case BK_SRC_DIR_FAIL:
					fprintf(fp, "MISC_SCH_NEW_STR40");
					break;
				case BK_DEST_DIR_FAIL:	
					fprintf(fp, "MISC_SCH_NEW_STR39");			
					break;
#ifdef	__SNAPSHOT__
				case BK_SNAP_OPTION_INVALID:
					fprintf(fp, "MISC_SCH_NEW_STR64");			
					break;
				case BK_SNAP_CREATE_FAIL:
					fprintf(fp, "MISC_SCH_NEW_STR65");			
					break;
#endif
			}		
		}	
		
	}	
#ifdef	__SNAPSHOT__
	else if (!strcmp(str, "take_snapshot_checked")){
		int is_from_snap;

		tmp = (INPUT*) arg;
		is_from_snap = atoi(parser_schedule(buf, tmp->val, 17));

		if (is_from_snap) fprintf(fp, "checked");
		else	fprintf(fp, "%s", "");
	}
#endif
	/*else if (!strcmp(str, "status_name")){
		sch = (BACKUP_SCHEDULE*)arg;
		if (sch == NULL)
			fprintf(fp,"&nbsp;");
		else
			fprintf(fp,"%s", sch->name);	
	}	
	else if (!strcmp(str, "status_policy")){
		sch = (BACKUP_SCHEDULE*)arg;
		if (sch == NULL)
			fprintf(fp,"&nbsp;");
		else{
			switch(sch->policy){
				case BACKUP_GET:
					fprintf(fp,"%s", "GET");
					break;
				case BACKUP_PUT:
					fprintf(fp,"%s", "PUT");
					break;	
			}	
		}	
	}
	else if (!strcmp(str,"status_usage")){
		sch = (BACKUP_SCHEDULE*)arg;
		if (sch == NULL)
		  	fprintf(fp, "\'&nbsp;\'");
		else{
			switch(sch->usage){
				case BK_VIA_CIFS:
					fprintf(fp, "%s","MISC_SCH_NEW_STR06");
					break;
				case BK_VIA_FTP:
					fprintf(fp, "%s","MISC_SCH_NEW_STR07");
					break;
				case BK_VIA_NFS:
					fprintf(fp, "%s","MISC_SCH_NEW_STR08");
					break;
			}	
		}  	
	}
	*/	
	else if (!strcmp(str,"RR_location")){
		input = (INPUT *)arg;
		tmp = CGI_Find_Parameter (input, "SMB_LOCATION");
		fprintf(fp, "%s", (tmp)?tmp->val:"");
	}
	else if (!strcmp(str,"RR_remote_vol")){
		input = (INPUT *)arg;
		tmp = CGI_Find_Parameter (input, "REMOTE_VOL");
		fprintf(fp, "%s", (tmp)?tmp->val:"");
	}
	else if (!strcmp(str,"RR_remote_path")){
		input = (INPUT *)arg;
		tmp = CGI_Find_Parameter (input, "REMOTE_PATH");
		fprintf(fp, "%s", (tmp)?tmp->val:"");
	}
	else if (!strcmp(str,"RR_username")){
		input = (INPUT *)arg;
		tmp = CGI_Find_Parameter (input, "SMB_USERNAME");
		fprintf(fp, "%s", (tmp)?tmp->val:"");
	}
	else if (!strcmp(str,"RR_passwd")){
		input = (INPUT *)arg;
		tmp = CGI_Find_Parameter (input, "SMB_PASSWD");
		fprintf(fp, "%s", (tmp)?tmp->val:"");
	}
	else if (!strcmp(str,"RR_local_path")){
		input = (INPUT *)arg;
		tmp = CGI_Find_Parameter (input, "LOCAL_PATH");
		fprintf(fp, "%s", (tmp)?tmp->val:"");
	}
	else 
		return CGI_REPLACE_FAIL;	
	return CGI_REPLACE_OK;
}

BACKUP_SCHEDULE* get_new_schedule(INPUT* input)
{
	BACKUP_SCHEDULE* s = NULL;
	INPUT* tmp = NULL;
	int option;
	
	if (!(s = calloc (1, sizeof(BACKUP_SCHEDULE))))
		return NULL;

//	option = BACKUP_COPY_COMPRESS;	
	option=0;
#ifdef __RTRR_SUPPORT__
	s->usage = BK_VIA_RSYNC;
	s->policy = 0;	
	s->bcompress = 0;
#else
  #ifdef __QNAP_RSYNC_RR__
	s->usage = BK_VIA_RSYNC;
	s->policy = 0;
	s->bcompress = 0;
  #else
	s->usage = BK_VIA_CIFS;
	s->policy = BACKUP_PUT;	
	s->bcompress = 1;
  #endif
#endif
	s->status = BK_NONE_ACTION;
	s->latest_time = (time_t)0;
	tmp = CGI_Find_Parameter(input, "NAME");
	strcpy(s->name, tmp->val);
	/*tmp = CGI_Find_Parameter(input, "POLICY");
	s->policy = atoi (tmp->val);*/
	if ((tmp = CGI_Find_Parameter(input, "COMPRESS"))){
		option |= BACKUP_COPY_COMPRESS;
		s->bcompress = 1;
	}
	else
		s->bcompress = 0;
	
	tmp = CGI_Find_Parameter(input, "LOCAL_VOL");
	strcpy(s->local.volume, tmp->val);
	tmp = CGI_Find_Parameter(input, "LOCAL_PATH");
	sprintf(s->local.path, "/%s", tmp->val);
	tmp = CGI_Find_Parameter(input, "REMOTE_VOL");
	strcpy(s->remote.volume, tmp->val);
	tmp = CGI_Find_Parameter(input, "REMOTE_PATH");
	sprintf(s->remote.path, "/%s",tmp->val);
	
	if ((tmp = CGI_Find_Parameter(input, "backup_type"))){
		if (!strcmp(tmp->val,"immediate" )){
			struct tm *t;
			s->latest_time = time(NULL);
			t = localtime(&s->latest_time);
			s->t_type = BK_IMMEDIATELY;	
			s->status = BK_NOW;
	 		s->t_hour = t->tm_hour;
			s->t_min = t->tm_min;
		}
		else if (!strcmp(tmp->val,"Day")){			
			s->t_type=BK_DAY;
		}	
		else if (!strcmp(tmp->val,"week" )){
			s->t_type = BK_WEEK;
			if ( (tmp = CGI_Find_Parameter(input, "b_week")) )
				s->week = atoi (tmp->val);
			else
				s->week = 0;
		}
		else if (!strcmp(tmp->val, "month")){			
			s->t_type = BK_MONTH;
			if ( (tmp = CGI_Find_Parameter(input, "b_day")) )
				s->month = atoi (tmp->val);
			else
				s->month = 0;
		} else
			s->t_type=BK_DAY;
	} else {
		s->t_type=BK_DAY;
	}
	
	if ((tmp = CGI_Find_Parameter(input, "TIME_HOUR")) != NULL){		
	 	s->t_hour = atoi(tmp->val);
		tmp = CGI_Find_Parameter(input, "TIME_MIN");
		s->t_min = atoi (tmp->val);
	}
		
	tmp = CGI_Find_Parameter(input, "SMB_LOCATION");
	strcpy(s->cifs.server.location, tmp->val);
	tmp = CGI_Find_Parameter(input, "SMB_USERNAME");
	strcpy(s->cifs.user.name, tmp->val);
	tmp = CGI_Find_Parameter(input, "SMB_PASSWD");
	strcpy(s->cifs.user.passwd, tmp->val); 
		
	if ((tmp = CGI_Find_Parameter(input, "STOP_SERVICE")) != NULL){
		option |= BACKUP_COPY_STOP_SERVICE;		
		if ((tmp = CGI_Find_Parameter(input, "INCREMENTAL_COPY")) != NULL)
			option |= BACKUP_COPY_TIMESTAMP;
				  
		if ((tmp = CGI_Find_Parameter(input, "REMOVE_EX_FILE")) != NULL)
			option |= BACKUP_COPY_SYNC;			  
	}
	else 
	if ((tmp = CGI_Find_Parameter(input, "INCREMENTAL_COPY")) != NULL){
		option |= BACKUP_COPY_TIMESTAMP;				  
		if ((tmp = CGI_Find_Parameter(input, "REMOVE_EX_FILE")) != NULL)
			option |= BACKUP_COPY_SYNC;			
	}
	else
	if ((tmp = CGI_Find_Parameter(input, "REMOVE_EX_FILE")) != NULL){
		option |= BACKUP_COPY_SYNC;
	}	
	s->option = option;//backup.h inside config lib


	if ((tmp = CGI_Find_Parameter(input, "TAKE_SNAPSHOT")) != NULL){
		s->rr_from_snapshot = 1; 
	}
	else {
		s->rr_from_snapshot = 0; 
	}
		
	
//#define DEBUG
#ifdef  DEBUG
	printf("schedule->option=%d<br>",s->option);
#ifdef __RTRR_SUPPORT__
	DEBUG_rsync_Schedule(s);
#else
#ifdef __QNAP_RSYNC_RR__
        DEBUG_rsync_Schedule(s, NULL);
#else
	DEBUG_Schedule(s);
#endif
#endif
#endif	
	/*else if (!strcmp(tmp->val, "FTP")){
		s->usage = BK_VIA_FTP;
		tmp = CGI_Find_Parameter(input, "FTP_LOCATION");
		strcpy(s->ftp.server.location, tmp->val);
		tmp = CGI_Find_Parameter(input, "FTP_USERNAME");
		strcpy(s->ftp.user.name, tmp->val);
		tmp = CGI_Find_Parameter(input, "FTP_PASSWD");
		strcpy(s->ftp.user.passwd, tmp->val); 
		s->ftp.port = 21;
	}	
	else if (!strcmp(tmp->val, "NFS")){
		s->usage = BK_VIA_NFS;
		tmp = CGI_Find_Parameter(input, "NFS_LOCATION");
		strcpy(s->nfs.server.location, tmp->val);		
	}*/	
	
	return s;
}	

void get_schedule_from_string(BACKUP_SCHEDULE* s, char* str)
{
	char buf[1024]={""};
	strcpy(s->name, parser_schedule(buf, str, 0));
	s->policy = atoi(parser_schedule(buf, str, 1));
	s->bcompress = atoi(parser_schedule(buf, str, 2));	
	strcpy(s->local.volume, parser_schedule(buf, str, 3));
	strcpy(s->local.path, parser_schedule(buf, str, 4));
	strcpy(s->remote.volume, parser_schedule(buf, str, 5));
	strcpy(s->remote.path, parser_schedule(buf, str, 6));
	s->t_hour = atoi(parser_schedule(buf, str, 7));
	s->t_min = atoi(parser_schedule(buf, str, 8));
	switch((s->t_type = atoi(parser_schedule(buf, str, 9)))){
		case BK_WEEK:
			s->week = atoi(parser_schedule(buf, str, 10));
			break;
		case BK_MONTH:
			s->month = atoi(parser_schedule(buf, str, 10));
			break;	
	}
	switch((s->usage = atoi(parser_schedule(buf, str, 11)))){
		case BK_VIA_RSYNC:
		case BK_VIA_CIFS:
			strcpy(s->cifs.server.location, parser_schedule(buf, str, 12));
			strcpy(s->cifs.user.name, parser_schedule(buf, str, 13));
			break;
			
	}	
	s->option = atoi(parser_schedule(buf, str, 16));		
	return;
}

int check_valid_schedule(BACKUP_SCHEDULE* schedule)
{
	
	int ret = MISC_SUCCESS;
	
	
	if (schedule->name[0] == 0x0)
		return MISC_SCHEDULE_EMPTY_NAME;
	else if (strlen(schedule->name)>32)
		return MISC_SCHEDULE_BAD_NAME_LEN;
	else if (schedule->remote.volume[0] == 0x0)
		return MISC_SCHEDULE_REMOTE_VOL_EMPTY;
	/*else if (schedule->remote.path[0] == 0x0)
		return MISC_SCHEDULE_REMOTE_PATH_EMPTY;
	else if (schedule->local.path[0] == 0x0)
		return MISC_SCHEDULE_LOCAL_PATH_EMPTY;*/
	switch(schedule->usage){
		case BK_VIA_FTP:
			if (schedule->ftp.server.location[0] == 0x0)
				return MISC_SCHEDULE_SERVER_EMPTY;
			else if (schedule->ftp.user.name[0] == 0x0)
				return MISC_SCHEDULE_USER_NAME_EMPTY;
			else if (schedule->ftp.user.passwd[0] == 0x0)
				return MISC_SCHEDULE_PASSWD_EMPTY; 
			break;			
		case BK_VIA_RSYNC:
		case BK_VIA_CIFS:	
			if (schedule->cifs.server.location[0] == 0x0)
				return MISC_SCHEDULE_SERVER_EMPTY;
			/*else if (schedule->cifs.user.name[0] == 0x0) {
				strcpy(schedule->cifs.user.name, "guest");
				//return MISC_SCHEDULE_USER_NAME_EMPTY;
			}
			else if (schedule->cifs.user.passwd[0] == 0x0)
				return MISC_SCHEDULE_PASSWD_EMPTY; */
			break;			
		case BK_VIA_NFS:
			if (schedule->nfs.server.location[0] == 0x0)
				return MISC_SCHEDULE_SERVER_EMPTY;			
			break;	
	}					
	return ret;		
}	

int show_header_schedule(int type, INPUT* input)
{
	HEADER_ITEM head;
	int onload, index;
	g_def_type = get_def_type ();
	index = SELECT_BACKUP;//Shone modified 2005,09,26

	head.back[0]=0x0;
        head.home[0]=0x0;
        head.logout[0]=0x0;
        switch(type){
        	case HELP_MAIN:
			if(Is_Version_22())
				CGI_Get_Help(head.help, "help_misc.html#help_schedule_main");
			else
				CGI_Get_Help(head.help, "help_schedule_main.html");
        		break;
        	case HELP_NEW:
			if(Is_Version_22())
				CGI_Get_Help(head.help, "help_misc.html#help_schedule_new");
			else
				CGI_Get_Help(head.help, "help_schedule_new.html");
        		onload = USE_SHEDULE_NEW_ONLOAD;
        		break;
        	case HELP_EDIT:
			if(Is_Version_22())
				CGI_Get_Help(head.help, "help_misc.html#help_schedule_edit");
			else
				CGI_Get_Help(head.help, "help_schedule_edit.html");
        		onload = USE_SHEDULE_EDIT_ONLOAD;
        		break;		       
        }
        CGI_Output_Html1(MISC_HEADER_HTML, "$", schedule_replace, (void*)&onload);
        CGI_Show_Menu_V3_1(FUNC_MISC, &head);         
       	CGI_Output_Html1(MENU_V3_HEADER_HTML, "$", schedule_replace, NULL);                    		
        CGI_Show_Menu_V3_2(szDefineFilePath[g_def_type], index);
        CGI_Output_Html1(MENU_V3_MIDDLE_HTML, "$", schedule_replace, NULL);
        return 1;	
		
}

int show_tail_html()
{
	CGI_Output_Html1(MENU_V3_TAIL_HTML, "$", schedule_replace, NULL);
	CGI_Output_Html1(MISC_TAIL_HTML, "$", schedule_replace, NULL);
	return 1;
}

int do_schedule_new(INPUT* input)
{
	SECTION_INFO *list=NULL;
	int share_num = 0;
	
	share_num = Get_NAS_Share_List_Ex(&list);
	if(share_num > 0) {
		show_header_schedule(HELP_NEW, input);
		CGI_Output_Html1(SCHEDULE_NEW_HTML, "$", schedule_replace, (void* )input);
		show_tail_html();
		if(list != NULL)
			Release_List(list);
		return MISC_SUCCESS;
	}
	else {
		return MISC_SCHEDULE_NEW_NO_SHARE;	
	}
}

int do_schedule_edit(INPUT* input)
{
	SECTION_INFO *list=NULL;
	int share_num = 0;
	
	share_num = Get_NAS_Share_List_Ex(&list);
	if(share_num > 0) {
		show_header_schedule(HELP_EDIT, input);
		CGI_Output_Html1(SCHEDULE_EDIT_HTML, "$", schedule_replace, (void* )input);
		show_tail_html();
		if(list != NULL)
			Release_List(list);
		return MISC_SUCCESS;
	}
	else {
		return MISC_SCHEDULE_EDIT_NO_SHARE;	
	}
}		

int do_schedule_main(INPUT* input)
{
	BACKUP_SCHEDULE * s, *tmp = NULL;
	show_header_schedule(HELP_MAIN, input);
	CGI_Output_Html1(SCHEDULE_MAIN_HEADER_HTML, "$", schedule_replace, NULL);
#ifdef __RTRR_SUPPORT__
	s = rsync_Get_Schedule();
#else
#ifdef __QNAP_RSYNC_RR__
        s = rsync_Get_Schedule();
#else
	s = Backup_Get_Schedule();
#endif
#endif
	if (!s)
		CGI_Output_Html1(SCHEDULE_MAIN_NONE_HTML, "$", schedule_replace, NULL);
	else{
		tmp = s;
		while(tmp){
			CGI_Output_Html1(SCHEDULE_MAIN_BODY_HTML, "$", schedule_replace, (void*)tmp);
			tmp = (BACKUP_SCHEDULE*)tmp->next;
		}
#ifdef __RTRR_SUPPORT__
		rsync_Free_Schedule(s);
#else
#ifdef __QNAP_RSYNC_RR__
		rsync_Free_Schedule(s);
#else		
		Backup_Free_Schedule(s);
#endif
#endif
	}
	CGI_Output_Html1(SCHEDULE_MAIN_TAIL_HTML, "$", schedule_replace, NULL);
	show_tail_html();
	
	return 	MISC_SUCCESS;
}

int do_schedule_main_submit(INPUT* input)
{
	int btn = MISC_BTN_UNKNOWN, ret = 0;
	INPUT* tmp = NULL;
	switch((btn = get_btn(input))){
		case MISC_BTN_NEW:
			ret = do_schedule_new(input);
			return ret;
		case MISC_BTN_DEL:
			tmp = select_checkbox(input, &ret);
			if (ret == 0)
				return MISC_SCHEDULE_DEL_NONE;
			else 
				del_schedule(tmp);
			free(tmp);
			do_schedule_main(input);
			break;
		case MISC_BTN_EDIT:
			tmp = select_checkbox(input, &ret);	
		
			if (ret == 0)
				return MISC_SCHEDULE_EDIT_NONE;
			else if (ret > 1)
				return MISC_SCHEDULE_EDIT_MUTL;
			/*Shone marked for editing while replicating is being allowed presently	
			      {//Shone added to detect whether the selected job is in progress	
				BACKUP_SCHEDULE* schedule = NULL, *schtmp = NULL;
	
				schedule = Backup_Get_Schedule();
				schtmp = schedule;
				while(schtmp != NULL)
				       {
					if (schtmp->status == BK_NOW || schtmp->status == BK_ACTION )
					   {
					         if(!strncmp(tmp->val,schtmp->name,strlen(schtmp->name)))
					           {	//compare selected job's name with the proceeding job's name 
					   	free(schedule);
					   	schedule=NULL;
						return MISC_SCHEDULE_EDIT_JOB_IN_EXEC;
					           }
		 			   }		
					schtmp = (BACKUP_SCHEDULE*)schtmp->next;	
				       }	
				free(schedule);
				schedule=NULL;   	
			       }		*/		
			ret = do_schedule_edit(tmp);
			return ret;		
	}
	return 	MISC_SUCCESS;
}

int do_schedule_new_submit (INPUT* input)
{
	BACKUP_SCHEDULE* s = NULL;
	int btn = MISC_BTN_UNKNOWN, ret;
	
	
	btn = get_btn(input);
	if (btn == MISC_BTN_TEST){
		//printf("into test<br>");
		goto new_schedule_show;	
	}
	else if (btn == MISC_BTN_CANCEL || btn != MISC_BTN_OK)
		goto schedule_not_found;
		
	s = get_new_schedule(input);
	if (s == NULL)
		goto schedule_not_found;
	else{
		if ((ret = check_valid_schedule(s))!=MISC_SUCCESS){
			
			free(s);
			return ret;
		}	
#ifdef __RTRR_SUPPORT__
		if ((ret = rsync_Add_Schedule(s)) != BACKUP_SUCCESS){
#else
  #ifdef __QNAP_RSYNC_RR__
		else if ((ret = rsync_Add_Schedule(s)) != BACKUP_SUCCESS){
  #else
		else if ((ret = Backup_Add_Schedule(s)) != BACKUP_SUCCESS){
  #endif
#endif
				free(s);
				return ret;
		}	
		//else
		free(s);
		system("/bin/echo administrator > /tmp/cron/crontabs/cron.update");
	}	

schedule_not_found:	
	need_refresh = 1;
	do_schedule_main(input);
	return 	MISC_SUCCESS;
new_schedule_show:
	do_schedule_new(input);		
	return 	MISC_SUCCESS;
}

int do_schedule_edit_submit (INPUT* input)
{
	BACKUP_SCHEDULE* new = NULL, *old = NULL;
	INPUT* tmp;	
	int btn = MISC_BTN_UNKNOWN, ret;

	btn = get_btn(input);
	if (btn == MISC_BTN_TEST){
		tmp = CGI_Find_Parameter(input, "old_schedule");
		goto edit_schedule_show;	
	}	
	if (btn == MISC_BTN_CANCEL || btn != MISC_BTN_OK)
		goto schedule_edit_not_found;		

	new = get_new_schedule(input);
	if (new == NULL){		
		goto schedule_edit_not_found;
	}	
	else{
		tmp = CGI_Find_Parameter(input, "old_schedule");
		if ((ret = check_valid_schedule(new))!=MISC_SUCCESS){
			free(new);
			return ret;
		}	
		if (tmp != NULL){
			old = calloc(1, sizeof(BACKUP_SCHEDULE));
			get_schedule_from_string(old, tmp->val);
#ifdef __RTRR_SUPPORT__
			if ((ret = rsync_Ren_Schedule(new, old)) != BACKUP_SUCCESS){
#else
#ifdef __QNAP_RSYNC_RR__
                        if ((ret = rsync_Ren_Schedule(new, old)) != BACKUP_SUCCESS){
#else
			if ((ret = Backup_Ren_Schedule(new, old)) != BACKUP_SUCCESS){
#endif
#endif
				free(new);
				free(old);
				return ret;
			}
			free(old);
			system("/bin/echo administrator > /tmp/cron/crontabs/cron.update");
		}
		free(new);		
	}
	
schedule_edit_not_found:
	need_refresh = 1;
	do_schedule_main(input);
	return 	MISC_SUCCESS;
edit_schedule_show:
	do_schedule_edit(tmp);		
	return 	MISC_SUCCESS;
}	

int do_schedule_immediate(INPUT* input)

{
	show_header_schedule(HELP_IMMEDIATE, input);
	CGI_Output_Html1(SCHEDULE_IMMEDIATE_HTML, "$", schedule_replace, NULL);
	show_tail_html();
	return 	MISC_SUCCESS;
}

int do_schedule_immediate_submit(INPUT* input)
{
	BACKUP_SCHEDULE* s = NULL;
	int btn = MISC_BTN_UNKNOWN, ret;
	pid_t pid;
	
	
	btn = get_btn(input);
	if (btn == MISC_BTN_CANCEL || btn != MISC_BTN_OK)
		goto schedule_not_found;
	if (backup_immediate_execute())
		return MISC_SCHEDULE_EXECUTE;	
	s = get_new_schedule(input);
	if (s == NULL)
		goto schedule_not_found;
	else{
		if ((ret = check_valid_schedule(s))!=MISC_SUCCESS){
			
			free(s);
			return ret;
		}	
		else {
			s->status = BK_ACTION;
			s->bk_pid = getpid();
			Backup_Add_Schedule(s);
			pid=fork();			
   			if (pid < 0)
	        		exit(EXIT_FAILURE);		//error
        
			if (pid == 0) { //child  	
	//			close(0);
				close(1);
				close(2);					
				Backup_Now(s);
				free(s);
				exit(0);			
			}	
			goto schedule_status;
		}	
	}	
schedule_not_found:
	need_refresh = 1;
	do_schedule_main(input);
	return 	MISC_SUCCESS;
schedule_status:
	do_schedule_status (input);
	return 	MISC_SUCCESS;
}

int do_schedule_status (INPUT* input)
{
	BACKUP_SCHEDULE* schedule = NULL, *tmp = NULL, *s = NULL;
	
	show_header_schedule(HELP_STATUS, input);
	schedule = Backup_Get_Schedule();
	tmp = schedule;
	while(tmp != NULL){
		if (tmp->t_type == BK_IMMEDIATELY){
			s->next = tmp->next;
			tmp->next=NULL;
			break;
		}	
		s = tmp;	
		tmp = (BACKUP_SCHEDULE*)tmp->next;	
	}	
	CGI_Output_Html1(SCHEDULE_STATUS_HTML, "$", schedule_replace, (void*) tmp);
	show_tail_html();
	if (tmp->t_type == BK_IMMEDIATELY && tmp->status != BK_ACTION)		
		Backup_Del_Schedule(tmp);
	else 
		free (tmp);	
	Backup_Free_Schedule(schedule);
	return MISC_SUCCESS;
}

int do_schedule_status_submit (INPUT* input)		
{
	return MISC_SUCCESS;
}	

