#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <dirent.h>
#include <time.h>
#include <cgi.h>
#include <cfg_backup.h>
#include <cfg_tape.h>
#include <cfg_ups.h>
#include <cfg_backup_agent.h>
#include <v2_menu.h>
#include <NAS.h>
#include <backup.h>
#include <rtcmond.h>
#include "misc.h"
#include "auto_bs.h"

#define	RTCMOND	"/sbin/rtcmond"

char	num2weekdays[7][10]={
	"Sunday",
	"Monday",
	"Tuesday",
	"Wednesday",
	"Thursday",
	"Friday",
	"Saturday"
	};

int bs_replace(FILE* fp, char* str, void* arg)
{
	char	old_boot_hour[4], old_shutdown_hour[4];
	char	old_boot_minute[4], old_shutdown_minute[4];
	char	old_boot_mday[4], old_shutdown_mday[4];
	char	old_boot_wday[4], old_shutdown_wday[4];
	char	buf[64];
	int	old_boot_type=RTC_CGI_DDAY, old_shutdown_type=RTC_CGI_DDAY;
	char	auto_boot_enable[20], auto_shutdown_enable[20];

	if ( !GetProfileString(RTC_SECTION, RTC_SUPPORT, "", buf, 64) )
		WriteProfileString(RTC_SECTION, RTC_SUPPORT, "False");
	if ( !GetProfileString(RTC_SECTION, RTC_ENABLED, "", buf, 64) )
		WriteProfileString(RTC_SECTION, RTC_ENABLED, "False");
	
	GetProfileString(RTC_SECTION, RTC_HOUR, "0", old_boot_hour, 4);
	GetProfileString(RTC_SECTION, RTC_MIN, "0", old_boot_minute, 4);
	GetProfileString(RTC_SECTION, RTC_MDAY, "1", old_boot_mday, 4);
	GetProfileString(RTC_SECTION, RTC_WDAY, "0", old_boot_wday, 4);
	GetProfileString(RTC_SECTION, RTC_ENABLED, "FALSE", auto_boot_enable, 20);
	GetProfileString(RTC_SECTION, RTC_MASK_TYPE, RTC_MASK_DDAY, buf, 64);
	if (!strcmp(buf, "Monthly"))
		old_boot_type=RTC_CGI_MDAY;
	if (!strcmp(buf, "Weekly"))
		old_boot_type=RTC_CGI_WDAY;
	if (!strcmp(buf, "Daily"))
		old_boot_type=RTC_CGI_DDAY;

//auto shutdown implementation
	if ( !GetProfileString(AUTO_SHUTDOWN_SECTION, RTC_SUPPORT, "", buf, 64) ) {
		WriteProfileString(AUTO_SHUTDOWN_SECTION, RTC_SUPPORT, "True");
		WriteProfileString(AUTO_SHUTDOWN_SECTION, RTC_ENABLED, "False");
	}
	
	GetProfileString(AUTO_SHUTDOWN_SECTION, RTC_HOUR, "0", old_shutdown_hour, 4);
	GetProfileString(AUTO_SHUTDOWN_SECTION, RTC_MIN, "0", old_shutdown_minute, 4);
	GetProfileString(AUTO_SHUTDOWN_SECTION, RTC_MDAY, "1", old_shutdown_mday, 4);
	GetProfileString(AUTO_SHUTDOWN_SECTION, RTC_WDAY, "0", old_shutdown_wday, 4);
	GetProfileString(AUTO_SHUTDOWN_SECTION, RTC_ENABLED, "FALSE", auto_shutdown_enable, 20);
	GetProfileString(AUTO_SHUTDOWN_SECTION, RTC_MASK_TYPE, RTC_MASK_DDAY, buf, 64);
	if (!strcmp(buf, "Monthly"))
		old_shutdown_type=RTC_CGI_MDAY;
	if (!strcmp(buf, "Weekly"))
		old_shutdown_type=RTC_CGI_WDAY;
	if (!strcmp(buf, "Daily"))
		old_shutdown_type=RTC_CGI_DDAY;


	if (!strcasecmp(str, "auto_boot_enable"))
	{
		if (!strcasecmp(auto_boot_enable, "True"))
			fprintf(fp, "checked");
	}
	else
	if (!strcasecmp(str, "old_boot_hour"))
	{
		fprintf(fp, "%02d", atoi(old_boot_hour));
	}
	else
	if (!strcasecmp(str, "old_boot_minute"))
	{
		fprintf(fp, "%02d", atoi(old_boot_minute));
	}
	else
	if (!strcasecmp(str, "auto_boot_type_Daily_check"))
	{
		if ( old_boot_type==RTC_CGI_DDAY )
			fprintf(fp, "checked");
	}
	else
	if (!strcasecmp(str, "auto_boot_type_Weekly_check"))
	{
		if ( old_boot_type==RTC_CGI_WDAY )
			fprintf(fp, "checked");
	}
	else
	if (!strcasecmp(str, "auto_boot_type_Monthly_check"))
	{
		if ( old_boot_type==RTC_CGI_MDAY )
			fprintf(fp, "checked");
	}
	else
	if (!strcasecmp(str, "old_boot_daily"))
	{
		if ( old_boot_type==RTC_CGI_DDAY )
			fprintf(fp, "Daily");
	}
	else
	if (!strcasecmp(str, "old_boot_weekly"))
	{
		if ( old_boot_type==RTC_CGI_WDAY )
			fprintf(fp, "Weekly on ");
	}
	else
	if (!strcasecmp(str, "old_boot_monthly"))
	{
		if ( old_boot_type==RTC_CGI_MDAY )
			fprintf(fp, "Monthly on ");
	}
	else
	if (!strcasecmp(str, "old_boot_wday"))
	{
		//MISC_SCH_NEW_STR20~26, Mon~Sun
		if ( old_boot_type==RTC_CGI_WDAY )
			fprintf(fp, "<script language=\"JavaScript\">document.write(MISC_SCH_NEW_STR2%d)</script>", (atoi(old_boot_wday)+6)%7);
	}
	else
	if (!strcasecmp(str, "old_boot_mday"))
	{
		if ( old_boot_type==RTC_CGI_MDAY )
			fprintf(fp, "%d", atoi(old_boot_mday));
	}
	else
	if (!strcasecmp(str, "auto_boot_hour_menu"))
	{
		int	i=0;
		fprintf(fp, "<select name=\"auto_boot_hour\" size=1 class=\"12-blue\">\n");
		for (i=0; i <=23; i++){
			char	is_selected[10]={'\0'};
			if ( i==atoi(old_boot_hour) )
				strcpy(is_selected, "selected");
			fprintf(fp, "  <option value=\"%d\" %s>%02d</option>\n", i, is_selected, i);
		}
                fprintf(fp, "</select>\n");
	}
	else
	if (!strcasecmp(str, "auto_boot_minute_menu"))
	{
		int	i=0;
		fprintf(fp, "<select name=\"auto_boot_minute\" size=1 class=\"12-blue\">\n");
		for (i=0; i <=59; i++){
			char	is_selected[10]={'\0'};
			if ( i==atoi(old_boot_minute) )
				strcpy(is_selected, "selected");
			fprintf(fp, "  <option value=\"%d\" %s>%02d</option>\n", i, is_selected, i);
		}
                fprintf(fp, "</select>\n");
	}
	else
	if (!strcasecmp(str, "auto_boot_wday_menu"))
	{
		if ( old_boot_type==RTC_CGI_WDAY ) {
			int	i=0;
			fprintf(fp, "<script language=\"JavaScript\">document.write('<select name=\"auto_boot_wday\" size=\"1\" width=\"108\" class=\"12-blue\">");
			for (i=0; i <=6; i++){
				char	is_selected[10]={'\0'};
				if ( i==atoi(old_boot_wday) )
					strcpy(is_selected, "selected");
				fprintf(fp, "<option value=\"%d\" %s>' + MISC_SCH_NEW_STR2%d + '</option>", i, is_selected, (i+6)%7);
			}
                	fprintf(fp, "</select>')</script>\n");
                } else {
                	fprintf(fp, "<script language=\"JavaScript\">document.write('<select name=\"auto_boot_wday\" size=\"1\" width=\"108\" class=\"12-blue\" disabled><option value=\"0\">' + MISC_SCH_NEW_STR26 + '</option><option value=\"1\">'+MISC_SCH_NEW_STR20+'</option><option value=\"2\">' +  MISC_SCH_NEW_STR21 + '</option><option value=\"3\">' + MISC_SCH_NEW_STR22 +'</option><option value=\"4\">' + MISC_SCH_NEW_STR23 +'</option><option value=\"5\">'+ MISC_SCH_NEW_STR24+'</option><option value=\"6\">' +MISC_SCH_NEW_STR25+ '</option></select>')</script>\n");
                }
	}
	else
	if (!strcasecmp(str, "auto_boot_mday_menu"))
	{
		if ( old_boot_type==RTC_CGI_MDAY ) {
			int	i=0;
			fprintf(fp, "<select name=\"auto_boot_mday\" size=1 class=\"12-blue\">\n");
			for (i=1; i <=31; i++){
				char	is_selected[10]={'\0'};
				if ( i==atoi(old_boot_mday) )
					strcpy(is_selected, "selected");
				fprintf(fp, "  <option value=\"%d\" %s>%02d</option>\n", i, is_selected, i);
			}
                	fprintf(fp, "</select>\n");
                } else {
                	int	i=0;
                	fprintf(fp, "<select name=\"auto_boot_mday\" size=1 class=\"12-blue\" disabled>\n");
			for (i=1; i <=31; i++){
				fprintf(fp, "  <option value=\"%d\">%02d</option>\n", i, i);
			}
                	fprintf(fp, "</select>\n");	
                }
	}
//auto shutdown implementation
	else
	if (!strcasecmp(str, "auto_shutdown_enable"))
	{
		if (!strcasecmp(auto_shutdown_enable, "True"))
			fprintf(fp, "checked");
	}
	else
	if (!strcasecmp(str, "old_shutdown_hour"))
	{
		fprintf(fp, "%02d", atoi(old_shutdown_hour));
	}
	else
	if (!strcasecmp(str, "old_shutdown_minute"))
	{
		fprintf(fp, "%02d", atoi(old_shutdown_minute));
	}
	else
	if (!strcasecmp(str, "auto_shutdown_type_Daily_check"))
	{
		if ( old_shutdown_type==RTC_CGI_DDAY )
			fprintf(fp, "checked");
	}
	else
	if (!strcasecmp(str, "auto_shutdown_type_Weekly_check"))
	{
		if ( old_shutdown_type==RTC_CGI_WDAY )
			fprintf(fp, "checked");
	}
	else
	if (!strcasecmp(str, "auto_shutdown_type_Monthly_check"))
	{
		if ( old_shutdown_type==RTC_CGI_MDAY )
			fprintf(fp, "checked");
	}
	else
	if (!strcasecmp(str, "old_shutdown_daily"))
	{
		if ( old_shutdown_type==RTC_CGI_DDAY )
			fprintf(fp, "Daily");
	}
	else
	if (!strcasecmp(str, "old_shutdown_weekly"))
	{
		if ( old_shutdown_type==RTC_CGI_WDAY )
			fprintf(fp, "Weekly on ");
	}
	else
	if (!strcasecmp(str, "old_shutdown_monthly"))
	{
		if ( old_shutdown_type==RTC_CGI_MDAY )
			fprintf(fp, "Monthly on ");
	}
	else
	if (!strcasecmp(str, "old_shutdown_wday"))
	{
		//MISC_SCH_NEW_STR20~26, Mon~Sun
		if ( old_shutdown_type==RTC_CGI_WDAY )
			fprintf(fp, "<script language=\"JavaScript\">document.write(MISC_SCH_NEW_STR2%d)</script>", (atoi(old_shutdown_wday)+6)%7);
	}
	else
	if (!strcasecmp(str, "old_shutdown_mday"))
	{
		if ( old_shutdown_type==RTC_CGI_MDAY )
			fprintf(fp, "%d", atoi(old_shutdown_mday));
	}
	else
	if (!strcasecmp(str, "auto_shutdown_hour_menu"))
	{
		int	i=0;
		fprintf(fp, "<select name=\"auto_shutdown_hour\" size=1 class=\"12-blue\">\n");
		for (i=0; i <=23; i++){
			char	is_selected[10]={'\0'};
			if ( i==atoi(old_shutdown_hour) )
				strcpy(is_selected, "selected");
			fprintf(fp, "  <option value=\"%d\" %s>%02d</option>\n", i, is_selected, i);
		}
                fprintf(fp, "</select>\n");
	}
	else
	if (!strcasecmp(str, "auto_shutdown_minute_menu"))
	{
		int	i=0;
		fprintf(fp, "<select name=\"auto_shutdown_minute\" size=1 class=\"12-blue\">\n");
		for (i=0; i <=59; i++){
			char	is_selected[10]={'\0'};
			if ( i==atoi(old_shutdown_minute) )
				strcpy(is_selected, "selected");
			fprintf(fp, "  <option value=\"%d\" %s>%02d</option>\n", i, is_selected, i);
		}
                fprintf(fp, "</select>\n");
	}
	else
	if (!strcasecmp(str, "auto_shutdown_wday_menu"))
	{
		if ( old_shutdown_type==RTC_CGI_WDAY ) {
			int	i=0;
			fprintf(fp, "<script language=\"JavaScript\">document.write('<select name=\"auto_shutdown_wday\" size=\"1\" width=\"108\" class=\"12-blue\">");
			for (i=0; i <=6; i++){
				char	is_selected[10]={'\0'};
				if ( i==atoi(old_shutdown_wday) )
					strcpy(is_selected, "selected");
				fprintf(fp, "<option value=\"%d\" %s>' + MISC_SCH_NEW_STR2%d + '</option>", i, is_selected, (i+6)%7);
			}
                	fprintf(fp, "</select>')</script>\n");
                } else {
                	fprintf(fp, " \
                		<script language=\"JavaScript\">document.write('<select name=\"auto_shutdown_wday\" size=\"1\" width=\"108\" class=\"12-blue\" disabled><option value=\"0\">' + MISC_SCH_NEW_STR26 + '</option><option value=\"1\">'+MISC_SCH_NEW_STR20+'</option><option value=\"2\">' +  MISC_SCH_NEW_STR21 + '</option><option value=\"3\">' + MISC_SCH_NEW_STR22 +'</option><option value=\"4\">' + MISC_SCH_NEW_STR23 +'</option><option value=\"5\">'+ MISC_SCH_NEW_STR24+'</option><option value=\"6\">' +MISC_SCH_NEW_STR25+ '</option></select>')</script>\n");
                }
	}
	else
	if (!strcasecmp(str, "auto_shutdown_mday_menu"))
	{
		if ( old_shutdown_type==RTC_CGI_MDAY ) {
			int	i=0;
			fprintf(fp, "<select name=\"auto_shutdown_mday\" size=1 class=\"12-blue\">\n");
			for (i=1; i <=31; i++){
				char	is_selected[10]={'\0'};
				if ( i==atoi(old_shutdown_mday) )
					strcpy(is_selected, "selected");
				fprintf(fp, "  <option value=\"%d\" %s>%02d</option>\n", i, is_selected, i);
			}
                	fprintf(fp, "</select>\n");
                } else {
                	int	i=0;
                	fprintf(fp, "<select name=\"auto_shutdown_mday\" size=1 class=\"12-blue\" disabled>\n");
			for (i=1; i <=31; i++){
				fprintf(fp, "  <option value=\"%d\">%02d</option>\n", i, i);
			}
                	fprintf(fp, "</select>\n");	
                }
	}
	else
		return CGI_REPLACE_FAIL;

	return CGI_REPLACE_OK;
}

int RTC_Is_Support()
{
	char buf[20];

	GetProfileString(RTC_SECTION, RTC_SUPPORT, "FALSE", buf, sizeof(buf));
	return NOT_FALSE(buf);
}

int do_auto_bs_main(INPUT* input, int select)
{
	show_misc_header(input, select);	
	if ( RTC_Is_Support() )
		CGI_Output_Html1(AUTO_BS_MAIN_HTML, "$", bs_replace, (void *)input);
	else
		CGI_Output_Html1(AUTO_BS_MAIN_NONE_HTML, "$", bs_replace, (void *)input);
	show_misc_tail();
	return MISC_SUCCESS;
}


int do_bs_submit_apply(INPUT* input, int select)
{
	char	buf[256];
	INPUT	*boot_enable=NULL, *shutdown_enable=NULL;
	INPUT	*boot_hour=NULL, *boot_minute=NULL, *boot_type=NULL, *boot_day=NULL;
	INPUT	*shutdown_hour=NULL, *shutdown_minute=NULL, *shutdown_type=NULL, *shutdown_day=NULL;
	int	is_boot_enable=0, boot_eventlog_trigger = 0;
	int	is_shutdown_enable=0, shutdown_eventlog_trigger=0;
	
	char	old_enable[16], old_type[16], old_mday[16], old_wday[16], old_hour[16], old_min[16];

//boot settings
	if ( (boot_enable = CGI_Find_Parameter(input, "auto_boot_chkbox")) != NULL ) {
		//auto_boot enabled
		is_boot_enable=1;
	} else {
		//auto_boot disabled
		is_boot_enable=0;
	}
	
	GetProfileString(RTC_SECTION, RTC_ENABLED, "", old_enable, 16);
	GetProfileString(RTC_SECTION, RTC_MASK_TYPE, "", old_type, 16);
	GetProfileString(RTC_SECTION, RTC_MDAY, "", old_mday, 16);
	GetProfileString(RTC_SECTION, RTC_WDAY, "", old_wday, 16);
	GetProfileString(RTC_SECTION, RTC_HOUR, "", old_hour, 16);
	GetProfileString(RTC_SECTION, RTC_MIN, "", old_min, 16);

	boot_hour	= CGI_Find_Parameter(input, "auto_boot_hour");
	boot_minute	= CGI_Find_Parameter(input, "auto_boot_minute");
	boot_type	= CGI_Find_Parameter(input, "auto_boot_type");

	if ( (!strcasecmp(old_enable, "True") ^ is_boot_enable) ) {  //checkbox changed
		boot_eventlog_trigger = 1;
	} else if ( !strcasecmp(old_enable, "True") && (
		strcasecmp(old_type, boot_type->val) || 
		strcasecmp(old_hour, boot_hour->val) || 
		strcasecmp(old_min, boot_minute->val)) ) {
		boot_eventlog_trigger = 1;
	}

	if (!strcmp("Weekly", boot_type->val)) {
		boot_day = CGI_Find_Parameter(input, "auto_boot_wday");
		if ( boot_eventlog_trigger == 1 ||
			strcasecmp(old_wday, boot_day->val) ) {
			if ( is_boot_enable )
				sprintf(buf, "/sbin/write_log \"Auto boot was enabled successfully with schedule: \
					%02d:%02d on %s Weekly\" 4 2>/dev/null 1>/dev/null", \
					atoi(boot_hour->val), atoi(boot_minute->val), \
					num2weekdays[atoi(boot_day->val)]);
			else
				sprintf(buf, "/sbin/write_log \"Auto boot was disabled successfully.\" 4 2>/dev/null 1>/dev/null");
			system(buf);
		}
	} else if (!strcmp("Monthly", boot_type->val)) {
		boot_day = CGI_Find_Parameter(input, "auto_boot_mday");
		if ( boot_eventlog_trigger == 1 ||
			strcasecmp(old_mday, boot_day->val) ) {
			if ( is_boot_enable )
				sprintf(buf, "/sbin/write_log \"Auto boot was enabled successfully with schedule: \
					%02d:%02d on day %d Monthly\" 4 2>/dev/null 1>/dev/null", \
					atoi(boot_hour->val), atoi(boot_minute->val), \
					atoi(boot_day->val));
			else
				sprintf(buf, "/sbin/write_log \"Auto boot was disabled successfully.\" 4 2>/dev/null 1>/dev/null");
			system(buf);
		}
	}

	if ( boot_day != NULL ) {
		sprintf(buf, "%s -%c -d %d -t %02d%02d -E %d", 
			RTCMOND, boot_type->val[0], atoi(boot_day->val), 
			atoi(boot_hour->val), atoi(boot_minute->val), is_boot_enable);
		system(buf);
	} else {
		if ( boot_eventlog_trigger == 1 ) {
			if ( is_boot_enable )
				sprintf(buf, "/sbin/write_log \"Auto boot was enabled successfully with schedule: \
					%02d:%02d Daily\" 4 2>/dev/null 1>/dev/null", \
					atoi(boot_hour->val), atoi(boot_minute->val));
			else
				sprintf(buf, "/sbin/write_log \"Auto boot was disbled successfully.\" 4 2>/dev/null 1>/dev/null");
			system(buf);
		}
		sprintf(buf, "%s -D -t %02d%02d -E %d", 
			RTCMOND, atoi(boot_hour->val), atoi(boot_minute->val), is_boot_enable);
		system(buf);
	}
//boot settings

//shutdown settings
	if((shutdown_enable = CGI_Find_Parameter(input, "auto_shutdown_chkbox")) != NULL) {
		//auto_boot enabled
		is_shutdown_enable=1;
	} else {
		//auto_boot disabled
		is_shutdown_enable=0;
	}

	GetProfileString(AUTO_SHUTDOWN_SECTION, RTC_ENABLED, "", old_enable, 16);
	GetProfileString(AUTO_SHUTDOWN_SECTION, RTC_MASK_TYPE, "", old_type, 16);
	GetProfileString(AUTO_SHUTDOWN_SECTION, RTC_HOUR, "", old_hour, 16);
	GetProfileString(AUTO_SHUTDOWN_SECTION, RTC_MIN, "", old_min, 16);

	shutdown_hour	= CGI_Find_Parameter(input, "auto_shutdown_hour");
	shutdown_minute	= CGI_Find_Parameter(input, "auto_shutdown_minute");
	shutdown_type	= CGI_Find_Parameter(input, "auto_shutdown_type");

	if ( (!strcasecmp(old_enable, "True") ^ is_shutdown_enable) ) {	//checkbox changed
		shutdown_eventlog_trigger = 1;
	} else if ( !strcasecmp(old_enable, "True") && (
		strcasecmp(old_type, shutdown_type->val) || 
		strcasecmp(old_hour, shutdown_hour->val) || 
		strcasecmp(old_min, shutdown_minute->val)) ) {
		shutdown_eventlog_trigger = 1;
	}

	if (!strcmp("Weekly", shutdown_type->val)) {
		shutdown_day = CGI_Find_Parameter(input, "auto_shutdown_wday");
		WriteProfileString(AUTO_SHUTDOWN_SECTION, RTC_WDAY, shutdown_day->val);
		WriteProfileString(AUTO_SHUTDOWN_SECTION, RTC_MDAY, "0");
		WriteProfileString(AUTO_SHUTDOWN_SECTION, RTC_MASK_TYPE, RTC_MASK_WDAY);

		if ( shutdown_eventlog_trigger == 1 ||
			strcasecmp(old_wday, shutdown_day->val) ) {
			if ( is_shutdown_enable )
				sprintf(buf, "/sbin/write_log \"Auto shutdown was enabled successfully with schedule: \
					%02d:%02d on %s Weekly\" 4 2>/dev/null 1>/dev/null", \
					atoi(shutdown_hour->val), atoi(shutdown_minute->val), \
					num2weekdays[atoi(shutdown_day->val)]);
			else
				sprintf(buf, "/sbin/write_log \"Auto shutdown was disabled successfully.\" 4 2>/dev/null 1>/dev/null");
			system(buf);
		}
	} else if (!strcmp("Monthly", shutdown_type->val)) {
		shutdown_day = CGI_Find_Parameter(input, "auto_shutdown_mday");
		WriteProfileString(AUTO_SHUTDOWN_SECTION, RTC_WDAY, "0");
		WriteProfileString(AUTO_SHUTDOWN_SECTION, RTC_MDAY, shutdown_day->val);
		WriteProfileString(AUTO_SHUTDOWN_SECTION, RTC_MASK_TYPE, RTC_MASK_MDAY);

		if ( shutdown_eventlog_trigger == 1 ||
			strcasecmp(old_mday, shutdown_day->val) ) {
			if ( is_shutdown_enable )
				sprintf(buf, "/sbin/write_log \"Auto shutdown was enabled successfully with schedule: \
					%02d:%02d on day %d Monthly\" 4 2>/dev/null 1>/dev/null", \
					atoi(shutdown_hour->val), atoi(shutdown_minute->val), \
					atoi(shutdown_day->val));
			else
				sprintf(buf, "/sbin/write_log \"Auto shutdown was disabled successfully.\" 4 2>/dev/null 1>/dev/null");
			system(buf);
		}
	} else {
		WriteProfileString(AUTO_SHUTDOWN_SECTION, RTC_WDAY, "0");
		WriteProfileString(AUTO_SHUTDOWN_SECTION, RTC_MDAY, "0");
		WriteProfileString(AUTO_SHUTDOWN_SECTION, RTC_MASK_TYPE, RTC_MASK_DDAY);

		if ( shutdown_eventlog_trigger == 1 ) {
			if ( is_shutdown_enable )
				sprintf(buf, "/sbin/write_log \"Auto shutdown was enabled successfully with schedule: \
					%02d:%02d Daily\" 4 2>/dev/null 1>/dev/null", \
					atoi(shutdown_hour->val), atoi(shutdown_minute->val));
			else
				sprintf(buf, "/sbin/write_log \"Auto shutdown was disabled successfully.\" 4 2>/dev/null 1>/dev/null");
			system(buf);
		}
	}
	WriteProfileString(AUTO_SHUTDOWN_SECTION, RTC_HOUR, shutdown_hour->val);
	WriteProfileString(AUTO_SHUTDOWN_SECTION, RTC_MIN, shutdown_minute->val);
	//WriteProfileString(AUTO_SHUTDOWN_SECTION, RTC_SUPPORT, "True");
	WriteProfileString(AUTO_SHUTDOWN_SECTION, RTC_ENABLED, is_shutdown_enable?"True":"False");

	if ( is_shutdown_enable ) {
		strcpy(buf, "/etc/init.d/auto_bs.sh Shutdown");
		system(buf);
	} else {
		strcpy(buf, "/etc/init.d/auto_bs.sh Shutdown");
		system(buf);
	}
//shutdown settings

//	CGI_Debug_Input(input);
	show_misc_header(input, select);	
	CGI_Output_Html1(AUTO_BS_MAIN_HTML, "$", bs_replace, (void *)input);
	show_misc_tail();
	return MISC_SUCCESS;
}
