#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>

/* NAS include file */
#include <cgi.h>
#include <v2_menu.h>
#include <cfg_nic.h>
#include <config.h>

/* local include */
#include "hwtest.h"
#include "hwtest01.h"
#include "hwtest02.h"
#include "test_hd_speed.h"
#include "flash_test.h"
#include "mem.h"


int hwtest01_replace(FILE *fptr, char *name, void *arg)
{
	char 	buf[128];
	int 	flag=1;
	double 	ret;
	INPUT   *input = (INPUT *)arg;
	if (!strcmp(name, "hwtest_ramtest"))
	{
		ret = get_mem();
		fprintf(fptr,"%5.1f MB", ret);
		sprintf(buf,"%5.1f MB", ret);
		Set_Private_Profile_String("Test Result", "ram size", buf, RESULT_FILE);
	}
        else
	if (!strcmp(name, "hwtest_flashtest"))
	{
		ret = flash_test();
		if(ret)
		{
			fprintf(fptr,"ok");
			Set_Private_Profile_String("Test Result", "Flashtest", "ok", RESULT_FILE);
		}
		else
		{
			fprintf(fptr,"<font color=\"red\">fail</font>");
			Set_Private_Profile_String("Test Result", "Flashtest", "<font color=\"red\">fail</font>", RESULT_FILE);
		}
	}
	else
	if (!strcmp(name, "hwtest_hdperm"))
	{
		FILE *fp;
		int count, fd, i=0;
		char buf[128], buf1[128];
		fp = fopen("/tmp/config/hdparm.sata","r");
		fd = open("/dev/sda", O_RDONLY);
		if(fp != NULL && fd != -1)
		{
			for(count=0; count<3; count++)
        		{
                		fgets(buf, sizeof(buf), fp);
        		}
        		while( buf[i] != '=')
        		{
                		i++;
        		}
        		sprintf(buf1, "%s", buf+i+2);
			fprintf(fptr, "%s", buf1);
			Set_Private_Profile_String("Test Result", "HD Speed", buf1, RESULT_FILE);
		}
		else
		{
			flag = get_hd_speed(buf, SDA);
			if(!flag)
                        {
                                fprintf(fptr,"%s",buf);
                                Set_Private_Profile_String("Test Result", "HD Speed", buf, RESULT_FILE);
                        }
                        else
                        {
                                fprintf(fptr,"<font color=\"red\">fail</font>");
                                Set_Private_Profile_String("Test Result", "HD Speed", "<font color=\"red\">fail</font>", RESULT_FILE);
                        }
		}
		if(fp != NULL)
			fclose(fp);
		if(fd != -1)
			close(fd);
	}
	else
	if (!strcmp(name, "hwtest_rtc"))
	{
		INPUT   *tmp;
      	  	int     ret;
        	if((tmp=CGI_Find_Parameter(input, "clienttime"))!=NULL)
		{
        		ret = Set_Current_Date_Time(tmp->val);
			if(!ret)
			{
				fprintf(fptr,"ok");
				Set_Private_Profile_String("Test Result", "RTC", "ok", RESULT_FILE);
			}
			else
			{
				fprintf(fptr,"<font color=\"red\">fail</font>");
				Set_Private_Profile_String("Test Result", "RTC", "<font color=\"red\">fail</font>", RESULT_FILE);
			}
		}
	}
	else
/*	if(!strcmp(name, "hwtest_mimiPCI"))
	{
		char 	str[128];
		int 	ret;
		sprintf(str, "/bin/grep \"Agere Systems\" /proc/pci 1>/dev/null 2>/dev/null");
		ret = system(str);
		if(ret == 0)
		{
			fprintf(fptr, "ok");
			Set_Private_Profile_String("Test Result", "mimiPCI", "ok", RESULT_FILE);
		}
		else
		{
			fprintf(fptr, "<font color=\"red\">fail</font>");
			Set_Private_Profile_String("Test Result", "mimiPCI", "<font color=\"red\">fail</font>", RESULT_FILE);
		}
	}
	else*/
        	return CGI_REPLACE_FAIL;
        return CGI_REPLACE_OK;
}

int do_hwtest01_main(INPUT *input)
{
	/* put your code here */
	CGI_Output_Html1(HWTEST01_MAIN_HTML, "$", hwtest01_replace, input);
	return HWTEST_SUCCESS;
}

int do_hwtest01_main_submit(INPUT *input)
{
	int	btn;
	int	ret=HWTEST_SUCCESS;

	btn=get_btn(input);
	switch (btn)
	{
		case HWTEST_BTN_NEXT:
			/* put your "next button" code here */
			do_hwtest02_main(input);
			break;
		case HWTEST_BTN_BACK:
			printf("press exit button");
			break;
		case HWTEST_BTN_REFLASH:
                        do_hwtest01_main(input);
                        break;
	}
	return ret;
}

