#include <stdio.h>
#include <string.h>

/* NAS include file */
#include <cgi.h>
#include <v2_menu.h>
#include <cfg_nic.h>

/* local file */
#include "hwtest.h"
#include "hwtestmain.h"
#include "hwtest00.h"
#include "hwtest01.h"
#include "hwtest02.h"
#include "hwtest03.h"
#include "hwtest04.h"
#include "hwtest05.h"
#include "hwtest06.h"
	


int get_btn(INPUT *input)
{
	int	ret=HWTEST_BTN_UNKNOWN;

	if (CGI_Find_Parameter(input, "next"))
		ret=HWTEST_BTN_NEXT;
	else
	if (CGI_Find_Parameter(input, "back"))
		ret=HWTEST_BTN_BACK;
	else
	if (CGI_Find_Parameter(input, "ok"))
		ret=HWTEST_BTN_OK;
	else
	if (CGI_Find_Parameter(input, "reflash"))
                ret=HWTEST_BTN_REFLASH;
	else
        if (CGI_Find_Parameter(input, "start"))
                ret=HWTEST_BTN_TEST;
	return	ret;
}

int get_func(INPUT *input)
{
	INPUT	*tmp;
	int	ret=HWTEST_NONE;

	tmp=CGI_Find_Parameter(input, "func");
	if (tmp==NULL)
		ret=HWTEST_NONE;
	else
	{
		if (!strcmp(tmp->val, "main"))
		{
			ret=HWTEST_MAIN;
		}
		else
		if(!strcmp(tmp->val, "hwtest_main_submit"))
		{
			ret=HWTEST_MAIN_SUBMIT;
		}
		else
		if (!strcmp(tmp->val, "hwtest00_main"))
		{
			ret=HWTEST00_MAIN;
		}
		else
		if (!strcmp(tmp->val, "hwtest00_main_submit"))
		{
			ret=HWTEST00_MAIN_SUBMIT;
		}
		else
		if (!strcmp(tmp->val, "hwtest01_main"))
		{
			ret=HWTEST01_MAIN;
		}
		else
		if (!strcmp(tmp->val, "hwtest01_main_submit"))
		{
			ret=HWTEST01_MAIN_SUBMIT;
		}
		else
		if (!strcmp(tmp->val, "hwtest02_main"))
		{
			ret=HWTEST02_MAIN;
		}
		else
		if (!strcmp(tmp->val, "hwtest02_main_submit"))
		{
			ret=HWTEST02_MAIN_SUBMIT;
		}
		else
		if (!strcmp(tmp->val, "hwtest03_main"))
		{
			ret=HWTEST03_MAIN;
		}
		else
		if (!strcmp(tmp->val, "hwtest03_main_submit"))
		{
			ret=HWTEST03_MAIN_SUBMIT;
		}
		else
		if (!strcmp(tmp->val, "hwtest04_main"))
		{
			ret=HWTEST04_MAIN;
		}
		else
		if (!strcmp(tmp->val, "hwtest04_main_submit"))
		{
			ret=HWTEST04_MAIN_SUBMIT;
		}
		else
		if (!strcmp(tmp->val, "hwtest05_main"))
		{
			ret=HWTEST05_MAIN;
		}
		else
		if (!strcmp(tmp->val, "hwtest05_main_submit"))
		{
			ret=HWTEST05_MAIN_SUBMIT;
		}
		else
		if (!strcmp(tmp->val, "hwtest06_main"))
		{
			ret=HWTEST06_MAIN;
		}
		else
		if (!strcmp(tmp->val, "hwtest06_main_submit"))
		{
			ret=HWTEST06_MAIN_SUBMIT;
		}
	}
	return ret;
}

int quick_replace(FILE *fptr, char *name, void *arg)
{
	if (!strcmp(name, "test"))
	{
	}
	else
		return CGI_REPLACE_FAIL;
	return CGI_REPLACE_OK;
}

int main()
{
	INPUT	*input = NULL;
	int	func, ret=0;

	CGI_Init();
	CGI_Check_User();
	input=CGI_Get_Input();
	func=get_func(input);

	switch (func)
	{
		case HWTEST_NONE:
			break;
		case HWTEST_MAIN:
                        ret=do_hwtest_main(input);
                        break;
                case HWTEST_MAIN_SUBMIT:
                        ret=do_hwtest_main_submit(input);
                        break;
		case HWTEST00_MAIN:
			ret=do_hwtest00_main(input);
			break;
		case HWTEST00_MAIN_SUBMIT:
			ret=do_hwtest00_main_submit(input);
			break;
		case HWTEST01_MAIN:
			ret=do_hwtest01_main(input);
			break;
		case HWTEST01_MAIN_SUBMIT:
			ret=do_hwtest01_main_submit(input);
			break;
		case HWTEST02_MAIN:
			ret=do_hwtest02_main(input);
			break;
		case HWTEST02_MAIN_SUBMIT:
			ret=do_hwtest02_main_submit(input);
			break;
		case HWTEST03_MAIN:
			ret=do_hwtest03_main(input);
			break;
		case HWTEST03_MAIN_SUBMIT:
			ret=do_hwtest03_main_submit(input);
			break;
		case HWTEST04_MAIN:
			ret=do_hwtest04_main(input);
			break;
		case HWTEST04_MAIN_SUBMIT:
			ret=do_hwtest04_main_submit(input);
			break;
		case HWTEST05_MAIN:
			ret=do_hwtest05_main(input);
			break;
		case HWTEST05_MAIN_SUBMIT:
			ret=do_hwtest05_main_submit(input);
			break;
		case HWTEST06_MAIN:
                        ret=do_hwtest06_main(input);
                        break;
                case HWTEST06_MAIN_SUBMIT:
                        ret=do_hwtest06_main_submit(input);
                        break;
	}
	CGI_Free_Input(input);
	return HWTEST_SUCCESS;
}

