//**************************************************************************
//
//	Copyright (c) 2000-2002  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		mb.c
//
//	Abstract:
//		multi-bytes processing.
//
//	HISTORY:
//		12/12/01 KW Lee - Created
//
//**************************************************************************
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <sys/file.h>

#include "uLinux.h"
#include "Util.h"
#include "../include/config.h"
#include "shm_conf.h"	// Catherine 2001/12/20
#include "nas_lib_common.h"

#define ILLEGAL_CHAR		"\"/\\+=:|*?<>[];,%`"

extern int Open_File(char* , int, FILE** );
extern int Close_File(char* , int, FILE*);
extern char* skip_white_space(char*);
extern char* get_string_until_ch(char*, char, char*, int);
extern int is_commented_string(char*);
extern int find_char_in_string(char*, char);
//extern char* stripe_white_space_tail(char*);


int conf_get_field(char *conf_file, char *section, char *field, char *result, int buf_size)
{
//	char *in_section = NULL;
	FILE *fp = NULL;
	char section_name[SECTION_NAME_MAX_LENGTH] = "";
	char p[BUF_SIZE], *q;
	int section_found = 0;
	int i = 0;


//usleep(300);
	if ((i = Open_File(conf_file,O_RDONLY, &fp)) != SUCCESS)
		return i;
	
	rewind(fp);
	if (EMPTY_STRING(section)) section_found = 1;

	while ((fgets(p, BUF_SIZE, fp)) != NULL) {
//		printf("Line %d: %s\n", ++i, p);
		q = skip_white_space(p);
		if (*q == '[') {	//start of section name...
			if (get_string_until_ch(q+1, ']', section_name, sizeof(section_name)) != NULL) {
//				printf("FOUND SECTION NAME [%s]\n", section_name);
				if (section_found) 		// already scan the whole section...
					break;
				if (strcasecmp(section_name, section) == 0)
					section_found = 1;
			}
		}
		else
		if (section_found) {
//			if (*q == ';' || *q == '#') {
			if (is_commented_string(q)) {
				continue;
			}
			else {		// not a section declaration, should be field data...
				char buf[FIELD_NAME_MAX_LENGTH] = "";
				if (get_string_until_ch(q, '=', buf, sizeof(buf)) == NULL)
					continue;
				if (strcasecmp(field, buf) == 0) {
					int j;
					q = q + find_char_in_string(q, '=') + 1;	// skip to the next character after '='
					q = skip_white_space(q);
					if (NULL != result) {
						result[0]='\0'; //empty string
						j = strlen(q);
						if (j+1 > buf_size) {
							j = buf_size - 1;
							strncpy(result, q, j);
							result[j] = '\0';
							stripe_white_space_tail(result);
							Close_File(conf_file,O_RDONLY,fp);
							return ERROR_BUFFER_TOO_SMALL;
						}
						else {
							strncpy(result, q, j);
							result[j] = '\0';
							stripe_white_space_tail(result);
							Close_File(conf_file,O_RDONLY,fp);
							return SUCCESS;
						}

//						printf("FOUND FIELD {%s} = {%s}\n", buf, result);
					}
					else { 
						Close_File(conf_file,O_RDONLY,fp);
						return (strlen(q)+1); //return required buffer length
					}
				}
			}
		}
	}
	Close_File(conf_file,O_RDONLY,fp);
	return ERROR_NOT_FOUND;
}

/*
int  get_system_codepage()
{
	char *str;
	int code=0;
	
	if (SHM_Get_Config((int)SHM_KEY_CODEPAGE, (int)SHM_CODEPAGE_SIZE,
		DEFAULT_CFG_FILE, "System", "code page", &str)==SUCCESS) {
		code = atoi(str);
		free(str);
	}
	return (code);
}
*/

//----------------------------------------------------------------------
//	Check if characters of string that str are all space characters.
//	return value: TRUE	The characters are space characters.
//      	      FALSE	
//----------------------------------------------------------------------
BOOL is_black_str(char* str)
{
	/*int i, len;
	
	len = strlen(str);
	for(i = 0; i < len; i++){
		if(str[i] != ' ')
			return FALSE;
	}
	return TRUE;*/
	int i = 0;
	while(str[i])
		if (str[i++] != ' ') return FALSE;
	return TRUE;			
}

//----------------------------------------------------------------------
//	Check if the character is traditional chinese.
//	return value: TRUE	The characters is traditional chinese.
//      	      FALSE	The characters is not traditional chinese.
//	Check rules:  Byte 0    0xA1~0xFE
//		      Byte 1	0x40~0x7E or 0xA1~0xFE			
//----------------------------------------------------------------------
BOOL is_tc_word(char *ch)
{
	/*unsigned char tmp_str[10];

	strncpy(tmp_str,ch, 2);*/
	
	unsigned char* tmp_str = (unsigned char*)ch;
	if (tmp_str[0] >=0xA1 && tmp_str[0]<=0xFE) {
		if((tmp_str[1]>=0x40 && tmp_str[1]<=0x7E) || (tmp_str[1]>=0xA1 && tmp_str[1]<=0xFE))
			return TRUE;
	}
	return FALSE;
}

//----------------------------------------------------------------------
//	Check if the character is simplified chinese.
//	return value: TRUE	The characters is simplified chinese.
//      	      FALSE	The characters is not simplified chinese.
//	Check rules:  Byte 0    0xA1~0xF7
//		      Byte 1	0xA1~0xFE			
//----------------------------------------------------------------------
BOOL is_sc_word(char *ch)
{
	/*unsigned char tmp_str[10];

	strncpy(tmp_str, ch, 2);*/
	unsigned char* tmp_str = (unsigned char*)ch;
	if(tmp_str[0] >= 0xA1 && tmp_str[0] <= 0xF7){
		if(tmp_str[1] >= 0xA1 && tmp_str[1] <= 0xFE)
			return TRUE;
	}
	return FALSE;
}

//----------------------------------------------------------------------
//	Check if the character is japanese.
//	return value: TRUE	The characters is japanese.
//      	      FALSE	The characters is not japnese.
//	Check rules:  Byte 0    0x81~0x9F or 0xE0~0xEF
//		      Byte 1	0x40~0x7E or 0x80~0xFC		
//----------------------------------------------------------------------
BOOL is_jis_word(char *ch)
{
	/*unsigned char tmp_str[10];

	strncpy(tmp_str, ch, 2);*/
	unsigned char* tmp_str = (unsigned char*)ch;
	if((tmp_str[0] >= 0x81 && tmp_str[0] <= 0x9F) || (tmp_str[0] >= 0xE0 && tmp_str[0] <= 0xEF)){
		if((tmp_str[1] >= 0x40 && tmp_str[1] <= 0x7E) || (tmp_str[1] >= 0x80 && tmp_str[1] <= 0xFC))
			return TRUE;
	}
	return FALSE;
}

//----------------------------------------------------------------------
//	Check if the character is korea.
//	return value: TRUE	The characters is korea.
//      	      FALSE	The characters is not korea.
//	Check rules:  Byte 0    0xA1~0xFE 
//		      Byte 1	0x80~0xFF		
//----------------------------------------------------------------------
BOOL is_korea_word(char *ch)
{
	/*unsigned char tmp_str[10];

	strncpy(tmp_str, ch, 2);*/
	unsigned char* tmp_str = (unsigned char*)ch;
	if(tmp_str[0] >= 0xA1 && tmp_str[0] <= 0xFE){
		if(tmp_str[1] >= 0x80 && tmp_str[1] <= 0xFF)
			return TRUE;
	}
	return FALSE;
}

//Add by john 2001-10-15
BOOL Is_Mb_Word(char *ch)
{
	int val;
	val=Get_System_Codepage();
//	val = get_system_codepage();
	switch(val){
	case 950:
		if(is_tc_word(ch))	return TRUE;
		break;
	case 936:
		if(is_sc_word(ch))	return TRUE;
		break;
	case 932:
		if(is_jis_word(ch))	return TRUE;
		break;
	case 949:
		if(is_korea_word(ch))	return TRUE;
		break;
	default:
		break;
	}
	return FALSE;
}
//end of add

//Add by john 2001-10-15
BOOL Is_Mb_String(char *str)
{
	char* p = str;
	if(p){
		while( *p != '\0'){
			if(Is_Mb_Word(p))
				return TRUE;
			p++;
		}
	}
	return FALSE;
}
//end of add:

// Catherine 2001/12/18
BOOL Is_Mb_Word_By_Codepage(char *ch, int codepage)
{
	switch(codepage){
	case 950:
		if(is_tc_word(ch))	return TRUE;
		break;
	case 936:
		if(is_sc_word(ch))	return TRUE;
		break;
	case 932:
		if(is_jis_word(ch))	return TRUE;
		break;
	case 949:
		if(is_korea_word(ch))	return TRUE;
		break;
	default:
		break;
	}
	return FALSE;
}

BOOL Is_Legal_String(char *str)
{
	char *illegal_str = ILLEGAL_CHAR;
	char* p = str;
	if(p){
		if(strlen(p) == 0 || is_black_str(p))
			return FALSE;
		while( *p != '\0'){
			if(Is_Mb_Word(p)) {
				p += 2;
			}
			else {
				if(strchr(illegal_str, *p) != NULL)
					return FALSE;
				p++;
			}
		}
	}
	return TRUE;
}

int mb_strcmp(char *s1, char *s2)
{
	int len, l1, l2, i, cnt = 0;
	int mask = 0;
	int code;

	if(s1 == NULL || s2 == NULL)
		return -1;

	l1 = strlen(s1);
	l2 = strlen(s2);
	if(l1 != l2)
		return (l1 - l2);

//	code = get_system_codepage();
	code=Get_System_Codepage();
	len = l1;
	for(i = 0; i < len; i += cnt) {
		mask = 0;
		/* Catherine 2001/12/18
		if(Is_Mb_Word(s1))
			mask |= 0x01;
		if(Is_Mb_Word(s2))
			mask |= 0x02;
		*/
		 if (Is_Mb_Word_By_Codepage(s1, code))
			mask |= 0x01;
		if(Is_Mb_Word_By_Codepage(s2, code))
			mask |= 0x02;
			
		cnt = 1;
		switch(mask) {
			case 0:
				if(strncmp(s1, s2, cnt))
					return 1;
				break;
			case 1:
			case 2:
				return 1;
				break;
			case 3:	// mb word
				cnt = 2;
				if(strncmp(s1, s2, cnt))
					return 1;
				break;
		}
		s1 += cnt;
		s2 += cnt;
	}
	return 0;
}

int mb_strcasecmp(char *s1, char *s2)
{
	int len, l1, l2, i, cnt = 0;
	int mask = 0;
	int code;

	if(s1 == NULL || s2 == NULL)
		return -1;

	l1 = strlen(s1);
	l2 = strlen(s2);
	if(l1 != l2)
		return (l1 - l2);

//	code = get_system_codepage();
	code=Get_System_Codepage();
	len = l1;
	for(i = 0; i < len; i += cnt) {
		mask = 0;
		/* Catherine 2001/12/18
		if(Is_Mb_Word(s1))
			mask |= 0x01;
		if(Is_Mb_Word(s2))
			mask |= 0x02;
		*/
		 if (Is_Mb_Word_By_Codepage(s1, code))
			mask |= 0x01;
		if(Is_Mb_Word_By_Codepage(s2, code))
			mask |= 0x02;

		cnt = 1;
		switch(mask) {
			case 0:
				if(strncasecmp(s1, s2, cnt))
					return 1;
				break;
			case 1:
			case 2:
				return 1;
				break;
			case 3:	// mb word
				cnt = 2;
				if(strncmp(s1, s2, cnt))
					return 1;
				break;
		}
		s1 += cnt;
		s2 += cnt;
	}
	return 0;
}

