#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dirent.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <uLinux.h>

BOOL Is_Exist_Another_Instance(char *progname)
{
        DIR             *dir;
        struct dirent   *d;
        char            path[256];
        char            buf[256];
        char            *s, *q;
        FILE            *fp;
        int             pid;
        int             status;

        status=FALSE;
        s=strrchr(progname, '/');
        if (s!=NULL)
                progname=s+1;
        if ((dir = opendir("/proc")) == NULL)
                return status;
        while (status==FALSE && (d=readdir(dir))!=NULL)
        {
                if ((pid=atoi(d->d_name))==0)
                        continue;
                if (pid==getpid())
                        continue;

                // Open the statistics file.
                sprintf(path, "/proc/%s/stat", d->d_name);
                // Read program name from it.
                if ((fp=fopen(path, "r"))!=NULL)
                {
                        buf[0]=0;
                        fgets(buf, 256, fp);

                        s=strchr(buf, '(');
                        q=strrchr(buf, ')');
                        if (s!=NULL && q!=NULL)
                        {
                                s++;
                                *q=0;
                                if (!strcmp(s, progname))
                                        status=TRUE;
                        }
                        fclose(fp);
                }
        }
        closedir(dir);
        return status;
}

int Become_Daemon()
{
        pid_t pid;

        pid=fork();

        if (pid<0)
                return FALSE;
        else
        if (pid>0) //parent
                exit(0);
        if (setsid()<0)
                return FALSE;
        chdir("/");
        umask(0);
        return TRUE;
}

