#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <time.h>

#include "file_lock.h"

//#define _DEBUG		1

/* show error lock file information	*/
void err_lock(LOCK_INFO	*lock)
{/*Shone marked for this message disturbs the web page sometimes 2005,11,25
	fprintf(stderr, "lock pid = [%d]\n", lock->pid);
	fprintf(stderr, "lock time = [%d]\n", lock->time);
	fprintf(stderr, "lock type = [%c]\n", lock->type);
	fprintf(stderr, "current time = [%d]\n", (int)time(NULL));*/
}

/* get exact filename	*/
char *get_filename(char *filename)
{
	char	*ptr;

	ptr=strrchr(filename, (int)'/');
	return (ptr==NULL)?filename:ptr+1;
}

int timeout(int locktime)
{
	int	now=time(NULL);

	if ((now-locktime)>FILE_LOCK_TIMEOUT)
		return 1;
	return 0;
}

int NAS_File_Lock(char *filename, char type)
{
	char		*ptr, lckfile[256];
	int		fd;
	int		try=MAX_TRY;
	LOCK_INFO	lock;

	/* get lck file, ex: /var/lock/NAS/uLinux.lck	*/
	ptr=get_filename(filename);
	sprintf(lckfile, "%s/%s.lck", LOCK_PATH, ptr);

	while (try)
	{
		fd=open(lckfile, O_RDWR | O_CREAT | O_EXCL, 0777);
		if (fd!=-1)
			break;
		try--;
#ifdef _DEBUG
		fprintf(stderr, "lock %s fail, retry again..., times=%d\n", filename, (MAX_TRY-try));
#endif
		fd=open(lckfile, O_RDONLY);
		if (fd==-1)
			continue;
		if (read(fd, &lock, sizeof(lock))!=sizeof(lock))
		{
			close(fd);
			goto retry;
		}
		if (timeout(lock.time))
		{	/************************************************/
			/* timeout, so retry again			*/
			/* if enter this state, code may be error	*/
			/* some process may not use File_Unlock() or	*/
			/* or some process may be died			*/
			/* this state will never happened		*/
			/************************************************/
			close(fd);
			unlink(lckfile);
#ifdef _DEBUG
			fprintf(stderr, "detect timeout, unlink %s...\n", filename);
#endif
			err_lock(&lock);
			continue;
		}
		else
			close(fd);
retry:
		/********************************************************/
		/* delay...may use usleep to reduce the delay time	*/
		/* but the lock will get more collection		*/
		/* use thread test program to see what happened		*/
		/********************************************************/
		sleep(1);
	}
	if (fd==-1 || try==0)
	{	/* lock fail	*/
#ifdef _DEBUG
		fprintf(stderr, "lock %s timeout...fail...\n", filename);
#endif
		return 0;
	}
	lock.time=time(NULL);
	lock.pid=getpid();
	lock.type=type;
	if (write(fd, &lock, sizeof(lock))!=sizeof(lock))
	{	/* write error, may be some process detect timeout, and unlink the lock	*/
		/* so return lock fail							*/
		close(fd);
		unlink(lckfile);
		return 0;
	}
	close(fd);
	return 1;
}

int NAS_File_Unlock(char *filename)
{
	char	*ptr, lckfile[256];

	/* unlock file, just delete the lck file	*/
	ptr=get_filename(filename);
	sprintf(lckfile, "%s/%s.lck", LOCK_PATH, ptr);
	if (unlink(lckfile)<0)
	{
#ifdef _DEBUG
		fprintf(stderr, "unlock %s warning, someone kill my lock file", filename);
#endif
	}
	return 1;
}

