//**************************************************************************
//
//	Copyright (c) 2000  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		timezone.h
//
//	Abstract: 
//		Common header for timezone definition.
//
//	FUNCTIONS:	TBD.
//
//	COMMENTS: 	N/A
//
//	HISTORY:
//		12/07/00	Meiji Chang created
//
//**************************************************************************

#ifndef TIMEZONE_H
#define TIMEZONE_H

#define	WINDOWS_TIMEZONE_MAX		63	
#define	LINUX_TIMEZONE_MAX		63	

#ifdef __TIME_ZONE__
char *timezone_Windows[WINDOWS_TIMEZONE_MAX] = 
	{
		"(GMT-12:00) Eniwetok,Kwajalein",
		"(GMT-11:00) MidwayIsland,Samoa",
		"(GMT-10:00) Hawaii",
		"(GMT-09:00) Alaska",
		"(GMT-08:00) Pacific Time(US & Canada); Tijuana",
		"(GMT-07:00) Arizona",
		"(GMT-07:00) Mountain Time(US & Canada)",
		"(GMT-06:00) Central Time(US & Canada)",
		"(GMT-06:00) Mexico City, Tegucigalpa",
		"(GMT-06:00) Saskatchewan",
		"(GMT-05:00) Bogota, Lima, Quito",
		"(GMT-05:00) Eastern Time(US & Canada)",
		"(GMT-05:00) Indiana(East)",
		"(GMT-04:00) Atlantic Time(Canada)",
		"(GMT-04:00) Caracas, La Paz",
		"(GMT-04:00) Santiago",
		"(GMT-03:30) Newfoundland",
		"(GMT-03:00) Brasilia",
		"(GMT-03:00) Buenos Aires, Georgetown",
		"(GMT-02:00) Mid-Atlantic",
		"(GMT-01:00) Azores, Cape Verde Is.",
		"(GMT) Casablanca, Monrovia",
		"(GMT) Greenwich Mean Time : Dublin, Edinburgh, Lisbon, London",
		"(GMT+01:00) Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna",
		"(GMT+01:00) Belgrade, Bratislava, Budapest, Ljubljana, Prague",
		"(GMT+01:00) Brussels, Copenhagen, Madrid, Paris, Vilnius",
		"(GMT+01:00) Sarajevo, Skopje, Sofija, Warsaw, Zagreb",
		"(GMT+02:00) Athens, Istanbul, Minsk",
		"(GMT+02:00) Bucharest",
		"(GMT+02:00) Cairo",
		"(GMT+02:00) Harare, Pretoria",
		"(GMT+02:00) Helsinki, Riga, Tallinn",
		"(GMT+02:00) Israel",
		"(GMT+03:00) Baghdad, Kuwait, Riyadh",
		"(GMT+03:00) Moscow, St. Petersburg, Volgograd",
		"(GMT+03:00) Nairobi",
		"(GMT+03:30) Tehran",
		"(GMT+04:00) Abu Dhabi, Muscat",
		"(GMT+04:00) Baku, Tbilisi",
		"(GMT+04:30) Kabul",
		"(GMT+05:00) Eekaterinburg",
		"(GMT+05:00) Islamabad, Karachi, Tashkent",
		"(GMT+05:30) Bombay, Calcutta, Madras, New Delhi",
		"(GMT+06:00) Almaty, Dhaka",
		"(GMT+06:00) Colombo",
		"(GMT+07:00) Bangkok, Hanoi, Jakarta",
		"(GMT+08:00) Beijing, Chongqing, Hong Kong, Urumqi",
		"(GMT+08:00) Perth",
		"(GMT+08:00) Singapore",
		"(GMT+08:00) Taipei",
		"(GMT+09:00) Osaka, Sapporo, Tokyo",
		"(GMT+09:00) Seoul",
		"(GMT+09:00) Yakutsk",
		"(GMT+09:30) Adelaide",
		"(GMT+09:30) Darwin",
		"(GMT+10:00) Brisbane",
		"(GMT+10:00) Canberra, Melbourne, Sydney",
		"(GMT+10:00) Guam, Port Moresby",
		"(GMT+10:00) Hobart",
		"(GMT+10:00) Vladivostok",
		"(GMT+11:00) Magadan, Solomon Is., New Caledonia",
		"(GMT+12:00) Auckland, Wellington",
		"(GMT+12:00) Fiji, Kamchatka, Marshall Is."
	};

char *timezone_Linux[LINUX_TIMEZONE_MAX]=
	{
		"Pacific/Kwajalein",
		"Pacific/Midway",
		"Pacific/Honolulu",
		"America/Anchorage",
		"America/Tijuana",
		"America/Phoenix",
		"US/Mountain",
		"US/Central",
		"America/Mexico_City",
		"America/Regina",
		"America/Bogota",
		"US/Eastern",
		"US/East-Indiana",
		"Canada/Atlantic",
		"America/Caracas",
		"America/Santiago",
		"America/St_Johns",
		"America/Buenos_Aires",
		"America/Buenos_Aires",
		"Atlantic/South_Georgia",
		"Atlantic/Azores",
		"Africa/Casablanca",
		"Europe/London",
		"Europe/Amsterdam",
		"Europe/Belgrade",
		"Europe/Paris",
		"Europe/Sarajevo",
		"Europe/Athens",
		"Europe/Bucharest",
		"Africa/Cairo",
		"Africa/Harare",
		"Europe/Helsinki",
		"Africa/Harare",    // same as 30
		"Asia/Baghdad",
		"Europe/Moscow",
		"Asia/Baghdad",    // same as 33
		"Asia/Tehran",
		"Asia/Muscat",
		"Asia/Baku",
		"Asia/Kabul",
		"Asia/Yekaterinburg",
		"Asia/Karachi",
		"Asia/Calcutta",
		"Asia/Almaty",
		"Asia/Colombo",
		"Asia/Bangkok",
		"Asia/Hong_Kong",
		"Australia/Perth",
		"Asia/Singapore",
		"Asia/Taipei",
		"Asia/Tokyo",
		"Asia/Seoul",
		"Asia/Yakutsk",
		"Australia/Adelaide",
		"Australia/Darwin",
		"Australia/Brisbane",
		"Australia/Melbourne",
		"Pacific/Guam",
		"Australia/Hobart",
		"Asia/Vladivostok",
		"Asia/Magadan",
		"Pacific/Auckland",
		"Pacific/Fiji"		                                          
	};

int timezone_Position[LINUX_TIMEZONE_MAX]=
	{
		-1200,
		-1100,
		-1000,
		-900,
		-800,
		-700, -700,
		-600, -600, -600,
		-500, -500, -500,
		-400, -400, -400,
		-350, -300, -300,
		-200,
		-100,
		0, 0,
		100, 100, 100, 100,
		200, 200, 200, 200, 200, 200,
		300, 300, 300, 350,
		400, 400, 450,
		500, 500, 550,
		600, 600,
		700,
		800, 800, 800, 800,
		900, 900, 900, 950, 950,
		1000, 1000, 1000, 1000, 1000,
		1100,
		1200, 1200
	};


char *timezone_mapping[WINDOWS_TIMEZONE_MAX] = 
	{
		"MHT12",
		"SST11",
		"HST10",
		"AKST9AKDT8",
		"PST8PDT7",
		"MST7",
		"MST7MDT6",
		"CST6",
		"CST6CDT5",
		"CST6",
		"COT5",
		"EST5EDT4",
		"EST5",
		"AST4ADT3",
		"VET4",
		"CLST3CLT4,M3.2.0/00:00:00,M10.2.0/00:00:00",
		"NST3:30NDT2:30",
		"BRST2BRT3,M2.3.0/00:00:00,M10.2.0/00:00:00",
		"ARST3ART4,M3.1.0/00:00:00,M10.1.0/00:00:00",
		"GST2",
		"AZOT1AZOST0",
		"WET0",
		"GMT0IST-1",
		"CET-1CEST-2",
		"CET-1CEST-2",
		"CET-1CEST-2",
		"CET-1CEST-2",
		"EET-2EEST-3",
		"EET-2",
		"EET-2EEST-3,M4.5.5/00:00:00,M9.5.4/23:00:00",
		"CAT-2",
		"EET-2EEST-3",
		"IST-2IDT-3,M3.5.5/01:00:00,273/01:00:00",
		"ADT-3",
		"MSK-3MSD-4",
		"EAT-3",
		"IRT-3:30IRST-4:30,79/00:00:00,265/00:00:00",
		"GST-4",
		"GET-4GEST-5",
		"AFT-4:30",
		"YEKT-5",
		"PKT-5",
		"IST-5:30",
		"ALMT-6ALMST-7",
		"LKT-6",
		"ICT-7",
		"HKT-8",
		"WST-8",
		"SGT-8",
		"CST-8",
		"JST-9",
		"KST-9",
		"YAKT-9YAKST-10",
		"CST-10:30CST-9:30",
		"CST-9:30",
		"EST-10",
		"EST-11EST-10,M3.5.0/02:00:00,M10.5.0/02:00:00",
		"GST-10",
		"EST-11EST-10,M3.5.0/02:00:00,M10.1.0/02:00:00",
		"VLAT-10VLAST-11",
		"MAGT-11MAGST-12,M3.5.0/02:00:00,M10.5.0/03:00:00",
		"NZDT-13NZST-12,M3.3.0/02:00:00,M10.1.0/02:00:00",
		"FJST-13FJT-12,M2.5.0/02:00:00,M11.1.0/02:00:00"
	};


//#define	WINDOWS_TIMEZONE_MAX	(sizeof(timezone_Windows) / sizeof(timezone_Windows[0]))
//#define	LINUX_TIMEZONE_MAX	(sizeof(timezone_Linux) / sizeof(timezone_Linux[0]))

#else

extern char *timezone_Windows[]; 
extern char *timezone_Linux[];

#endif


#endif



