//**************************************************************************
//
//	Copyright (c) 2001  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		interface.c
//
//	Abstract: 
//		 interface function for physical and logical disk operation
//
//	HISTORY:
//		2002/03/24	Catherine Shen -- remove the code of mounting root partition
//					before checking hidden conf file in "Verify_Hidden_Conf_File()"
//		2001/5/21	Louis Tsai created - Get_MP_String() haven't check raid
//
//**************************************************************************
#include "storage.h"
#include "storage_err.h"
#include "config.h" 
#include <ctype.h>
#include <dirent.h>
#include <cfg_nic.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#define min(a, b) ((a > b) ? b : a)

int create_file(char *filename)
{
	FILE *fd;
	if((fd=fopen(filename,"w")) <0)
		return 	ERROR_FAIL;
	fclose(fd);
	return SUCCESS;
}

void get_drive_alphabetic_order(int hd_no, char start_char, char* out_buf, int buf_size)
{
	int q, r, i=0;

	if (hd_no <= 0 || out_buf == NULL || buf_size <= 0)
		return;

	memset(out_buf, 0, buf_size);
	q = hd_no-1;

	do {
		r = q % 26;
		q = q / 26;
		out_buf[i++] = start_char + r;
	} while (q-- > 0);

	if (strlen(out_buf) > 1) { // reverse tmp string
		char c;
		char *head, *tail;

		head = out_buf;
		tail = out_buf + strlen(out_buf) - 1;

		while (head < tail) {
			c = *tail;
			*tail-- = *head;
			*head++ = c;
		}
	}
}

int get_drive_no_by_alphabetic_order(char start_char, char* in_buf)
{
	int drvno = 0;
	char *p = in_buf;

	while (p && *p) {
		drvno = drvno * 26 + (*p - start_char) + 1;
		p++;
	}
	return drvno;
}

void prepare_mp_path(char* mp_path)
{
	struct stat pstat;

	// path already exists
	if (stat(mp_path, &pstat) == 0 && S_ISDIR(pstat.st_mode))
		return;

	// create a new mount point
	mkdir(mp_path, 0755);
}

int Get_HD_DevName(int drive_no, char *device_name)
{
	int ret;
	char key_str[BUF_SIZE];
	char tmp_str[BUF_SIZE];

	sprintf(key_str,"Drive %d",drive_no);
	ret = GetProfileString("Storage",key_str,"",device_name,HD_DEVICE_NAME_LENGTH);
	
	if (ret >0) {
		sprintf(tmp_str,"/dev/%s",device_name);	
		strcpy(device_name,tmp_str);
		return strlen(device_name);
	}
	
	return ret;
}

//get singal disk partition name

int Get_Partition_Name(int drive_no, int which_part,char *part_name)
{
	int ret;
	char key_str[BUF_SIZE];
	char tmp_str[BUF_SIZE];
	
	sprintf(key_str,"Drive %d",drive_no);
	ret = GetProfileString("Storage",key_str,"",part_name,HD_DEVICE_NAME_LENGTH);
	if (ret >0) {
		sprintf(tmp_str,"/dev/%s%d",part_name,which_part);	
		strcpy(part_name,tmp_str);
		return SUCCESS;
	}
	else
		return ERROR_FAIL;		
}

int Get_Partition_Name_Ex(char* dev_name, int which_part,char *part_name)
{
	if(strncasecmp(dev_name, "/dev/", 5))
		return ERROR_FAIL;

	sprintf(part_name,"%s%d",dev_name,which_part);	
	return SUCCESS;
}	

int Get_MP_String(int drive_no, int which_part,char *mp_name)
{
	char tmp_raid_name[HD_DEVICE_NAME_LENGTH];
	char *name_ptr;
	switch(which_part) {
		case ROOT_PART:
			get_drive_alphabetic_order(drive_no, 'A', tmp_raid_name,
				sizeof(tmp_raid_name));
			sprintf(mp_name, MP_ROOT_PATH_FORMAT, tmp_raid_name);
			break;
		case DATA_PART:
			if(Is_Raid_HD(drive_no,tmp_raid_name,HD_DEVICE_NAME_LENGTH)) {
				char raidname[HD_DEVICE_NAME_LENGTH];

				name_ptr = strrchr(tmp_raid_name,'/')+3;
				sprintf(raidname, "MD%d", atoi(name_ptr));
				sprintf(mp_name,MP_RD_DATA_PATH_FORMAT, raidname);
			}
			else {
				get_drive_alphabetic_order(drive_no, 'A', tmp_raid_name,
					sizeof(tmp_raid_name));			
				sprintf(mp_name,MP_SD_DATA_PATH_FORMAT,tmp_raid_name);
			}
			break;
		default:
			return ERROR_FAIL;
	}
	prepare_mp_path(mp_name);
	return SUCCESS;
}

int Get_Drive_No(char *device_name)
{
	int ret,len;
	char key_str[BUF_SIZE];
	char tmp_str[BUF_SIZE];
	char tmpdev[HD_DEVICE_NAME_LENGTH];
	int i=1;
	char *tmp_ptr;

	len = (strlen(device_name)>HD_DEVICE_NAME_LENGTH-1)? (HD_DEVICE_NAME_LENGTH-1) : strlen(device_name);
	strncpy(tmpdev, device_name, len);		
	tmpdev[len] = 0x0;

	tmp_ptr = strrchr(tmpdev,'/')+1;
	if( (len=strlen(tmp_ptr))>= 4){
		for(i=len-1;i>2;i--) 
			if(isdigit(tmp_ptr[i])) tmp_ptr[i] = '\0';
	}
	
	i=1;
	do {
		sprintf(key_str,"Drive %d",i);
		ret = GetProfileString("Storage",key_str,"",tmp_str,BUF_SIZE);
		if ( strcasecmp(tmp_str,tmp_ptr)==0 )
			return i;		
		i++;
	}while(ret>0);
	return ERROR_NOT_FOUND;
	
}

int Verify_Hidden_Conf_File(int drive_no)
{
	char embed_conf_file[BUF_SIZE];
	char m_address[BUF_SIZE], m_name[HD_DEVICE_NAME_LENGTH];
//	char	hwaddr[80], device_name[HD_DEVICE_NAME_LENGTH];
	int  ret;

	if((ret = Get_Hidden_Conf_File_Name(drive_no,embed_conf_file)) <0)
     		return ERROR_FAIL;
/*
	if (NIC_Count_Interface()==2)
		NIC_Get_HWADDR(hwaddr, 80, NIC_WAN_DEFAULT);
	else
		NIC_Get_HWADDR(hwaddr, 80, NIC_LAN01_DEFAULT);
*/
 	 /*------  Get HD Device Name --------*/
//  	if ( (ret=Get_HD_DevName(drive_no, device_name)) <0) 
//  		return ret;

     	ret = Conf_Get_Field(embed_conf_file,"","hw_addr",m_address,BUF_SIZE);
     	if (ret <0) {
		return ERROR_FAIL;
	}
  	ret = Conf_Get_Field(embed_conf_file,"","hd_name",m_name,HD_DEVICE_NAME_LENGTH);
     	if (ret <0) {
		return ERROR_FAIL;
	}
/*     
     	if(strcasecmp(m_name,device_name) !=0) {
		return ERROR_HD_DEVICE_NAME;
	}
	if (strcasecmp(hwaddr, m_address)!=0)
	{
*/		/* if (mac address != wan address) then check lan address)	*/
/*		if (NIC_Count_Interface()==2)
		{
			NIC_Get_HWADDR(hwaddr, 80, NIC_LAN01_DEFAULT);
			if (strcasecmp(hwaddr, m_address)!=0) {
				return ERROR_HD_MAC_ADDRESS;
			}
		}
		else {
			return ERROR_HD_MAC_ADDRESS;
		}
	}
*/
     	return SUCCESS;
}

int Create_Hidden_Dir(int drive_no){

        char device_name[BUF_SIZE], dirname[BUF_SIZE];
        char cmd[BUF_SIZE], abs_path[BUF_SIZE];;
        int ret=0;

        /*------  Get HD Device Name --------*/
        if ((ret = Get_HD_DevName(drive_no, device_name)) < 0)
                return ret;

        ret = Get_MP_String(drive_no,ROOT_PART, dirname);
	sprintf(abs_path, "%s/%s", dirname, ".config");

        sprintf(cmd, "/bin/mkdir -p %s", abs_path);
        ret = system(cmd);
	sprintf(cmd, "/bin/cp -a /etc/config/* %s", abs_path);
	system(cmd);
	sprintf(abs_path, "%s/%s", dirname, ".logs");
	sprintf(cmd, "/bin/mkdir -p %s", abs_path);
	system(cmd);
        return ret;
}

int Create_Hidden_Dir_Ex(int drive_no){

        char dirname[BUF_SIZE];
        char cmd[BUF_SIZE], abs_path[BUF_SIZE];;
        int ret=0;

        ret = Get_MP_String(drive_no,ROOT_PART, dirname);
	sprintf(abs_path, "%s/%s", dirname, ".config");

        sprintf(cmd, "/bin/mkdir -p %s", abs_path);
        ret = system(cmd);
	sprintf(cmd, "/bin/cp -a /etc/config/* %s", abs_path);
	system(cmd);
	sprintf(abs_path, "%s/%s", dirname, ".logs");
	sprintf(cmd, "/bin/mkdir -p %s", abs_path);
	system(cmd);
        return ret;
}

int Create_Hidden_Conf_File(int drive_no)
{
	char device_name[BUF_SIZE], embed_conf_file[BUF_SIZE];
//  	IFInfo eth0;
  	int  ret;
	char	hwaddr[80];

  	/*---------   Get MAC Address  -------------*/
//  	if ( Get_Network_Interface_Volatile(0, &eth0) <0) ;
/* modify by Kent 2001/01/07 */
        if (NIC_Count_Interface()==2)
                NIC_Get_HWADDR(hwaddr, 80, NIC_WAN_DEFAULT);
        else
                NIC_Get_HWADDR(hwaddr, 80, NIC_LAN01_DEFAULT);
 //    		return ERROR_GET_MAC_ADDRESS;

 	 /*------  Get HD Device Name --------*/
  	if ( (ret=Get_HD_DevName(drive_no, device_name)) <0) 
  		return ret;
  		
  	/*-----  Create & Write to Hidden Conf File --------*/
  	if((ret = Get_Hidden_Conf_File_Name(drive_no,embed_conf_file)) <0)
     		return ret;

  	/*-----------  prepare data  ----------*/
  	ret = create_file(embed_conf_file);
  	if (ret <0)	return ERROR_FAIL;
  	
//  	ret = Conf_Set_Field(embed_conf_file,"","hw_addr",eth0.hw_addr);
	ret = Conf_Set_Field(embed_conf_file, "", "hw_addr", hwaddr);
  	ret = Conf_Set_Field(embed_conf_file,"","hd_name",device_name);
  
/*????  
  	//-------  Append it to DS_CONF_FILE --------------------------
  	//-- I don't care it is exist or, just to write it, it will
  	//-- create a new one or overwrite it ( if it exist)
  	//-------------------------------------------------------------
  	Get_HD_String(hd, hd_name);
  	strcat(hd_name,"_NOEXIST");
  	strcpy(line,"0");
  	ret=WriteCFGData(DS_CONF_FILE, DISK_SESSION_NAME, hd_name, line);
  	if ( ret!=SUCCESS ) return  ret;
*/

	ret = Create_Hidden_Dir(drive_no);
	system("/etc/init.d/sysinit.sh start");
  	return ret;	
}

int Create_Hidden_Conf_File_Ex(int drive_no, char* dev_name)
{
	char embed_conf_file[BUF_SIZE];
  	int  ret;
	char	hwaddr[80];

        if (NIC_Count_Interface()==2)
                NIC_Get_HWADDR(hwaddr, 80, NIC_WAN_DEFAULT);
        else
                NIC_Get_HWADDR(hwaddr, 80, NIC_LAN01_DEFAULT);

  	if((ret = Get_Hidden_Conf_File_Name(drive_no,embed_conf_file)) <0)
     		return ret;

  	/*-----------  prepare data  ----------*/
  	ret = create_file(embed_conf_file);
  	if (ret <0)	return ERROR_FAIL;
  	
//  	ret = Conf_Set_Field(embed_conf_file,"","hw_addr",eth0.hw_addr);
	ret = Conf_Set_Field(embed_conf_file, "", "hw_addr", hwaddr);
  	ret = Conf_Set_Field(embed_conf_file,"","hd_name",dev_name);
  
	ret = Create_Hidden_Dir_Ex(drive_no);
	// 2005.11.07, Johnson Cheng
	// This function is used by QRAID1, don't start sysinit script.
	//system("/etc/init.d/sysinit.sh start");
  	return ret;	
}

int Get_Hidden_Conf_File_Name(int drive_no, char *filename)
{
	int ret;
	ret = Get_MP_String(drive_no,ROOT_PART,filename);
	if (ret <0) return ret;
	strcat(filename,HD_HIDDEN_CONF);
	return SUCCESS;
}


//============================================//
// check hd drive is exist and verify data in 
// .conf is correct
//============================================//

BOOL Is_HD_Ready(int drive_no)
{
	char device_name[HD_DEVICE_NAME_LENGTH];
	
	Get_HD_DevName(drive_no,device_name);
	if(!Is_HD_Exist(device_name)) return FALSE;
	if( Verify_Hidden_Conf_File(drive_no)<0 ) return FALSE;
	return TRUE;
}

BOOL Is_HD_Valid(int drive_no)
{
//	char device_name[HD_DEVICE_NAME_LENGTH];
	
//	Get_HD_DevName(drive_no,device_name);
//	if(!Is_HD_Exist(device_name)) return FALSE;
	if( Verify_Hidden_Conf_File(drive_no)<0 ) return FALSE;
	return TRUE;
}

int Get_FileSystem_Type() 
{
	char fs_type[20];
	int fs_no;
/* ReiserFS Support
	GetProfileString("SYSTEM","FS TYPE","",fs_type,20);
*/
	GetProfileString("SYSTEM","FS TYPE","ext3",fs_type,20);
	
	if(strcasecmp(fs_type,"reiserfs") == 0 ) 
		fs_no = REISER_FS;
	else if(strcasecmp(fs_type,"ext3") == 0 ) 
		fs_no = EXT3_FS;
	else
		fs_no = EXT2_FS;
		
	return fs_no;
}

BOOL Is_Disk_Path_Ready( char *real_path)
{
  	int  j;
  	char mp[64];
  	DIR *dp;
	
	int drive_no = Get_Profile_Integer(NASCONF_STORAGE_SECTION,NASCONF_DRIVE_NO_FIELD,0);
	
	dp = opendir(real_path);

	if (dp != NULL) 
		closedir(dp);
	else
		return FALSE;

  	for (j=1; j<drive_no+1; j++) {
    		if ( Get_MP_String(j,DATA_PART,mp) != SUCCESS)  continue;	
    		if ( strncmp(mp, real_path, strlen(mp))==0 ) { // equal
    			Get_Partition_Name(j,DATA_PART,mp);
      			if ( !Is_Mounted(mp))
				return FALSE;
      			break;
    		} 
 	 } 
	return TRUE;
}

// 2002/08/15 Catherine
// get the beginning number of the SWAP RAID devices
int Get_Swap_RAID_No_Base()
{
	int base;
 	int drive_cnt = Get_Profile_Integer(NASCONF_STORAGE_SECTION,NASCONF_DRIVE_NO_FIELD,0);

	base = min(drive_cnt, MAX_RAID_NO-drive_cnt/2);
	return base;
}
