#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <dirent.h>
#include <unistd.h>
#include <signal.h>
#include <time.h>
#include <ctype.h>
#include <stdlib.h>

#include <sys/ipc.h>
#include <sys/shm.h>

#include <userManager.h>

//#define _DEBUG		1
long locktime_timeout(time_t oldtime)
{
	long diff;
	time_t	t;

	t=time(NULL);
	diff=t-oldtime;
	return diff;
}

int shm_lock(USER_HEADER *header)
{
	int times=0;

repeat:
        if (header->lock==1 && locktime_timeout(header->locktime)<LOCK_TIMEOUT)
        {
                if (times>10)
                        return SHM_FAIL;
                sleep(1);
                times++;
                goto repeat;
        }

        header->locktime=time(NULL);
        header->lock=1;
	return SHM_SUCCESS;
}

void shm_unlock(USER_HEADER *header)
{
	header->lock=0;
}

int check_record(USER_INFO *user, time_t t)
{
        struct dirent 	*dir;
        DIR 		*proc;
	char 		path[256], buf[256];
	int 		pid, shmid, i;
	char 		*shm;
	USER_HEADER	*header;
	FILE		*fp;
	char		*s=NULL, *q;

	memset(buf, 0x0, 256);
	/* if not timeout, return valid */
	if (user->schedule==SCHEDULE_TIMEOUT)
	{
		if ((t-user->lasttime)<=MAX_TIME)
			return VALID;
	}
	else
	if (user->schedule==SCHEDULE_NO_TIMEOUT)
		return VALID;
	else
	if (user->schedule==SCHEDULE_NONE)
		return INVALID;

	/* check user from process, need to add */
        shmid=shmget((key_t)SHMKEY, SHMSIZE, 0666);
        if (shmid==-1)
        	return INVALID;
        shm=shmat(shmid, (char *)0, 0);
        if (shm==(char *)-1)
                return INVALID;
        header=(USER_HEADER *)shm;

        proc=opendir("/proc");
        while (dir=readdir(proc))
        {
                if (!strcmp(dir->d_name, ".") || !strcmp(dir->d_name, "..") || !isdigit(*dir->d_name))
                        continue;
		sprintf(path, "/proc/%s/stat", dir->d_name);
		// Read program name from it, and store program name in ptr "s"
		if ((fp=fopen(path, "r"))!=NULL)
		{
			buf[0]=0;
			fgets(buf, 256, fp);

			s=strchr(buf, '(');
			q=strrchr(buf, ')');
			if (s!=NULL && q!=NULL)
			{
				s++;
				*q=0;
			}
			fclose(fp);
		}
		if (user->schedule==SCHEDULE_PID)
		{
			pid=atol(dir->d_name);
			if (user->pid==pid)
			{
        	                pid=atol(dir->d_name);
				for (i=0;i<header->totalapp;i++)
				{	/* get app id */
					if (!strcmp(s, header->app[i].regname))
					{	/* if appid are the same, return valid */
						if (header->app[i].id==user->app_id)
						{
							goto valid_record;
						}
					}
				}
				goto invalid_record;
			}
		}
		else
		{
        	        pid=atol(dir->d_name);
			if (!strcmp(s, "thttpd"))
			{	/* reset header->tmpuser */
				strcpy(header->tmpuser.username, "");
				strcpy(header->tmpuser.ip, "");
				header->tmpuser.app_id=0;

				header->sid=pid;	/* record signal id */
/*				kill(pid, SIGUSR2);
				for (i=0;i<3;i++)
				{
					if (header->sid==0)
						break;
					sleep(1);
				}*/
				if (!strcmp(header->tmpuser.username, user->username) && !strcmp(header->tmpuser.ip, user->ip)
					&& header->tmpuser.app_id==user->app_id)
					goto valid_record;
			}
		}
        }
invalid_record:
        closedir(proc);
	shmdt(shm);
	return INVALID;
valid_record:
	closedir(proc);
	shmdt(shm);
	return VALID;
}

int find_user(USER_INFO *user, USER_INFO *new, int total)
{
	time_t	t;
	int	i;

	t=time(NULL);
	for (i=0;i<total;i++)
	{
		if (!strcmp(user->username, new->username) && !strcmp(user->ip, new->ip) && user->app_id==new->app_id)
		{
			if (user->lasttime==0)	/* refresh set to 0 */
				return SHM_FAIL;
			if (check_record(user, t)==INVALID)
			{	/* find user, but is not valid */
				return SHM_FAIL;
			}
			else
			{	/* find user, and modify user last time */
				new->logintime=user->logintime;
				new->lasttime=t;
				return i;
			}
		}
		user=user+1;
	}
	return SHM_FAIL;
}

int free_user(USER_INFO *user, USER_INFO *new, int total)
{
	time_t	t;
	int	i;

	t=time(NULL);
	for (i=0;i<total;i++)
	{
		if (check_record(user, t)==INVALID)
		{
			/* invalid record, this is a free record */
			new->logintime=new->lasttime=t;
			return i;
		}
		user=user+1;
	}
	return SHM_FAIL;
}

void remove_record(USER_INFO *user)
{
	user->lasttime=0;
	user->schedule=SCHEDULE_NONE;
	user->pid=0;
}

int shm_refresh_record()
{
//        int             shmid, i, ret, times=0;
	int             shmid, i;
        char            *shm;
        USER_HEADER     *header;
        USER_INFO       *user;
        time_t          t;

        shmid=shmget((key_t)SHMKEY, SHMSIZE, 0666);
        if (shmid==-1)
                return SHM_FAIL;
        shm=shmat(shmid, (char *)0, 0);
        if (shm==(char *)-1)
                return SHM_FAIL;
        header=(USER_HEADER *)shm;

        if (shm_lock(header)==SHM_FAIL)
                return SHM_ADD_FAIL;
        user=(USER_INFO *)(shm+sizeof(USER_HEADER));

	t=time(NULL);
	for (i=0;i<header->totalrecord;i++)
	{
		if (check_record(user, t)==INVALID)
			remove_record(user);
		user=user++;
	}
        shm_unlock(header);
        shmdt(shm);
	return SHM_SUCCESS;
}

void printf_user(USER_INFO *user)
{
	printf("%20s %12s %20s %12ld %12ld %12d %12d %5d %5d\n", user->username, user->sharename, user->ip,
					user->logintime, user->lasttime, user->index, user->app_id, user->schedule, user->pid);
}

int show_records()
{
        int             shmid, i;
        char            *shm;
        USER_HEADER     *header;
        USER_INFO       *user;

        shmid=shmget((key_t)SHMKEY, SHMSIZE, 0666);
        if (shmid==-1)
        {
                printf("create share memory fail\n");
                return SHM_FAIL;
        }
        shm=shmat(shmid, (char *)0, 0);
        if (shm==(char *)-1)
        {
                printf("attached shm fail\n");
                return SHM_FAIL;
        }
        header=(USER_HEADER *)shm;
        if (header->lock==1)
                return SHM_FAIL;

	printf("total record=%d\n", header->totalrecord);
	printf("lock time=%ld\n", header->locktime);
	printf("tmpuser\n");
	printf_user(&(header->tmpuser));
	shm_lock(header);
        user=(USER_INFO *)(shm+sizeof(USER_HEADER));
	printf("records\n");
	printf("            username     sharename              ipaddr    logintime    lasttime           index      appid schedule pid\n");
	printf("=======================================================================================================================\n");
	for (i=0;i<header->totalrecord;i++)
	{
		printf_user(user);
		user++;
	}
	printf("\ntotal reg app=%d\n", header->totalapp);
	for (i=0;i<header->totalapp;i++)
	{
		printf("app name=%20s, app id=%d\n", header->app[i].regname, header->app[i].id);
	}
	shm_unlock(header);
	return 0;
}

int shm_get_all_app(APP_INFO *app, int *cnt)
{
        int             shmid, i, ret=0;
        USER_HEADER     *header;
        char            *shm;
	APP_INFO	*ptr;

        shmid=shmget((key_t)SHMKEY, SHMSIZE, 0666);
        if (shmid==-1)
                return SHM_FAIL;
        shm=shmat(shmid, (char *)0, 0);
        if (shm==(char *)-1)
                return SHM_FAIL;
        header=(USER_HEADER *)shm;

	ptr=app;
	*cnt=header->totalapp;
        for (i=0;i<header->totalapp;i++)
        {
		strcpy(ptr->regname, header->app[i].regname);
		ptr->id=header->app[i].id;
		ptr++;
        }

//exit_get_app_id:
        shmdt(shm);
        return ret;
}

int shm_add_user(USER_INFO *new)
{
//	int 		shmid, i, ret, times=0, max_record;
	int             shmid, ret,  max_record;
        char 		*shm;
	USER_HEADER	*header;
	USER_INFO	*user;
	time_t		t;

	shm_refresh_record();
        shmid=shmget((key_t)SHMKEY, SHMSIZE, 0666);
        if (shmid==-1)
		return SHM_FAIL;
        shm=shmat(shmid, (char *)0, 0);
        if (shm==(char *)-1)
		return SHM_FAIL;
	header=(USER_HEADER *)shm;

	if (shm_lock(header)==SHM_FAIL)
		return SHM_ADD_FAIL;
	user=(USER_INFO *)(shm+sizeof(USER_HEADER));
	max_record=(SHMSIZE-sizeof(USER_HEADER))/sizeof(USER_INFO)-1;
	if ((ret=find_user(user, new, header->totalrecord))!=SHM_FAIL)
	{
#ifdef _DEBUG
		printf("find user in record [%d]\n", ret);
#endif
		user=user+ret;
		new->index=ret;
		goto copy_user;
	}
	else
	if ((ret=free_user(user, new, header->totalrecord))!=SHM_FAIL)
	{
#ifdef _DEBUG
		printf("first free user in record [%d]\n", ret);
#endif
		if (ret>max_record)
			goto full;
		user=user+ret;
		new->index=ret;
		goto copy_user;
	}
	if (header->totalrecord>SHMSIZE/sizeof(USER_INFO))	/* check if share memory is enough? */
		return SHM_NOT_ENOUGH;
	user=user+header->totalrecord;
	new->index=header->totalrecord;
	t=time(NULL);
	new->logintime=new->lasttime=t;
	header->totalrecord++;

copy_user:
	memcpy(user, new, sizeof(USER_INFO));
	shm_unlock(header);
	shmdt(shm);
        return SHM_SUCCESS;
full:
	shm_unlock(header);
	shmdt(shm);
	return SHM_FULL;
}

int shm_get_user(USER_INFO *new, int where, int app_id)
{
        int             shmid, i, index;
        char            *shm;
        USER_HEADER     *header;
        USER_INFO       *user, *ptruser;
        time_t          t;

        shmid=shmget((key_t)SHMKEY, SHMSIZE, 0666);
        if (shmid==-1)
                return SHM_FAIL;
        shm=shmat(shmid, (char *)0, 0);
        if (shm==(char *)-1)
                return SHM_FAIL;
        header=(USER_HEADER *)shm;
	user=(USER_INFO *)(shm+sizeof(USER_HEADER));
	ptruser=user;
	if (where==USER_START)
		index=0;
	else
		index=new->index+1;
	t=time(NULL);
	for (i=index;i<header->totalrecord;i++)
	{
		ptruser=user+i;
		if (app_id==ptruser->app_id)
		{
			if (check_record(ptruser, t)==VALID)
			{
				memcpy(new, ptruser, sizeof(USER_INFO));
				shmdt(shm);
				return SHM_SUCCESS;
			}
		}
	}
	shmdt(shm);
	return SHM_NO_USER;
}

int shm_get_all_user_by_app(USER_INFO *new, int size, int appid)
{
	USER_INFO	*ptr, user, *start, *end;
	int		count=0, ret, i, j, user_size;

	ret=shm_get_user(&user, USER_START, appid);
	user_size=sizeof(USER_INFO);
        if (ret==SHM_FAIL)
		return SHM_FAIL;
	else
	if (ret==SHM_NO_USER)
		return count;
        else
        {
		ptr=new;
		memcpy(ptr, &user, user_size);
		ptr=ptr+1;
		count++;
		if (count>size)
			return SHM_SIZE_NOT_ENOUGH;
		while (shm_get_user(&user, USER_NEXT, appid)==SHM_SUCCESS)
		{
			memcpy(ptr, &user, user_size);
			ptr=ptr+1;
			count++;
		}
	}

	/* sort user */
	start=new;
	for (i=0;i<count;i++)
	{
		end=start;
		ptr=start;
		for (j=i;j<count;j++)
		{
			if (strcmp(ptr->sharename, end->sharename)>0)
			{
				ptr=end;
			}
			end++;
		}
		if (ptr!=start)
		{
                	memcpy(&user, ptr, user_size);
	                memcpy(ptr, start, user_size);
        	        memcpy(start, &user, user_size);
		}
		start++;
	}
	return count;
}

int shm_get_all_user(USER_INFO *new, int size, int appid)
{
//        USER_INFO       *ptr, user;
	USER_INFO       *ptr;
        int             count=0, ret, totalapp, i;
	APP_INFO	app[20];

	shm_get_all_app(app, &totalapp);
	ptr=new;
	for (i=0;i<totalapp;i++)
	{
		if (appid==SHM_APP_ALL || appid==app[i].id)
		{
			ret=shm_get_all_user_by_app(ptr, size-count, app[i].id);
			count=count+ret;
			ptr=ptr+ret;
		}
	}
	return count;
}

int shm_del_user(char *username, char *ip, int app_id)
{
	int		shmid, i;
	USER_INFO	*user;
	USER_HEADER	*header;
	char		*shm;

        shmid=shmget((key_t)SHMKEY, SHMSIZE, 0666);
        if (shmid==-1)
                return SHM_FAIL;
        shm=shmat(shmid, (char *)0, 0);
        if (shm==(char *)-1)
                return SHM_FAIL;
        header=(USER_HEADER *)shm;
        user=(USER_INFO *)(shm+sizeof(USER_HEADER));
        for (i=0;i<header->totalrecord;i++)
        {
                if (!strcmp(username, user->username) && !strcmp(ip, user->ip) && app_id==user->app_id)
                {
			remove_record(user);
			shmdt(shm);
			return SHM_SUCCESS;
		}
		user++;
        }
        shmdt(shm);

	return SHM_USER_NOT_FOUND;
}

int shm_write_current_user(USER_INFO *user)
{
        int     shmid;
        char    *shm;
        USER_HEADER     *header;

        shmid=shmget((key_t)SHMKEY, SHMSIZE, 0666);
        if (shmid==-1)
        	return SHM_FAIL;
        shm=shmat(shmid, (char *)0, 0);
        if (shm==(char *)-1)
        	return SHM_FAIL;
        header=(USER_HEADER *)shm;
        strcpy(header->tmpuser.username, user->username);
	strcpy(header->tmpuser.ip, user->ip);
	header->tmpuser.app_id=user->app_id;
	header->sid=0;		/* reset signal id */
        shmdt(shm);
	return SHM_SUCCESS;
}

int shm_reg_app(USER_HEADER *header, char *appname)
{
	if (shm_lock(header)==SHM_FAIL)
		return SHM_FAIL;
	if (header->totalapp>=10)
		return SHM_APP_REG_FULL;
	strcpy(header->app[header->totalapp].regname, appname);
	header->app[header->totalapp].id=header->totalapp;
	header->totalapp++;
	shm_unlock(header);

	return SHM_SUCCESS;
}

int shm_get_app_id(char *appname)
{
	int		shmid, i, ret;
	USER_HEADER	*header;
	char		*shm;

        shmid=shmget((key_t)SHMKEY, SHMSIZE, 0666);
        if (shmid==-1)
                return SHM_FAIL;
        shm=shmat(shmid, (char *)0, 0);
        if (shm==(char *)-1)
                return SHM_FAIL;
        header=(USER_HEADER *)shm;

	for (i=0;i<header->totalapp;i++)
	{
		if (!strcmp(appname, header->app[i].regname))
		{
			ret=i;
			goto exit_get_app_id;
		}
	}
	ret=shm_reg_app(header, appname);
	if (ret==SHM_FAIL)
	{
		ret=SHM_LOCK_FAIL;
		goto exit_get_app_id;
	}
	else
	if (ret==SHM_APP_REG_FULL)
	{
		ret=SHM_APP_REG_FULL;
		goto exit_get_app_id;
	}
	ret=header->app[header->totalapp-1].id;

exit_get_app_id:
	shmdt(shm);
	return ret;
}

int init_userManager()
{
	int 		shmid;
	char 		*shm;
	USER_HEADER 	*header;

        shmid=shmget((key_t)SHMKEY, SHMSIZE, 0666 | IPC_CREAT);
        if (shmid==-1)
        {
                shm=shmat(shmid, (char *)0, 0);
                shmdt(shm);
                shmctl(shmid, IPC_RMID, 0);
                shmid=shmget((key_t)SHMKEY, SHMSIZE, 0666 | IPC_CREAT);
                if (shmid==-1)
			return SHM_FAIL;
        }
        shm=shmat(shmid, (char *)0, 0);
        if (shm==(char *)-1)
		return SHM_FAIL;
        else
        {
                header=(USER_HEADER *)shm;
                header->lock=0;
                header->totalrecord=0;
                header->locktime=0;
		header->totalapp=0;
                shmdt(shm);
        }
	return SHM_SUCCESS;
}

